/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.menu;

import com.tom.trading.Content;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.DataSlots;
import com.tom.trading.util.LimitedContainer;
import com.tom.trading.util.TradeResult;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VendingMachineTradingMenu
extends AbstractContainerMenu {
    private VendingMachineBlockEntityBase machine;
    public int state;
    public int matchNBT;
    public Runnable updateGui;

    public VendingMachineTradingMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(8));
        this.addDataSlot(DataSlots.set(c -> {
            this.state = c;
        }).onUpdate(this::updateGui));
        this.addDataSlot(DataSlots.set(c -> {
            this.matchNBT = c;
        }));
    }

    public VendingMachineTradingMenu(int pContainerId, Inventory pPlayerInventory, VendingMachineBlockEntityBase machine) {
        this(pContainerId, pPlayerInventory, (Container)machine.getConfig());
        this.machine = machine;
        this.addDataSlot(DataSlots.get(machine::getTradingState));
        this.addDataSlot(DataSlots.get(machine::getMatchNBT));
    }

    private VendingMachineTradingMenu(int pContainerId, Inventory pPlayerInventory, Container config) {
        super(Content.VENDING_MACHINE_TRADING_MENU.get(), pContainerId);
        int k;
        for (k = 0; k < 8; ++k) {
            this.addSlot(new Slot(this, config, k, 8 + k * 18 + (k > 3 ? 18 : 0), 35){

                public boolean mayPickup(Player pPlayer) {
                    return false;
                }

                public boolean mayPlace(ItemStack pStack) {
                    return false;
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pPlayer) {
        return this.machine != null ? this.machine.isInRange(pPlayer) : true;
    }

    private void updateGui() {
        if (this.updateGui != null) {
            this.updateGui.run();
        }
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        for (int i = 0; i < pId; ++i) {
            TradeResult r = this.machine.tradeWith(new LimitedContainer((Container)pPlayer.getInventory(), pPlayer.getInventory().getNonEquipmentItems().size()));
            if (r == TradeResult.SUCCESS) continue;
            pPlayer.displayClientMessage((Component)Component.translatable((String)"chat.toms_trading_network.vending_machine.trade_error", (Object[])new Object[]{i, pId, Component.translatable((String)("chat.toms_trading_network.vending_machine.trade_error." + r.name().toLowerCase(Locale.ROOT)))}), false);
            break;
        }
        return true;
    }
}

