/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.network;

import com.tom.trading.network.DataPacket;
import com.tom.trading.util.IDataReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    @SubscribeEvent
    public static void onPayloadRegister(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(DataPacket.ID, DataPacket.STREAM_CODEC, NetworkHandler::handleDataServer, NetworkHandler::handleDataClient);
    }

    public static void handleDataServer(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)context.player();
            if (sender.containerMenu instanceof IDataReceiver) {
                ((IDataReceiver)sender.containerMenu).receive(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)sender.registryAccess(), (CompoundTag)packet.tag()));
            }
        });
    }

    public static void handleDataClient(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().screen instanceof IDataReceiver) {
                ((IDataReceiver)Minecraft.getInstance().screen).receive(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)packet.tag()));
            }
        });
    }

    public static void sendDataToServer(CompoundTag tag) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTo(ServerPlayer pl, CompoundTag tag) {
        PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

