/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class OwnableBlockEntity
extends BlockEntity {
    private String ownerNameCache;
    private UUID owner;

    public OwnableBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void setOwner(Player p) {
        this.ownerNameCache = p.getScoreboardName();
        this.owner = p.getUUID();
        this.setChanged();
    }

    protected void saveAdditional(ValueOutput pTag) {
        super.saveAdditional(pTag);
        if (this.ownerNameCache != null) {
            pTag.putString("ownerNameCache", this.ownerNameCache);
        }
        if (this.owner != null) {
            pTag.store("owner", UUIDUtil.CODEC, (Object)this.owner);
        }
    }

    public void loadAdditional(ValueInput pTag) {
        super.loadAdditional(pTag);
        this.ownerNameCache = pTag.getStringOr("ownerNameCache", null);
        this.owner = pTag.read("owner", UUIDUtil.CODEC).orElse(null);
    }

    public boolean canAccess(Player p) {
        return p.getUUID().equals(this.owner);
    }

    public String getOwnerNameCache() {
        return this.ownerNameCache;
    }
}

