/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.PredicatingHandler;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import org.jetbrains.annotations.Nullable;

public class VendingMachineBlockEntity
extends VendingMachineBlockEntityBase {
    private EnumMap<Direction, ResourceHandler<ItemResource>> itemCaps = new EnumMap(Direction.class);
    private ResourceHandler<ItemResource> inputWr = VanillaContainerWrapper.of((Container)this.getInputs());
    private ResourceHandler<ItemResource> outputWr = VanillaContainerWrapper.of((Container)this.getOutputs());
    private EnumMap<Direction, BlockCapabilityCache<ResourceHandler<ItemResource>, Direction>> sideCache = new EnumMap(Direction.class);

    public VendingMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        for (Direction d : Direction.values()) {
            this.itemCaps.put(d, (ResourceHandler<ItemResource>)new CombinedResourceHandler(new ResourceHandler[]{new PredicatingHandler<ItemResource>(this.inputWr, d, this::canInput, null), new PredicatingHandler<ItemResource>(this.outputWr, d, null, this::canOutput)}));
        }
    }

    private boolean canInput(Direction d, ItemResource resource) {
        return this.canInput(resource.toStack(), d);
    }

    public ResourceHandler<ItemResource> getInventory(@Nullable Direction side) {
        return this.itemCaps.get(side);
    }

    public void pullItemsFrom(BlockPos relative, Direction opposite) {
        ResourceHandler<ItemResource> cap = this.getHandler(relative, opposite);
        if (cap != null) {
            ResourceHandlerUtil.move(cap, this.inputWr, r -> this.canInputItem(r.toStack()), (int)64, null);
        }
    }

    public void pushItemsTo(BlockPos relative, Direction opposite) {
        ResourceHandler<ItemResource> cap = this.getHandler(relative, opposite);
        if (cap != null) {
            ResourceHandlerUtil.move(this.outputWr, cap, r -> true, (int)64, null);
        }
    }

    private ResourceHandler<ItemResource> getHandler(BlockPos relative, Direction d) {
        return (ResourceHandler)this.sideCache.computeIfAbsent(d, __ -> BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)relative, (Object)d, () -> !this.isRemoved(), () -> {})).getCapability();
    }
}

