/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.Content;
import com.tom.trading.block.VendingMachineBlock;
import com.tom.trading.menu.VendingMachineConfigMenu;
import com.tom.trading.menu.VendingMachineTradingMenu;
import com.tom.trading.tile.OwnableBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.util.BasicContainer;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.TradeResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class VendingMachineBlockEntityBase
extends OwnableBlockEntity
implements MenuProvider,
Nameable {
    private BasicContainer config = new BasicContainer(8);
    private BasicContainer inputs = new BasicContainer(8);
    private BasicContainer outputs = new BasicContainer(8);
    private int inputSides;
    private int outputSides;
    private int autoSides;
    private int matchNBT = 255;
    private Component name;
    private Boolean hasInputs;
    private boolean creativeMode;

    public VendingMachineBlockEntityBase(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Content.VENDING_MACHINE_TILE.get(), pPos, pBlockState);
        this.inputs.addListener(c -> {
            this.hasInputs = null;
        });
        this.config.addListener(c -> {
            this.hasInputs = null;
        });
        ContainerListener l = c -> this.setChanged();
        this.config.addListener(l);
        this.inputs.addListener(l);
        this.outputs.addListener(l);
    }

    @Override
    public void loadAdditional(ValueInput pTag) {
        super.loadAdditional(pTag);
        this.inputs.loadItems((ValueInput.TypedInputList<ItemStackWithSlot>)pTag.listOrEmpty("Inputs", ItemStackWithSlot.CODEC));
        this.outputs.loadItems((ValueInput.TypedInputList<ItemStackWithSlot>)pTag.listOrEmpty("Outputs", ItemStackWithSlot.CODEC));
        this.config.loadItems((ValueInput.TypedInputList<ItemStackWithSlot>)pTag.listOrEmpty("Config", ItemStackWithSlot.CODEC));
        this.inputSides = pTag.getIntOr("inputSides", 0);
        this.outputSides = pTag.getIntOr("outputSides", 0);
        this.autoSides = pTag.getIntOr("autoSides", 0);
        this.matchNBT = pTag.getIntOr("matchNBT", 255);
        this.creativeMode = pTag.getBooleanOr("Creative", false);
        this.name = VendingMachineBlockEntityBase.parseCustomNameSafe((ValueInput)pTag, (String)"CustomName");
    }

    @Override
    protected void saveAdditional(ValueOutput pTag) {
        super.saveAdditional(pTag);
        this.inputs.storeItems((ValueOutput.TypedOutputList<ItemStackWithSlot>)pTag.list("Inputs", ItemStackWithSlot.CODEC));
        this.outputs.storeItems((ValueOutput.TypedOutputList<ItemStackWithSlot>)pTag.list("Outputs", ItemStackWithSlot.CODEC));
        this.config.storeItems((ValueOutput.TypedOutputList<ItemStackWithSlot>)pTag.list("Config", ItemStackWithSlot.CODEC));
        pTag.putInt("inputSides", this.inputSides);
        pTag.putInt("outputSides", this.outputSides);
        pTag.putInt("autoSides", this.autoSides);
        pTag.putInt("matchNBT", this.matchNBT);
        pTag.putBoolean("Creative", this.creativeMode);
        pTag.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.name);
    }

    public BasicContainer getInputs() {
        return this.inputs;
    }

    public BasicContainer getOutputs() {
        return this.outputs;
    }

    public Runnable consumeInputs(List<ItemStack> items) {
        return this.consumeInputs((Container)this.inputs, 4, items);
    }

    public Runnable consumeInputs(Container inputs, int start, List<ItemStack> items) {
        ItemStack[] modArray = new ItemStack[inputs.getContainerSize()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = inputs.getItem(i).copy();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < 4; ++i) {
            ItemStack o = this.config.getItem(i + start);
            int rem = o.getCount();
            if (rem > 0) {
                for (int j = 0; j < modArray.length; ++j) {
                    ItemStack s = modArray[j];
                    if (s.isEmpty() || !this.compareItemStack(s, o, i + start)) continue;
                    int d = Math.min(rem, s.getCount());
                    int fj = j;
                    actions.add(() -> inputs.removeItem(fj, d));
                    items.add(s.split(d));
                    if ((rem -= d) < 1) break;
                }
            }
            if (rem <= 0) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public Runnable addOutput(List<ItemStack> items) {
        return this.addOutput((Container)this.outputs, items, false);
    }

    private Runnable addOutput(Container outputs, List<ItemStack> items, boolean drop) {
        ItemStack[] modArray = new ItemStack[outputs.getContainerSize()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = outputs.getItem(i).copy();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < items.size(); ++i) {
            int j;
            ItemStack o = items.get(i).copy();
            for (j = 0; j < modArray.length; ++j) {
                if (ItemStack.isSameItemSameComponents((ItemStack)o, (ItemStack)modArray[j])) {
                    ItemStack s = modArray[j];
                    int m = Math.min(outputs.getMaxStackSize(), o.getMaxStackSize());
                    int c = Math.min(o.getCount(), m - s.getCount());
                    if (c > 0) {
                        ItemStack ins = o.copy();
                        ins.setCount(c);
                        o.shrink(c);
                        s.grow(c);
                        actions.add(() -> {
                            ItemStack is = HopperBlockEntity.addItem(null, (Container)outputs, (ItemStack)ins, null);
                            if (!is.isEmpty() && drop) {
                                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)is);
                            }
                        });
                    }
                }
                if (o.isEmpty()) break;
            }
            if (!o.isEmpty()) {
                for (j = 0; j < modArray.length; ++j) {
                    ItemStack s2;
                    if (!modArray[j].isEmpty()) continue;
                    modArray[j] = s2 = o.copy();
                    o.setCount(0);
                    actions.add(() -> {
                        ItemStack is = HopperBlockEntity.addItem(null, (Container)outputs, (ItemStack)s2, null);
                        if (!is.isEmpty() && drop) {
                            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)is);
                        }
                    });
                }
            }
            if (o.isEmpty()) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public boolean canInput(ItemStack stack, Direction dir) {
        return this.canInputFrom(dir) && this.canInputItem(stack);
    }

    public boolean canInputItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack o = this.config.getItem(i + 4).copy();
            if (!this.compareItemStack(stack, o, i + 4)) continue;
            return true;
        }
        return false;
    }

    public boolean compareItemStack(ItemStack stack, ItemStack template, int slot) {
        if (template.getItem() == Content.TAG_FILTER.get()) {
            TagKey tag = (TagKey)template.get(Content.TAG_COMPONENT.get());
            if (tag == null) {
                return false;
            }
            return stack.is(tag);
        }
        if ((this.matchNBT & 1 << slot) != 0) {
            return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)template);
        }
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)template);
    }

    public boolean canInputFrom(Direction dir) {
        Direction facing = (Direction)this.getBlockState().getValue(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.inputSides & 1 << d.ordinal()) != 0;
    }

    public boolean canOutput(Direction dir) {
        Direction facing = (Direction)this.getBlockState().getValue(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.outputSides & 1 << d.ordinal()) != 0;
    }

    public boolean isAutoSide(Direction dir) {
        Direction facing = (Direction)this.getBlockState().getValue(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.autoSides & 1 << d.ordinal()) != 0;
    }

    public boolean isInRange(Player pPlayer) {
        return !this.remove && pPlayer.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.canAccess(pPlayer)) {
            return new VendingMachineConfigMenu(pContainerId, pPlayerInventory, this);
        }
        return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, this);
    }

    public void setCustomName(Component pName) {
        this.name = pName;
        this.setChanged();
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getCustomName() {
        return this.name;
    }

    protected Component getDefaultName() {
        return Content.VENDING_MACHINE.get().getName();
    }

    public BasicContainer getConfig() {
        return this.config;
    }

    public int getInputSides() {
        return this.inputSides;
    }

    public int getOutputSides() {
        return this.outputSides;
    }

    public int getAutoSides() {
        return this.autoSides;
    }

    public int getMatchNBT() {
        return this.matchNBT;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public int getTradingState() {
        if (this.hasInputs == null) {
            this.hasInputs = this.creativeMode || this.consumeInputs(new ArrayList<ItemStack>()) != null;
        }
        return this.hasInputs != false ? 1 : 0;
    }

    public void setSides(int id, int config, boolean auto) {
        this.inputSides = (config & 1) != 0 ? (this.inputSides |= 1 << id) : (this.inputSides &= ~(1 << id));
        this.outputSides = (config & 2) != 0 ? (this.outputSides |= 1 << id) : (this.outputSides &= ~(1 << id));
        this.autoSides = auto && config != 0 ? (this.autoSides |= 1 << id) : (this.autoSides &= ~(1 << id));
        this.setChanged();
    }

    public void setMatchNBT(int slot, boolean config) {
        this.matchNBT = config ? (this.matchNBT |= 1 << slot) : (this.matchNBT &= ~(1 << slot));
    }

    public TradeResult tradeWith(Container c) {
        if (this.creativeMode) {
            ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
            Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
            if (commitGetPlayer == null) {
                return TradeResult.TRADER_MISSING_INPUT;
            }
            ArrayList<ItemStack> machineItems = new ArrayList<ItemStack>();
            for (int i = 4; i < 8; ++i) {
                ItemStack o = this.config.getItem(i);
                int rem = o.getCount();
                if (rem <= 0 || o.getItem() == Content.TAG_FILTER.get()) continue;
                machineItems.add(o.copy());
            }
            Runnable commitGive = this.addOutput(c, machineItems, true);
            if (commitGive == null) {
                return TradeResult.TRADER_NO_SPACE;
            }
            commitGetPlayer.run();
            commitGive.run();
            return TradeResult.SUCCESS;
        }
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> machineItems = new ArrayList<ItemStack>();
        Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
        if (commitGetPlayer == null) {
            return TradeResult.TRADER_MISSING_INPUT;
        }
        Runnable commitGetInv = this.consumeInputs(machineItems);
        if (commitGetInv == null) {
            return TradeResult.MACHINE_MISSING_INPUT;
        }
        Runnable commitGive = this.addOutput(c, machineItems, true);
        if (commitGive == null) {
            return TradeResult.TRADER_NO_SPACE;
        }
        Runnable commitStore = this.addOutput(playerItems);
        if (commitStore == null) {
            return TradeResult.MACHINE_NO_SPACE;
        }
        commitGetPlayer.run();
        commitGetInv.run();
        commitGive.run();
        commitStore.run();
        return TradeResult.SUCCESS;
    }

    @Override
    public boolean canAccess(Player p) {
        if (this.creativeMode && !p.getAbilities().instabuild) {
            return false;
        }
        return super.canAccess(p);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T beIn) {
        if (!(beIn instanceof VendingMachineBlockEntity)) {
            return;
        }
        VendingMachineBlockEntity be = (VendingMachineBlockEntity)beIn;
        if (level.getGameTime() % 20L != (long)(Math.abs(pos.hashCode()) % 20)) {
            return;
        }
        for (Direction d : Direction.values()) {
            if (!be.isAutoSide(d)) continue;
            if (be.canInputFrom(d)) {
                be.pullItemsFrom(pos.relative(d), d.getOpposite());
            }
            if (!be.canOutput(d)) continue;
            be.pushItemsTo(pos.relative(d), d.getOpposite());
        }
    }

    public void setCreativeMode(boolean b) {
        this.creativeMode = b;
        this.hasInputs = null;
        this.setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getInputs());
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getOutputs());
    }
}

