/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PopupMenuManager {
    private final Screen screen;
    private int x;
    private int y;
    private List<PopupElement> menu;
    private int selected;

    public PopupMenuManager(Screen screen) {
        this.screen = screen;
    }

    public void open(double x, double y, PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.x = (int)x;
        this.y = (int)y;
        this.selected = -1;
    }

    public void replace(PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.selected = -1;
    }

    public boolean render(GuiGraphics g, Font font, int pMouseX, int pMouseY) {
        if (this.menu != null) {
            g.setComponentTooltipForNextFrame(font, IntStream.range(0, this.menu.size()).mapToObj(i -> this.menu.get(i).getHoveredText(pMouseX - this.x, pMouseY - this.y - i * 10, this.selected == i)).toList(), this.x - 12, this.y + 12);
        }
        return this.menu == null;
    }

    private static boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return pMouseX >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && pMouseY >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public boolean mouseClick(MouseButtonEvent event) {
        if (this.menu != null) {
            for (int i = 0; i < this.menu.size(); ++i) {
                if (!PopupMenuManager.isHovering(this.x, this.y + i * 10, 100, 8, event.x(), event.y())) continue;
                this.menu.get(i).onClick(new MouseButtonEvent(event.x() - (double)this.x, event.y() - (double)this.y - (double)(i * 10), event.buttonInfo()));
                this.selected = i;
                return true;
            }
            this.menu = null;
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.menu != null) {
            if (this.selected != -1 && this.menu.get(this.selected).keyPressed(event)) {
                return true;
            }
            if (event.key() == 264) {
                this.selected = (this.selected + 1) % this.menu.size();
            } else if (event.key() == 265) {
                this.selected = (this.selected + this.menu.size() - 1) % this.menu.size();
            } else if (event.key() == 256) {
                this.menu = null;
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        return this.menu != null && this.selected != -1 && this.menu.get(this.selected).charTyped(characterEvent);
    }

    public void close() {
        this.menu = null;
    }

    public static interface PopupElement {
        public MutableComponent getText();

        public void activate();

        default public void onClick(MouseButtonEvent event) {
            this.activate();
        }

        default public boolean keyPressed(KeyEvent event) {
            if (event.key() == 257 || event.key() == 335) {
                this.activate();
                return true;
            }
            return false;
        }

        default public boolean charTyped(CharacterEvent characterEvent) {
            return false;
        }

        default public Component getHoveredText(int pMouseX, int pMouseY, boolean selected) {
            return this.getText().withStyle(PopupMenuManager.isHovering(0, 0, 100, 8, pMouseX, pMouseY) || selected ? ChatFormatting.AQUA : ChatFormatting.GRAY);
        }
    }

    public static class TextFieldElement
    implements PopupElement {
        private final Supplier<MutableComponent> text;
        private final Consumer<String> action;
        private boolean activated;
        private EditBox box;
        private String value;

        public TextFieldElement(Supplier<MutableComponent> text, Consumer<String> action, Font font, String value) {
            this.text = text;
            this.action = action;
            this.box = new EditBox(font, 0, 0, 0, 0, null);
            this.value = value;
            this.box.setValue(value);
            this.box.setCanLoseFocus(false);
            this.box.setFocused(true);
        }

        @Override
        public MutableComponent getText() {
            if (this.activated) {
                StringBuilder sb = new StringBuilder(this.box.getValue());
                sb.insert(this.box.getCursorPosition(), '_');
                return Component.translatable((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), Component.literal((String)sb.toString()).withStyle(ChatFormatting.YELLOW)});
            }
            return Component.translatable((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), Component.literal((String)this.box.getValue())});
        }

        @Override
        public void activate() {
            if (this.activated) {
                this.value = this.box.getValue();
                this.action.accept(this.value);
            }
            this.activated = !this.activated;
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.activated && event.key() == 256) {
                this.box.setValue(this.value);
                this.activated = false;
                return true;
            }
            if (PopupElement.super.keyPressed(event)) {
                return true;
            }
            if (this.activated) {
                return this.box.keyPressed(event);
            }
            return false;
        }

        @Override
        public boolean charTyped(CharacterEvent characterEvent) {
            if (this.activated) {
                return this.box.charTyped(characterEvent);
            }
            return false;
        }
    }

    public static class ButtonElement
    implements PopupElement {
        private final Supplier<MutableComponent> text;
        private final Runnable action;

        public ButtonElement(Supplier<MutableComponent> text, Runnable action) {
            this.text = text;
            this.action = action;
        }

        @Override
        public MutableComponent getText() {
            return this.text.get();
        }

        @Override
        public void activate() {
            this.action.run();
        }
    }
}

