/*
 * Decompiled with CFR 0.152.
 */
package cc.barnab.smoothmaps.mixin.client.map;

import cc.barnab.smoothmaps.client.LightUpdateAccessor;
import cc.barnab.smoothmaps.client.MathUtil;
import cc.barnab.smoothmaps.client.RenderRelightCounter;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import net.minecraft.class_10090;
import net.minecraft.class_11659;
import net.minecraft.class_1533;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_330;
import net.minecraft.class_3568;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_330.class})
public abstract class MapRendererMixin
implements RenderRelightCounter {
    @Unique
    boolean shouldReuseVertexLights = false;
    @Unique
    private static final int[][] vertexRotationMap = new int[][]{{2, 0, 3, 1}, {3, 2, 1, 0}, {1, 3, 0, 2}};
    @Unique
    private static final float[] xPositions = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
    @Unique
    private static final float[] yPositions = new float[]{1.0f, 1.0f, 0.0f, 0.0f};
    @Unique
    int[][][] lightLevels = new int[3][3][3];
    @Unique
    boolean shouldSmoothLight = false;
    @Unique
    private int numRendered = 0;
    @Unique
    private int numRelit = 0;

    @Override
    public int getNumRendered() {
        return this.numRendered;
    }

    @Override
    public int getNumRelit() {
        return this.numRelit;
    }

    @Override
    public void resetCounters() {
        this.numRendered = 0;
        this.numRelit = 0;
    }

    @Unique
    private boolean shouldSmoothLight(class_10090 mapRenderState, boolean shouldReuseVertexLights) {
        boolean isCamBehind;
        if (mapRenderState.isGlowing()) {
            return false;
        }
        if (!class_310.method_1588()) {
            return false;
        }
        if (shouldReuseVertexLights) {
            return true;
        }
        class_757 gameRenderer = class_310.method_1551().field_1773;
        class_4184 mainCamera = gameRenderer.method_19418();
        Vector3f camLook = mainCamera.method_19335();
        class_2350.class_2351 axis = mapRenderState.direction().method_10166();
        class_2350.class_2352 axisDir = mapRenderState.direction().method_10171();
        switch (axis) {
            default: {
                throw new MatchException(null, null);
            }
            case field_11048: {
                boolean bl;
                if (((double)mapRenderState.getBlockPos().method_10263() - mainCamera.method_19326().field_1352) * (double)axisDir.method_10181() > 1.0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11052: {
                boolean bl;
                if (((double)mapRenderState.getBlockPos().method_10264() - mainCamera.method_19326().field_1351) * (double)axisDir.method_10181() > 1.0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11051: {
                boolean bl = isCamBehind = ((double)mapRenderState.getBlockPos().method_10260() - mainCamera.method_19326().field_1350) * (double)axisDir.method_10181() > 1.0;
            }
        }
        if (isCamBehind) {
            return false;
        }
        float distSqr = (float)mapRenderState.getBlockPos().method_10262((class_2382)mainCamera.method_19328());
        if (distSqr > 16384.0f) {
            return false;
        }
        float clampedFovModifier = Math.max(Math.max(gameRenderer.field_4019, gameRenderer.field_3999), 1.0f);
        float fovVert = (float)Math.toRadians((float)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() * clampedFovModifier);
        float fovHoriz = fovVert * (float)class_310.method_1551().method_22683().method_4489() / (float)class_310.method_1551().method_22683().method_4506();
        return !((double)mapRenderState.direction().method_23955().angle((Vector3fc)camLook) < Math.PI - (double)fovHoriz);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void render(class_10090 mapRenderState, class_4587 poseStack, class_11659 submitNodeCollector, boolean bl, int i, CallbackInfo ci, @Share(value="originalLight") LocalIntRef originalLight) {
        int blockLight;
        int z;
        int y;
        int x;
        ++this.numRendered;
        assert (class_310.method_1551().field_1687 != null);
        class_3568 lightEngine = class_310.method_1551().field_1687.method_22336();
        class_2338 blockPos = mapRenderState.getBlockPos();
        class_1533 itemFrame = mapRenderState.getItemFrame();
        if (!bl || itemFrame == null) {
            this.shouldReuseVertexLights = false;
            this.shouldSmoothLight = false;
            return;
        }
        this.shouldReuseVertexLights = ((LightUpdateAccessor)lightEngine).getLastUpdated() <= itemFrame.getLastUpdated() && blockPos.equals((Object)itemFrame.getLastBlockPos()) && itemFrame.method_5735().equals((Object)itemFrame.getLastDirection()) && itemFrame.method_6934() == itemFrame.getLastRotation();
        this.shouldSmoothLight = this.shouldSmoothLight(mapRenderState, this.shouldReuseVertexLights);
        if (!this.shouldSmoothLight) {
            return;
        }
        originalLight.set(i);
        if (this.shouldReuseVertexLights) {
            return;
        }
        ++this.numRelit;
        itemFrame.setLastUpdated(class_310.method_1551().field_1773.getLastRenderTime());
        itemFrame.setLastBlockPos(blockPos);
        itemFrame.setLastRotation(itemFrame.method_6934());
        itemFrame.setLastDirection(itemFrame.method_5735());
        for (x = -1; x <= 1; ++x) {
            for (y = -1; y <= 1; ++y) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) {
                        this.lightLevels[x + 1][y + 1][z + 1] = i;
                        continue;
                    }
                    class_2338 pos = blockPos.method_10069(x, y, z);
                    int light = 0;
                    if (lightEngine.field_15813 != null) {
                        int skyLight = lightEngine.field_15813.method_15543(pos);
                        light += skyLight * 16 << 16;
                    }
                    if (lightEngine.field_15814 != null) {
                        blockLight = lightEngine.field_15814.method_15543(pos);
                        light += blockLight * 16;
                    }
                    this.lightLevels[x + 1][y + 1][z + 1] = light;
                }
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (y = -1; y <= 1; ++y) {
                for (z = -1; z <= 1; ++z) {
                    int light = this.lightLevels[x + 1][y + 1][z + 1];
                    int skyLight = light >> 16;
                    blockLight = light & 0xFFFF;
                    if (blockLight != 0 || skyLight != 0) continue;
                    int maxSky = 0;
                    int maxBlock = 0;
                    for (int x2 = x - 1; x2 <= x + 1; ++x2) {
                        for (int y2 = y - 1; y2 <= y + 1; ++y2) {
                            for (int z2 = z - 1; z2 <= z + 1; ++z2) {
                                int otherBlockLight;
                                if (x2 == x && y2 == y && z2 == z || x2 < -1 || x2 > 1 || y2 < -1 || y2 > 1 || z2 < -1 || z2 > 1) continue;
                                int otherLight = this.lightLevels[x2 + 1][y2 + 1][z2 + 1];
                                int otherSkyLight = otherLight >> 16;
                                int dist = Math.abs(x2 - x) + Math.abs(y2 - y) + Math.abs(z2 - z);
                                if (otherSkyLight - dist * 16 > maxSky) {
                                    maxSky = otherSkyLight - dist * 16;
                                }
                                if ((otherBlockLight = otherLight & 0xFFFF) - dist * 16 <= maxBlock) continue;
                                maxBlock = otherBlockLight - dist * 16;
                            }
                        }
                    }
                    skyLight = maxSky;
                    blockLight = maxBlock;
                    this.lightLevels[x + 1][y + 1][z + 1] = light = (skyLight << 16) + blockLight;
                }
            }
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitCustomGeometry(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/SubmitNodeCollector$CustomGeometryRenderer;)V", ordinal=0))
    private void submitMapGeometry(class_11659 instance, class_4587 poseStack, class_1921 renderType, class_11659.class_11660 customGeometryRenderer, @Local(ordinal=0, argsOnly=true) int light, @Local(argsOnly=true) class_10090 mapRenderState) {
        int[] lights = new int[]{light, light, light, light};
        if (this.shouldSmoothLight) {
            int[] vertexLights = mapRenderState.getItemFrame().getVertLights();
            for (int i = 0; i < 4; ++i) {
                int rotatedVertNum;
                switch (mapRenderState.rotation()) {
                    default: {
                        int n = i;
                        break;
                    }
                    case 1: 
                    case 5: {
                        int n = vertexRotationMap[0][i];
                        break;
                    }
                    case 2: 
                    case 6: {
                        int n = vertexRotationMap[1][i];
                        break;
                    }
                    case 3: 
                    case 7: {
                        int n = rotatedVertNum = vertexRotationMap[2][i];
                    }
                }
                if (!this.shouldReuseVertexLights) {
                    int lightVal;
                    float f = xPositions[i];
                    float g = yPositions[i];
                    float xInBlock = switch (mapRenderState.rotation()) {
                        case 0, 4 -> f;
                        case 1, 5 -> 1.0f - g;
                        case 2, 6 -> 1.0f - f;
                        case 3, 7 -> g;
                        default -> 0.0f;
                    };
                    float yInBlock = switch (mapRenderState.rotation()) {
                        case 0, 4 -> g;
                        case 1, 5 -> f;
                        case 2, 6 -> 1.0f - g;
                        case 3, 7 -> 1.0f - f;
                        default -> 0.0f;
                    };
                    vertexLights[rotatedVertNum] = lightVal = MapRendererMixin.getLight(this.lightLevels, xInBlock, yInBlock, mapRenderState.direction());
                }
                lights[i] = vertexLights[rotatedVertNum];
            }
            if (!this.shouldReuseVertexLights) {
                mapRenderState.getItemFrame().setVertLights(vertexLights);
            }
        }
        instance.method_73483(poseStack, renderType, (pose, vertexConsumer) -> {
            vertexConsumer.method_56824(pose, 0.0f, 128.0f, -0.01f).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(lights[0]);
            vertexConsumer.method_56824(pose, 128.0f, 128.0f, -0.01f).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(lights[1]);
            vertexConsumer.method_56824(pose, 128.0f, 0.0f, -0.01f).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(lights[2]);
            vertexConsumer.method_56824(pose, 0.0f, 0.0f, -0.01f).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(lights[3]);
        });
    }

    @Unique
    private static int getLight(int[][][] blockLights, float x, float y, class_2350 direction) {
        int light;
        int tl = light = blockLights[1][1][1];
        int tr = light;
        int bl = light;
        int br = light;
        if (x > 0.5f && y > 0.5f) {
            bl = MapRendererMixin.getLightRelative(0, -1, direction, blockLights);
            tr = MapRendererMixin.getLightRelative(1, 0, direction, blockLights);
            br = MapRendererMixin.getLightRelative(1, -1, direction, blockLights);
        }
        if (x < 0.5f && y > 0.5f) {
            tl = MapRendererMixin.getLightRelative(-1, 0, direction, blockLights);
            bl = MapRendererMixin.getLightRelative(-1, -1, direction, blockLights);
            br = MapRendererMixin.getLightRelative(0, -1, direction, blockLights);
        }
        if (x > 0.5f && y < 0.5f) {
            tl = MapRendererMixin.getLightRelative(0, 1, direction, blockLights);
            tr = MapRendererMixin.getLightRelative(1, 1, direction, blockLights);
            br = MapRendererMixin.getLightRelative(1, 0, direction, blockLights);
        }
        if (x < 0.5f && y < 0.5f) {
            tl = MapRendererMixin.getLightRelative(-1, 1, direction, blockLights);
            bl = MapRendererMixin.getLightRelative(-1, 0, direction, blockLights);
            tr = MapRendererMixin.getLightRelative(0, 1, direction, blockLights);
        }
        int lightBlock = MathUtil.midOf4(tl & 0xFFFF, tr & 0xFFFF, bl & 0xFFFF, br & 0xFFFF);
        int lightSky = MathUtil.midOf4(tl >> 16, tr >> 16, bl >> 16, br >> 16);
        return lightBlock + (lightSky << 16);
    }

    @Unique
    private static int getLightRelative(int xStep, int yStep, class_2350 dir, int[][][] blockLights) {
        class_2350 leftDir = switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> class_2350.field_11039;
            case class_2350.field_11036 -> class_2350.field_11039;
            case class_2350.field_11043 -> class_2350.field_11034;
            case class_2350.field_11035 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11043;
            case class_2350.field_11034 -> class_2350.field_11035;
        };
        class_2350 rightDir = switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> class_2350.field_11034;
            case class_2350.field_11036 -> class_2350.field_11034;
            case class_2350.field_11043 -> class_2350.field_11039;
            case class_2350.field_11035 -> class_2350.field_11034;
            case class_2350.field_11039 -> class_2350.field_11035;
            case class_2350.field_11034 -> class_2350.field_11043;
        };
        class_2350 upDir = switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> class_2350.field_11035;
            case class_2350.field_11036 -> class_2350.field_11043;
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> class_2350.field_11036;
        };
        class_2350 downDir = switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> class_2350.field_11043;
            case class_2350.field_11036 -> class_2350.field_11035;
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> class_2350.field_11033;
        };
        class_2338.class_2339 pos = class_2338.field_10980.method_25503();
        if (xStep > 0) {
            pos.method_10104(rightDir, 1);
        }
        if (xStep < 0) {
            pos.method_10104(leftDir, 1);
        }
        if (yStep > 0) {
            pos.method_10104(upDir, 1);
        }
        if (yStep < 0) {
            pos.method_10104(downDir, 1);
        }
        return blockLights[pos.method_10263() + 1][pos.method_10264() + 1][pos.method_10260() + 1];
    }
}

