/*
 * Decompiled with CFR 0.152.
 */
package cc.barnab.smoothmaps.mixin.client.painting;

import cc.barnab.smoothmaps.client.LightUpdateAccessor;
import cc.barnab.smoothmaps.client.MathUtil;
import cc.barnab.smoothmaps.client.RenderRelightCounter;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.class_10049;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_1534;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_928;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_928.class})
public abstract class PaintingRendererMixin
implements RenderRelightCounter {
    @Unique
    private static final String VERTEX_TARGET = "Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V";
    @Unique
    private int numRendered = 0;
    @Unique
    private int numRelit = 0;

    @Shadow
    protected abstract void method_4074(class_4587 var1, class_11659 var2, class_1921 var3, int[] var4, int var5, int var6, class_1058 var7, class_1058 var8);

    @Override
    public int getNumRendered() {
        return this.numRendered;
    }

    @Override
    public int getNumRelit() {
        return this.numRelit;
    }

    @Override
    public void resetCounters() {
        this.numRendered = 0;
        this.numRelit = 0;
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/decoration/Painting;Lnet/minecraft/client/renderer/entity/state/PaintingRenderState;F)V"}, at={@At(value="TAIL")})
    public void extractRenderState(class_1534 painting, class_10049 paintingRenderState, float f, CallbackInfo ci) {
        paintingRenderState.setPainting(painting);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/decoration/Painting;Lnet/minecraft/client/renderer/entity/state/PaintingRenderState;F)V"}, at={@At(value="TAIL")})
    private void lightPainting(class_1534 painting, class_10049 paintingRenderState, float f, CallbackInfo ci) {
        ++this.numRendered;
        if (class_310.method_1588()) {
            boolean shouldRelight;
            assert (paintingRenderState.field_53497 != null);
            int[] vertLights = painting.getVertLights();
            class_2338 blockPos = class_2338.method_49637((double)paintingRenderState.field_53325, (double)paintingRenderState.field_53326, (double)paintingRenderState.field_53327);
            assert (class_310.method_1551().field_1687 != null);
            class_3568 lightEngine = class_310.method_1551().field_1687.method_22336();
            boolean bl = shouldRelight = ((LightUpdateAccessor)lightEngine).getLastUpdated() > painting.getLastUpdated() || !blockPos.equals((Object)painting.getLastBlockPos()) || !painting.method_5735().equals((Object)painting.getLastDirection()) || vertLights == null;
            if (shouldRelight) {
                int pWidth = paintingRenderState.field_53497.comp_2670();
                int pHeight = paintingRenderState.field_53497.comp_2671();
                int frontFaceVertCount = (pWidth + 1) * (pHeight + 1);
                if (vertLights == null || vertLights.length < frontFaceVertCount) {
                    vertLights = new int[frontFaceVertCount];
                }
                for (int v = 0; v < frontFaceVertCount; ++v) {
                    int blockX = Math.min(v % (pWidth + 1), pWidth - 1);
                    int blockY = Math.min(v / (pWidth + 1), pHeight - 1);
                    int blockIdx = blockY * pWidth + blockX;
                    float xInBlock = v % (pWidth + 1) > blockX ? 0.5f : -0.5f;
                    float yInBlock = v > blockIdx + blockY ? 0.5f : -0.5f;
                    vertLights[v] = this.getLight(blockX, blockY, pWidth, pHeight, paintingRenderState.field_53498, xInBlock, yInBlock);
                }
                ++this.numRelit;
                painting.setVertLights(vertLights);
                painting.setLastUpdated(class_310.method_1551().field_1773.getLastRenderTime());
                painting.setLastBlockPos(blockPos);
                painting.setLastDirection(painting.method_5735());
            }
            paintingRenderState.field_53498 = vertLights;
        }
    }

    @Inject(method={"method_72990"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;getV(F)F", ordinal=2)})
    private void performEdgeChecks(CallbackInfo ci, @Local(argsOnly=true, ordinal=0) int pWidth, @Local(argsOnly=true, ordinal=1) int pHeight, @Local(ordinal=2) int blockX, @Local(ordinal=3) int blockY, @Share(value="isNorthEdge") LocalBooleanRef isNorthEdge, @Share(value="isEastEdge") LocalBooleanRef isEastEdge, @Share(value="isSouthEdge") LocalBooleanRef isSouthEdge, @Share(value="isWestEdge") LocalBooleanRef isWestEdge, @Share(value="blockPos") LocalRef<class_2338> blockPos) {
        isNorthEdge.set(blockY == pHeight - 1);
        isWestEdge.set(blockX == pWidth - 1);
        isSouthEdge.set(blockY == 0);
        isEastEdge.set(blockX == 0);
    }

    @WrapWithCondition(method={"method_72990"}, at={@At(ordinal=8, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=9, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=10, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=11, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V")})
    private boolean preventNorthFace(class_928 instance, class_4587.class_4665 pose, class_4588 vertexConsumer, float f, float g, float h, float i, float j, int k, int l, int m, int n, @Share(value="isNorthEdge") LocalBooleanRef isEdge) {
        return isEdge.get();
    }

    @WrapWithCondition(method={"method_72990"}, at={@At(ordinal=12, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=13, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=14, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=15, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V")})
    private boolean preventSouthFace(class_928 instance, class_4587.class_4665 pose, class_4588 vertexConsumer, float f, float g, float h, float i, float j, int k, int l, int m, int n, @Share(value="isSouthEdge") LocalBooleanRef isEdge) {
        return isEdge.get();
    }

    @WrapWithCondition(method={"method_72990"}, at={@At(ordinal=16, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=17, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=18, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=19, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V")})
    private boolean preventWestFace(class_928 instance, class_4587.class_4665 pose, class_4588 vertexConsumer, float f, float g, float h, float i, float j, int k, int l, int m, int n, @Share(value="isWestEdge") LocalBooleanRef isEdge) {
        return isEdge.get();
    }

    @WrapWithCondition(method={"method_72990"}, at={@At(ordinal=20, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=21, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=22, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"), @At(ordinal=23, value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V")})
    private boolean preventEastFace(class_928 instance, class_4587.class_4665 pose, class_4588 vertexConsumer, float f, float g, float h, float i, float j, int k, int l, int m, int n, @Share(value="isEastEdge") LocalBooleanRef isEdge) {
        return isEdge.get();
    }

    @Redirect(method={"method_72990"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/PaintingRenderer;vertex(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFIIII)V"))
    private void vertexWithSmoothLight(class_928 instance, class_4587.class_4665 pose, class_4588 vertexConsumer, float f, float g, float h, float i, float j, int k, int l, int m, int n, @Local(ordinal=0, argsOnly=true) int[] lightCoords, @Local(ordinal=0, argsOnly=true) int pWidth, @Local(ordinal=1, argsOnly=true) int pHeight, @Local(ordinal=2) int blockX, @Local(ordinal=3) int blockY) {
        if (class_310.method_1588()) {
            int packedVertPos = (int)((g + (float)pHeight / 2.0f) * (float)(pWidth + 1) + (f + (float)pWidth / 2.0f));
            n = lightCoords[packedVertPos];
        }
        vertexConsumer.method_56824(pose, f, g, j).method_39415(-1).method_22913(h, i).method_22922(class_4608.field_21444).method_60803(n).method_60831(pose, (float)k, (float)l, (float)m);
    }

    @Unique
    private int getLight(int blockX, int blockY, int pWidth, int pHeight, int[] lightCoords, float x, float y) {
        int light;
        int tl = light = lightCoords[blockX + blockY * pWidth];
        int tr = light;
        int bl = light;
        int br = light;
        if (x > 0.5f && y < 0.5f) {
            bl = this.getLightRelative(0, -1, blockX, blockY, pWidth, pHeight, lightCoords);
            tr = this.getLightRelative(1, 0, blockX, blockY, pWidth, pHeight, lightCoords);
            br = this.getLightRelative(1, -1, blockX, blockY, pWidth, pHeight, lightCoords);
        }
        if (x < 0.5f && y < 0.5f) {
            tl = this.getLightRelative(-1, 0, blockX, blockY, pWidth, pHeight, lightCoords);
            bl = this.getLightRelative(-1, -1, blockX, blockY, pWidth, pHeight, lightCoords);
            br = this.getLightRelative(0, -1, blockX, blockY, pWidth, pHeight, lightCoords);
        }
        if (x > 0.5f && y > 0.5f) {
            tl = this.getLightRelative(0, 1, blockX, blockY, pWidth, pHeight, lightCoords);
            tr = this.getLightRelative(1, 1, blockX, blockY, pWidth, pHeight, lightCoords);
            br = this.getLightRelative(1, 0, blockX, blockY, pWidth, pHeight, lightCoords);
        }
        if (x < 0.5f && y > 0.5f) {
            tl = this.getLightRelative(-1, 1, blockX, blockY, pWidth, pHeight, lightCoords);
            bl = this.getLightRelative(-1, 0, blockX, blockY, pWidth, pHeight, lightCoords);
            tr = this.getLightRelative(0, 1, blockX, blockY, pWidth, pHeight, lightCoords);
        }
        int lightBlock = MathUtil.midOf4(tl & 0xFFFF, tr & 0xFFFF, bl & 0xFFFF, br & 0xFFFF);
        int lightSky = MathUtil.midOf4(tl >> 16, tr >> 16, bl >> 16, br >> 16);
        return lightBlock + (lightSky << 16);
    }

    @Unique
    private int getLightRelative(int xStep, int yStep, int blockX, int blockY, int pWidth, int pHeight, int[] lightCoords) {
        if (xStep > 0 && blockX != pWidth - 1) {
            ++blockX;
        }
        if (xStep < 0 && blockX != 0) {
            --blockX;
        }
        if (yStep > 0 && blockY != pHeight - 1) {
            ++blockY;
        }
        if (yStep < 0 && blockY != 0) {
            --blockY;
        }
        return lightCoords[blockX + blockY * pWidth];
    }
}

