/*
 * Decompiled with CFR 0.152.
 */
package org.ptr47.tfmg_stellaris_compat.generators;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.ptr47.tfmg_stellaris_compat.config.TFMGStellarisCompatConfigs;
import org.ptr47.tfmg_stellaris_compat.generators.RadioactiveGeneratorBlock;
import org.ptr47.tfmg_stellaris_compat.registry.BlockEntities;
import org.ptr47.tfmg_stellaris_compat.registry.Tags;

public class RadioactiveGeneratorBlockEntity
extends ElectricBlockEntity {
    private final SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return RadioactiveGeneratorBlockEntity.this.isFuel(stack);
        }
    }.withMaxStackSize(64).allowInsertion().allowExtraction().whenContentsChanged(slot -> this.tryActivate());
    private int burnTimeLeft = 0;
    private int burnTimeTotal = 0;
    private int currentPowerLevel = 0;
    private ItemStack currentFuel = null;

    public RadioactiveGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.updateNetwork();
        if (this.burnTimeLeft > 0) {
            --this.burnTimeLeft;
            if (this.burnTimeLeft == 0) {
                this.currentPowerLevel = 0;
                this.setLitBlockState(false);
                this.tryActivate();
            }
        }
    }

    private void tryActivate() {
        if (this.burnTimeLeft > 0) {
            return;
        }
        ItemStack stack = this.inventory.getItem(0);
        if (!this.isFuel(stack)) {
            return;
        }
        this.burnTimeLeft = this.burnTimeTotal = this.getBurnDuration(stack);
        this.currentPowerLevel = this.getPowerLevelForFuel(stack);
        stack.shrink(1);
        this.setLitBlockState(true);
        this.updateNextTick();
        this.setChanged();
        this.sendData();
    }

    private void setLitBlockState(boolean isLit) {
        BlockState state = (BlockState)this.getBlockState().setValue((Property)RadioactiveGeneratorBlock.LIT, (Comparable)Boolean.valueOf(isLit));
        this.level.setBlock(this.getBlockPos(), state, 3);
    }

    private int getPowerLevelForFuel(ItemStack stack) {
        boolean isRefined;
        boolean bl = isRefined = stack.is(Tags.Items.INGOTS) || stack.is(Tags.Items.STORAGE_BLOCKS);
        int tier = stack.is(Tags.RTG_FUEL_LOW) ? 0 : (stack.is(Tags.RTG_FUEL_MEDIUM) ? 1 : (stack.is(Tags.RTG_FUEL_HIGH) ? 2 : (stack.is(Tags.RTG_FUEL_EXTREME) ? 3 : -1)));
        int refinementBonus = 40;
        return isRefined ? refinementBonus + tier * 5 : tier + 1;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntities.RADIOACTIVE_GENERATOR.get(), (be, dir) -> be.getInventory());
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("burnLeft", this.burnTimeLeft);
        compound.putInt("burnTotal", this.burnTimeTotal);
        compound.putInt("powerLevel", this.currentPowerLevel);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("inventory"));
        this.burnTimeLeft = compound.getInt("burnLeft");
        this.burnTimeTotal = compound.getInt("burnTotal");
        this.currentPowerLevel = compound.getInt("powerLevel");
    }

    private int getBurnDuration(ItemStack stack) {
        boolean isBlock = stack.is(Tags.Items.STORAGE_BLOCKS);
        boolean isNugget = stack.is(Tags.Items.NUGGETS);
        int burnTime = 0;
        if (stack.is(Tags.RTG_FUEL_LOW)) {
            burnTime = (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.burnTimeLow.get();
        } else if (stack.is(Tags.RTG_FUEL_MEDIUM)) {
            burnTime = (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.burnTimeMedium.get();
        } else if (stack.is(Tags.RTG_FUEL_HIGH)) {
            burnTime = (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.burnTimeHigh.get();
        } else if (stack.is(Tags.RTG_FUEL_EXTREME)) {
            burnTime = (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.burnTimeExtreme.get();
        }
        return isBlock ? burnTime * 10 : (isNugget ? burnTime / 9 : burnTime);
    }

    public int voltageGeneration() {
        int base = this.currentPowerLevel > 0 ? (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.voltageBase.get() : 0;
        return base + this.currentPowerLevel * (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.voltagePerLevel.get();
    }

    public int powerGeneration() {
        float lifeFraction = (float)this.burnTimeLeft / (float)this.burnTimeTotal;
        double maxDecay = (Double)TFMGStellarisCompatConfigs.common().rtgConfig.maxRTGPowerDecay.get();
        float decayFactor = (float)(1.0 - maxDecay + maxDecay * (double)lifeFraction);
        int maxPower = (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.powerBase.get() + this.currentPowerLevel * (Integer)TFMGStellarisCompatConfigs.common().rtgConfig.powerPerLevel.get();
        return Math.round(decayFactor * (float)maxPower);
    }

    public SmartInventory getInventory() {
        return this.inventory;
    }

    public boolean isFuel(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(Tags.RTG_FUELS);
    }
}

