/*
 * Decompiled with CFR 0.152.
 */
package org.ptr47.tfmg_stellaris_compat.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceItemLootModifier
extends LootModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceItemLootModifier.class);
    public static final Codec<Replacement> REPLACEMENT_CODEC = Codec.list((Codec)BuiltInRegistries.ITEM.byNameCodec()).comapFlatMap(list -> {
        if (list.size() != 2) {
            return DataResult.error(() -> "Replacement must have exactly 2 items");
        }
        return DataResult.success((Object)new Replacement((Item)list.get(0), (Item)list.get(1)));
    }, r -> List.of(r.from(), r.to()));
    public static final MapCodec<ReplaceItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list(REPLACEMENT_CODEC).fieldOf("replacements").forGetter(m -> m.replacements)).and((App)Codec.STRING.optionalFieldOf("namespace", (Object)"stellaris").forGetter(m -> m.namespace)).apply((Applicative)inst, ReplaceItemLootModifier::new));
    private final List<Replacement> replacements;
    private final String namespace;

    protected ReplaceItemLootModifier(LootItemCondition[] conditions, List<Replacement> replacements, String namespace) {
        super(conditions);
        this.replacements = replacements;
        this.namespace = namespace;
        LOGGER.info("[ReplaceItemLootModifier] Loaded with {} replacements", (Object)replacements.size());
        for (Replacement r : replacements) {
            LOGGER.info(" - {} -> {}", (Object)BuiltInRegistries.ITEM.getKey((Object)r.from()), (Object)BuiltInRegistries.ITEM.getKey((Object)r.to()));
        }
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ResourceLocation tableId = context.getQueriedLootTableId();
        if (!this.namespace.equals(tableId.getNamespace())) {
            return generatedLoot;
        }
        for (int i = 0; i < generatedLoot.size(); ++i) {
            ItemStack stack = (ItemStack)generatedLoot.get(i);
            for (Replacement r : this.replacements) {
                if (stack.getItem() != r.from()) continue;
                LOGGER.info("[ReplaceItemLootModifier] Replacing {} with {} (count: {})", new Object[]{BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), BuiltInRegistries.ITEM.getKey((Object)r.to()), stack.getCount()});
                generatedLoot.set(i, (Object)new ItemStack((ItemLike)r.to(), stack.getCount()));
            }
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public record Replacement(Item from, Item to) {
    }
}

