package com.boyonk.horarium.block;

import com.boyonk.horarium.Horarium;
import com.boyonk.horarium.block.entity.HourglassBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HourglassBlock extends class_2237 {

    public static final MapCodec<HourglassBlock> CODEC = method_54094(HourglassBlock::new);

    public static final class_265 SHAPE = class_259.method_17786(
            method_9541(5,11,5,11,12,11),
            method_9541(6,1,6,10,11,10),
            method_9541(5,0,5,11,1,11)
    );

    public static final class_2758 PROGRESS = class_2758.method_11867("progress", 0, 5);

    public HourglassBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(PROGRESS, 0));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(PROGRESS);
    }


    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!(world.method_8321(pos) instanceof HourglassBlockEntity blockEntity)) return class_1269.field_5814;

        if (world.method_8608()) return class_1269.field_5812;

        if (state.method_11654(PROGRESS) != 5 || player.method_21823()) {
            player.method_17355(blockEntity);
        } else {
            blockEntity.flip();
        }
        return class_1269.field_5812;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HourglassBlockEntity(pos, state);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, Horarium.BLOCK_ENTITY, HourglassBlockEntity::tick);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return method_20044(world, pos.method_10074(), class_2350.field_11036);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == class_2350.field_11033 && !this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_1263) {
            class_1264.method_5451(world, pos, (class_1263) blockEntity);
            world.method_8455(pos, this);
        }
        super.method_9615(state, world, pos, newState, moved);
    }

    @Override
    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}
