package com.boyonk.horarium.screen;

import com.boyonk.horarium.Horarium;
import com.boyonk.horarium.block.entity.HourglassBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3915;

public class HourglassScreenHandler extends class_1703 {

    private final class_1263 inventory;
    private final class_3915 nextDropTime;

    public HourglassScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, new class_1277(2), class_3915.method_17403());
    }

    public HourglassScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3915 nextDropTime) {
        super(Horarium.SCREEN_HANDLER, syncId);

        method_17359(inventory, 2);

        this.inventory = inventory;
        this.nextDropTime = nextDropTime;

        inventory.method_5435(playerInventory.field_7546);

        int r;
        int c;

        //Our inventory
        this.method_7621(new class_1735(inventory, HourglassBlockEntity.TOP_SLOT, 80, 17) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(Horarium.FLOWS_IN_HOURGLASS);
            }
        });
        this.method_7621(new class_1735(inventory, HourglassBlockEntity.BOTTOM_SLOT, 80, 71) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(Horarium.FLOWS_IN_HOURGLASS);
            }
        });

        //Player Inventory
        for (r = 0; r < 3; r++) {
            for (c = 0; c < 9; c++) {
                this.method_7621(new class_1735(playerInventory, c + r * 9 + 9, 8 + c * 18, 102 + r * 18));
            }
        }

        //Player Hotbar
        for (c = 0; c < 9; c++) {
            this.method_7621(new class_1735(playerInventory, c, 8 + c * 18, 160));
        }

        this.method_17362(this.nextDropTime);
    }


    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(invSlot);
        if (slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439()) {
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }

            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }

        return newStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public float getProgress() {
        class_1799 top = this.inventory.method_5438(HourglassBlockEntity.TOP_SLOT);
        class_1799 bottom = this.inventory.method_5438(HourglassBlockEntity.BOTTOM_SLOT);

        float total = top.method_7947() + bottom.method_7947();
        float current = bottom.method_7947();

        current += (1 - (this.nextDropTime.method_17407() / (float) Horarium.TICKS_PER_SAND)) % 1;


        return class_3532.method_15363(current / total, 0, 1);
    }


    public float getTimeLeft() {
        float progress = this.getProgress();

        if (progress == 1f) return 0;

        class_1799 top = this.inventory.method_5438(HourglassBlockEntity.TOP_SLOT);
        class_1799 bottom = this.inventory.method_5438(HourglassBlockEntity.BOTTOM_SLOT);

        float total = top.method_7947() + bottom.method_7947();

        return ((total * Horarium.TICKS_PER_SAND) / 20) * (1 - progress);
    }
}
