/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.horarium.block.entity;

import com.boyonk.horarium.Horarium;
import com.boyonk.horarium.block.HourglassBlock;
import com.boyonk.horarium.screen.HourglassScreenHandler;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3915;
import net.minecraft.class_5819;

public class HourglassBlockEntity
extends class_2621 {
    public static final int TOP_SLOT = 0;
    public static final int BOTTOM_SLOT = 1;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private final class_3915 property = new class_3915(){

        public int method_17407() {
            return HourglassBlockEntity.this.nextDropTime;
        }

        public void method_17404(int value) {
        }
    };
    private int nextDropTime = 0;

    public HourglassBlockEntity(class_2338 pos, class_2680 state) {
        super(Horarium.BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, HourglassBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        if (!entity.canDrop()) {
            entity.nextDropTime = 0;
        } else if (entity.nextDropTime == 0) {
            entity.nextDropTime = 20;
        } else {
            --entity.nextDropTime;
            world.method_8396(null, pos, Horarium.SOUND, class_3419.field_15245, entity.getVolume(), entity.getPitch(world.field_9229));
            if (entity.nextDropTime == 0) {
                entity.drop();
            }
            entity.method_5431();
        }
        int progress = entity.getState();
        if ((Integer)state.method_11654((class_2769)HourglassBlock.PROGRESS) != progress) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)HourglassBlock.PROGRESS, (Comparable)Integer.valueOf(progress)));
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, this.inventory);
        }
        if (this.nextDropTime != 0) {
            view.method_71465("next_drop_time", this.nextDropTime);
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, this.inventory);
        }
        view.method_71439("next_drop_time").ifPresent(nextDropTime -> {
            this.nextDropTime = nextDropTime;
        });
    }

    public int method_5439() {
        return this.inventory.size();
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.horarium.hourglass");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new HourglassScreenHandler(syncId, playerInventory, (class_1263)this, this.property);
    }

    public void flip() {
        class_1799 top = this.method_5438(0);
        class_1799 bottom = this.method_5438(1);
        this.method_5447(0, bottom);
        this.method_5447(1, top);
    }

    public boolean canDrop() {
        class_1799 top = this.method_5438(0);
        if (top.method_7960()) {
            return false;
        }
        class_1799 bottom = this.method_5438(1);
        return bottom.method_7960() || class_1799.method_31577((class_1799)top, (class_1799)bottom) && bottom.method_7947() < bottom.method_7914();
    }

    public void drop() {
        class_1799 top = this.method_5438(0);
        class_1799 bottom = this.method_5438(1);
        if (bottom.method_7960()) {
            this.method_5447(1, top.method_46651(1));
            top.method_7934(1);
        } else if (class_1799.method_31577((class_1799)top, (class_1799)bottom) && bottom.method_7947() < bottom.method_7914()) {
            bottom.method_7933(1);
            top.method_7934(1);
        }
    }

    public float getProgress() {
        class_1799 top = this.method_5438(0);
        class_1799 bottom = this.method_5438(1);
        float total = top.method_7947() + bottom.method_7947();
        return (float)bottom.method_7947() / total;
    }

    private int getState() {
        if (this.method_5442()) {
            return 0;
        }
        return 1 + class_3532.method_15375((float)(4.0f * this.getProgress()));
    }

    public float getVolume() {
        return 1.0f - this.getProgress() * 0.5f;
    }

    public float getPitch(class_5819 random) {
        return 0.7f + this.getProgress() * 0.3f + random.method_43057() * 0.2f;
    }
}

