/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import java.util.function.Supplier;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.minecraft.resources.ResourceLocation;

public class ClientConfigs {
    public static final ModConfigHolder CONFIG_SPEC;
    public static final Supplier<Boolean> COLORED_TEXT;
    public static final Supplier<Boolean> OUTLINE;
    public static final Supplier<Boolean> IS_RECOLORED;
    public static final Supplier<Boolean> REDUCE_COLORS;
    public static final Supplier<Integer> TEXTURE_SIZE;
    public static final Supplier<Preset> COLOR_PRESET;

    public static void init() {
    }

    static {
        if (PlatHelper.getPhysicalSide().isServer() && PlatHelper.isDev()) {
            throw new AssertionError((Object)"Tried to load client configs on server side");
        }
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)LabelsMod.res("client"), (ConfigType)ConfigType.CLIENT);
        builder.push("general");
        COLORED_TEXT = builder.comment("If text is enabled, allows it to accept the label dye color").define("colored_text", true);
        TEXTURE_SIZE = builder.comment("Item texture resolution. You might want to keep this multiples of 16").define("texture_resolution", 16, 8, 512);
        builder.pop();
        builder.push("color_settings");
        IS_RECOLORED = builder.comment("Greyscales then recolors each item. You can customize said colors by overriding 'label_colors.png' with a resourcepack").define("recolor_texture", true);
        COLOR_PRESET = builder.comment("picks one of the 3 presets for dyes on labels. This simply changes the texture that is used.Requires a resource pack reloadNote that you can always change this manually with a resource pack to control all the colors individually").define("color_texture_preset", (Enum)Preset.PENCIL);
        REDUCE_COLORS = builder.comment("Reduce colors of original image before processing. Makes 3d blocks more 2d like by giving them a limited palette").define("limit_palette", true);
        OUTLINE = builder.comment("Adds an outline to label images").define("outline", true);
        builder.pop();
        builder.onChange(RenderedTexturesManager::clearCache);
        CONFIG_SPEC = builder.build();
        CONFIG_SPEC.forceLoad();
    }

    public static enum Preset {
        DEFAULT(""),
        PENCIL("pencil_"),
        PASTEL("pastel_"),
        FLAT("flat_");

        private final String name;

        private Preset(String pastel) {
            this.name = pastel;
        }

        public String getName() {
            return this.name;
        }
    }
}

