/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.mehvahdjukaar.labels.ClientConfigs;
import net.mehvahdjukaar.labels.ColorManager;
import net.mehvahdjukaar.labels.LabelEntity;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.labels.LabelsModClient;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1011;
import net.minecraft.class_1059;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LabelEntityRenderer
extends class_897<LabelEntity> {
    private final class_778 modelRenderer;
    private final class_1092 modelManager;
    private final class_4184 camera;

    public LabelEntityRenderer(class_5617.class_5618 context) {
        super(context);
        class_310 minecraft = class_310.method_1551();
        this.modelRenderer = minecraft.method_1541().method_3350();
        this.modelManager = minecraft.method_1541().method_3351().method_3333();
        this.camera = minecraft.field_1773.method_19418();
    }

    public void render(LabelEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int light) {
        FrameBufferBackedDynamicTexture tex;
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, buffer, light);
        if (this.field_4676.method_3958()) {
            class_2338 behind = entity.calculateBehindPos();
            class_4588 lines = buffer.getBuffer(class_1921.method_23594());
            poseStack.method_22903();
            class_243 ep = entity.method_19538();
            class_243 vec3 = new class_243((double)behind.method_10263() - ep.field_1352, (double)behind.method_10264() - ep.field_1351, (double)behind.method_10260() - ep.field_1350);
            class_238 bb = new class_238(vec3, vec3.method_1031(1.0, 1.0, 1.0)).method_1014(0.01);
            class_761.method_22982((class_4587)poseStack, (class_4588)lines, (class_238)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            poseStack.method_22909();
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-entity.method_36455()));
        poseStack.method_22904(0.0, 0.0, -0.46875);
        poseStack.method_22904(-0.5, -0.5, -0.5);
        this.modelRenderer.method_3367(poseStack.method_23760(), buffer.getBuffer(class_4722.method_24074()), null, ClientHelper.getModel((class_1092)this.modelManager, (class_1091)LabelsModClient.LABEL_MODEL), 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        class_1792 item = entity.getItem().method_7909();
        class_2960 id = entity.getTextureId();
        if (item != class_1802.field_8162 && id != null && (tex = RenderedTexturesManager.requestFlatItemTexture((class_2960)id, (class_1792)item, (int)ClientConfigs.TEXTURE_SIZE.get(), i -> {
            try {
                LabelEntityRenderer.postProcess(i, entity.getColor());
            }
            catch (Exception e) {
                LabelsMod.LOGGER.warn("Failed to correctly create label image for {}:", i, (Object)e);
            }
        })).isInitialized()) {
            boolean hasText = entity.hasText();
            class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)tex.getTextureLocation()));
            class_4587.class_4665 pose = poseStack.method_23760();
            int overlay = class_4608.field_21444;
            float z = 0.9875f;
            float s = hasText ? 0.1875f : 0.25f;
            poseStack.method_22904(0.5, hasText ? 0.575 : 0.5, (double)z);
            poseStack.method_22903();
            boolean glow = entity.hasGlowInk();
            if (glow) {
                light = 0xF000F0;
            }
            vertexConsumer.method_56824(pose, -s, -s, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_22922(overlay).method_60803(light).method_60831(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.method_56824(pose, -s, s, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_22922(overlay).method_60803(light).method_60831(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.method_56824(pose, s, s, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_22922(overlay).method_60803(light).method_60831(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.method_56824(pose, s, -s, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(light).method_60831(pose, 0.0f, 0.0f, -1.0f);
            poseStack.method_22909();
            if (hasText) {
                this.drawLabelText(poseStack, buffer, entity, entity.getItem().method_7964(), glow, light);
            }
        }
        poseStack.method_22909();
    }

    private static void postProcess(class_1011 image, @Nullable class_1767 tint) {
        TextureImage outlineTexture;
        boolean outline;
        boolean reduceColors = ClientConfigs.REDUCE_COLORS.get();
        boolean recolor = ClientConfigs.IS_RECOLORED.get();
        boolean bl = outline = ClientConfigs.OUTLINE.get() != false && recolor;
        if (recolor || reduceColors) {
            SpriteUtils.mergeSimilarColors((class_1011)image, (float)0.015f);
        }
        if (recolor) {
            SpriteUtils.grayscaleImage((class_1011)image);
        }
        TextureImage originalTexture = TextureImage.of((class_1011)image, (McMetaFile)null);
        if (outline) {
            ArrayList outlinePosition = new ArrayList();
            outlineTexture = originalTexture.makeCopy();
            SpriteUtils.forEachPixel((class_1011)outlineTexture.getImage(), (x, y) -> {
                int c = outlineTexture.getImage().method_4315(x.intValue(), y.intValue());
                if (new RGBColor(c).alpha() != 0.0f && (x == 0 || new RGBColor(image.method_4315(x - 1, y.intValue())).alpha() == 0.0f || x == image.method_4307() - 1 || new RGBColor(image.method_4315(x + 1, y.intValue())).alpha() == 0.0f || y == 0 || new RGBColor(image.method_4315(x.intValue(), y - 1)).alpha() == 0.0f || y == image.method_4323() - 1 || new RGBColor(image.method_4315(x.intValue(), y + 1)).alpha() == 0.0f)) {
                    outlinePosition.add(Pair.of((Object)x, (Object)y));
                }
            });
            SpriteUtils.forEachPixel((class_1011)outlineTexture.getImage(), (x, y) -> {
                if (!outlinePosition.contains(Pair.of((Object)x, (Object)y))) {
                    outlineTexture.getImage().method_4305(x.intValue(), y.intValue(), 0);
                } else {
                    originalTexture.getImage().method_4305(x.intValue(), y.intValue(), 0);
                }
            });
        } else {
            outlineTexture = null;
        }
        if (reduceColors) {
            int cutoff = 11;
            IntUnaryOperator fn = i -> {
                if (i < cutoff) {
                    return i;
                }
                return (int)(Math.pow(i - cutoff + 1, 0.3333333432674408) + (double)cutoff - 1.0);
            };
            SpriteUtils.reduceColors((class_1011)image, (IntUnaryOperator)fn);
            if (outlineTexture != null) {
                int maxOutlineColors = 3;
                try {
                    SpriteUtils.reduceColors((class_1011)outlineTexture.getImage(), j -> Math.min(j, maxOutlineColors));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (recolor) {
            Palette old;
            int s;
            RGBColor dark = new RGBColor(ColorManager.getDark(tint));
            RGBColor light = new RGBColor(ColorManager.getLight(tint));
            if (ClientConfigs.COLOR_PRESET.get() != ClientConfigs.Preset.DEFAULT) {
                dark = dark.asHCL();
                light = light.asHCL();
            }
            Palette newPalette = (s = (old = Palette.fromImage((TextureImage)originalTexture, null, (float)0.0f)).size()) < 3 ? Palette.ofColors(List.of(light.asRGB(), dark.asRGB())) : Palette.fromArc((BaseColor)light.asRGB(), (BaseColor)dark.asRGB(), (int)(s + (outline ? 2 : 0)));
            if (outline) {
                Palette newOutlinePalette;
                if (newPalette.size() > 4) {
                    newOutlinePalette = Palette.ofColors(List.of(newPalette.remove(0).rgb()));
                    PaletteColor v = newPalette.remove(0);
                    newOutlinePalette.add(v);
                    newOutlinePalette.add(newPalette.getDarkest());
                } else {
                    newOutlinePalette = newPalette.copy();
                    newOutlinePalette.add(newPalette.getDarkest().getDarkened());
                }
                LabelEntityRenderer.fastInPlaceRecolor(outlineTexture.getImage(), Palette.fromImage((TextureImage)outlineTexture), newOutlinePalette);
            }
            LabelEntityRenderer.fastInPlaceRecolor(image, old, newPalette);
        }
        if (outlineTexture != null) {
            originalTexture.applyOverlay(new TextureImage[]{outlineTexture});
            outlineTexture.close();
        }
    }

    private static void fastInPlaceRecolor(class_1011 image, Palette old, Palette newPalette) {
        assert (old.size() <= newPalette.size()) : "Palettes must have same size";
        SpriteUtils.forEachPixel((class_1011)image, (x, y) -> {
            int c = image.method_4315(x.intValue(), y.intValue());
            for (int i = 0; i < old.size(); ++i) {
                if (((PaletteColor)old.getValues().get(i)).value() != c) continue;
                c = ((PaletteColor)newPalette.getValues().get(i)).value();
                image.method_4305(x.intValue(), y.intValue(), c);
                break;
            }
        });
    }

    private void drawLabelText(class_4587 matrixStack, class_4597 buffer, LabelEntity entity, class_2561 text, boolean glow, int light) {
        class_1767 d;
        matrixStack.method_22905(-1.0f, 1.0f, -1.0f);
        class_327 font = class_310.method_1551().field_1772;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.25, 0.0);
        if (entity.needsVisualUpdate()) {
            float paperHeight = 0.100000024f;
            float paperWidth = 0.45f;
            Pair pair = TextUtil.fitLinesToBox((class_327)font, (class_5348)text, (float)paperWidth, (float)paperHeight);
            entity.setLabelText((class_5481[])((List)pair.getFirst()).toArray(class_5481[]::new));
            entity.setLabelTextScale(((Float)pair.getSecond()).floatValue());
        }
        float scale = entity.getLabelTextScale();
        class_5481[] tempPageLines = entity.getLabelText();
        matrixStack.method_22904(0.0, -0.475, 0.0);
        matrixStack.method_22905(scale, -scale, scale);
        class_1767 c = class_1767.field_7963;
        if (ClientConfigs.COLORED_TEXT.get().booleanValue() && (d = entity.getColor()) != null) {
            c = d;
        }
        TextUtil.renderAllLines((class_5481[])tempPageLines, (int)10, (class_327)font, (class_4587)matrixStack, (class_4597)buffer, (TextUtil.RenderProperties)TextUtil.renderProperties((class_1767)c, (boolean)glow, (float)1.5f, (int)light, (class_2583)class_2583.field_24360, (Vector3f)entity.method_5735().method_23955(), () -> new LOD(this.camera, entity.method_24515()).isVeryNear()));
        matrixStack.method_22909();
    }

    public class_243 getRenderOffset(LabelEntity entity, float partialTicks) {
        return class_243.field_1353;
    }

    public class_2960 getTextureLocation(LabelEntity labelEntity) {
        return class_1059.field_5275;
    }

    protected boolean shouldShowName(LabelEntity labelEntity) {
        return false;
    }
}

