/*
 * Decompiled with CFR 0.152.
 */
package com.pixelindiedev.ghast_sight_pixelindiedev.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelindiedev.ghast_sight_pixelindiedev.config.HeightEnum;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhastModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "ghast_sight.json";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"GhastSight");
    public static final File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "ghast_sight.json");
    public HeightEnum HeightDifference = HeightEnum.Medium;
    public transient long lastModified = 0L;

    public static GhastModConfig load() {
        GhastModConfig config = new GhastModConfig();
        JsonObject obj = new JsonObject();
        boolean changed = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.isJsonObject()) {
                    obj = element.getAsJsonObject();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config, restoring defaults.", (Throwable)e);
                config = new GhastModConfig();
            }
        } else {
            LOGGER.warn("Config file not found, creating a new one.");
            config = new GhastModConfig();
            changed = true;
        }
        if (!obj.has("HeightDifference")) {
            LOGGER.warn("Missing option 'HeightDifference', adding default (Medium).");
            obj.addProperty("HeightDifference", HeightEnum.Medium.name());
            changed = true;
        }
        config = (GhastModConfig)GSON.fromJson((JsonElement)obj, GhastModConfig.class);
        if (changed) {
            config.save();
        }
        config.lastModified = configFile.lastModified();
        return config;
    }

    public void save() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), FILE_NAME);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
            this.lastModified = configFile.lastModified();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config:", (Throwable)e);
        }
    }

    public boolean hasExternalChange() {
        return configFile.exists() && configFile.lastModified() != this.lastModified;
    }
}

