#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float GameTime;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    float shadow = 1.;
    if (vertexColor.r<0.25 && vertexColor.g<0.25 && vertexColor.b<0.25) {
        shadow = 0.2;
    }
    vec4 color_untinted = texture(Sampler0, texCoord0) * vec4(shadow,shadow,shadow,1.);
    if (color.a < 0.1) {
        discard;
    }
    if (color.a < 1 && color.a >0.996) {
        fragColor = linear_fog(color_untinted, vertexDistance, FogStart, FogEnd, FogColor);
    } else {
        fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
    }
    
}
