/*
 * Decompiled with CFR 0.152.
 */
package com.hamarb123.macos_input_fixes.client.compat;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class IxerisCompat {
    private static final boolean _isModPresent = FabricLoader.getInstance().isModLoaded("ixeris");
    private static final Object _ixerisApi;
    private static final MethodHandle _runOnRenderThreadHandle;

    public static boolean isModPresent() {
        return _isModPresent;
    }

    public static void runOnRenderThread(Runnable runnable) {
        try {
            _runOnRenderThreadHandle.invoke(_ixerisApi, runnable);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception invoking Ixeris method!", e);
        }
    }

    static {
        if (_isModPresent) {
            try {
                Class<?> clazz = Class.forName("me.decce.ixeris.api.IxerisApi");
                _ixerisApi = clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                _runOnRenderThreadHandle = lookup.unreflect(clazz.getMethod("runLaterOnRenderThread", Runnable.class));
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception initializing Ixeris compat!", t);
            }
        } else {
            _ixerisApi = null;
            _runOnRenderThreadHandle = null;
        }
    }
}

