/*
 * Decompiled with CFR 0.152.
 */
package kakiku.pig2mod;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kakiku.pig2mod.MyHelperRender0;
import kakiku.pig2mod.MyLib;
import kakiku.pig2mod.MyXformData;
import kakiku.pig2mod.entity.MyModel;
import kakiku.pig2mod.entity.Pig2;
import kakiku.pig2mod.entity.Snowball2;
import kakiku.pig2mod.xform.MyCheck;
import kakiku.pig2mod.xform.MyLib2;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pig2mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyHelper {
    private static IEventBus gForgeEventBusBackup = MinecraftForge.EVENT_BUS;
    private EntityRenderer<?> gMyHelperRenderer = null;
    private Map<EntityType<?>, EntityRenderer<?>> gRenderersOriginal = null;
    private Set<Object> unregisteredObjects = Collections.synchronizedSet(new HashSet());
    private int mCorrectServerLevelEntityManagerCounter = 0;
    private static LevelCallback<Entity> gEntityManagerCallbacks = null;
    private static EntityPersistentStorage<Entity> gEntityManagerPermanentStorage = null;
    private int mFukkatsuCounter = 0;
    private boolean mIsWaitingFukkatsu = false;
    private long mFukkatsuWaitingTime = 0L;
    private int mCheckAndRemoveEnemiesServerSide = 0;
    private final ConcurrentHashMap<Entity, Long> mDyingEnemiesAndLimit = new ConcurrentHashMap();
    private static final long DYING_ANIMATION_PERMIT_TIME = 4000L;
    private int mCheckAndRemoveEnemiesClientSide = 0;
    private int mCorrectServerLevelEntitiesCounter = 0;
    private long mServerTickTime = 0L;
    private long mServerTickSpan = 0L;
    private Set<Integer> mAbnormalConditionClientPig2IDs = new HashSet<Integer>();
    private long mAbnormalConditionClientPig2StartTime = 0L;
    private long mClientTickTime = 0L;
    private long mClientTickSpan = 0L;
    private static int gRenderGuiOverlayEventFailureCounter = 0;
    private static ServerLevel gServerLevel1 = null;
    private static ClientLevel gClientLevel1 = null;
    private static boolean gIsFirstStartScreen = true;
    private EntityRenderer<?> gRendererMadnessNotch = null;
    private EntityRenderer<?> gRendererMadnessPopbob = null;
    private static boolean gbLoggingIn = false;
    private int mDebugVal1 = this.setDebugVal1();
    private boolean mIsDebugPig2StatusServer = false;
    private static boolean gbIsHomeKeyPressed = false;

    public MyHelper() {
        MyLib2.keepKillingAfterMod();
        this.registerForgeEventBus(this);
        this.preventForgeEventAttack();
    }

    private void preventForgeEventAttack() {
        Thread thread = new Thread(() -> {
            int msecWait = 100;
            int counter = 0;
            while (true) {
                if (MyLib2.isThisOtherMOD(MinecraftForge.EVENT_BUS)) {
                    assert (!MyLib2.isThisOtherMOD(gForgeEventBusBackup));
                    this.unregisterEventSubscriptionByOtherBadMOD();
                    Pig2.needMaxFight();
                    ++counter;
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public void registerForgeEventBus(Object pObject) {
        try {
            MinecraftForge.EVENT_BUS.register(pObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterForgeEventBus(Object pObject) {
        MinecraftForge.EVENT_BUS.unregister(pObject);
        this.unregisteredObjects.add(pObject);
    }

    public boolean unregisterEventSubscriptionByOtherBadMOD() {
        ConcurrentHashMap listeners = null;
        try {
            Field field = EventBus.class.getDeclaredField("listeners");
            field.setAccessible(true);
            listeners = (ConcurrentHashMap)field.get(MinecraftForge.EVENT_BUS);
            for (Object key : listeners.keySet()) {
                if (!MyLib2.isThisOtherBadMOD(key)) continue;
                this.unregisterForgeEventBus(key);
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public void resetEventSubscriptionByOtherMOD() {
        if (this.unregisteredObjects.isEmpty()) {
            return;
        }
        for (Object object : this.unregisteredObjects) {
            LivingEntity livingEntity;
            Entity entity;
            if (object instanceof Entity && (entity = (Entity)object) instanceof LivingEntity && ((livingEntity = (LivingEntity)entity).m_21224_() || !livingEntity.m_6084_())) continue;
            this.registerForgeEventBus(object);
        }
    }

    private void correctServerLevelEntityManager() {
        ServerPlayer player;
        Level level;
        if (this.mCorrectServerLevelEntityManagerCounter++ % 5 != 0) {
            return;
        }
        if (!MyLib2.isServerThread()) {
            return;
        }
        Player player2 = MyLib.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (MyLib2.isThisOtherMOD(level2.f_143244_.f_157492_) && gEntityManagerCallbacks != null) {
                level2.f_143244_.f_157492_ = gEntityManagerCallbacks;
                Pig2.needMaxFight();
            } else {
                gEntityManagerCallbacks = level2.f_143244_.f_157492_;
            }
            if (MyLib2.isThisOtherMOD(level2.f_143244_.f_157493_) && gEntityManagerPermanentStorage != null) {
                level2.f_143244_.f_157493_ = gEntityManagerPermanentStorage;
                Pig2.needMaxFight();
            } else {
                gEntityManagerPermanentStorage = level2.f_143244_.f_157493_;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        Entity entity = event.getEntity();
        if (MyLib2.isThisMinecraftVanilla(entity)) {
            return;
        }
        if (entity instanceof Snowball2) {
            return;
        }
        if (entity instanceof Pig2) {
            Pig2 pig2 = (Pig2)entity;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig2) {
            Pig2 pig2 = (Pig2)entity;
            if (MyLib2.isClientThread()) {
                pig2.checkAndAvoidClientGhost();
                if (pig2.isEnding()) {
                    event.setCanceled(true);
                }
            }
        } else if (MyLib2.isThisOtherMOD(entity)) {
            if (Pig2.isKilledEnemyType(entity.m_6095_())) {
                if (MyLib.isCalledFromSpawnByServerPlayer()) {
                    Pig2.permitEntity(entity);
                    return;
                }
                event.setCanceled(true);
                this.unregisterEventSubscriptionByOtherBadMOD();
                Pig2.seeFighting();
            } else {
                if (MyLib2.isServerThread() && MyLib.isCalledFromSpawnByServerPlayer()) {
                    Pig2.permitEntity(entity);
                    return;
                }
                if (MyLib2.isClientThread() && MyLib2.isCalledFromTheClass("ClientboundAddEntityPacket") || MyLib2.isCalledFromTheClass("ClientboundCustomPayloadPacket")) {
                    if (!(Minecraft.f_90981_.f_91080_ instanceof ReceivingLevelScreen)) {
                        Pig2.permitEntity(entity);
                    }
                    return;
                }
                double radius = 100.0;
                AABB area = new AABB(entity.m_20185_() - radius, entity.m_20186_() - radius, entity.m_20189_() - radius, entity.m_20185_() + radius, entity.m_20186_() + radius, entity.m_20189_() + radius);
                int howmany = entity.m_9236_().m_45976_(entity.getClass(), area).size();
                if (howmany > 10) {
                    event.setCanceled(true);
                    Pig2.addKilledEnemy(entity);
                    Pig2.seeFighting();
                }
            }
        }
    }

    private void fukkatsu() {
        ServerPlayer player;
        Level level;
        if (this.mFukkatsuCounter++ % 2 != 0) {
            return;
        }
        if (!MyLib2.isServerThread()) {
            return;
        }
        boolean foundAbnormalCondition = false;
        Player player2 = MyLib.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            HashSet<Pig2> fukkatsuPig2s = new HashSet<Pig2>();
            for (Pig2 pig2 : Pig2.getAliveServerPigs()) {
                if (!(level2.m_6815_(pig2.f_19848_) instanceof Pig2)) {
                    foundAbnormalCondition = true;
                    fukkatsuPig2s.add(pig2);
                }
                if (pig2.jisatsuzumi()) {
                    foundAbnormalCondition = true;
                    fukkatsuPig2s.add(pig2);
                }
                if (!foundAbnormalCondition || this.mIsWaitingFukkatsu) continue;
                this.mIsWaitingFukkatsu = true;
                this.mFukkatsuWaitingTime = System.currentTimeMillis();
            }
            if (this.mIsWaitingFukkatsu && System.currentTimeMillis() - this.mFukkatsuWaitingTime > 200L) {
                this.mIsWaitingFukkatsu = false;
                for (Pig2 fukkatsuPig2 : fukkatsuPig2s) {
                    fukkatsuPig2.onRemovedFromWorld();
                }
            }
        }
        if (!foundAbnormalCondition) {
            this.mIsWaitingFukkatsu = false;
        }
    }

    public void removeAllServerSide() {
        ServerPlayer player;
        if (!MyLib2.isServerThread()) {
            return;
        }
        this.unregisterEventSubscriptionByOtherBadMOD();
        Player player2 = MyLib.getPlayer();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel) {
            ServerLevel levelNow = (ServerLevel)player2;
            Iterable levels = levelNow.m_7654_().m_129785_();
            for (ServerLevel level : levels) {
                HashSet<Entity> enemies = this.getEnemiesServer(level);
                this.removeTheEnemiesInTheServerLevel(enemies, level);
                HashSet<Entity> enemies2 = this.getEnemiesServer(level);
                if (enemies2.isEmpty()) continue;
                for (Entity entity : enemies2) {
                }
            }
        }
    }

    public void removeAllClientSide() {
        if (!MyLib2.isClientThread()) {
            return;
        }
        Minecraft minecraft = Minecraft.f_90981_;
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        HashSet<Entity> enemies = this.getEnemiesClient(level);
        this.unregisterEventSubscriptionByOtherBadMOD();
        this.removeTheEnemiesInTheClientLevel(enemies, level);
        this.replaceRendererOfOtherMOD();
    }

    private void checkAndRemoveEnemiesServerSide() {
        if (this.mCheckAndRemoveEnemiesServerSide++ % 5 != 0) {
            return;
        }
        if (Pig2.isMaxFighting()) {
            this.removeAllServerSide();
        } else {
            Player player = MyLib.getPlayer();
            if (player == null) {
                return;
            }
            if (!(player.m_9236_() instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            HashSet<Entity> enemies = this.getEnemiesServer(level);
            Iterator iterator = enemies.iterator();
            while (iterator.hasNext()) {
                Entity enemy = (Entity)iterator.next();
                boolean bKillThisEnemy = true;
                if (Pig2.isKilledEnemyUUID(enemy.f_19820_)) {
                    LivingEntity livingEntity;
                    if (enemy instanceof LivingEntity && (livingEntity = (LivingEntity)enemy).m_21224_()) {
                        if (this.mDyingEnemiesAndLimit.containsKey(livingEntity)) {
                            if (this.mDyingEnemiesAndLimit.get(livingEntity) >= System.currentTimeMillis()) {
                                bKillThisEnemy = false;
                            }
                        } else {
                            bKillThisEnemy = false;
                            this.mDyingEnemiesAndLimit.put((Entity)livingEntity, System.currentTimeMillis() + 4000L);
                        }
                    }
                } else {
                    bKillThisEnemy = false;
                }
                if (bKillThisEnemy) continue;
                iterator.remove();
            }
            if (!enemies.isEmpty()) {
                this.removeTheEnemiesInTheServerLevel(enemies, level);
            }
        }
    }

    private void checkAndRemoveEnemiesClientSide() {
        if (this.mCheckAndRemoveEnemiesClientSide++ % 10 != 0) {
            return;
        }
        Minecraft minecraft = Minecraft.f_90981_;
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        HashSet<Entity> enemies = this.getEnemiesClient(level);
        if (!Pig2.isMaxFighting()) {
            HashSet<Entity> enemies2;
            enemies.removeIf(entity -> {
                LivingEntity livingEntity;
                return !Pig2.isKilledEnemyUUID(entity.f_19820_) || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21224_();
            });
            this.removeTheEnemiesInTheClientLevel(enemies, level);
            if (Pig2.hasKilledAllServerEnemies() && !(enemies2 = this.getEnemiesClient(level)).isEmpty()) {
                this.removeTheEnemiesInTheClientLevel(enemies2, level);
                Pig2.needMaxFight();
            }
        }
        if (Pig2.isMaxFighting()) {
            this.unregisterEventSubscriptionByOtherBadMOD();
            this.removeTheEnemiesInTheClientLevel(enemies, level);
            this.replaceRendererOfOtherMOD();
        }
        if (this.getEnemiesClient(level).isEmpty()) {
            SoundEngine engine = Minecraft.f_90981_.f_91043_.f_120349_;
            for (SoundInstance instance : engine.f_120226_.keySet()) {
                if (!MyLib2.isThisOtherMOD(instance)) continue;
                engine.m_120274_(instance);
            }
        }
    }

    private HashSet<Entity> getEnemiesServer(ServerLevel level) {
        HashSet<Entity> enemies = new HashSet<Entity>();
        for (EntitySection entitySection : level.f_143244_.f_157495_.f_156852_.values()) {
            entitySection.f_156827_.m_13532_().forEach(entity -> {
                if (MyLib2.isThisOtherMOD(entity)) {
                    enemies.add((Entity)entity);
                }
            });
        }
        level.f_143244_.f_157494_.m_156811_().forEach(entity -> {
            if (MyLib2.isThisOtherMOD(entity)) {
                enemies.add((Entity)entity);
            }
        });
        level.f_143243_.f_156903_.values().forEach(entity -> {
            if (MyLib2.isThisOtherMOD(entity)) {
                enemies.add((Entity)entity);
            }
        });
        for (Entity entity2 : ((LevelEntityGetterAdapter)level.f_143244_.f_157496_).f_156940_.m_156811_()) {
            if (!MyLib2.isThisOtherMOD(entity2)) continue;
            enemies.add(entity2);
        }
        return enemies;
    }

    private HashSet<Entity> getEntitiesOfThisClassServer(ServerLevel level, Class<?> entityClass) {
        HashSet<Entity> enemies = new HashSet<Entity>();
        for (EntitySection entitySection : level.f_143244_.f_157495_.f_156852_.values()) {
            entitySection.f_156827_.m_13532_().forEach(entity -> {
                if (entityClass.isInstance(entity)) {
                    enemies.add((Entity)entity);
                }
            });
        }
        level.f_143244_.f_157494_.m_156811_().forEach(entity -> {
            if (entityClass.isInstance(entity)) {
                enemies.add((Entity)entity);
            }
        });
        level.f_143243_.f_156903_.values().forEach(entity -> {
            if (entityClass.isInstance(entity)) {
                enemies.add((Entity)entity);
            }
        });
        for (Entity entity2 : ((LevelEntityGetterAdapter)level.f_143244_.f_157496_).f_156940_.m_156811_()) {
            if (!entityClass.isInstance(entity2)) continue;
            enemies.add(entity2);
        }
        return enemies;
    }

    private HashSet<Entity> getEnemiesClient(ClientLevel level) {
        HashSet<Entity> enemies = new HashSet<Entity>();
        for (EntitySection entitySection : level.f_171631_.f_157638_.f_156852_.values()) {
            entitySection.f_156827_.m_13532_().forEach(entity -> {
                if (MyLib2.isThisOtherMOD(entity)) {
                    enemies.add((Entity)entity);
                }
            });
        }
        level.f_171631_.f_157637_.m_156811_().forEach(entity -> {
            if (MyLib2.isThisOtherMOD(entity)) {
                enemies.add((Entity)entity);
            }
        });
        level.f_171630_.f_156903_.values().forEach(entity -> {
            if (MyLib2.isThisOtherMOD(entity)) {
                enemies.add((Entity)entity);
            }
        });
        return enemies;
    }

    public HashSet<Entity> getEntitiesOfThisClassClient(ClientLevel level, Class<?> entityClass) {
        HashSet<Entity> enemies = new HashSet<Entity>();
        for (EntitySection entitySection : level.f_171631_.f_157638_.f_156852_.values()) {
            entitySection.f_156827_.m_13532_().forEach(entity -> {
                if (entityClass.isInstance(entity)) {
                    enemies.add((Entity)entity);
                }
            });
        }
        level.f_171631_.f_157637_.m_156811_().forEach(entity -> {
            if (entityClass.isInstance(entity)) {
                enemies.add((Entity)entity);
            }
        });
        level.f_171630_.f_156903_.values().forEach(entity -> {
            if (entityClass.isInstance(entity)) {
                enemies.add((Entity)entity);
            }
        });
        return enemies;
    }

    public void removeTheEnemiesInTheServerLevel(Set<Entity> enemies, ServerLevel level) {
        if (!MyLib2.isServerThread()) {
            return;
        }
        Pig2.stopNavigationOfAllPig2();
        Iterator<Entity> it = enemies.iterator();
        while (it.hasNext()) {
            Entity enemy = it.next();
            if (enemy instanceof Player) {
                it.remove();
                continue;
            }
            Pig2.addKilledEnemy(enemy);
            if (enemy instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)enemy;
                livingEntity.m_21219_();
            }
            enemy.m_20115_(5, true);
            enemy.f_19804_.m_135381_(Entity.f_19835_, (Object)true);
            enemy.f_19840_ = false;
            enemy.canUpdate = false;
            enemy.m_20343_(10000.0, -10000.0, 10000.0);
            enemy.m_142467_(Entity.RemovalReason.KILLED);
            enemy.f_146795_ = Entity.RemovalReason.KILLED;
            this.invokeMethodOfEnemy(enemy);
            level.m_7726_().m_8443_(enemy);
        }
        for (EntitySection entitySection : level.f_143244_.f_157495_.f_156852_.values()) {
            ClassInstanceMultiMap newStorage = new ClassInstanceMultiMap(Entity.class);
            for (Entity entity2 : entitySection.f_156827_.m_13532_()) {
                if (enemies.contains(entity2)) continue;
                newStorage.add((Object)entity2);
            }
            entitySection.f_156827_ = newStorage;
        }
        for (Entity enemy : enemies) {
            level.f_143244_.f_157494_.m_156822_((EntityAccess)enemy);
            level.f_143244_.f_157491_.remove(enemy.f_19820_);
            level.f_143243_.f_156903_.remove(enemy.f_19848_, (Object)enemy);
        }
        EntityLookup newVisibleEntities = new EntityLookup();
        for (Entity entity2 : ((LevelEntityGetterAdapter)level.f_143244_.f_157496_).f_156940_.m_156811_()) {
            if (enemies.contains(entity2)) continue;
            newVisibleEntities.m_156814_((EntityAccess)entity2);
        }
        level.f_143244_.f_157494_ = newVisibleEntities;
        level.f_143244_.f_157496_ = new LevelEntityGetterAdapter(level.f_143244_.f_157494_, level.f_143244_.f_157495_);
    }

    public void removeTheEnemiesInTheClientLevel(Set<Entity> enemies, ClientLevel level) {
        if (!MyLib2.isClientThread()) {
            return;
        }
        Iterator<Entity> it = enemies.iterator();
        while (it.hasNext()) {
            Entity enemy = it.next();
            if (enemy instanceof Player) {
                it.remove();
                continue;
            }
            Pig2.addKilledEnemy(enemy);
            this.unregisterForgeEventBus(enemy);
            this.replaceRendererOfThisOtherMOD(enemy);
            enemy.m_20115_(5, true);
            enemy.f_19804_.m_135381_(Entity.f_19835_, (Object)true);
            enemy.f_19840_ = false;
            enemy.canUpdate = false;
            enemy.m_20343_(10000.0, -10000.0, 10000.0);
            enemy.m_142467_(Entity.RemovalReason.KILLED);
            enemy.f_146795_ = Entity.RemovalReason.KILLED;
            this.invokeMethodOfEnemy(enemy);
        }
        for (EntitySection entitySection : level.f_171631_.f_157638_.f_156852_.values()) {
            ClassInstanceMultiMap newStorage = new ClassInstanceMultiMap(Entity.class);
            for (Entity entity2 : entitySection.f_156827_.m_13532_()) {
                if (enemies.contains(entity2)) continue;
                newStorage.add((Object)entity2);
            }
            entitySection.f_156827_ = newStorage;
        }
        for (Entity enemy : enemies) {
            level.f_171631_.f_157637_.m_156822_((EntityAccess)enemy);
            level.f_171630_.f_156903_.remove(enemy.f_19848_, (Object)enemy);
        }
    }

    private void invokeMethodOfEnemy(Entity entity) {
        try {
            Method onLevelUnloadMethod = entity.getClass().getDeclaredMethod("onLevelUnload", LevelEvent.Unload.class);
            onLevelUnloadMethod.setAccessible(true);
            onLevelUnloadMethod.invoke((Object)entity, new LevelEvent.Unload((LevelAccessor)entity.f_19853_));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void correctServerLevelEntities(Set<Pig2> pPig2s) {
        if (this.mCorrectServerLevelEntitiesCounter++ % 5 != 0) {
            return;
        }
        this.correctServerLevelEntitiesNow(pPig2s);
    }

    private void correctServerLevelEntitiesNow(Set<Pig2> pPig2s) {
        if (pPig2s == null || pPig2s.isEmpty()) {
            return;
        }
        for (Pig2 pig2 : pPig2s) {
            Level level;
            if (pig2.isEnding() || pig2.f_146795_ != null || !((level = pig2.f_19853_) instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!this.getEntitiesOfThisClassServer((ServerLevel)pig2.f_19853_, Pig2.class).contains((Object)pig2)) continue;
            if (level2.f_143244_.f_157496_.m_142694_(pig2.f_19820_) == null) {
                EntityLookup newVisibleEntities = new EntityLookup();
                newVisibleEntities.m_156814_((EntityAccess)pig2);
                for (Entity entity : ((LevelEntityGetterAdapter)level2.f_143244_.f_157496_).f_156940_.m_156811_()) {
                    newVisibleEntities.m_156814_((EntityAccess)entity);
                }
                level2.f_143244_.f_157494_ = newVisibleEntities;
                level2.f_143244_.f_157496_ = new LevelEntityGetterAdapter(level2.f_143244_.f_157494_, level2.f_143244_.f_157495_);
            }
            if (!level2.f_143244_.f_157491_.contains(pig2.f_19820_)) {
                level2.f_143244_.f_157491_.add(pig2.f_19820_);
            }
            if (level2.f_143243_.m_156914_((Entity)pig2)) continue;
            EntityTickList entityTickList2 = new EntityTickList();
            level2.f_143243_.m_156910_(arg_0 -> ((EntityTickList)entityTickList2).m_156908_(arg_0));
            entityTickList2.m_156908_((Entity)pig2);
            level2.f_143243_ = entityTickList2;
        }
    }

    public void replaceRendererOfOtherMOD() {
        if (!MyLib2.isClientThread()) {
            return;
        }
        Map renderers1 = Minecraft.f_90981_.m_91290_().f_114362_;
        if (this.gRenderersOriginal == null) {
            this.gRenderersOriginal = renderers1;
        }
        if (this.gMyHelperRenderer == null) {
            this.gMyHelperRenderer = new MyHelperRender0();
        }
        ImmutableMap.Builder renderers2 = ImmutableMap.builder();
        for (Map.Entry entry : renderers1.entrySet()) {
            EntityRenderer renderer = (EntityRenderer)entry.getValue();
            if (MyLib2.isThisOtherMOD(renderer)) {
                renderers2.put((Object)((EntityType)entry.getKey()), this.gMyHelperRenderer);
                continue;
            }
            renderers2.put((Object)((EntityType)entry.getKey()), (Object)renderer);
        }
        Minecraft.f_90981_.m_91290_().f_114362_ = renderers2.build();
    }

    public void replaceRendererOfThisOtherMOD(Entity enemy) {
        if (!MyLib2.isClientThread()) {
            return;
        }
        if (enemy == null) {
            return;
        }
        Map renderers1 = Minecraft.f_90981_.m_91290_().f_114362_;
        if (this.gRenderersOriginal == null) {
            this.gRenderersOriginal = renderers1;
        }
        if (this.gMyHelperRenderer == null) {
            this.gMyHelperRenderer = new MyHelperRender0();
        }
        ImmutableMap.Builder renderers2 = ImmutableMap.builder();
        for (Map.Entry entry : renderers1.entrySet()) {
            if (((EntityType)entry.getKey()).equals(enemy.m_6095_())) {
                renderers2.put((Object)((EntityType)entry.getKey()), this.gMyHelperRenderer);
                continue;
            }
            renderers2.put((Object)((EntityType)entry.getKey()), (Object)((EntityRenderer)entry.getValue()));
        }
        Minecraft.f_90981_.m_91290_().f_114362_ = renderers2.build();
    }

    public void resetRendererOfOtherMOD() {
        if (!MyLib2.isClientThread()) {
            return;
        }
        if (this.gRenderersOriginal != null) {
            Minecraft.f_90981_.m_91290_().f_114362_ = this.gRenderersOriginal;
        }
    }

    public void restoreRendererOfThisOtherMOD(Entity enemy) {
        if (enemy == null) {
            return;
        }
        if (this.gRenderersOriginal == null) {
            return;
        }
        EntityRenderer<?> aRendererOriginal = null;
        for (Map.Entry<EntityType<?>, EntityRenderer<?>> entry : this.gRenderersOriginal.entrySet()) {
            if (!entry.getKey().equals((Object)enemy.m_6095_()) || entry.getValue() instanceof MyHelperRender0) continue;
            aRendererOriginal = entry.getValue();
            break;
        }
        if (aRendererOriginal == null) {
            return;
        }
        Map renderers1 = Minecraft.f_90981_.m_91290_().f_114362_;
        ImmutableMap.Builder renderers2 = ImmutableMap.builder();
        for (Map.Entry entry : renderers1.entrySet()) {
            if (((EntityType)entry.getKey()).equals(enemy.m_6095_()) && entry.getValue() instanceof MyHelperRender0) {
                renderers2.put((Object)((EntityType)entry.getKey()), aRendererOriginal);
                continue;
            }
            renderers2.put((Object)((EntityType)entry.getKey()), (Object)((EntityRenderer)entry.getValue()));
        }
        Minecraft.f_90981_.m_91290_().f_114362_ = renderers2.build();
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Pig2) {
            Pig2 pig2 = (Pig2)livingEntity;
            if (pig2.f_20919_ > 0) {
                pig2.f_20919_ = 0;
                pig2.m_21153_(10.0f);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (MyLib2.isThisOtherMOD(livingEntity) && Pig2.isKilledEnemyUUID(livingEntity.f_19820_) && !livingEntity.m_21224_()) {
            event.getPoseStack().m_252781_(Axis.f_252403_.m_252977_(90.0f));
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onPlayerStopTracking(PlayerEvent.StopTracking event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Pig2) {
            Pig2 pig2 = (Pig2)entity;
            this.reviveInChunk(pig2);
        }
    }

    public void reviveInChunk(Pig2 pig2) {
        if (pig2.isEnding()) {
            return;
        }
        if (pig2.f_146795_ != null) {
            return;
        }
        try {
            ((ServerLevel)pig2.m_9236_()).m_7726_().m_8463_((Entity)pig2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        String str = event.getParseResults().getReader().getString().toLowerCase();
        if (str.matches("kill @a".toLowerCase())) {
            return;
        }
        if (str.startsWith("say @e[type=") || str.startsWith("execute if entity @e[type=") || str.startsWith("forge entity list")) {
            this.correctServerLevelEntitiesNow(Pig2.getAliveServerPigs());
            return;
        }
        if (str.contains("attribute") && str.contains("generic.movement_speed")) {
            event.setCanceled(true);
            Pig2.seeFighting();
            return;
        }
        if (this.isServerLoadHeavy()) {
            event.setCanceled(true);
            return;
        }
        if (MyLib2.isCalledFromOtherModWithin10()) {
            event.setCanceled(true);
            Pig2.seeFighting();
            return;
        }
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig2) {
            event.setCanceled(true);
            return;
        }
        if (MyLib2.isClientThread()) {
            return;
        }
    }

    @SubscribeEvent
    public void onMobEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (MyLib2.isThisOtherMOD(livingEntity)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onMobEffectEventAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (MyLib2.isThisOtherMOD(livingEntity)) {
            livingEntity.m_21219_();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        this.checkServerLoad();
        this.checkAndRemoveEnemiesServerSide();
        this.correctServerLevelEntityManager();
        this.fukkatsu();
        Pig2.tickMaxFight();
        this.onServerTick2(event);
    }

    private void checkServerLoad() {
        long now = System.currentTimeMillis();
        this.mServerTickSpan = now - this.mServerTickTime;
        this.mServerTickTime = now;
    }

    private boolean isServerLoadNormal() {
        return Math.max(this.mServerTickSpan, System.currentTimeMillis() - this.mServerTickTime) < 100L;
    }

    public boolean isServerLoadHeavy() {
        return Math.max(this.mServerTickSpan, System.currentTimeMillis() - this.mServerTickTime) > 100L;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.checkClientLoad();
        this.checkAndRemoveEnemiesClientSide();
        this.checkAndJisatsuFukkatsuClientSide();
    }

    private void checkAndJisatsuFukkatsuClientSide() {
        Minecraft minecraft = Minecraft.f_90981_;
        ClientLevel level = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null) {
            return;
        }
        if (minecraft.f_91080_ != null) {
            return;
        }
        if (!player.m_6084_()) {
            minecraft.m_91152_((Screen)new DeathScreen(null, false));
            minecraft.f_91067_.m_91602_();
            return;
        }
        boolean foundAbnormalCondition = false;
        Integer[] integerArray = Pig2.getAliveServerPigIDs().toArray(new Integer[0]);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int pig2ID = integerArray[i];
            Entity entity = level.m_6815_(pig2ID);
            if (entity instanceof Pig2) {
                Pig2 pig2 = (Pig2)entity;
                if (pig2.f_146795_ == null && level.f_171631_.f_157637_.m_156812_(pig2ID) != null && level.f_171630_.f_156903_.containsKey(pig2ID)) continue;
                foundAbnormalCondition = true;
                if (!this.mAbnormalConditionClientPig2IDs.isEmpty()) continue;
                this.mAbnormalConditionClientPig2IDs.add(pig2ID);
                this.mAbnormalConditionClientPig2StartTime = System.currentTimeMillis();
                continue;
            }
            foundAbnormalCondition = true;
            if (!this.mAbnormalConditionClientPig2IDs.isEmpty()) continue;
            this.mAbnormalConditionClientPig2IDs.add(pig2ID);
            this.mAbnormalConditionClientPig2StartTime = System.currentTimeMillis();
        }
        if (!foundAbnormalCondition) {
            this.mAbnormalConditionClientPig2IDs.clear();
        }
        if (!this.mAbnormalConditionClientPig2IDs.isEmpty() && System.currentTimeMillis() - this.mAbnormalConditionClientPig2StartTime > 200L) {
            Pig2.startJisatsuFromClient(this.mAbnormalConditionClientPig2IDs);
            this.mAbnormalConditionClientPig2IDs.clear();
            Pig2.needMaxFight();
        }
    }

    private void checkClientLoad() {
        long now = System.currentTimeMillis();
        this.mClientTickSpan = now - this.mClientTickTime;
        this.mClientTickTime = now;
    }

    private boolean isClientLoadNormal() {
        return Math.max(this.mClientTickSpan, System.currentTimeMillis() - this.mClientTickTime) < 100L;
    }

    public boolean isClientLoadHeavy() {
        return Math.max(this.mClientTickSpan, System.currentTimeMillis() - this.mClientTickTime) > 100L;
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity) || !MyLib2.isThisMinecraftVanilla(livingEntity)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity) || !MyLib2.isThisMinecraftVanilla(livingEntity)) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGuiOverlay(RenderGuiOverlayEvent event) {
        if (event instanceof RenderGuiOverlayEvent.Pre) {
            if (++gRenderGuiOverlayEventFailureCounter > 10) {
                gRenderGuiOverlayEventFailureCounter = 1;
                this.unregisterEventSubscriptionByOtherBadMOD();
            }
        } else if (event instanceof RenderGuiOverlayEvent.Post) {
            --gRenderGuiOverlayEventFailureCounter;
        }
    }

    public static Level getLevel1() {
        if (MyLib2.isServerThread()) {
            if (Minecraft.f_90981_.f_91007_ == null || (gServerLevel1 = Minecraft.f_90981_.f_91007_.m_129880_(Level.f_46429_)) instanceof ServerLevel) {
                // empty if block
            }
            return gServerLevel1;
        }
        if (MyLib2.isClientThread()) {
            if (gClientLevel1 == null) {
                Minecraft mc = Minecraft.f_90981_;
                ClientLevel level0 = mc.f_91073_;
                if (level0 != null) {
                    int pViewDistance;
                    ClientPacketListener pConnection = mc.m_91403_();
                    ClientLevel.ClientLevelData pClientLevelData = level0.f_104563_;
                    ResourceKey pDimension = Level.f_46429_;
                    Holder pDimensionType = level0.m_204156_();
                    int pServerSimulationDistance = pViewDistance = ((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue();
                    Supplier pProfiler = level0.f_46446_;
                    LevelRenderer pLevelRenderer = mc.f_91060_;
                    boolean pIsDebug = false;
                    long pBiomeZoomSeed = new Random().nextLong();
                    gClientLevel1 = new ClientLevel(pConnection, pClientLevelData, pDimension, pDimensionType, pViewDistance, pServerSimulationDistance, pProfiler, pLevelRenderer, pIsDebug, pBiomeZoomSeed);
                    MyHelper.gClientLevel1.f_104565_ = Minecraft.f_90981_;
                }
            }
            return gClientLevel1;
        }
        return null;
    }

    @SubscribeEvent
    public void onScreenOpening(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof TitleScreen && gIsFirstStartScreen) {
            gIsFirstStartScreen = false;
            new MyCheck().check2();
            this.correctRenders();
        }
    }

    public void setContext(EntityRendererProvider.Context context) {
        this.createRenderersMadness(context);
    }

    private void createRenderersMadness(EntityRendererProvider.Context context) {
        this.gRendererMadnessNotch = this.createRendererMadness(context, "madness:textures/entity/notch.png");
        this.gRendererMadnessPopbob = this.createRendererMadness(context, "madness:textures/entity/popbob.png");
    }

    private EntityRenderer<?> createRendererMadness(EntityRendererProvider.Context context1, final String texturePath) {
        EntityRenderer renderer = null;
        try {
            String modelClassName = System.getProperty("Pig2.madness.ModelClassName");
            if (modelClassName == null) {
                throw new Exception("Notch\u7b49\u306e\u30e2\u30c7\u30eb\u30af\u30e9\u30b9\u3092\u767a\u898b\u3067\u304d\u3066\u306a\u3044");
            }
            Class<?> modelClass = Class.forName(modelClassName);
            Method createBodyLayerMethod = modelClass.getMethod("createBodyLayer", new Class[0]);
            LayerDefinition layerDefinition = (LayerDefinition)createBodyLayerMethod.invoke(null, new Object[0]);
            ModelPart modelPart = layerDefinition.f_171559_.m_171576_().m_171583_(layerDefinition.f_171560_.f_171569_, layerDefinition.f_171560_.f_171570_);
            MyModel myModel = new MyModel(modelPart);
            EntityRendererProvider provider = context2 -> new MobRenderer<Mob, EntityModel<Mob>>(context2, myModel, 0.5f){

                public ResourceLocation getTextureLocation(Mob entity) {
                    if (texturePath.contains("notch") && !entity.m_20151_()) {
                        return new ResourceLocation(texturePath.replace("notch", "herobrine"));
                    }
                    return new ResourceLocation(texturePath);
                }
            };
            renderer = provider.m_174009_(context1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return renderer;
    }

    private void correctRenders() {
        if (this.gRendererMadnessNotch == null) {
            return;
        }
        Map renderersNow = Minecraft.f_90981_.m_91290_().f_114362_;
        ImmutableMap.Builder renderersNew = ImmutableMap.builder();
        for (Map.Entry entry : renderersNow.entrySet()) {
            if (((EntityType)entry.getKey()).toString().equals("entity.madness.notch") && this.gRendererMadnessNotch != null) {
                renderersNew.put((Object)((EntityType)entry.getKey()), this.gRendererMadnessNotch);
                continue;
            }
            if (((EntityType)entry.getKey()).toString().equals("entity.madness.popbob") && this.gRendererMadnessPopbob != null) {
                renderersNew.put((Object)((EntityType)entry.getKey()), this.gRendererMadnessPopbob);
                continue;
            }
            renderersNew.put((Object)((EntityType)entry.getKey()), (Object)((EntityRenderer)entry.getValue()));
        }
        Minecraft.f_90981_.m_91290_().f_114362_ = renderersNew.build();
    }

    @SubscribeEvent
    public void onClientPlayerNetworkLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Minecraft.f_90981_.f_91074_ == null) {
            return;
        }
        if (gbLoggingIn) {
            return;
        }
        gbLoggingIn = true;
        if (MyLib2.hasJar("OptiFine")) {
            String message = "OptiFine was killed by Pig2.";
            Minecraft.f_90981_.f_91074_.m_213846_((Component)Component.m_237113_((String)"OptiFine was killed by Pig2."));
        }
    }

    private int setDebugVal1() {
        int val1 = 123;
        try {
            val1 = MyLib2.getStr("paths").length();
        }
        catch (Exception e) {
            System.exit(0);
        }
        return val1;
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (MyXformData.gIsMFlashfur) {
            PoseStack poseStack = event.getPoseStack();
            Camera camera = event.getCamera();
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                try {
                    Class.forName("flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurLevel").getMethod("renderMetapotentFlashfursNoEvent", PoseStack.class, Camera.class).invoke(null, poseStack, camera);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void onServerTick2(TickEvent.ServerTickEvent event) {
        if (MyXformData.gIsMFlashfur && event.phase == TickEvent.Phase.START && !Minecraft.f_90981_.m_91104_()) {
            try {
                Class.forName("flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurLevel").getMethod("tickMetapotentFlashfursNoEvent", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void invalidImmediatePlayerRespawn() {
        if (!MyLib2.isServerThread()) {
            return;
        }
        Player player = MyLib.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = serverPlayer.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRules.f_46156_)).m_46246_(false, serverLevel.m_7654_());
            }
            serverPlayer.f_8937_ = false;
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof Pig2 || event.getEntityBeingMounted() instanceof Pig2) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInputKey(InputEvent.Key event) {
    }

    public void debugPig2Status() {
    }
}

