/*
 * Decompiled with CFR 0.152.
 */
package kakiku.pig2mod.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Nullable;
import kakiku.pig2mod.Pig2Mod;
import kakiku.pig2mod.entity.MyEntities;
import kakiku.pig2mod.entity.Snowball2;
import kakiku.pig2mod.xform.MyLib2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pig2mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Pig2
extends Pig
implements RangedAttackMob {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42620_, Items.f_42732_});
    private ATTACK_LEVEL mAttackLevel = ATTACK_LEVEL.L0;
    private Entity mEnemy1st = null;
    private Vec3 mEnemy2ndPos = null;
    private long mFirstHurtTime = 0L;
    private long mAttackingTime = 0L;
    private Entity mAttackingEnemy = null;
    private double mOldX = 0.0;
    private double mOldY = 0.0;
    private double mOldZ = 0.0;
    private CommandEvent mLastCommandEvent = null;
    private boolean mIsJisatsu = false;
    private EntityInLevelCallback mLevelCallbackBackup = EntityInLevelCallback.f_156799_;
    public static final float PIG2_MAX_HEALTH = 10.0f;
    private static final double mOldMax = 3.0;
    private static final Set<UUID> gKilledEnemyUUIDs = Collections.synchronizedSet(new HashSet());
    private static final Set<EntityType<?>> gKilledEnemyTypes = Collections.synchronizedSet(new HashSet());
    private static final Set<Pig2> gAliveServerPigs = Collections.synchronizedSet(new HashSet());
    private static final Set<Integer> gAliveServerPigIDs = Collections.synchronizedSet(new HashSet());
    private static final Set<Integer> gJisatsuPigIDs = Collections.synchronizedSet(new HashSet());
    private static final Set<Integer> gLevel4PigIDs = Collections.synchronizedSet(new HashSet());
    private static MAX_FIGHT gMaxFightPhase = MAX_FIGHT.OFF;
    private static long gStartFightingTime = 0L;
    private static long gLastFightingTime = 0L;
    public static long gKickStartTime = 0L;
    public static final long KICKED_SCREEN_MILLISECOND = 1000L;
    private static boolean gKilledAllServerEnemies = false;
    private static long gNonEntityEnemyTime = 0L;
    private boolean mIsAddingNewPig2 = false;
    private int mTickCounter = 0;
    int mStartFightingIfNeededCounter = 0;
    private int mLookAtHiddenEnemyCounter = 0;
    private boolean isHurting = false;
    private List<EntityType<?>> mHurtEnemyTypes = new ArrayList();
    private int mStopFightingRemovedEnemyCounter = 0;
    private int mTickCounterLevel2 = 0;
    private long mTimeLevel2 = 0L;
    public static final String MY_COMMAND_1_KILL = "kill @a";
    private int mTickCounterLevel3 = 0;
    private long mTimeLevel3 = 0L;
    private int mTickCounterLevel4 = 0;
    private long mTimeLevel4 = 0L;
    private int mTickCounterLevel4Client = 0;
    private boolean mIsSetRemoveding = false;

    public Pig2(EntityType<? extends Pig> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        Pig2Mod.gMyHelper.registerForgeEventBus((Object)this);
        this.preventForgeEventUnregisterAttack();
    }

    public static AttributeSupplier.Builder m_29503_() {
        return Pig.m_29503_().m_22268_(Attributes.f_22277_, 40.0);
    }

    private void preventForgeEventUnregisterAttack() {
        Timer timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    Pig2Mod.gMyHelper.registerForgeEventBus(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        timer.schedule(timerTask, 0L, 100L);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.mAttackLevel == ATTACK_LEVEL.L0) {
            this.mAttackLevel = ATTACK_LEVEL.L1;
            if (!this.isThisOutside(this.f_19825_.f_82479_, this.f_19825_.f_82480_, this.f_19825_.f_82481_)) {
                this.mOldX = this.f_19825_.f_82479_;
                this.mOldY = this.f_19825_.f_82480_;
                this.mOldZ = this.f_19825_.f_82481_;
            }
        }
        this.m_6863_(true);
        this.m_146915_(true);
        this.m_6593_((Component)Component.m_237113_((String)"Pig2_2.7.0"));
        this.m_20340_(true);
        this.f_21353_ = true;
        if (MyLib2.isServerThread()) {
            gAliveServerPigs.add(this);
            gAliveServerPigIDs.add(this.f_19848_);
        }
        this.mLevelCallbackBackup = this.f_146801_;
    }

    private boolean isBeforeBornToThisWorld() {
        return this.mAttackLevel == ATTACK_LEVEL.L0;
    }

    public static Set<Pig2> getAliveServerPigs() {
        return gAliveServerPigs;
    }

    public static boolean isThereAnyPigs() {
        return !gAliveServerPigs.isEmpty();
    }

    public static Set<Integer> getAliveServerPigIDs() {
        return gAliveServerPigIDs;
    }

    public void onRemovedFromWorld() {
        int deadCount;
        boolean bHasUnregistered;
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            Pig2.seeFighting();
            return;
        }
        this.isAddedToWorld = false;
        if (MyLib2.isClientThread()) {
            return;
        }
        if (this.isEnding()) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)this.f_19853_;
        if (sLevel.m_7654_().m_195518_()) {
            return;
        }
        if (sLevel.m_6907_().isEmpty() && sLevel.m_46472_() != Level.f_46428_) {
            return;
        }
        Pig2.seeFighting();
        Pig2 pig2b = new Pig2((EntityType<? extends Pig>)((EntityType)MyEntities.PIG2.get()), (Level)sLevel);
        pig2b.copy(this);
        this.startJisatsu();
        boolean bHasRevived = this.addFreshEntity(pig2b);
        if (!bHasRevived && (bHasUnregistered = Pig2Mod.gMyHelper.unregisterEventSubscriptionByOtherBadMOD())) {
            pig2b.revive();
            boolean bHasRevived2 = sLevel.f_143244_.addEntityWithoutEvent((EntityAccess)pig2b, false);
            if (!bHasRevived2) {
                // empty if block
            }
        }
        if ((deadCount = gJisatsuPigIDs.size()) == 50) {
            Pig2Mod.gMyHelper.removeAllServerSide();
        } else if (deadCount == 60) {
            Pig2.needMaxFight();
        }
    }

    public void copy(Pig2 pig2Before) {
        LivingEntity livingEntity;
        Entity entity;
        this.myCopyPosition(pig2Before);
        this.mOldX = pig2Before.mOldX;
        this.mOldY = pig2Before.mOldY;
        this.mOldZ = pig2Before.mOldZ;
        if (this.f_19825_.m_82554_(new Vec3(this.mOldX, this.mOldY, this.mOldZ)) > 3.0 || this.isThisOutside(this.f_19825_.f_82479_, this.f_19825_.f_82480_, this.f_19825_.f_82481_) || Double.isNaN(this.f_19825_.f_82479_) || Double.isNaN(this.f_19825_.f_82480_) || Double.isNaN(this.f_19825_.f_82481_)) {
            this.mySetPosRaw(this.mOldX, this.mOldY, this.mOldZ);
        }
        this.f_20883_ = pig2Before.f_20883_;
        this.f_20885_ = pig2Before.f_20885_;
        this.mEnemy1st = pig2Before.mEnemy1st;
        this.mFirstHurtTime = pig2Before.mFirstHurtTime;
        this.mAttackingTime = pig2Before.mAttackingTime;
        this.mAttackingEnemy = pig2Before.mAttackingEnemy;
        this.mAttackLevel = pig2Before.mAttackLevel;
        this.mHurtEnemyTypes = pig2Before.mHurtEnemyTypes;
        this.f_21362_ = pig2Before.f_21362_;
        if (this.mAttackLevel == ATTACK_LEVEL.L2 && !(this.mEnemy1st instanceof Player)) {
            this.mAttackLevel = ATTACK_LEVEL.L3;
            this.mTickCounterLevel2 = 0;
        } else if (this.mAttackLevel == ATTACK_LEVEL.L3 && !(this.mEnemy1st instanceof Player)) {
            this.mAttackLevel = ATTACK_LEVEL.L4;
            this.mTickCounterLevel3 = 0;
        }
        if (this.mEnemy1st == null || !this.mEnemy1st.m_6084_() || (entity = this.mEnemy1st) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21224_()) {
            this.mEnemy1st = this.findMODEnemyAroundHere(null);
            if (this.mEnemy1st == null) {
                this.mEnemy1st = this.findPlayerWithModItemAroundHere();
            }
            if (this.mEnemy1st instanceof Player && this.mAttackLevel == ATTACK_LEVEL.L1) {
                this.mAttackLevel = ATTACK_LEVEL.L2;
            }
        }
    }

    private void myCopyPosition(Pig2 pig2Before) {
        this.myMoveTo(pig2Before.f_19825_.f_82479_, pig2Before.f_19825_.f_82480_, pig2Before.f_19825_.f_82481_, pig2Before.f_19857_, pig2Before.f_19858_);
    }

    private void myMoveTo(double pX, double pY, double pZ) {
        this.myMoveTo(pX, pY, pZ, this.f_19857_, this.f_19858_);
    }

    private void myMoveTo(double pX, double pY, double pZ, float pYRot, float pXRot) {
        this.mySetPosRaw(pX, pY, pZ);
        this.f_19857_ = pYRot;
        this.f_19858_ = pXRot;
        super.m_146867_();
        this.mySetPosRaw(pX, pY, pZ);
        super.m_20011_(this.m_142242_());
    }

    private void mySetPosRaw(double pX, double pY, double pZ) {
        if (this.f_19825_.f_82479_ != pX || this.f_19825_.f_82480_ != pY || this.f_19825_.f_82481_ != pZ) {
            this.f_19825_ = new Vec3(pX, pY, pZ);
            int i = Mth.m_14107_((double)pX);
            int j = Mth.m_14107_((double)pY);
            int k = Mth.m_14107_((double)pZ);
            if (i != this.f_19826_.m_123341_() || j != this.f_19826_.m_123342_() || k != this.f_19826_.m_123343_()) {
                this.f_19826_ = new BlockPos(i, j, k);
                this.f_185934_ = null;
                if (SectionPos.m_123171_((int)i) != this.f_185933_.f_45578_ || SectionPos.m_123171_((int)k) != this.f_185933_.f_45579_) {
                    this.f_185933_ = new ChunkPos(this.f_19826_);
                }
            }
            this.f_146801_.m_142044_();
        }
        if (this.isAddedToWorld && !this.f_19853_.f_46443_ && !this.m_213877_()) {
            this.f_19853_.m_6325_((int)Math.floor(pX) >> 4, (int)Math.floor(pZ) >> 4);
        }
    }

    public boolean isEnding() {
        return this.mIsJisatsu;
    }

    public void checkAndAvoidClientGhost() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        if (!MyLib2.isClientThread()) {
            return;
        }
        if (!(this.f_19853_ instanceof ClientLevel)) {
            return;
        }
        if (gJisatsuPigIDs.contains(this.f_19848_)) {
            this.startJisatsu();
        }
    }

    private void startJisatsu() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            Pig2.seeFighting();
            return;
        }
        if (this.isEnding()) {
            return;
        }
        this.mIsJisatsu = true;
        if (MyLib2.isServerThread()) {
            gJisatsuPigIDs.add(this.f_19848_);
            gAliveServerPigs.remove((Object)this);
            gAliveServerPigIDs.remove(this.f_19848_);
        }
        this.m_142467_(Entity.RemovalReason.DISCARDED);
    }

    public static void startJisatsuFromClient(Set<Integer> pig2IDs) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            Pig2.seeFighting();
            return;
        }
        for (int id : pig2IDs) {
            gJisatsuPigIDs.add(id);
        }
    }

    public boolean jisatsuzumi() {
        return gJisatsuPigIDs.contains(this.f_19848_);
    }

    private boolean addFreshEntity(Pig2 pig2) {
        pig2.mIsAddingNewPig2 = true;
        boolean rtn = ((ServerLevel)pig2.f_19853_).m_7967_((Entity)pig2);
        pig2.mIsAddingNewPig2 = false;
        return rtn;
    }

    public boolean m_213877_() {
        if (this.mIsAddingNewPig2) {
            return false;
        }
        return this.f_146795_ != null;
    }

    public static boolean isMaxFighting() {
        return gMaxFightPhase == MAX_FIGHT.ON;
    }

    public static void seeFighting() {
        if (gAliveServerPigs.isEmpty()) {
            return;
        }
        gLastFightingTime = System.currentTimeMillis();
        if (gStartFightingTime == 0L) {
            gStartFightingTime = gLastFightingTime;
        }
    }

    public static void needMaxFight() {
        if (gMaxFightPhase == MAX_FIGHT.OFF) {
            gMaxFightPhase = MAX_FIGHT.WAITING;
        }
        Pig2.seeFighting();
        Pig2.tickMaxFight();
    }

    public static void tickMaxFight() {
        if (gMaxFightPhase == MAX_FIGHT.WAITING && gStartFightingTime != 0L && System.currentTimeMillis() - gStartFightingTime > 8000L && MyLib2.isServerThread()) {
            Pig2.setMaxFight();
        }
        if ("true".equals(System.getProperty("Pig2.needMaxFight"))) {
            System.setProperty("Pig2.needMaxFight", "false");
            Pig2.needMaxFight();
        }
    }

    private static void setMaxFight() {
        gMaxFightPhase = MAX_FIGHT.ON;
        Pig2Mod.gMyHelper.removeAllServerSide();
    }

    public static void resetMaxFight() {
        if (MyLib2.isCalledFromOtherModWithin1()) {
            return;
        }
        gMaxFightPhase = MAX_FIGHT.OFF;
        gStartFightingTime = 0L;
        gKilledAllServerEnemies = false;
    }

    public void m_8119_() {
        if (MyLib2.isClientThread() && this.m_9236_() instanceof ServerLevel || MyLib2.isServerThread() && this.m_9236_() instanceof ClientLevel) {
            return;
        }
        super.m_8119_();
        this.checkAndAvoidClientGhost();
        if (this.isEnding()) {
            return;
        }
        this.correctMovement();
        this.myRevive();
        if (MyLib2.isClientThread()) {
            if (gLevel4PigIDs.contains(this.f_19848_)) {
                this.tickLevel4Client();
            }
            return;
        }
        if (MyLib2.isServerThread()) {
            AttributeInstance attributeInstance;
            switch (this.mAttackLevel) {
                case L0: {
                    break;
                }
                case L1: {
                    this.tickLevel1();
                    break;
                }
                case L2: {
                    this.tickLevel2();
                    break;
                }
                case L3: {
                    this.tickLevel3();
                    break;
                }
                case L4: {
                    this.tickLevel4();
                }
            }
            this.f_21353_ = true;
            if (this.m_21233_() != 10.0f && (attributeInstance = this.m_21051_(Attributes.f_22276_)) != null) {
                attributeInstance.m_22100_(10.0);
            }
            Pig2Mod.gMyHelper.reviveInChunk(this);
            if (this.mTickCounter++ % 4 != 0) {
                return;
            }
            this.m_6863_(true);
            this.m_6593_((Component)Component.m_237113_((String)"Pig2_2.7.0"));
            this.m_20340_(true);
            this.m_20115_(5, false);
            this.m_21195_(MobEffects.f_19596_);
            this.m_21185_();
            this.m_146915_(true);
            if (this.m_21051_(Attributes.f_22279_) != null) {
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
            }
            if (this.m_21525_()) {
                this.m_21557_(false);
            }
            if (this.f_21362_ instanceof Pig2) {
                this.f_21362_ = null;
            }
            this.m_21219_();
            if (this.m_20068_()) {
                this.m_20242_(false);
            }
            this.m_20301_(this.m_6062_());
            this.m_146917_(0);
            Pig2.tickMaxFight();
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Pig2 && event.isCanceled()) {
            event.setCanceled(false);
        }
    }

    private void tickLevel1() {
        this.startFightingIfNeeded();
        this.lookAtHiddenEnemy();
    }

    private void startFightingIfNeeded() {
        Entity entity;
        if (this.mStartFightingIfNeededCounter++ % 20 != 0) {
            return;
        }
        if (this.f_21362_ != null) {
            return;
        }
        if (Pig2.isMaxFighting()) {
            return;
        }
        if ((gStartFightingTime == 0L || System.currentTimeMillis() - gLastFightingTime > 2000L) && (entity = this.findMODEnemyAroundHere(null)) instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.f_21362_ = livingEntity = (LivingEntity)entity;
        }
    }

    private void lookAtHiddenEnemy() {
        LivingEntity enemy;
        if (this.mLookAtHiddenEnemyCounter++ % 4 != 0) {
            return;
        }
        Entity entity = this.findMODEnemyAroundHere((Entity)this);
        if (entity instanceof LivingEntity && (enemy = (LivingEntity)entity).m_6084_()) {
            boolean isHiddenEnemy = false;
            if (enemy.m_20147_()) {
                isHiddenEnemy = true;
            }
            if (!this.m_21574_().m_148306_((Entity)enemy)) {
                isHiddenEnemy = true;
            }
            if (isHiddenEnemy) {
                super.m_7618_(EntityAnchorArgument.Anchor.EYES, enemy.f_19825_);
                this.m_6504_(enemy, 5.0f);
                Pig2.seeFighting();
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 30.0f));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42684_}), false));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, MyLib2::isThisOtherMOD));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, livingEntity -> livingEntity instanceof LivingEntity && !(livingEntity instanceof Pig2)));
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        if (MyLib2.isClientThread()) {
            return;
        }
        if (!this.f_19825_.m_82509_((Position)pTarget.f_19825_, 100.0)) {
            return;
        }
        int radius = 20;
        AABB area = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - (double)radius, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)radius, this.m_20189_() + (double)radius);
        int howmanySnowballs = this.m_9236_().m_45976_(Snowball2.class, area).size();
        if (howmanySnowballs < 100) {
            Snowball2 snowball = new Snowball2(this.f_19853_, (LivingEntity)this);
            double d0 = pTarget.m_20188_() - (double)1.1f;
            double d1 = pTarget.m_20185_() - this.m_20185_();
            double d2 = d0 - snowball.m_20186_();
            double d3 = pTarget.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            snowball.m_6686_(d1, d2 + d4, d3, 1.6f, 6.0f);
            this.m_9236_().m_7967_((Entity)snowball);
        }
        Pig2.seeFighting();
        if (this.mAttackLevel != ATTACK_LEVEL.L1) {
            return;
        }
        if (this.mAttackingEnemy == null || !pTarget.getClass().equals(this.mAttackingEnemy.getClass())) {
            this.mAttackingEnemy = pTarget;
            this.mAttackingTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.mAttackingTime > 5100L && !Pig2.isMaxFighting() && this.mAttackingEnemy.getClass().equals(pTarget.getClass()) && !(this.mAttackingEnemy instanceof Pig2)) {
            this.mEnemy1st = this.mAttackingEnemy;
            this.mAttackLevel = ATTACK_LEVEL.L2;
        }
    }

    public void performRangedAttackToBlockPos(Vec3 pPos) {
        Snowball2 snowball = new Snowball2(this.m_9236_(), (LivingEntity)this);
        double d0 = 0.0 + pPos.f_82480_ - (double)1.1f;
        double d1 = 0.5 + pPos.f_82479_ - this.m_20185_();
        double d2 = d0 - snowball.m_20186_();
        double d3 = 0.5 + pPos.f_82481_ - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        snowball.m_6686_(d1, d2 + d4, d3, 1.6f, 0.3f);
        this.m_9236_().m_7967_((Entity)snowball);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.isEnding()) {
            return false;
        }
        if (MyLib2.isClientThread()) {
            return false;
        }
        Entity enemy = pSource.m_7639_();
        if (enemy instanceof Pig2) {
            return false;
        }
        if (this.mAttackLevel != ATTACK_LEVEL.L1) {
            return false;
        }
        if (this.isHurting) {
            return false;
        }
        this.isHurting = true;
        Pig2.seeFighting();
        Pig2Mod.gMyHelper.invalidImmediatePlayerRespawn();
        try {
            if (this.mFirstHurtTime == 0L) {
                this.mFirstHurtTime = System.currentTimeMillis();
            }
            if (!(enemy instanceof Entity)) {
                Entity enemyCandidate = this.findMODEnemyAroundHere(null);
                if (enemyCandidate instanceof Entity) {
                    enemy = enemyCandidate;
                } else {
                    if (pSource.m_276093_(DamageTypes.f_268612_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268631_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268468_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268546_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268434_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268722_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268444_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268671_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268428_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268565_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pSource.m_276093_(DamageTypes.f_268448_)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (MyLib2.isCalledFromTheClass("CommandDispatcher") && MyLib2.isCalledFromTheClass("ServerGamePacketListenerImpl") && !MyLib2.isCalledFromOtherModWithin10()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (MyLib2.isCalledFromTheClass("CommandBlock") && !MyLib2.isCalledFromOtherModWithin10()) {
                        this.attackCommandBlock();
                        boolean bl = false;
                        return bl;
                    }
                    Player badPlayer = this.findPlayerWithModItemAroundHere();
                    if (badPlayer != null && MyLib2.isCalledFromTheClass("Player")) {
                        enemy = badPlayer;
                    }
                }
            }
            if (enemy instanceof Entity) {
                LivingEntity livingEntity;
                LivingEntity livingEntity2;
                if (!this.mHurtEnemyTypes.contains(enemy.m_6095_())) {
                    this.mHurtEnemyTypes.add(enemy.m_6095_());
                    this.mFirstHurtTime = System.currentTimeMillis();
                }
                this.mEnemy1st = enemy;
                if (enemy instanceof LivingEntity && this.f_21362_ != (livingEntity2 = (LivingEntity)enemy)) {
                    this.f_21362_ = livingEntity2;
                }
                float damage = pAmount;
                if (enemy instanceof LivingEntity) {
                    livingEntity = (LivingEntity)enemy;
                    damage = Math.max(pAmount, livingEntity.m_21233_() / 5.0f);
                }
                enemy.m_6469_(new DamageSource(pSource.m_269150_()), damage);
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, enemy.m_146892_());
                if (enemy instanceof LivingEntity) {
                    livingEntity = (LivingEntity)enemy;
                    this.m_6504_(livingEntity, 5.0f);
                }
            }
            if (System.currentTimeMillis() - this.mFirstHurtTime > 5100L && !Pig2.isMaxFighting()) {
                if (this.mEnemy1st == null && this.m_5448_() != null && !(this.m_5448_() instanceof Pig2)) {
                    this.mEnemy1st = this.m_5448_();
                }
                this.mAttackLevel = ATTACK_LEVEL.L2;
            }
        }
        finally {
            this.isHurting = false;
        }
        return false;
    }

    private void attackCommandBlock() {
        try {
            Vec3 pos = ((CommandSourceStack)this.mLastCommandEvent.getParseResults().getContext().getSource()).m_81371_();
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, pos);
            this.performRangedAttackToBlockPos(pos);
            this.performRangedAttackToBlockPos(pos);
            this.performRangedAttackToBlockPos(pos);
            ServerLevel sLevel = ((CommandSourceStack)this.mLastCommandEvent.getParseResults().getContext().getSource()).m_81372_();
            BlockPos blockPos = new BlockPos(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82480_), Mth.m_14107_((double)pos.f_82481_));
            sLevel.m_7731_(blockPos, Blocks.f_50083_.m_49966_(), 3);
            String string = this.mLastCommandEvent.getParseResults().getReader().getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private Entity findMODEnemyAroundHere(Entity exceptThisEntity) {
        double radius = 40.0;
        AABB levelBounds = new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius);
        List entities = this.m_9236_().m_6249_((Entity)this, levelBounds, entity -> true);
        if (entities.isEmpty()) {
            return null;
        }
        Entity enemyCandidate = null;
        for (Entity entity2 : entities) {
            if (entity2 instanceof Player || !MyLib2.isThisOtherMOD(entity2) || entity2 == exceptThisEntity || enemyCandidate != null && !(this.m_20270_(enemyCandidate) > this.m_20270_(entity2))) continue;
            enemyCandidate = entity2;
        }
        return enemyCandidate;
    }

    @Nullable
    private Player findPlayerWithModItemAroundHere() {
        double radius = 40.0;
        AABB levelBounds = new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius);
        List entities = this.m_9236_().m_6249_((Entity)this, levelBounds, entity -> entity instanceof Player);
        if (entities.isEmpty()) {
            return null;
        }
        Player enemyCandidate = null;
        for (Entity entity2 : entities) {
            Player player;
            if (!(entity2 instanceof Player) || !MyLib2.isThisOtherMOD((player = (Player)entity2).m_21205_().m_41720_()) || enemyCandidate != null && !(this.m_20270_((Entity)enemyCandidate) > this.m_20270_((Entity)player))) continue;
            enemyCandidate = player;
        }
        return enemyCandidate;
    }

    public static void addKilledEnemy(Entity entity) {
        gKilledEnemyTypes.add(entity.m_6095_());
        gKilledEnemyUUIDs.add(entity.m_20148_());
        Pig2.seeFighting();
    }

    public static boolean isKilledEnemyType(EntityType<?> type) {
        return gKilledEnemyTypes.contains(type);
    }

    public static boolean isKilledEnemyUUID(UUID pUUID) {
        return gKilledEnemyUUIDs.contains(pUUID);
    }

    public static void clearKilledEnemy() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        gKilledEnemyTypes.clear();
        gKilledEnemyUUIDs.clear();
    }

    private static void permitKilledEnemy(Entity enemy) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        if (enemy == null) {
            return;
        }
        gKilledEnemyTypes.remove(enemy.m_6095_());
        gKilledEnemyUUIDs.remove(enemy.f_19820_);
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        Level eventLevel = (Level)event.getLevel();
        if (this.f_19853_ != eventLevel) {
            return;
        }
        if (this.f_146795_ == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            this.startJisatsu();
        }
        if (!Pig2.isMaxFighting()) {
            Pig2.clearKilledEnemy();
        }
    }

    public static void permitEntity(Entity enemy) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        if (MyLib2.isServerThread()) {
            if (Pig2.isMaxFighting()) {
                Pig2.resetMaxFight();
            }
            Pig2.permitKilledEnemy(enemy);
            Pig2Mod.gMyHelper.registerForgeEventBus(enemy);
            gAliveServerPigs.forEach(Pig2::levelDownTo1);
        } else if (MyLib2.isClientThread()) {
            Pig2Mod.gMyHelper.restoreRendererOfThisOtherMOD(enemy);
            Pig2Mod.gMyHelper.registerForgeEventBus(enemy);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.f_19853_ instanceof ClientLevel) {
            return;
        }
        if (this.isBeforeBornToThisWorld()) {
            return;
        }
        if (this.isEnding()) {
            return;
        }
        if (this.f_19853_.m_6907_().isEmpty()) {
            return;
        }
        if (this.f_146795_ != null) {
            this.m_142467_(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.correctMovement();
        Pig2Mod.gMyHelper.correctServerLevelEntities(new HashSet<Pig2>(Collections.singleton(this)));
        this.stopFightingRemovedEnemy();
        this.canUpdate = true;
    }

    private void stopFightingRemovedEnemy() {
        if (this.mStopFightingRemovedEnemyCounter++ % 10 != 0) {
            return;
        }
        if (Pig2.isMaxFighting() && MyLib2.isThisOtherMOD(this.f_21362_)) {
            this.stopNavigation();
        }
        if (this.f_21344_.m_26570_() != null && Math.sqrt(this.f_21344_.m_26570_().m_77406_().m_203198_(this.f_19825_.f_82479_, this.f_19825_.f_82480_, this.f_19825_.f_82481_)) > 100.0) {
            this.stopNavigation();
        }
    }

    private void stopNavigation() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        if (!MyLib2.isServerThread()) {
            return;
        }
        if (this.f_21362_ == null || MyLib2.isThisMinecraftVanilla(this.f_21362_)) {
            return;
        }
        this.f_21362_ = null;
        this.f_21344_.m_26573_();
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
    }

    public static void stopNavigationOfAllPig2() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        gAliveServerPigs.forEach(Pig2::stopNavigation);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.f_19853_ instanceof ServerLevel) {
            return;
        }
        if (this.isEnding()) {
            return;
        }
        if (Minecraft.f_90981_.f_91074_ == null || this.m_9236_().m_6907_().isEmpty() || MyLib2.isCalledFromTheClass("PauseScreen")) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.correctMovement();
        }
        this.canUpdate = true;
    }

    private void correctMovement() {
        if (this.isBeforeBornToThisWorld() || this.isEnding()) {
            return;
        }
        try {
            if (this.m_20159_()) {
                this.m_8127_();
            }
            Vec3 position = this.m_20182_();
            if (Double.isNaN(position.f_82479_) || Double.isNaN(position.f_82480_) || Double.isNaN(position.f_82481_)) {
                this.myMoveTo(this.mOldX, this.mOldY, this.mOldZ);
                this.m_6853_(true);
                this.f_19827_ = Vec3.f_82478_;
                this.f_19789_ = 0.0f;
                Pig2.seeFighting();
            } else if (position.m_82554_(new Vec3(this.mOldX, this.mOldY, this.mOldZ)) > 3.0 || this.isThisOutside(position.f_82479_, position.f_82480_, position.f_82481_)) {
                this.myMoveTo(this.mOldX, this.mOldY, this.mOldZ);
                this.m_6853_(true);
                this.f_19827_ = Vec3.f_82478_;
                this.f_19789_ = 0.0f;
                Pig2.seeFighting();
            } else if (this.m_5830_()) {
                if (!position.equals((Object)new Vec3(this.mOldX, this.mOldY, this.mOldZ))) {
                    this.myMoveTo(this.mOldX, this.mOldY, this.mOldZ);
                }
                this.m_6853_(true);
                this.f_19827_ = Vec3.f_82478_;
                this.f_19789_ = 0.0f;
            } else {
                this.mOldX = position.f_82479_;
                this.mOldY = position.f_82480_;
                this.mOldZ = position.f_82481_;
            }
        }
        catch (Exception position) {
            // empty catch block
        }
        Vec3 vec3A = this.f_19827_;
        double deltamove = vec3A.m_82554_(Vec3.f_82478_);
        if (deltamove > 1.0) {
            this.f_19827_ = vec3A.m_82542_(1.0 / deltamove, 1.0 / deltamove, 1.0 / deltamove);
        }
        if (this.f_146801_ != EntityInLevelCallback.f_156799_) {
            this.mLevelCallbackBackup = this.f_146801_;
        }
    }

    private boolean isThisOutside(double x, double y, double z) {
        if (x < this.f_19853_.m_6857_().m_61955_() || this.f_19853_.m_6857_().m_61957_() < x) {
            return true;
        }
        if (y < (double)this.f_19853_.m_141937_() || (double)this.f_19853_.m_151558_() < y) {
            return true;
        }
        return z < this.f_19853_.m_6857_().m_61956_() || this.f_19853_.m_6857_().m_61958_() < z;
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        if (MyLib2.isClientThread() && this.f_19825_.f_82479_ == 0.0 && this.f_19825_.f_82480_ == 0.0 && this.f_19825_.f_82481_ == 0.0 && this.mOldX == 0.0 && this.mOldY == 0.0 && this.mOldZ == 0.0) {
            this.mOldX = pPacket.m_131500_();
            this.mOldY = pPacket.m_131501_();
            this.mOldZ = pPacket.m_131502_();
        }
        super.m_141965_(pPacket);
    }

    public void m_217006_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        super.m_217006_(pX, pY, pZ);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYRot, float pXRot, int pLerpSteps, boolean pTeleport) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        if (MyLib2.isClientThread() && MyLib2.isCalledFromTheClass("ClientPacketListener") && MyLib2.isCalledFromTheClass("BlockableEventLoop")) {
            this.mOldX = pX;
            this.mOldY = pY;
            this.mOldZ = pZ;
        }
        super.m_6453_(pX, pY, pZ, pYRot, pXRot, pLerpSteps, pTeleport);
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        if (MyLib2.isClientThread()) {
            return;
        }
        if (this.m_9236_() instanceof ClientLevel) {
            return;
        }
        this.mLastCommandEvent = event;
    }

    private void levelDownTo1() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        this.mEnemy1st = null;
        this.mAttackingEnemy = null;
        this.mAttackLevel = ATTACK_LEVEL.L1;
        this.mTickCounterLevel2 = 0;
        this.mTickCounterLevel3 = 0;
        this.mTickCounterLevel4 = 0;
        gLevel4PigIDs.remove(this.f_19848_);
        this.resetAI();
    }

    private void resetAI() {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            return;
        }
        this.f_21362_ = null;
        this.f_21346_.f_25344_.clear();
        this.f_21346_.m_148105_().clear();
        this.f_21345_.f_25344_.clear();
        this.f_21345_.m_148105_().clear();
        this.m_8099_();
        this.m_147271_();
        this.m_21557_(false);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            if (pTarget instanceof Pig2) {
                return;
            }
            if (this.f_21362_ != null && pTarget == null) {
                return;
            }
        }
        this.f_21362_ = pTarget;
    }

    private void tickLevel2() {
        long waitTime = 1500L;
        ++this.mTickCounterLevel2;
        if (this.mTickCounterLevel2 == 1) {
            if (this.mEnemy1st == null) {
                this.mEnemy1st = this.findMODEnemyAroundHere(null);
            }
            if (this.mEnemy1st != null) {
                Pig2.addKilledEnemy(this.mEnemy1st);
                this.mEnemy2ndPos = this.mEnemy1st.m_20182_();
                Entity entity = this.mEnemy1st;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                } else {
                    this.mEnemy1st.m_6074_();
                    Pig2.seeFighting();
                }
            } else {
                this.mAttackLevel = ATTACK_LEVEL.L3;
                this.mTickCounterLevel2 = 0;
            }
            this.mTimeLevel2 = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.mTimeLevel2 > waitTime) {
            if (this.mEnemy1st != null) {
                BlockPos enemyPos = this.mEnemy1st.m_20183_();
                if (this.mEnemy1st.m_6084_()) {
                    Entity entity = this.mEnemy1st;
                    if (!(entity instanceof ServerPlayer)) {
                        this.mAttackLevel = ATTACK_LEVEL.L3;
                        this.mTickCounterLevel2 = 0;
                    } else {
                        ServerPlayer player = (ServerPlayer)entity;
                        this.levelDownTo1();
                    }
                } else {
                    Entity enemy2nd = this.findRevivedEnemy(this.mEnemy1st, this.mEnemy2ndPos);
                    if (enemy2nd == null || !MyLib2.isThisOtherMOD(this.mEnemy1st)) {
                        enemy2nd = this.findMODEnemyAroundHere(this.mEnemy1st);
                        if (enemy2nd != null) {
                            this.mEnemy1st = enemy2nd;
                            this.mAttackLevel = ATTACK_LEVEL.L4;
                            this.mTickCounterLevel2 = 0;
                        } else {
                            this.levelDownTo1();
                        }
                    } else {
                        this.mEnemy1st = enemy2nd;
                        Entity entity = this.mEnemy1st;
                        if (!(entity instanceof ServerPlayer)) {
                            this.mAttackLevel = ATTACK_LEVEL.L3;
                            this.mTickCounterLevel2 = 0;
                        } else {
                            ServerPlayer player = (ServerPlayer)entity;
                            this.kickPlayer(player);
                            this.levelDownTo1();
                        }
                    }
                }
            } else {
                this.mAttackLevel = ATTACK_LEVEL.L3;
                this.mTickCounterLevel2 = 0;
            }
        }
    }

    private void killPlayers() {
        IntegratedServer server = Minecraft.f_90981_.m_91092_();
        if (server != null) {
            Pig2Mod.gMyHelper.invalidImmediatePlayerRespawn();
            server.m_129892_().m_230957_(server.m_129893_().m_81324_(), MY_COMMAND_1_KILL);
        }
    }

    private void kickPlayer(ServerPlayer player) {
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12322_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_150109_().m_36071_();
        gKickStartTime = System.currentTimeMillis();
        MutableComponent message22 = Component.m_237113_((String)(player.m_7755_().getString() + " was killed by Pig2."));
        ClientboundPlayerCombatKillPacket packet = new ClientboundPlayerCombatKillPacket(player.m_19879_(), (Component)message22);
        player.f_8906_.m_9829_((Packet)packet);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception message22) {
            // empty catch block
        }
        BlockPos respawnPos = player.m_8961_();
        if (respawnPos == null) {
            respawnPos = player.m_9236_().m_220360_();
        }
        player.m_6021_((double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_(), (double)respawnPos.m_123343_() + 0.5);
        player.f_8906_.m_9942_((Component)Component.m_237113_((String)"You were killed by Pig2"));
    }

    @SubscribeEvent
    public void onScreenOpening(ScreenEvent.Opening event) {
        if (this.m_9236_() instanceof ServerLevel) {
            return;
        }
        if (event.getScreen() instanceof DisconnectedScreen) {
            event.setNewScreen((Screen)new TitleScreen());
        }
    }

    private void tickLevel3() {
        long waitTime = 1500L;
        ++this.mTickCounterLevel3;
        if (this.mTickCounterLevel3 == 1) {
            if (this.mEnemy1st == null) {
                this.mEnemy1st = this.findMODEnemyAroundHere(null);
            }
            if (this.mEnemy1st != null) {
                this.mEnemy2ndPos = this.mEnemy1st.m_20182_();
                Pig2.addKilledEnemy(this.mEnemy1st);
                Pig2Mod.gMyHelper.removeTheEnemiesInTheServerLevel(new HashSet<Entity>(Collections.singleton(this.mEnemy1st)), (ServerLevel)this.f_19853_);
            }
            this.mTimeLevel3 = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.mTimeLevel3 > waitTime) {
            boolean isFightingAfterRemove;
            boolean bl = isFightingAfterRemove = System.currentTimeMillis() - gLastFightingTime < waitTime / 2L;
            if (this.mEnemy1st != null) {
                BlockPos enemyPos = this.mEnemy1st.m_20183_();
                if (this.mEnemy1st.m_6084_() && this.mEnemy1st.m_9236_().m_6815_(this.mEnemy1st.m_19879_()) != null) {
                    this.mAttackLevel = ATTACK_LEVEL.L4;
                    this.mTickCounterLevel3 = 0;
                } else {
                    Entity enemy2nd = this.findRevivedEnemy(this.mEnemy1st, this.mEnemy2ndPos);
                    if (enemy2nd == null) {
                        enemy2nd = this.findMODEnemyAroundHere(this.mEnemy1st);
                        if (enemy2nd != null) {
                            this.mEnemy1st = enemy2nd;
                            this.mAttackLevel = ATTACK_LEVEL.L4;
                            this.mTickCounterLevel3 = 0;
                        } else if (isFightingAfterRemove) {
                            this.mAttackLevel = ATTACK_LEVEL.L4;
                            this.mTickCounterLevel3 = 0;
                        } else {
                            this.levelDownTo1();
                            this.f_19853_.m_7731_(enemyPos, (BlockState)Blocks.f_50083_.m_49966_().m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(14)), 2);
                            this.checkKilledAllServerEnemies((ServerLevel)this.f_19853_);
                        }
                    } else {
                        this.mEnemy1st = enemy2nd;
                        this.mAttackLevel = ATTACK_LEVEL.L4;
                        this.mTickCounterLevel3 = 0;
                    }
                }
            } else {
                this.mAttackLevel = ATTACK_LEVEL.L4;
                this.mTickCounterLevel3 = 0;
            }
        }
    }

    private Entity findRevivedEnemy(Entity enemy1st, Vec3 enemyPos) {
        double radius = 40.0;
        AABB levelBounds = new AABB(enemyPos.m_82520_(-radius, -radius, -radius), enemyPos.m_82520_(radius, radius, radius));
        ArrayList entities = new ArrayList();
        if (enemy1st instanceof Player) {
            Player player = (Player)enemy1st;
            entities.addAll(this.m_9236_().m_45955_(TargetingConditions.f_26872_, (LivingEntity)player, levelBounds));
        } else {
            entities.addAll(this.m_9236_().m_6249_((Entity)this, levelBounds, entity -> true));
        }
        Entity enemy2nd = null;
        for (Entity entity2 : entities) {
            if (entity2 == enemy1st || entity2.m_6095_() != enemy1st.m_6095_() || enemy2nd != null && !(enemy2nd.m_20238_(enemyPos) > entity2.m_20238_(enemyPos))) continue;
            if (enemy2nd instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)enemy2nd;
                if (!livingEntity.m_6084_()) continue;
                enemy2nd = entity2;
                continue;
            }
            enemy2nd = entity2;
        }
        return enemy2nd;
    }

    private void checkKilledAllServerEnemies(ServerLevel level) {
        if (!MyLib2.isServerThread()) {
            return;
        }
        for (EntitySection entitySection : level.f_143244_.f_157495_.f_156852_.values()) {
            for (Entity entity : entitySection.f_156827_.m_13532_()) {
                if (!MyLib2.isThisOtherMOD(entity)) continue;
                gKilledAllServerEnemies = false;
                return;
            }
        }
        gKilledAllServerEnemies = true;
    }

    public static boolean hasKilledAllServerEnemies() {
        return gKilledAllServerEnemies;
    }

    private void tickLevel4() {
        long waitTime = 2000L;
        ++this.mTickCounterLevel4;
        if (this.mTickCounterLevel4 == 1) {
            gLevel4PigIDs.add(this.f_19848_);
            Pig2Mod.gMyHelper.removeAllServerSide();
            this.mTimeLevel4 = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.mTimeLevel4 > waitTime) {
            boolean isFightingAfterRemoveAll;
            boolean bl = isFightingAfterRemoveAll = System.currentTimeMillis() - gLastFightingTime < waitTime / 2L;
            if (isFightingAfterRemoveAll) {
                Pig2Mod.gMyHelper.removeAllServerSide();
                Pig2.needMaxFight();
                this.mTimeLevel4 = System.currentTimeMillis();
            } else {
                this.levelDownTo1();
            }
        }
    }

    private void tickLevel4Client() {
        if (!MyLib2.isClientThread()) {
            return;
        }
        if (this.mTickCounterLevel4Client++ % 10 != 0) {
            return;
        }
        Pig2Mod.gMyHelper.removeAllClientSide();
    }

    public void m_21153_(float pHealth) {
        if (MyLib2.isCalledFromOtherModWithin1() || MyLib2.isCalledFromMixinWithin1()) {
            Pig2.seeFighting();
        }
        super.m_21153_(10.0f);
    }

    public float m_21223_() {
        return this.isEnding() ? super.m_21223_() : 10.0f;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public void m_6842_(boolean pInvisible) {
        if (pInvisible) {
            return;
        }
        super.m_6842_(pInvisible);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        if (pEffectInstance.m_19544_() == MobEffects.f_19596_) {
            return false;
        }
        if (pEffectInstance.m_19544_() == MobEffects.f_19609_) {
            return false;
        }
        return super.m_7301_(pEffectInstance);
    }

    public void m_8107_() {
        this.m_21195_(MobEffects.f_19596_);
        this.m_21185_();
        super.m_8107_();
    }

    public Entity changeDimension(ServerLevel pDestination, ITeleporter teleporter) {
        return null;
    }

    public boolean m_264318_(ServerLevel pLevel, double pX, double pY, double pZ, Set<RelativeMovement> pRelativeMovements, float pYRot, float pXRot) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return false;
        }
        if (MyLib2.isCalledFromTheClass("TeleportCommand")) {
            if (MyLib2.isCalledFromTheClass("CommandBlock")) {
                return false;
            }
            if (!MyLib2.isCalledFromTheClass("ServerGamePacketListenerImpl") || MyLib2.isCalledFromOtherModWithin10()) {
                return false;
            }
        }
        if (pLevel != this.m_9236_()) {
            return false;
        }
        return super.m_264318_(pLevel, pX, pY, pZ, pRelativeMovements, pYRot, pXRot);
    }

    public void m_6021_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_6021_(pX, pY, pZ);
    }

    public void m_20258_(CompoundTag pCompound) {
        if (MyLib2.isCalledFromTheClass("DataCommands")) {
            return;
        }
        super.m_20258_(pCompound);
        this.m_146915_(true);
        this.correctMovement();
    }

    public boolean m_7998_(Entity pVehicle, boolean pForce) {
        this.m_8127_();
        return false;
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_142687_(pReason);
    }

    public void m_6074_() {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_6074_();
    }

    public void m_20124_(Pose pPose) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        if (pPose == Pose.DYING || pPose == Pose.SLEEPING) {
            return;
        }
        super.m_20124_(pPose);
    }

    public AttributeMap m_21204_() {
        if (MyLib2.isCalledFromTheClass("AttributeCommand")) {
            return new AttributeMap(DefaultAttributes.m_22297_((EntityType)((EntityType)MyEntities.PIG2.get())));
        }
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return new AttributeMap(DefaultAttributes.m_22297_((EntityType)((EntityType)MyEntities.PIG2.get())));
        }
        return super.m_21204_();
    }

    protected void m_6153_() {
        this.myRevive();
    }

    private void myRevive() {
        this.m_21153_(10.0f);
        this.revive();
        this.f_20919_ = 0;
    }

    public void m_7822_(byte pId) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        if (pId == 60) {
            return;
        }
        super.m_7822_(pId);
    }

    public void m_146917_(int pTicksFrozen) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        super.m_146917_(pTicksFrozen);
    }

    public void m_20301_(int pAir) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        super.m_20301_(pAir);
    }

    public PathNavigation m_21573_() {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            Pig pig = new Pig(EntityType.f_20510_, this.m_9236_());
            return pig.m_21573_();
        }
        return super.m_21573_();
    }

    public SynchedEntityData m_20088_() {
        if (MyLib2.isCalledFromOtherModWithin5() && !MyLib2.isCalledFromTheClass("yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch")) {
            return new Pig((EntityType)EntityType.f_20510_, (Level)this.f_19853_).f_19804_;
        }
        return this.f_19804_;
    }

    public void m_7618_(EntityAnchorArgument.Anchor pAnchor, Vec3 pTarget) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return;
        }
        if (pTarget.m_82554_(this.m_20182_()) < 0.4) {
            return;
        }
        super.m_7618_(pAnchor, pTarget);
    }

    public boolean m_147207_(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return false;
        }
        return super.m_147207_(pEffectInstance, pEntity);
    }

    public void m_6034_(double x, double y, double z) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        if (MyLib2.isCalledFromTheClass("m_19956_")) {
            return;
        }
        super.m_6034_(x, y, z);
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_6478_(pType, pPos);
    }

    public void m_19920_(float pAmount, Vec3 pRelative) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_19920_(pAmount, pRelative);
    }

    public void m_19890_(double pX, double pY, double pZ, float pYRot, float pXRot) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_19890_(pX, pY, pZ, pYRot, pXRot);
    }

    public void m_20248_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_20248_(pX, pY, pZ);
    }

    public void m_7678_(double pX, double pY, double pZ, float pYRot, float pXRot) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        if (MyLib2.isCalledFromTheClass("m_19956_")) {
            return;
        }
        super.m_7678_(pX, pY, pZ, pYRot, pXRot);
    }

    public void m_5997_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_5997_(pX, pY, pZ);
    }

    public void m_6541_(float pYaw, int pPitch) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_6541_(pYaw, pPitch);
    }

    public void m_6001_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_6001_(pX, pY, pZ);
    }

    public void m_20256_(Vec3 pDeltaMovement) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_20256_(pDeltaMovement);
    }

    public void m_246865_(Vec3 pAddend) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_246865_(pAddend);
    }

    public ChunkPos m_146902_() {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            return new ChunkPos(this.f_185933_.f_45578_, this.f_185933_.f_45579_);
        }
        return this.f_185933_;
    }

    public boolean m_20223_(CompoundTag pCompound) {
        return super.m_20223_(pCompound);
    }

    public void m_20343_(double pX, double pY, double pZ) {
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        super.m_20343_(pX, pY, pZ);
    }

    public void m_142467_(Entity.RemovalReason pRemovalReason) {
        if (this.mIsSetRemoveding) {
            return;
        }
        if (MyLib2.isCalledFromOtherModWithin5()) {
            Pig2.seeFighting();
            return;
        }
        if (this.f_146801_ == EntityInLevelCallback.f_156799_ && this.mLevelCallbackBackup != EntityInLevelCallback.f_156799_) {
            this.f_146801_ = this.mLevelCallbackBackup;
        }
        this.mIsSetRemoveding = true;
        super.m_142467_(pRemovalReason);
        this.mIsSetRemoveding = false;
    }

    public static boolean permitItemSwing(LivingEntity entityWithItem, Item item) {
        if (MyLib2.isThisOtherMOD(item)) {
            for (Pig2 pig2 : Pig2.getAliveServerPigs()) {
                double distance;
                double maxAngle;
                double threshold;
                Vec3 pig2Vec;
                Vec3 lookVec = entityWithItem.m_20252_(1.0f);
                double dotProduct = lookVec.m_82526_(pig2Vec = pig2.f_19825_.m_82546_(entityWithItem.m_146892_()).m_82541_());
                if (!(dotProduct > (threshold = Math.cos(maxAngle = Math.toRadians(25.0 / (1.0 + (distance = (double)entityWithItem.m_20270_((Entity)pig2)) / 10.0)))))) continue;
                return false;
            }
        }
        return true;
    }

    public void canUpdate(boolean value) {
        this.canUpdate = true;
    }

    private static enum ATTACK_LEVEL {
        L0,
        L1,
        L2,
        L3,
        L4;

    }

    private static enum MAX_FIGHT {
        OFF,
        WAITING,
        ON;

    }
}

