/*
 * Decompiled with CFR 0.152.
 */
package kakiku.pig2mod.xform;

import com.sun.tools.attach.VirtualMachine;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.ITransformationService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import kakiku.pig2mod.xform.MyLaunchPluginHandler;
import kakiku.pig2mod.xform.MyMap;
import kakiku.pig2mod.xform.MyNative;
import sun.misc.Unsafe;

public class MyLib2 {
    public static final boolean MYLIB2_DEBUG_MODE = false;
    public static final String PIG2_CUSTOMNAME = "Pig2_2.7.0";
    private static ScheduledExecutorService gThreadScheduler = Executors.newScheduledThreadPool(1);
    private static final Set<Long> gStoppedThreadIDs = ConcurrentHashMap.newKeySet();
    public static final String REIGAI_THREAD_CLASSNAME1 = "com.mega.uom.";
    private static TransformingClassLoader gClassLoaderBackup = null;
    private static Set<String> gClassNeedsTransformingBackup = null;
    private static Set<String> gModClassNamesFromJar = null;
    private static final Map<String, byte[]> gModClassDataFromJar = new HashMap<String, byte[]>();
    private static final Set<String> gModPackageNamesFromJar = new HashSet<String>();
    private static final Set<String> gJarNames = new HashSet<String>();
    public static final Set<String> gBlackListNames = ConcurrentHashMap.newKeySet();
    private static Instrumentation gKeisou = null;
    private static Instrumentation gKeisouAgent = null;

    public static void MyLog2(String string) {
    }

    public static void showStackTrace() {
        MyLib2.showStackTrace(Thread.currentThread());
    }

    public static void showStackTrace(Thread thread) {
    }

    public static boolean isThisMinecraftVanilla(Object obj) {
        assert (obj != null);
        String name = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        return MyLib2.isThisNameMinecraftVanilla(name);
    }

    public static boolean isThisNameMinecraftVanilla(String name) {
        for (String blackName : gBlackListNames) {
            if (!name.startsWith(blackName)) continue;
            return false;
        }
        if (name.startsWith("com.electronwill.")) {
            return true;
        }
        if (name.startsWith("com.google.")) {
            return true;
        }
        if (name.startsWith("com.mojang.")) {
            return true;
        }
        if (name.startsWith("com.sun.")) {
            return true;
        }
        if (name.startsWith("cpw.mods.")) {
            return true;
        }
        if (name.startsWith("io.netty.")) {
            return true;
        }
        if (name.startsWith("it.unimi.")) {
            return true;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.startsWith("javax.")) {
            return true;
        }
        if (name.startsWith("jdk.")) {
            return true;
        }
        if (name.startsWith("joptsimple.")) {
            return true;
        }
        if (name.startsWith("net.minecraft.")) {
            return true;
        }
        if (name.startsWith("net.minecraftforge.")) {
            return true;
        }
        if (name.startsWith("net.minecrell.")) {
            return true;
        }
        if (name.startsWith("netscape.javascript.")) {
            return true;
        }
        if (name.startsWith("org.antlr.")) {
            return true;
        }
        if (name.startsWith("org.apache.")) {
            return true;
        }
        if (name.startsWith("org.jline.")) {
            return true;
        }
        if (name.startsWith("org.joml.")) {
            return true;
        }
        if (name.startsWith("org.lwjgl.")) {
            return true;
        }
        if (name.startsWith("org.objectweb.")) {
            return true;
        }
        if (name.startsWith("org.openjdk.")) {
            return true;
        }
        if (name.startsWith("org.slf4j.")) {
            return true;
        }
        if (name.startsWith("org.spongepowered.")) {
            return true;
        }
        if (name.startsWith("org.w3c.")) {
            return true;
        }
        if (name.startsWith("org.xml.")) {
            return true;
        }
        return name.startsWith("sun.");
    }

    public static boolean isThisNameWhiteListedMOD(String name) {
        for (String string : gBlackListNames) {
            if (!name.startsWith(string)) continue;
            return false;
        }
        for (Map.Entry entry : MyLib2.getWhiteListNameAndJarEntrySet()) {
            if (!name.startsWith((String)entry.getKey())) continue;
            return true;
        }
        if (!MyLib2.isThisNameMyMOD(name)) {
            if (gModPackageNamesFromJar.stream().noneMatch(name::startsWith)) {
                return true;
            }
        }
        return false;
    }

    private static Set<Map.Entry<String, String>> getWhiteListNameAndJarEntrySet() {
        return Map.ofEntries(Map.entry("com.github.alexthe666.citadel.", "citadel"), Map.entry("me.jellysquid.mods.sodium.", "embeddium"), Map.entry("org.embeddedt.modernfix", "modernfix"), Map.entry("org.embeddedt.embeddium", "embeddium"), Map.entry("com.supermartijn642.fusion.", "fusion"), Map.entry("com.supermartijn642.core.", "supermartijn642corelib"), Map.entry("committee.nova.mods.avaritia.", "Re-Avaritia"), Map.entry("dev.architectury.", "architectury"), Map.entry("dev.kosmx.playerAnim.", "player-animation-lib"), Map.entry("dev.tr7zw.entityculling.", "entityculling"), Map.entry("io.redspace.ironsspellbooks.", "irons_spellbooks"), Map.entry("malte0811.ferritecore.", "ferritecore"), Map.entry("mezz.jei.", "jei"), Map.entry("net.irisshaders.iris.", "oculus"), Map.entry("net.irisshaders.batchedentityrendering.", "oculus"), Map.entry("net.raphimc.immediatelyfast.", "ImmediatelyFast"), Map.entry("net.tslat.smartbrainlib", "SmartBrainLib"), Map.entry("software.bernie.geckolib.", "geckolib"), Map.entry("top.theillusivec4.caelus.", "caelus"), Map.entry("top.theillusivec4.curios.", "curios"), Map.entry("virtuoel.pehkui.", "Pehkui"), Map.entry("com.llamalad7.mixinextras.", "mixinextras"), Map.entry("net.fabricmc.", "fabric-api"), Map.entry("org.apache.commons.math", "commons-math")).entrySet();
    }

    public static boolean isThisMyMOD(Object obj) {
        if (obj == null) {
            return false;
        }
        String name = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        return MyLib2.isThisNameMyMOD(name);
    }

    public static boolean isThisNameMyMOD(String name) {
        return name.startsWith("kakiku.");
    }

    public static boolean isThisOtherMOD(Object obj) {
        if (obj == null) {
            return false;
        }
        String name = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        return MyLib2.isThisNameOtherMOD(name);
    }

    public static boolean isThisNameOtherMOD(String name) {
        if (name.startsWith("kakiku.pig2mod.MyAttacker")) {
            return true;
        }
        return !MyLib2.isThisNameMinecraftVanilla(name) && !MyLib2.isThisNameMyMOD(name);
    }

    public static boolean isThisOtherBadMOD(Object obj) {
        if (obj == null) {
            return false;
        }
        String name = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        return MyLib2.isThisNameOtherBadMOD(name);
    }

    public static boolean isThisNameOtherBadMOD(String name) {
        return MyLib2.isThisNameOtherMOD(name) && !MyLib2.isThisNameWhiteListedMOD(name);
    }

    public static boolean isClientThread() {
        return Thread.currentThread().getName().contains("Render");
    }

    public static boolean isServerThread() {
        return Thread.currentThread().getName().contains("Server");
    }

    public static boolean isThisBadThread() {
        if (MyLib2.isClientThread()) {
            return false;
        }
        if (MyLib2.isServerThread()) {
            return false;
        }
        return MyLib2.isThisBadThread(Thread.currentThread());
    }

    public static boolean isThisBadThread(Thread thread) {
        if (MyLib2.isThisNameOtherBadMOD(thread.getClass().getName())) {
            return true;
        }
        StackTraceElement[] callers = thread.getStackTrace();
        if (callers.length == 0) {
            return false;
        }
        String lastCallerName = callers[callers.length - 1].getClassName();
        if (lastCallerName.startsWith("java.util.concurrent.ForkJoinWorkerThread")) {
            return false;
        }
        Object pattern = "";
        for (StackTraceElement caller : callers) {
            String className = caller.getClassName();
            if (MyLib2.isThisNameOtherBadMOD(className)) {
                if (className.startsWith(REIGAI_THREAD_CLASSNAME1)) {
                    return false;
                }
                if (((String)pattern).endsWith("\u4ed6")) continue;
                pattern = (String)pattern + "\u4ed6";
                continue;
            }
            if (className.startsWith("java.")) {
                if (((String)pattern).endsWith("J")) continue;
                pattern = (String)pattern + "J";
                continue;
            }
            if (className.startsWith("kakiku.")) {
                if (!((String)pattern).endsWith("\u81ea")) {
                    pattern = (String)pattern + "\u81ea";
                }
                if (!className.startsWith("kakiku.pig2mod.xform.") || !caller.getMethodName().equals("transform")) continue;
                return false;
            }
            if (((String)pattern).endsWith("*")) continue;
            pattern = (String)pattern + "*";
        }
        if (((String)(pattern = (String)pattern + "\u7d42")).equals("\u4ed6J\u7d42")) {
            return true;
        }
        if (((String)pattern).equals("J\u4ed6J\u7d42")) {
            return true;
        }
        if (((String)pattern).contains("\u81ea") && ((String)pattern).endsWith("\u4ed6J\u7d42")) {
            return true;
        }
        return ((String)pattern).endsWith("\u4ed6\u7d42");
    }

    public static void stopBadThreads() {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            long tid = t.getId();
            if (!MyLib2.isThisBadThread(t) || !gStoppedThreadIDs.add(tid)) continue;
            try {
                StackTraceElement[] stack;
                t.suspend();
                if (!MyLib2.isThisNameOtherBadMOD(t.getClass().getName()) && ((stack = t.getStackTrace()).length > 0 && stack[0].getClassName().equals("jdk.internal.misc.Unsafe") && stack[0].getMethodName().contains("park") || stack[0].getClassName().startsWith("java.util.Collections$Synchronized"))) {
                    t.resume();
                    gStoppedThreadIDs.remove(tid);
                    return;
                }
                if (MyLib2.isThisNameOtherBadMOD(t.getClass().getName())) continue;
                MyLib2.showStackTrace(t);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void stopMyselfIfImBadThread(String debugMessage) {
        Thread t = Thread.currentThread();
        long tid = t.getId();
        if (!MyLib2.isThisBadThread(t)) {
            return;
        }
        if (gStoppedThreadIDs.add(tid)) {
            try {
                Thread.sleep(6000000L);
                t.suspend();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isCalledFromTheClass(String className) {
        for (StackTraceElement caller : MyLib2.getStackTrace()) {
            if (!caller.getClassName().contains(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCalledFromMixinWithin1() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        StackTraceElement caller = callers[3];
        return caller.getMethodName().startsWith("handler$");
    }

    public static boolean isCalledFromOtherModWithin1() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        StackTraceElement caller = callers[3];
        if (caller.getClassName().startsWith("jdk.internal.reflect.")) {
            return true;
        }
        return MyLib2.isThisNameOtherMOD(caller.getClassName());
    }

    public static boolean isCalledFromOtherModWithin5() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        for (int i = 3; i < 8; ++i) {
            StackTraceElement caller = callers[i];
            if (caller.getClassName().startsWith("jdk.internal.reflect.")) {
                return true;
            }
            if (!MyLib2.isThisNameOtherMOD(caller.getClassName()) || callers[i - 1].getClassName().startsWith("net.minecraftforge.eventbus.EventBus") && callers[i - 1].getMethodName().equals(caller.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCalledFromOtherModWithin10() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        for (int i = 3; i < 13; ++i) {
            StackTraceElement caller = callers[i];
            if (caller.getClassName().startsWith("jdk.internal.reflect.")) {
                return true;
            }
            if (!MyLib2.isThisNameOtherMOD(caller.getClassName()) || callers[i - 1].getClassName().startsWith("net.minecraftforge.eventbus.EventBus") && callers[i - 1].getMethodName().equals(caller.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement getCaller1() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        return callers[3];
    }

    public static StackTraceElement getCaller2() {
        StackTraceElement[] callers = MyLib2.getStackTrace();
        return callers[4];
    }

    private static StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = null;
        try {
            throw new Exception("dummy");
        }
        catch (Exception e) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                Unsafe unsafe = (Unsafe)theUnsafe.get(null);
                Field stackTraceField = Throwable.class.getDeclaredField("stackTrace");
                long fieldOffset = unsafe.objectFieldOffset(stackTraceField);
                e.getStackTrace();
                stackTrace = (StackTraceElement[])unsafe.getObject(e, fieldOffset);
            }
            catch (Exception exception) {
                stackTrace = e.getStackTrace();
            }
            return (StackTraceElement[])stackTrace.clone();
        }
    }

    public static String getStr(String key) {
        return System.getProperty("Pig2." + key);
    }

    public static void setStr(String key, String value) {
        System.setProperty("Pig2." + key, value);
    }

    public static void keepKillingBeforeMod() {
        gThreadScheduler.scheduleWithFixedDelay(() -> {
            if ("true".equals(MyLib2.getStr("MyLib2.keepKillingAfterMod"))) {
                gThreadScheduler.shutdown();
                return;
            }
            Thread thread = new Thread(() -> {
                MyLib2.stopBadThreads();
                MyLib2.killOtherXformFromMyThread();
            });
            thread.setPriority(10);
            thread.start();
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public static void keepKillingAfterMod() {
        MyLib2.setStr("MyLib2.keepKillingAfterMod", "true");
        gThreadScheduler.scheduleWithFixedDelay(() -> {
            Thread thread = new Thread(() -> MyLib2.stopBadThreads());
            thread.setPriority(10);
            thread.start();
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public static void killOtherXformFromMainThread() {
        MyLib2.killOtherXform();
        MyLib2.invalidOtherXformService();
    }

    public static void killOtherXformFromMyThread() {
        MyLib2.killOtherXform();
    }

    private static void killOtherXform() {
        try {
            Instrumentation keisou = MyLib2.getKeisou();
            if (keisou != null) {
                Class<?> instImplClass;
                Field transformerField1;
                long offset1;
                ArrayList managers = new ArrayList();
                Unsafe unsafe = MyLib2.getUnsafe();
                Object manager = unsafe.getObject(keisou, offset1 = unsafe.objectFieldOffset(transformerField1 = (instImplClass = Class.forName("sun.instrument.InstrumentationImpl")).getDeclaredField("mRetransfomableTransformerManager")));
                if (manager != null) {
                    long listOffset = unsafe.objectFieldOffset(manager.getClass().getDeclaredField("mTransformerList"));
                    Object[] transformerList = (Object[])unsafe.getObject(manager, listOffset);
                    Class<?> transformerInfoClass = Class.forName("sun.instrument.TransformerManager$TransformerInfo");
                    Field tfField = transformerInfoClass.getDeclaredField("mTransformer");
                    long tfOffset = unsafe.objectFieldOffset(tfField);
                    if (transformerList.length > 0) {
                        for (Object info : transformerList) {
                            Object tfObj = unsafe.getObject(info, tfOffset);
                            if (!(tfObj instanceof ClassFileTransformer)) continue;
                            ClassFileTransformer tf = (ClassFileTransformer)tfObj;
                            String XformerName = new String(tf.getClass().getName());
                            if (MyLib2.isThisNameOtherBadMOD(XformerName)) {
                                keisou.removeTransformer(tf);
                                continue;
                            }
                            if (XformerName.startsWith("kakiku.")) continue;
                        }
                    }
                }
            }
        }
        catch (Throwable keisou) {
            // empty catch block
        }
        try {
            Field launchPluginsField = Launcher.class.getDeclaredField("launchPlugins");
            launchPluginsField.setAccessible(true);
            LaunchPluginHandler launchPlugins = (LaunchPluginHandler)launchPluginsField.get(Launcher.INSTANCE);
            if (launchPlugins.getClass() != MyLaunchPluginHandler.class) {
                if (launchPlugins.getClass() == LaunchPluginHandler.class) {
                    launchPluginsField.set(Launcher.INSTANCE, (Object)MyLaunchPluginHandler.myNew());
                } else {
                    launchPluginsField.set(Launcher.INSTANCE, (Object)MyLaunchPluginHandler.myNew());
                }
            } else {
                MyMap.setMyMap();
            }
        }
        catch (Throwable launchPluginsField) {
            // empty catch block
        }
        try {
            Field classLoaderField = Launcher.class.getDeclaredField("classLoader");
            classLoaderField.setAccessible(true);
            TransformingClassLoader classLoader = (TransformingClassLoader)classLoaderField.get(Launcher.INSTANCE);
            if (MyLib2.isThisOtherMOD(classLoader)) {
                classLoaderField.set(Launcher.INSTANCE, gClassLoaderBackup);
            } else {
                gClassLoaderBackup = classLoader;
            }
        }
        catch (Throwable classLoaderField) {
            // empty catch block
        }
        try {
            Field transformationServicesHandlerField = Launcher.class.getDeclaredField("transformationServicesHandler");
            transformationServicesHandlerField.setAccessible(true);
            Object transformationServicesHandler = transformationServicesHandlerField.get(Launcher.INSTANCE);
            Field transformStoreField = transformationServicesHandler.getClass().getDeclaredField("transformStore");
            transformStoreField.setAccessible(true);
            TransformStore transformStore = (TransformStore)transformStoreField.get(transformationServicesHandler);
            Field classNeedsTransformingField = TransformStore.class.getDeclaredField("classNeedsTransforming");
            classNeedsTransformingField.setAccessible(true);
            Set classNeedsTransforming = (Set)classNeedsTransformingField.get(transformStore);
            if (MyLib2.isThisOtherMOD(classNeedsTransforming)) {
                if (gClassNeedsTransformingBackup == null) {
                    gClassNeedsTransformingBackup = new HashSet<String>();
                }
                classNeedsTransformingField.set(transformStore, gClassNeedsTransformingBackup);
            } else {
                gClassNeedsTransformingBackup = classNeedsTransforming;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void invalidOtherXformService() {
        try {
            Field transformationServicesHandlerField = Launcher.class.getDeclaredField("transformationServicesHandler");
            transformationServicesHandlerField.setAccessible(true);
            Object transformationServicesHandler = transformationServicesHandlerField.get(Launcher.INSTANCE);
            Field serviceLookupField = transformationServicesHandler.getClass().getDeclaredField("serviceLookup");
            serviceLookupField.setAccessible(true);
            Map serviceLookup = (Map)serviceLookupField.get(transformationServicesHandler);
            if (serviceLookup != null && !serviceLookup.isEmpty()) {
                boolean bChanged = false;
                HashMap<String, TransformationServiceDecorator> serviceLookupNew = new HashMap<String, TransformationServiceDecorator>();
                for (Map.Entry entryService : serviceLookup.entrySet()) {
                    TransformationServiceDecorator decorator = (TransformationServiceDecorator)entryService.getValue();
                    Field serviceField = TransformationServiceDecorator.class.getDeclaredField("service");
                    serviceField.setAccessible(true);
                    ITransformationService service = (ITransformationService)serviceField.get(decorator);
                    if (MyLib2.isThisNameOtherBadMOD(service.getClass().getName())) {
                        bChanged = true;
                        continue;
                    }
                    serviceLookupNew.put((String)entryService.getKey(), (TransformationServiceDecorator)entryService.getValue());
                }
                if (bChanged) {
                    serviceLookupField.set(transformationServicesHandler, serviceLookupNew);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Unsafe getUnsafe() throws Exception {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        return (Unsafe)unsafeField.get(null);
    }

    private static Set<String> findModClassFromJar() {
        if (gModClassNamesFromJar != null) {
            return gModClassNamesFromJar;
        }
        gModClassNamesFromJar = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        File modsFolder = new File("mods");
        if (!modsFolder.exists() || !modsFolder.isDirectory()) {
            return gModClassNamesFromJar;
        }
        File[] jarFiles = modsFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarFiles == null) {
            return gModClassNamesFromJar;
        }
        for (File jarFile : jarFiles) {
            try (JarFile jar = new JarFile(jarFile);){
                gJarNames.add(jarFile.getName());
                try (FileInputStream is = new FileInputStream(jarFile);){
                    MyLib2.processJarStream(is, jarFile.getName(), classNames);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        gModClassNamesFromJar = classNames;
        return gModClassNamesFromJar;
    }

    private static void processJarStream(InputStream jarStream, String parentJarName, Set<String> classNames) {
        try (JarInputStream jis = new JarInputStream(jarStream);){
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                String jarName;
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    String className = name.replace('/', '.').substring(0, name.length() - 6);
                    classNames.add(className);
                    byte[] classFile = jis.readAllBytes();
                    gModClassDataFromJar.put(className, classFile);
                    String packageName = name.substring(0, name.lastIndexOf(47) + 1).replace('/', '.');
                    gModPackageNamesFromJar.add(packageName);
                    boolean isFakeName = false;
                    if (className.startsWith("kakiku.") && !parentJarName.startsWith("pig2")) {
                        isFakeName = true;
                    } else if (MyLib2.isThisNameWhiteListedMOD(className)) {
                        isFakeName = MyLib2.getWhiteListNameAndJarEntrySet().stream().anyMatch(e -> className.startsWith((String)e.getKey()) && !parentJarName.startsWith((String)e.getValue()));
                    } else if (MyLib2.isThisNameMinecraftVanilla(className)) {
                        isFakeName = true;
                    }
                    if (!isFakeName) continue;
                    gBlackListNames.add(className);
                    continue;
                }
                if (!name.endsWith(".jar")) continue;
                int idx = name.lastIndexOf(47);
                String string = jarName = idx >= 0 ? name.substring(idx + 1) : name;
                if (jarName.toLowerCase().startsWith("mixinextras")) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                jis.transferTo(baos);
                byte[] nestedJarBytes = baos.toByteArray();
                MyLib2.processJarStream(new ByteArrayInputStream(nestedJarBytes), jarName, classNames);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Set<String> getModClassNamesFromJar() {
        return MyLib2.findModClassFromJar();
    }

    public static Map<String, byte[]> getModClassDataFromJar() {
        return gModClassDataFromJar;
    }

    public static boolean hasJar(String pJarName) {
        return gJarNames.stream().anyMatch(jarName -> jarName.contains(pJarName));
    }

    @Nullable
    public static Instrumentation getKeisou() {
        if (gKeisou != null) {
            return gKeisou;
        }
        gKeisou = MyLib2.getKeisouFromDll();
        if (gKeisou != null) {
            return gKeisou;
        }
        gKeisou = MyLib2.getKeisouFromAgent();
        return gKeisou;
    }

    @Nullable
    public static Instrumentation getKeisouFromDll() {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            return null;
        }
        Instrumentation keisou = null;
        try {
            Object obj;
            int test = 0;
            test = MyNative.getNumber();
            if (test == 123 && (obj = MyNative.getKeisou()) instanceof Instrumentation) {
                Instrumentation inst;
                keisou = inst = (Instrumentation)obj;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return keisou;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Instrumentation getKeisouFromAgent() {
        VirtualMachine vm = null;
        try {
            String pid = Long.toString(ProcessHandle.current().pid());
            Field field = Class.forName("sun.tools.attach.HotSpotVirtualMachine").getDeclaredField("ALLOW_ATTACH_SELF");
            Unsafe unsafe = MyLib2.getUnsafe();
            unsafe.putBoolean(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), true);
            String myAgentPath = MyLib2.extractAgentJar().toString();
            vm = VirtualMachine.attach(pid);
            vm.loadAgent(myAgentPath, "");
        }
        catch (Throwable throwable) {
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (Throwable throwable) {}
            }
        }
        return gKeisouAgent;
    }

    public static void setKeisou(String args, Instrumentation inst) {
        gKeisouAgent = inst;
    }

    public static Path extractAgentJar() throws IOException {
        String agentFileName = "pig2_agent.jar";
        String resourcePath = "/assets/pig2mod/agent/" + agentFileName;
        Path outputPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(agentFileName);
        try (InputStream in = MyLib2.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new FileNotFoundException("pig2_agent.jar \u304c pig2mod \u5185\u306b\u898b\u3064\u304b\u3089\u306a\u3044\u3002");
            }
            try {
                Files.copy(in, outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return outputPath.toAbsolutePath();
    }

    public static String shortName(String className, String methodName) {
        return MyLib2.shortClassName(className) + "." + MyLib2.shortMethodName(methodName) + "()";
    }

    public static String shortClassName(String className) {
        int idx = className.lastIndexOf(47);
        if (idx < 0) {
            idx = className.lastIndexOf(46);
        }
        if (idx >= 0) {
            return className.substring(idx + 1);
        }
        return className;
    }

    public static String shortMethodName(String methodName) {
        int idx = methodName.indexOf(40);
        if (idx >= 0) {
            return methodName.substring(0, idx);
        }
        return methodName;
    }

    static {
        MyLib2.findModClassFromJar();
    }
}

