/*
 * Decompiled with CFR 0.152.
 */
package kakiku.pig2mod.xform;

import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import kakiku.pig2mod.xform.MyLib2;
import kakiku.pig2mod.xform.MyXformer2;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MyPlugin
implements ILaunchPluginService {
    public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader, NamedPath[] specialPaths) {
        MyLib2.killOtherXformFromMainThread();
        super.initializeLaunch(transformerLoader, specialPaths);
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type type, boolean b) {
        if (MyLib2.isThisNameOtherBadMOD(type.getClassName())) {
            return EnumSet.of(ILaunchPluginService.Phase.AFTER);
        }
        return EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    public String name() {
        return "pig2xform";
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        boolean bChanged = false;
        if (reason.equals("classloading")) {
            bChanged = this.processClass(classNode);
        } else if (reason.equals("mixin") || !reason.equals("computing_frames")) {
            // empty if block
        }
        if (bChanged) {
            MyXformer2.doNotResetThisClass(classType.getClassName());
        }
        return bChanged;
    }

    public boolean processClass(ClassNode classNode) {
        if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
            return false;
        }
        boolean bChanged = false;
        bChanged |= this.transform_BadEventBus(classNode);
        bChanged |= this.transform_methodWithRunnableArg(classNode);
        bChanged |= this.transform_level_Entity(classNode);
        bChanged |= this.transform_BadThreads(classNode);
        bChanged |= this.transform_mFlashfur(classNode);
        bChanged |= this.transform_crashMethod(classNode);
        bChanged |= this.transform_BadEntityRemover(classNode);
        bChanged |= this.transform_disconnect(classNode);
        bChanged |= this.transform_BadDeleteFiles(classNode);
        bChanged |= this.transform_fakeEntityID(classNode);
        bChanged |= this.transform_BadRender(classNode);
        bChanged |= this.transform_mixinPlugin(classNode);
        bChanged |= this.transform_playerJammer(classNode);
        bChanged |= this.transform_BadDainyuu(classNode);
        return bChanged |= this.transform_BadCall(classNode);
    }

    private boolean transform_tempXXXX(ClassNode classNode) {
        boolean bChanged = false;
        if (classNode.name.contains("xxxx")) {
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("xxxx") && !method.name.equals("xxxx")) continue;
            }
        }
        return bChanged;
    }

    private boolean transform_playerJammer(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            if (classNode.name.contains("DragionnTickUpdateProcedure") && method.name.equals("onEntityTick")) continue;
            boolean hasSubscribeAnnotation = false;
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode aNode : method.visibleAnnotations) {
                if (!aNode.desc.equals("Lnet/minecraftforge/eventbus/api/SubscribeEvent;")) continue;
                hasSubscribeAnnotation = true;
                break;
            }
            if (!hasSubscribeAnnotation) continue;
            if (method.desc.equals("(Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;)V") || method.desc.startsWith("(Lnet/minecraftforge/client/event/ScreenEvent") && method.desc.endsWith(")V") || method.desc.equals("(Lnet/minecraftforge/client/event/ViewportEvent$ComputeFov;)V")) {
                if (!this.makeMethodEmpty(classNode, method)) continue;
                bChanged = true;
                continue;
            }
            if (!method.desc.equals("(Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;)V") && !method.desc.equals("(Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;)V")) continue;
            int eventVar = (method.access & 8) != 0 ? 0 : 1;
            int entityVar = eventVar + 1;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, eventVar));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/event/entity/EntityEvent", "getEntity", "()Lnet/minecraft/world/entity/Entity;", false));
            insnList.add((AbstractInsnNode)new VarInsnNode(58, entityVar));
            LabelNode notPlayer = new LabelNode();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, entityVar));
            insnList.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/world/entity/player/Player"));
            insnList.add((AbstractInsnNode)new JumpInsnNode(153, notPlayer));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            insnList.add((AbstractInsnNode)notPlayer);
            LabelNode notPig2 = new LabelNode();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, entityVar));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)"kakiku.pig2mod.entity.Pig2"));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false));
            insnList.add((AbstractInsnNode)new JumpInsnNode(153, notPig2));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            insnList.add((AbstractInsnNode)notPig2);
            method.instructions.insert(insnList);
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_mixinPlugin(ClassNode classNode) {
        boolean bChanged = false;
        if (classNode.interfaces.contains("org/spongepowered/asm/mixin/extensibility/IMixinConfigPlugin")) {
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("getMixins") && !method.name.equals("preApply") && !method.name.equals("postApply") || !this.makeMethodEmpty(classNode, method)) continue;
                bChanged = true;
            }
        }
        for (MethodNode method : classNode.methods) {
            boolean needChange = false;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode mInsn = (MethodInsnNode)insn;
                    if (!mInsn.owner.equals("org/spongepowered/asm/mixin/MixinEnvironment") || !mInsn.name.equals("getCurrentEnvironment")) continue;
                    needChange = true;
                    break;
                }
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fInsn = (FieldInsnNode)insn;
                if (insn.getOpcode() != 178 || !fInsn.owner.equals("org/spongepowered/asm/mixin/MixinEnvironment") || !fInsn.name.equals("currentEnvironment")) continue;
                needChange = true;
                break;
            }
            if (!needChange || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_BadRender(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            boolean usingSetOrtho = false;
            boolean usingRenderClear = false;
            boolean usingTranslateBig = false;
            boolean usingJNIinvoke = false;
            boolean usingBuilderAssign = false;
            boolean usingGLFWMakeContextCurrent = false;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                FieldInsnNode fInsn;
                if (insn instanceof MethodInsnNode) {
                    AbstractInsnNode abstractInsnNode;
                    MethodInsnNode mInsn = (MethodInsnNode)insn;
                    if (mInsn.owner.equals("org/joml/Matrix4f") && mInsn.name.equals("setOrtho")) {
                        usingSetOrtho = true;
                    }
                    if (mInsn.owner.equals("com/mojang/blaze3d/systems/RenderSystem") && mInsn.name.equals("clear")) {
                        usingRenderClear = true;
                    }
                    if (mInsn.name.equals("translate") && (mInsn.desc.contains("DDD)") || mInsn.desc.contains("FFF)")) && (abstractInsnNode = mInsn.getPrevious()) instanceof LdcInsnNode) {
                        Double d;
                        Float f;
                        LdcInsnNode ldc = (LdcInsnNode)abstractInsnNode;
                        Object object = ldc.cst;
                        if (object instanceof Float && Math.abs((f = (Float)object).floatValue()) >= 10000.0f) {
                            usingTranslateBig = true;
                        }
                        if ((object = ldc.cst) instanceof Double && Math.abs(d = (Double)object) >= 10000.0) {
                            usingTranslateBig = true;
                        }
                    }
                    if (mInsn.owner.equals("org/lwjgl/system/JNI") && mInsn.name.startsWith("invoke")) {
                        usingJNIinvoke = true;
                    }
                    if (!mInsn.owner.equals("org/lwjgl/glfw/GLFW") || !mInsn.name.equals("glfwMakeContextCurrent")) continue;
                    usingGLFWMakeContextCurrent = true;
                    continue;
                }
                if (!(insn instanceof FieldInsnNode) || (fInsn = (FieldInsnNode)insn).getOpcode() != 181 || !fInsn.owner.equals("com/mojang/blaze3d/vertex/Tesselator") || !fInsn.name.equals("f_85907_")) continue;
                usingBuilderAssign = true;
            }
            if ((!usingSetOrtho || !usingRenderClear) && !usingTranslateBig && !usingJNIinvoke && !usingBuilderAssign && !usingGLFWMakeContextCurrent || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_fakeEntityID(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            InsnList insnList;
            if ((method.access & 0x500) != 0) continue;
            if (method.name.equals("m_20148_") && method.desc.equals("()Ljava/util/UUID;")) {
                method.instructions.clear();
                method.tryCatchBlocks.clear();
                method.localVariables = null;
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/world/entity/Entity", "m_20148_", "()Ljava/util/UUID;", false));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                method.instructions.insert(insnList);
                bChanged = true;
                continue;
            }
            if (method.name.equals("m_19879_") && method.desc.equals("()I")) {
                method.instructions.clear();
                method.tryCatchBlocks.clear();
                method.localVariables = null;
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/world/entity/Entity", "m_19879_", "()I", false));
                insnList.add((AbstractInsnNode)new InsnNode(172));
                method.instructions.insert(insnList);
                bChanged = true;
                continue;
            }
            if (method.name.equals("m_20084_") && method.desc.equals("(Ljava/util/UUID;)V")) {
                method.instructions.clear();
                method.tryCatchBlocks.clear();
                method.localVariables = null;
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/world/entity/Entity", "m_20084_", "(Ljava/util/UUID;)V", false));
                insnList.add((AbstractInsnNode)new InsnNode(177));
                method.instructions.insert(insnList);
                bChanged = true;
                continue;
            }
            if (!method.name.equals("m_20234_") || !method.desc.equals("(I)V")) continue;
            method.instructions.clear();
            method.tryCatchBlocks.clear();
            method.localVariables = null;
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new VarInsnNode(21, 1));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/world/entity/Entity", "m_20234_", "(I)V", false));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.insert(insnList);
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_BadDeleteFiles(ClassNode classNode) {
        boolean bChanged = false;
        HashSet<MethodNode> fileDeleteMethods = new HashSet<MethodNode>();
        HashSet<MethodNode> entitiesMethods = new HashSet<MethodNode>();
        for (MethodNode method0 : classNode.methods) {
            boolean usesEntities = false;
            boolean callsDelete = false;
            for (AbstractInsnNode insn : method0.instructions) {
                MethodInsnNode minsn;
                if (insn instanceof LdcInsnNode) {
                    LdcInsnNode ldc = (LdcInsnNode)insn;
                    if ("entities".equals(ldc.cst)) {
                        usesEntities = true;
                    }
                }
                if (!(insn instanceof MethodInsnNode) || (minsn = (MethodInsnNode)insn).getOpcode() != 182 || !minsn.owner.equals("java/io/File") || !minsn.name.equals("delete") || !minsn.desc.equals("()Z")) continue;
                callsDelete = true;
            }
            if (usesEntities) {
                entitiesMethods.add(method0);
            }
            if (!callsDelete) continue;
            fileDeleteMethods.add(method0);
        }
        for (MethodNode method : fileDeleteMethods) {
            boolean isThisTargetMethod = entitiesMethods.contains(method);
            if (!isThisTargetMethod) {
                for (MethodNode caller : entitiesMethods) {
                    if (method.name.contains(caller.name)) {
                        isThisTargetMethod = true;
                        break;
                    }
                    for (AbstractInsnNode insn : caller.instructions) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode minsn = (MethodInsnNode)insn;
                        if (!minsn.name.equals(method.name) || !minsn.desc.equals(method.desc)) continue;
                        isThisTargetMethod = true;
                        break;
                    }
                    if (!isThisTargetMethod) continue;
                    break;
                }
            }
            if (!isThisTargetMethod || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_disconnect(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (insn.getOpcode() != 182 || !methodInsn.name.equals("m_9942_") || !methodInsn.desc.equals("(Lnet/minecraft/network/chat/Component;)V")) continue;
                MethodInsnNode staticCall = new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "disconnect", "(Lnet/minecraft/server/network/ServerGamePacketListenerImpl;Lnet/minecraft/network/chat/Component;)V", false);
                method.instructions.set((AbstractInsnNode)methodInsn, (AbstractInsnNode)staticCall);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private boolean transform_BadDainyuu(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getOpcode() != 181 && insn.getOpcode() != 179) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (!(fieldInsn.owner.equals("net/minecraft/client/Minecraft") || fieldInsn.owner.equals("net/minecraftforge/common/MinecraftForge") || fieldInsn.owner.equals("net/minecraft/server/level/ServerLevel") && fieldInsn.name.equals("f_143243_") || fieldInsn.owner.equals("net/minecraft/server/level/ServerLevel") && fieldInsn.name.equals("f_143244_") || fieldInsn.owner.equals("net/minecraft/world/level/entity/EntitySection") || fieldInsn.owner.equals("net/minecraft/world/level/entity/PersistentEntitySectionManager") || fieldInsn.owner.equals("net/minecraft/client/multiplayer/ClientLevel") && fieldInsn.name.equals("f_171631_") || fieldInsn.owner.equals("net/minecraft/client/multiplayer/ClientLevel") && fieldInsn.name.equals("f_171630_") || fieldInsn.owner.equals("net/minecraft/client/multiplayer/ClientLevel") && fieldInsn.name.equals("f_104561_") || fieldInsn.owner.equals("net/minecraft/client/multiplayer/ClientLevel") && fieldInsn.name.equals("f_104562_") || fieldInsn.owner.equals("net/minecraft/world/level/entity/TransientEntitySectionManager") || fieldInsn.owner.equals("net/minecraft/world/level/entity/EntityTickList") || fieldInsn.owner.equals("net/minecraft/client/renderer/entity/EntityRenderDispatcher") || fieldInsn.owner.equals("net/minecraft/world/entity/player/Player") && fieldInsn.name.equals("f_36093_") || fieldInsn.owner.equals("com/mojang/blaze3d/vertex/BufferBuilder") || fieldInsn.owner.equals("com/mojang/blaze3d/systems/RenderSystem") || fieldInsn.owner.equals("com/mojang/blaze3d/platform/Window") || fieldInsn.owner.equals("net/minecraft/client/renderer/GameRenderer") || fieldInsn.owner.equals("net/minecraft/network/Connection") || fieldInsn.owner.equals("net/minecraft/client/multiplayer/ClientPacketListener") || fieldInsn.owner.equals("net/minecraft/client/player/LocalPlayer") || fieldInsn.owner.equals("net/minecraft/client/renderer/LevelRenderer") || fieldInsn.owner.equals("net/minecraft/client/Options")) && (!MyLib2.isThisNameMinecraftVanilla(fieldInsn.owner.replace('/', '.')) || !fieldInsn.desc.equals("L" + fieldInsn.owner + ";") || fieldInsn.getOpcode() != 179)) continue;
                InsnList insnList = new InsnList();
                if (insn.getOpcode() == 181) {
                    insnList.add((AbstractInsnNode)new InsnNode(87));
                }
                if (fieldInsn.desc.equals("J") || fieldInsn.desc.equals("D")) {
                    insnList.add((AbstractInsnNode)new InsnNode(88));
                } else {
                    insnList.add((AbstractInsnNode)new InsnNode(87));
                }
                method.instructions.insert(insn, insnList);
                method.instructions.remove(insn);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private boolean transform_BadCall(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode mInsn = (MethodInsnNode)insn;
                boolean needChange = false;
                if (mInsn.owner.equals("net/minecraftforge/eventbus/api/IEventBus") || mInsn.owner.equals("net/minecraftforge/eventbus/EventBus")) {
                    if (mInsn.name.equals("unregister") || mInsn.name.equals("shutdown")) {
                        needChange = true;
                    }
                } else if (mInsn.owner.equals("net/minecraftforge/eventbus/ListenerList") && mInsn.name.equals("unregisterAll")) {
                    needChange = true;
                }
                if (!needChange) continue;
                this.makeMethodCallEmpty(method, mInsn);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private boolean transform_BadEntityRemover(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            boolean hasCallUnsafeGetPut = false;
            boolean hasNewRemoveEntitiesPacket = false;
            boolean hasRemovalReasonAssignment = false;
            boolean hasCanUpdateAssignment = false;
            boolean hasEntityLevel = false;
            boolean hasCallbackMove = false;
            InsnList insns = method.instructions;
            for (AbstractInsnNode insn : insns) {
                MethodInsnNode mInsn;
                if (insn.getOpcode() == 182 || insn.getOpcode() == 184) {
                    mInsn = (MethodInsnNode)insn;
                    if (!mInsn.owner.equals("sun/misc/Unsafe") || !mInsn.name.equals("putObject") && !mInsn.name.equals("getObject")) continue;
                    hasCallUnsafeGetPut = true;
                    break;
                }
                if (insn.getOpcode() == 187) {
                    TypeInsnNode tInsn = (TypeInsnNode)insn;
                    if (!tInsn.desc.equals("net/minecraft/network/protocol/game/ClientboundRemoveEntitiesPacket")) continue;
                    hasNewRemoveEntitiesPacket = true;
                    break;
                }
                if (insn.getOpcode() == 181) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (fieldInsn.owner.equals("net/minecraft/world/entity/Entity") && fieldInsn.name.equals("f_146795_") && fieldInsn.desc.equals("Lnet/minecraft/world/entity/Entity$RemovalReason;")) {
                        hasRemovalReasonAssignment = true;
                        break;
                    }
                    if (fieldInsn.owner.equals("net/minecraft/world/entity/Entity") && fieldInsn.name.equals("canUpdate") && fieldInsn.desc.equals("Z")) {
                        hasCanUpdateAssignment = true;
                        break;
                    }
                    if (fieldInsn.owner.equals("net/minecraft/world/entity/Entity") && fieldInsn.name.equals("f_19853_") && fieldInsn.desc.equals("Lnet/minecraft/world/level/Level;")) {
                        hasEntityLevel = true;
                        break;
                    }
                    if (!fieldInsn.owner.equals("net/minecraft/world/entity/Entity") || !fieldInsn.name.equals("f_146801_") || !fieldInsn.desc.equals("Lnet/minecraft/world/level/entity/EntityInLevelCallback;")) continue;
                    hasEntityLevel = true;
                    break;
                }
                if (insn.getOpcode() != 185) continue;
                mInsn = (MethodInsnNode)insn;
                if (!mInsn.owner.equals("net/minecraft/world/level/entity/EntityInLevelCallback") || !mInsn.name.equals("m_142044_")) continue;
                hasCallbackMove = true;
                break;
            }
            boolean hasArgEntity = method.desc.contains("Lnet/minecraft/world/entity/Entity;");
            boolean hasArgLivingEntity = method.desc.contains("Lnet/minecraft/world/entity/LivingEntity;");
            boolean rtnBoolean = method.desc.endsWith(")Z");
            boolean rtnVoid = method.desc.endsWith(")V");
            if ((hasArgEntity || hasArgLivingEntity) && (rtnVoid || rtnBoolean)) {
                int entityIndex;
                if (!hasCallUnsafeGetPut && !hasNewRemoveEntitiesPacket && !hasRemovalReasonAssignment && !hasCanUpdateAssignment && !hasEntityLevel && !hasCallbackMove || (entityIndex = this.getEntityArgumentIndex(method)) < 0) continue;
                InsnList patch = new InsnList();
                patch.add((AbstractInsnNode)new VarInsnNode(25, entityIndex));
                patch.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false));
                patch.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false));
                patch.add((AbstractInsnNode)new LdcInsnNode((Object)"pig2mod"));
                patch.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", false));
                LabelNode labelContinue = new LabelNode();
                patch.add((AbstractInsnNode)new JumpInsnNode(153, labelContinue));
                if (rtnBoolean) {
                    patch.add((AbstractInsnNode)new InsnNode(3));
                    patch.add((AbstractInsnNode)new InsnNode(172));
                } else {
                    patch.add((AbstractInsnNode)new InsnNode(177));
                }
                patch.add((AbstractInsnNode)labelContinue);
                method.instructions.insert(patch);
                bChanged = true;
                continue;
            }
            if (!hasRemovalReasonAssignment || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private int getEntityArgumentIndex(MethodNode method) {
        int currentSlot = (method.access & 8) != 0 ? 0 : 1;
        for (Type type : Type.getArgumentTypes((String)method.desc)) {
            String d = type.getDescriptor();
            if (d.equals("Lnet/minecraft/world/entity/Entity;") || d.equals("Lnet/minecraft/world/entity/LivingEntity;")) {
                return currentSlot;
            }
            currentSlot += type.getSize();
        }
        return -1;
    }

    private boolean transform_crashMethod(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            boolean bFound = false;
            for (AbstractInsnNode insn : method.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (insn.getOpcode() != 184 || !methodInsn.owner.equals("net/minecraft/client/Minecraft") || !methodInsn.name.equals("m_91332_")) continue;
                bFound = true;
                break;
            }
            if (!bFound || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_mFlashfur(ClassNode classNode) {
        boolean bChanged = false;
        if (classNode.name.contains("MetapotentFlashfurRenderer")) {
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("render") || !method.desc.endsWith(";FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")) continue;
                LabelNode skipLabel = new LabelNode();
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "shouldRender", "(Lnet/minecraft/world/entity/Entity;)Z", false));
                insnList.add((AbstractInsnNode)new JumpInsnNode(154, skipLabel));
                insnList.add((AbstractInsnNode)new InsnNode(177));
                insnList.add((AbstractInsnNode)skipLabel);
                method.instructions.insert(insnList);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private boolean transform_BadThreads(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                MethodInsnNode methodInsn;
                if (insn instanceof MethodInsnNode) {
                    methodInsn = (MethodInsnNode)insn;
                    if (insn.getOpcode() == 182) {
                        if (methodInsn.name.equals("start") && methodInsn.desc.equals("()Ljava/lang/Process;")) {
                            method.instructions.insertBefore((AbstractInsnNode)methodInsn, (AbstractInsnNode)new InsnNode(87));
                            methodInsn.owner = "kakiku/pig2mod/MyXformData";
                            methodInsn.name = "start";
                            methodInsn.desc = "()Ljava/lang/Process;";
                            methodInsn.setOpcode(184);
                            bChanged = true;
                        } else if (methodInsn.owner.equals("java/lang/Thread") && methodInsn.name.equals("start") && methodInsn.desc.equals("()V")) {
                            method.instructions.set((AbstractInsnNode)methodInsn, (AbstractInsnNode)new InsnNode(87));
                            bChanged = true;
                        }
                    }
                }
                if (insn instanceof MethodInsnNode) {
                    methodInsn = (MethodInsnNode)insn;
                    if (insn.getOpcode() == 184 && methodInsn.owner.equals("java/util/concurrent/Executors") && methodInsn.name.equals("newScheduledThreadPool") && methodInsn.desc.endsWith(")Ljava/util/concurrent/ScheduledExecutorService;")) {
                        methodInsn.owner = "kakiku/pig2mod/MyXformData";
                        methodInsn.name = "newScheduledThreadPool";
                        bChanged = true;
                    }
                }
                if (!(insn instanceof MethodInsnNode)) continue;
                methodInsn = (MethodInsnNode)insn;
                if (insn.getOpcode() != 185 || !methodInsn.owner.equals("java/util/concurrent/ScheduledExecutorService") || !methodInsn.name.equals("scheduleAtFixedRate") || !methodInsn.desc.equals("(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;") || classNode.name.replace('/', '.').startsWith("com.mega.uom.")) continue;
                MethodInsnNode original = methodInsn;
                MethodInsnNode newInsn = new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "scheduleAtFixedRate", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;", false);
                method.instructions.set((AbstractInsnNode)original, (AbstractInsnNode)newInsn);
                bChanged = true;
            }
            if (!(classNode.superName.equals("java/lang/Thread") && method.name.equals("run") && method.desc.equals("()V") || classNode.interfaces.contains("java/lang/Runnable") && method.name.equals("run") && method.desc.equals("()V")) && (!classNode.interfaces.contains("java/util/concurrent/Callable") || !method.name.equals("call"))) continue;
            this.makeMethodEmpty(classNode, method);
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_level_Entity(ClassNode classNode) {
        boolean bChanged = false;
        if (this.isBadClassForLevel(classNode) || "net/minecraft/world/item/SwordItem".equals(classNode.superName) || "net/minecraft/world/item/TieredItem".equals(classNode.superName) || "net/minecraft/world/item/Item".equals(classNode.superName) && !classNode.name.toLowerCase().contains("egg") && !classNode.name.toLowerCase().contains("spawn")) {
            for (MethodNode method : classNode.methods) {
                int levelArgIndex;
                if (this.isBadMethodForLevel(classNode, method)) {
                    System.setProperty("Pig2.needMaxFight", "true");
                    if (this.makeMethodEmpty(classNode, method)) {
                        bChanged = true;
                        continue;
                    }
                }
                for (int i = 0; i < method.instructions.size(); ++i) {
                    MethodInsnNode staticCall;
                    AbstractInsnNode insn = method.instructions.get(i);
                    if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode) {
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (fieldInsn.name.equals("f_19853_") && fieldInsn.desc.equals("Lnet/minecraft/world/level/Level;")) {
                            staticCall = new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "level_Entity", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/level/Level;", false);
                            method.instructions.set((AbstractInsnNode)fieldInsn, (AbstractInsnNode)staticCall);
                            bChanged = true;
                        }
                    }
                    if (insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodInsn = (MethodInsnNode)insn;
                    if (methodInsn.name.equals("m_9236_") && methodInsn.desc.equals("()Lnet/minecraft/world/level/Level;")) {
                        staticCall = new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "level_Entity", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/level/Level;", false);
                        method.instructions.set((AbstractInsnNode)methodInsn, (AbstractInsnNode)staticCall);
                        bChanged = true;
                        continue;
                    }
                    if (!methodInsn.name.equals("m_284548_") || !methodInsn.desc.equals("()Lnet/minecraft/server/level/ServerLevel;")) continue;
                    staticCall = new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "serverLevel_ServerPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)Lnet/minecraft/server/level/ServerLevel;", false);
                    method.instructions.set((AbstractInsnNode)methodInsn, (AbstractInsnNode)staticCall);
                    bChanged = true;
                }
                String name = method.name;
                String desc = method.desc;
                if (!(name.equals("m_6883_") && desc.equals("(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V") || name.equals("m_7203_") && desc.equals("(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;") || name.equals("m_5551_") && desc.equals("(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V")) && (!name.equals("m_5929_") || !desc.equals("(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;I)V")) || (levelArgIndex = this.getLevelArgumentIndex(desc)) < 1) continue;
                InsnList insert = new InsnList();
                insert.add((AbstractInsnNode)new VarInsnNode(25, levelArgIndex));
                insert.add((AbstractInsnNode)new MethodInsnNode(184, "kakiku/pig2mod/MyXformData", "levelArg", "(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/level/Level;", false));
                insert.add((AbstractInsnNode)new VarInsnNode(58, levelArgIndex));
                method.instructions.insert(insert);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private int getLevelArgumentIndex(String desc) {
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        String levelDesc = "Lnet/minecraft/world/level/Level;";
        int index = 1;
        for (Type type : argTypes) {
            if (type.getDescriptor().equals(levelDesc)) {
                return index;
            }
            index += type.getSize();
        }
        return 0;
    }

    private boolean isBadClassForLevel(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!this.isBadMethodForLevel(classNode, method)) continue;
            return true;
        }
        return false;
    }

    private boolean isBadMethodForLevel(ClassNode classNode, MethodNode method) {
        if (method.name.toLowerCase().contains("addentity")) {
            return false;
        }
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode) {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (fieldInsn.name.equals("f_143244_") && fieldInsn.desc.equals("Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;")) {
                    return true;
                }
                if (fieldInsn.name.equals("f_171631_") && fieldInsn.desc.equals("Lnet/minecraft/world/level/entity/TransientEntitySectionManager;")) {
                    return true;
                }
            }
            if (insn.getOpcode() != 187 || !(insn instanceof TypeInsnNode)) continue;
            TypeInsnNode newInsn = (TypeInsnNode)insn;
            if (!"net/minecraft/server/level/ServerLevel".equals(newInsn.desc) && !"net/minecraft/client/multiplayer/ClientLevel".equals(newInsn.desc) && !"net/minecraft/world/level/Level".equals(newInsn.desc)) continue;
            return true;
        }
        return false;
    }

    private boolean transform_methodWithRunnableArg(ClassNode classNode) {
        boolean bChanged = false;
        for (MethodNode method : classNode.methods) {
            Type[] argTypes = Type.getArgumentTypes((String)method.desc);
            boolean hasRunnableArg = Arrays.stream(argTypes).anyMatch(t -> t.getSort() == 10 && t.getInternalName().equals("java/lang/Runnable"));
            if (!hasRunnableArg || classNode.superName.equals("net/minecraft/client/KeyMapping") || !this.makeMethodEmpty(classNode, method)) continue;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean transform_BadEventBus(ClassNode classNode) {
        boolean bChanged = false;
        if (classNode.superName.equals("net/minecraftforge/eventbus/EventBus") && !classNode.methods.isEmpty()) {
            for (MethodNode methodNode : classNode.methods) {
                String arg1Name;
                Type[] args;
                InsnList insnList;
                switch (methodNode.name + methodNode.desc) {
                    case "register(Ljava/lang/Object;)V": {
                        methodNode.instructions.clear();
                        methodNode.tryCatchBlocks.clear();
                        methodNode.localVariables = null;
                        insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraftforge/eventbus/EventBus", "register", "(Ljava/lang/Object;)V", false));
                        insnList.add((AbstractInsnNode)new InsnNode(177));
                        methodNode.instructions.add(insnList);
                        bChanged = true;
                        break;
                    }
                    case "unregister(Ljava/lang/Object;)V": {
                        methodNode.instructions.clear();
                        methodNode.tryCatchBlocks.clear();
                        methodNode.localVariables = null;
                        insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new InsnNode(177));
                        methodNode.instructions.add(insnList);
                        bChanged = true;
                        break;
                    }
                    case "post(Lnet/minecraftforge/eventbus/api/Event;Lnet/minecraftforge/eventbus/api/IEventBusInvokeDispatcher;)Z": {
                        methodNode.instructions.clear();
                        methodNode.tryCatchBlocks.clear();
                        methodNode.localVariables = null;
                        insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraftforge/eventbus/EventBus", "post", "(Lnet/minecraftforge/eventbus/api/Event;Lnet/minecraftforge/eventbus/api/IEventBusInvokeDispatcher;)Z", false));
                        insnList.add((AbstractInsnNode)new InsnNode(172));
                        methodNode.instructions.add(insnList);
                        bChanged = true;
                        break;
                    }
                    case "post(Lnet/minecraftforge/eventbus/api/Event;)Z": {
                        methodNode.instructions.clear();
                        methodNode.tryCatchBlocks.clear();
                        methodNode.localVariables = null;
                        insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraftforge/eventbus/EventBus", "post", "(Lnet/minecraftforge/eventbus/api/Event;)Z", false));
                        insnList.add((AbstractInsnNode)new InsnNode(172));
                        methodNode.instructions.add(insnList);
                        bChanged = true;
                    }
                }
                if (!Type.getReturnType((String)methodNode.desc).equals((Object)Type.VOID_TYPE) || (args = Type.getArgumentTypes((String)methodNode.desc)).length != 1 || !(arg1Name = args[0].getInternalName()).equals("net/minecraftforge/eventbus/api/Event") && !arg1Name.equals("net/minecraftforge/eventbus/api/GenericEvent")) continue;
                methodNode.instructions.clear();
                methodNode.tryCatchBlocks.clear();
                methodNode.localVariables = null;
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new InsnNode(177));
                methodNode.instructions.add(insnList);
                bChanged = true;
            }
        }
        return bChanged;
    }

    private boolean makeMethodEmpty(ClassNode classNode, MethodNode method) {
        if (!MyXformer2.getInstance().canMakeMethodEmpty(method)) {
            return false;
        }
        if (method.name.equals("queueServerWork") && method.desc.equals("(ILjava/lang/Runnable;)V")) {
            return false;
        }
        if (classNode.name.toLowerCase().contains("shader")) {
            return false;
        }
        MyXformer2.getInstance().makeMethodEmpty(classNode, method);
        return true;
    }

    public void makeMethodCallEmpty(MethodNode method, MethodInsnNode methodInsn) {
        MyXformer2.getInstance().makeMethodCallEmpty(method, methodInsn);
    }
}

