/*
 * Decompiled with CFR 0.152.
 */
package kakiku.pig2mod.xform;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kakiku.pig2mod.xform.MyKeisou;
import kakiku.pig2mod.xform.MyLib2;
import kakiku.pig2mod.xform.MyPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import sun.misc.Unsafe;

public class MyXformer2
implements ClassFileTransformer {
    private static MyXformer2 gInstance = null;
    private static Set<String> gDoNotResetThisClass = new HashSet<String>();

    public MyXformer2() {
        if (gInstance == null) {
            gInstance = this;
        }
    }

    public static MyXformer2 getInstance() {
        if (gInstance == null) {
            new MyXformer2();
        }
        return gInstance;
    }

    public static void doIt() {
        MyXformer2.doMethods();
    }

    private static void doMethods() {
        if (MyLib2.getKeisou() == null) {
            return;
        }
        if (gInstance == null) {
            new MyXformer2();
            MyLib2.getKeisou().addTransformer(gInstance, true);
        }
        ArrayList<Class<Object>> listOfTargetClass1st = new ArrayList<Class<Object>>();
        ArrayList<Class> listOfTargetClass2nd = new ArrayList<Class>();
        for (Class clazz1 : MyLib2.getKeisou().getAllLoadedClasses()) {
            if (clazz1.getName().startsWith("[") || !MyLib2.isThisOtherBadMOD(clazz1) && !MyLib2.isThisMyMOD(clazz1) && !MyXformer2.isThisNameTarget(clazz1.getName())) continue;
            if (clazz1.getInterfaces().length > 0 && clazz1.getInterfaces()[0].getName().contains("ClassFileTransformer") || MyXformer2.isThisNameTarget(clazz1.getName())) {
                listOfTargetClass1st.add(clazz1);
                continue;
            }
            listOfTargetClass2nd.add(clazz1);
        }
        listOfTargetClass1st.addAll(listOfTargetClass2nd);
        for (Class clazz : listOfTargetClass1st) {
            try {
                MyLib2.getKeisou().retransformClasses(clazz);
            }
            catch (Throwable throwable) {}
        }
    }

    private static boolean isThisNameTarget(String name) {
        if (name.startsWith("sun.instrument.TransformerManager")) {
            return true;
        }
        if (name.startsWith("net.minecraftforge.fml.loading.moddiscovery.ModValidator")) {
            return true;
        }
        if (name.startsWith("net.minecraftforge.coremod.api.ASMAPI")) {
            return true;
        }
        if (name.startsWith("net.minecraftforge.fml.loading.moddiscovery.ModFileParser")) {
            return true;
        }
        return name.startsWith("io.netty.util.internal.PlatformDependent0");
    }

    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return this.transform(className, classfileBuffer);
    }

    private byte[] transform(String className, byte[] classfileBuffer) {
        byte[] classfileBufferNodesBig;
        byte[] classfileBufferVisitBig;
        byte[] classfileBufferNodesSmall;
        byte[] classfileBufferVisitSmall;
        byte[] classFile;
        String classNamePeriod = className.replace('/', '.');
        if (!MyXformer2.isThisNameTarget(classNamePeriod)) {
            if (MyLib2.isThisNameWhiteListedMOD(classNamePeriod)) {
                return null;
            }
            if (MyLib2.isThisNameMinecraftVanilla(classNamePeriod)) {
                return null;
            }
            if (!MyLib2.getModClassNamesFromJar().contains(classNamePeriod) && className.contains("/__")) {
                return null;
            }
        }
        if (!gDoNotResetThisClass.contains(classNamePeriod) && (classFile = MyLib2.getModClassDataFromJar().get(classNamePeriod)) != null) {
            classfileBuffer = classFile;
            if (MyLib2.isThisNameMyMOD(classNamePeriod)) {
                return classFile;
            }
        }
        if ((classfileBufferVisitSmall = this.tranVisitSmall(className, classfileBuffer)) != null) {
            classfileBuffer = classfileBufferVisitSmall;
        }
        if ((classfileBufferNodesSmall = this.tranNodesSmall(className, classfileBuffer)) != null) {
            classfileBuffer = classfileBufferNodesSmall;
        }
        if ((classfileBufferVisitBig = this.tranVisitBig(className, classfileBuffer)) != null) {
            classfileBuffer = classfileBufferVisitBig;
        }
        if ((classfileBufferNodesBig = this.tranNodesBig(className, classfileBuffer)) != null) {
            classfileBuffer = classfileBufferNodesBig;
        }
        if (classfileBufferVisitSmall != null || classfileBufferNodesSmall != null || classfileBufferVisitBig != null || classfileBufferNodesBig != null) {
            return classfileBuffer;
        }
        return null;
    }

    private byte[] tranVisitSmall(final String className, byte[] classfileBuffer) {
        String classNamePeriod = className.replace('/', '.');
        int readerFlag = 0;
        int writerFlag = 1;
        final AtomicBoolean bChanged = new AtomicBoolean(false);
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(writerFlag);
            reader.accept(new ClassVisitor(589824, (ClassVisitor)writer){

                public MethodVisitor visitMethod(int access, final String name1, String descriptor1, String signature, String[] exceptions) {
                    if (signature == null) {
                        signature = "";
                    }
                    if (exceptions == null) {
                        exceptions = new String[]{};
                    }
                    MethodVisitor mv = super.visitMethod(access, name1, descriptor1, signature, exceptions);
                    return new MethodVisitor(589824, mv){

                        public void visitCode() {
                            super.visitCode();
                        }

                        public void visitMethodInsn(int opcode, String owner, String name2, String descriptor2, boolean isInterface) {
                            if (name2.toLowerCase().contains("inst") && (descriptor2.endsWith(")Ljava/lang/instrument/Instrumentation;") || descriptor2.endsWith(")Lsun/instrument/InstrumentationImpl;"))) {
                                bChanged.set(true);
                                super.visitMethodInsn(184, "kakiku/pig2mod/xform/MyXformer2", "myCreateInstrumentationImpl", "()Ljava/lang/instrument/Instrumentation;", false);
                            } else if (className.equals("net/minecraftforge/coremod/api/ASMAPI") && name1.equals("redirectFieldToMethod") && owner.equals("java/lang/reflect/Modifier") && name2.equals("isPrivate")) {
                                bChanged.set(true);
                                super.visitInsn(87);
                                super.visitInsn(4);
                            } else {
                                super.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
                            }
                        }

                        public void visitInsn(int opcode) {
                            super.visitInsn(opcode);
                        }
                    };
                }
            }, readerFlag);
            if (bChanged.get()) {
                if (gDoNotResetThisClass.contains(classNamePeriod)) {
                    // empty if block
                }
                return writer.toByteArray();
            }
        }
        catch (Throwable t) {
            if (bChanged.get()) {
                // empty if block
            }
        }
        return null;
    }

    private byte[] tranVisitBig(final String className, byte[] classfileBuffer) {
        String classNamePeriod = className.replace('/', '.');
        if (MyLib2.isThisNameOtherBadMOD(classNamePeriod)) {
            return null;
        }
        int readerFlag = 8;
        int writerFlag = 3;
        final AtomicBoolean bChanged = new AtomicBoolean(false);
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(writerFlag);
            reader.accept(new ClassVisitor(589824, (ClassVisitor)writer){

                public MethodVisitor visitMethod(int access, String name1, String descriptor, String signature, String[] exceptions) {
                    if (signature == null) {
                        signature = "";
                    }
                    if (exceptions == null) {
                        exceptions = new String[]{};
                    }
                    MethodVisitor mv = super.visitMethod(access, name1, descriptor, signature, exceptions);
                    if (name1.startsWith("getSnapshot") && descriptor.equals("()[Lsun/instrument/TransformerManager$TransformerInfo;")) {
                        bChanged.set(true);
                        return new MethodVisitor(589824, mv){

                            public void visitCode() {
                                super.visitCode();
                                Label loopStart = new Label();
                                Label loopCheck = new Label();
                                Label afterLoop = new Label();
                                Label skipRemove = new Label();
                                this.mv.visitInsn(1);
                                this.mv.visitVarInsn(58, 1);
                                this.mv.visitInsn(3);
                                this.mv.visitVarInsn(54, 2);
                                this.mv.visitLabel(loopCheck);
                                this.mv.visitVarInsn(21, 2);
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitFieldInsn(180, "sun/instrument/TransformerManager", "mTransformerList", "[Lsun/instrument/TransformerManager$TransformerInfo;");
                                this.mv.visitInsn(190);
                                this.mv.visitJumpInsn(162, afterLoop);
                                this.mv.visitLabel(loopStart);
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitFieldInsn(180, "sun/instrument/TransformerManager", "mTransformerList", "[Lsun/instrument/TransformerManager$TransformerInfo;");
                                this.mv.visitVarInsn(21, 2);
                                this.mv.visitInsn(50);
                                this.mv.visitMethodInsn(182, "sun/instrument/TransformerManager$TransformerInfo", "transformer", "()Ljava/lang/instrument/ClassFileTransformer;", false);
                                this.mv.visitVarInsn(58, 3);
                                this.mv.visitVarInsn(25, 3);
                                this.mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
                                this.mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
                                this.mv.visitVarInsn(58, 4);
                                this.mv.visitVarInsn(25, 4);
                                this.mv.visitLdcInsn((Object)"kakiku.");
                                this.mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
                                this.mv.visitJumpInsn(154, skipRemove);
                                this.mv.visitVarInsn(25, 4);
                                this.mv.visitLdcInsn((Object)"kakiku.");
                                this.mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
                                this.mv.visitJumpInsn(154, skipRemove);
                                this.mv.visitVarInsn(25, 3);
                                this.mv.visitVarInsn(58, 1);
                                this.mv.visitLabel(skipRemove);
                                this.mv.visitIincInsn(2, 1);
                                this.mv.visitJumpInsn(167, loopCheck);
                                this.mv.visitLabel(afterLoop);
                                this.mv.visitVarInsn(25, 1);
                                Label skipRemoveCall = new Label();
                                this.mv.visitJumpInsn(198, skipRemoveCall);
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitVarInsn(25, 1);
                                this.mv.visitMethodInsn(182, "sun/instrument/TransformerManager", "removeTransformer", "(Ljava/lang/instrument/ClassFileTransformer;)Z", false);
                                this.mv.visitInsn(87);
                                this.mv.visitLabel(skipRemoveCall);
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitFieldInsn(180, "sun/instrument/TransformerManager", "mTransformerList", "[Lsun/instrument/TransformerManager$TransformerInfo;");
                                this.mv.visitInsn(176);
                            }
                        };
                    }
                    if (className.startsWith("net/minecraftforge/fml/loading/moddiscovery/ModValidator") && name1.equals("stage1Validation") && descriptor.equals("()V")) {
                        bChanged.set(true);
                        if (MyLib2.hasJar("OptiFine")) {
                            // empty if block
                        }
                        return new MethodVisitor(589824, mv){

                            public void visitInsn(int opcode) {
                                if (opcode == 177) {
                                    Label start = new Label();
                                    Label check = new Label();
                                    Label end = new Label();
                                    this.mv.visitLabel(start);
                                    this.mv.visitVarInsn(25, 0);
                                    this.mv.visitFieldInsn(180, "net/minecraftforge/fml/loading/moddiscovery/ModValidator", "candidateMods", "Ljava/util/List;");
                                    this.mv.visitMethodInsn(185, "java/util/List", "iterator", "()Ljava/util/Iterator;", true);
                                    this.mv.visitVarInsn(58, 1);
                                    this.mv.visitLabel(check);
                                    this.mv.visitVarInsn(25, 1);
                                    this.mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
                                    this.mv.visitJumpInsn(153, end);
                                    this.mv.visitVarInsn(25, 1);
                                    this.mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
                                    this.mv.visitTypeInsn(192, "net/minecraftforge/forgespi/locating/IModFile");
                                    this.mv.visitVarInsn(58, 2);
                                    this.mv.visitVarInsn(25, 2);
                                    this.mv.visitMethodInsn(185, "net/minecraftforge/forgespi/locating/IModFile", "getFileName", "()Ljava/lang/String;", true);
                                    this.mv.visitLdcInsn((Object)"OptiFine");
                                    this.mv.visitMethodInsn(182, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", false);
                                    Label skipRemove = new Label();
                                    this.mv.visitJumpInsn(153, skipRemove);
                                    this.mv.visitVarInsn(25, 1);
                                    this.mv.visitMethodInsn(185, "java/util/Iterator", "remove", "()V", true);
                                    this.mv.visitLabel(skipRemove);
                                    this.mv.visitJumpInsn(167, check);
                                    this.mv.visitLabel(end);
                                }
                                this.mv.visitInsn(opcode);
                            }
                        };
                    }
                    if (className.startsWith("net/minecraftforge/fml/loading/moddiscovery/ModFileParser") && name1.equals("getCoreMods") && descriptor.equals("(Lnet/minecraftforge/fml/loading/moddiscovery/ModFile;)Ljava/util/List;")) {
                        bChanged.set(true);
                        return new MethodVisitor(589824, mv){

                            public void visitCode() {
                                this.mv.visitCode();
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitMethodInsn(182, "net/minecraftforge/fml/loading/moddiscovery/ModFile", "getFilePath", "()Ljava/nio/file/Path;", false);
                                this.mv.visitMethodInsn(185, "java/nio/file/Path", "toString", "()Ljava/lang/String;", true);
                                this.mv.visitLdcInsn((Object)"\\");
                                this.mv.visitLdcInsn((Object)"/");
                                this.mv.visitMethodInsn(182, "java/lang/String", "replace", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", false);
                                this.mv.visitVarInsn(58, 1);
                                this.mv.visitVarInsn(25, 1);
                                this.mv.visitLdcInsn((Object)"/net/minecraftforge/forge/");
                                this.mv.visitMethodInsn(182, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", false);
                                this.mv.visitVarInsn(25, 1);
                                this.mv.visitLdcInsn((Object)"forge-1.20.1-");
                                this.mv.visitMethodInsn(182, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", false);
                                this.mv.visitInsn(126);
                                this.mv.visitVarInsn(54, 2);
                                this.mv.visitVarInsn(25, 1);
                                this.mv.visitLdcInsn((Object)"/mods/pig2mod");
                                this.mv.visitMethodInsn(182, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", false);
                                this.mv.visitVarInsn(54, 3);
                                this.mv.visitVarInsn(21, 2);
                                this.mv.visitVarInsn(21, 3);
                                this.mv.visitInsn(128);
                                this.mv.visitVarInsn(54, 4);
                                Label continueLabel = new Label();
                                this.mv.visitVarInsn(21, 4);
                                this.mv.visitJumpInsn(154, continueLabel);
                                this.mv.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
                                this.mv.visitInsn(176);
                                this.mv.visitLabel(continueLabel);
                                this.mv.visitFrame(3, 0, null, 0, null);
                                super.visitCode();
                            }
                        };
                    }
                    return mv;
                }
            }, readerFlag);
            if (bChanged.get()) {
                return writer.toByteArray();
            }
        }
        catch (Throwable t) {
            if (bChanged.get()) {
                // empty if block
            }
        }
        return null;
    }

    private byte[] tranNodesSmall(String className, byte[] classfileBuffer) {
        boolean bChanged = false;
        try {
            ClassReader classReader = new ClassReader(classfileBuffer);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            bChanged |= this.tranNodes_addTransformer(classNode);
            bChanged |= this.tranNodes_retransformClasses(classNode);
            bChanged |= this.tranNodes_transform(classNode);
            bChanged |= this.tranNodes_transformClassReader(classNode);
            bChanged |= this.tranNodes_transformClassNode(classNode);
            bChanged |= this.tranNodes_transformJavassist(classNode);
            bChanged |= this.tranNodes_javaAgent(classNode);
            bChanged |= this.tranNodes_unsafeClassReplace(classNode);
            bChanged |= this.tranNodes_dllString(classNode);
            bChanged |= this.tranNodes_dllCall(classNode);
            bChanged |= this.tranNodes_nativeMethod(classNode);
            bChanged |= this.tranNodes_ifWin(classNode);
            bChanged |= this.tranNodes_methodHandle(classNode);
            bChanged |= this.tranNodes_badLoop(classNode);
            bChanged |= this.tranNodes_osCommand(classNode);
            bChanged |= this.tranNodes_vmAttach(classNode);
            if (bChanged |= this.tranNodes_fixVanilla(classNode)) {
                ClassWriter cw = new ClassWriter(1);
                classNode.accept((ClassVisitor)cw);
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            if (bChanged) {
                // empty if block
            }
        }
        return null;
    }

    private byte[] tranNodesBig(String className, byte[] classfileBuffer) {
        boolean bChanged = false;
        try {
            ClassReader classReader = new ClassReader(classfileBuffer);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 8);
            bChanged |= this.tranNodes_invalidKakure(classNode);
            if (bChanged |= this.tranNodes_dllLoad(classNode)) {
                ClassWriter cw = new ClassWriter(3);
                classNode.accept((ClassVisitor)cw);
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            if (bChanged) {
                // empty if block
            }
        }
        return null;
    }

    private boolean tranNodes_addTransformer(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (insn.getOpcode() != 185 && insn.getOpcode() != 182 || !methodInsn.name.equals("addTransformer") || !methodInsn.owner.equals("java/lang/instrument/Instrumentation") && !methodInsn.owner.equals("sun/instrument/InstrumentationImpl") || !methodInsn.desc.equals("(Ljava/lang/instrument/ClassFileTransformer;Z)V") && !methodInsn.desc.equals("(Ljava/lang/instrument/ClassFileTransformer;)V")) continue;
                        this.makeMethodCallEmpty(method, methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_retransformClasses(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (insn.getOpcode() != 185 && insn.getOpcode() != 182 || !methodInsn.name.equals("retransformClasses") || !methodInsn.owner.equals("java/lang/instrument/Instrumentation") && !methodInsn.owner.equals("sun/instrument/InstrumentationImpl") || !methodInsn.desc.equals("([Ljava/lang/Class;)V")) continue;
                        this.makeMethodCallEmpty(method, methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_transform(ClassNode classNode) {
        boolean bChanged;
        block4: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("transform") || !method.desc.endsWith(")[B") || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block4;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_transformClassReader(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean usingClassReader = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (insn instanceof MethodInsnNode) {
                            MethodInsnNode methodInsn = (MethodInsnNode)insn;
                            if (!methodInsn.owner.equals("org/objectweb/asm/ClassReader") && !methodInsn.owner.equals("org/objectweb/asm/ClassWriter")) continue;
                            usingClassReader = true;
                            break;
                        }
                        if (!(insn instanceof FieldInsnNode)) continue;
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (!fieldInsn.owner.equals("org/objectweb/asm/ClassReader") && !fieldInsn.owner.equals("org/objectweb/asm/ClassWriter")) continue;
                        usingClassReader = true;
                        break;
                    }
                    if (!usingClassReader || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_transformClassNode(ClassNode classNode) {
        boolean bChanged;
        block7: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean usingClassNode = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (insn instanceof MethodInsnNode) {
                            MethodInsnNode methodInsn = (MethodInsnNode)insn;
                            if (!methodInsn.owner.equals("org/objectweb/asm/tree/ClassNode") && !methodInsn.owner.equals("org/objectweb/asm/ClassVisitor") && !methodInsn.owner.equals("org/objectweb/asm/tree/MethodNode") && !methodInsn.owner.equals("org/objectweb/asm/MethodVisitor") && !methodInsn.owner.equals("org/objectweb/asm/tree/MethodInsnNode") && !methodInsn.owner.equals("org/objectweb/asm/tree/AbstractInsnNode") && !methodInsn.owner.equals("org/objectweb/asm/tree/FieldInsnNode")) continue;
                            usingClassNode = true;
                            break;
                        }
                        if (!(insn instanceof FieldInsnNode)) continue;
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (!fieldInsn.owner.equals("org/objectweb/asm/tree/ClassNode") && !fieldInsn.owner.equals("org/objectweb/asm/tree/MethodNode") && !fieldInsn.owner.equals("org/objectweb/asm/tree/MethodInsnNode") && !fieldInsn.owner.equals("org/objectweb/asm/tree/FieldInsnNode")) continue;
                        usingClassNode = true;
                        break;
                    }
                    if (classNode.name.startsWith("com/mega/uom/coremod/") && MyLib2.hasJar("fantasy_ending")) {
                        usingClassNode = false;
                    }
                    if (!usingClassNode || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block7;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_transformJavassist(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean usingJavassist = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (insn instanceof MethodInsnNode) {
                            MethodInsnNode methodInsn = (MethodInsnNode)insn;
                            if (!methodInsn.owner.contains("javassist/ClassPool") && !methodInsn.owner.contains("javassist/CtClass") && !methodInsn.owner.contains("javassist/CtMethod")) continue;
                            usingJavassist = true;
                            break;
                        }
                        if (!(insn instanceof FieldInsnNode)) continue;
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (!fieldInsn.owner.contains("javassist/ClassPool") && !fieldInsn.owner.contains("javassist/CtClass") && !fieldInsn.owner.contains("javassist/CtMethod")) continue;
                        usingJavassist = true;
                        break;
                    }
                    if (!usingJavassist || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    public static byte[] tranKakureClass(String classNamePeriod, byte[] classfileBuffer1) {
        String className = classNamePeriod.replace('.', '/');
        byte[] classfileBuffer2 = null;
        try {
            ClassReader classReader = new ClassReader(classfileBuffer1);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            boolean bChanged = new MyPlugin().processClass(classNode);
            if (bChanged) {
                ClassWriter cw = new ClassWriter(1);
                classNode.accept((ClassVisitor)cw);
                classfileBuffer2 = cw.toByteArray();
            }
        }
        catch (Throwable classReader) {
            // empty catch block
        }
        if (classfileBuffer2 == null) {
            classfileBuffer2 = classfileBuffer1;
        }
        byte[] classfileBuffer3 = null;
        classfileBuffer3 = new MyXformer2().transform(className, classfileBuffer2);
        if (classfileBuffer3 == null) {
            classfileBuffer3 = classfileBuffer2;
        }
        return classfileBuffer3;
    }

    private boolean tranNodes_javaAgent(ClassNode classNode) {
        boolean bChanged;
        block4: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("agentmain") && !method.name.equals("premain") || !this.canMakeMethodEmpty(method) || !method.desc.equals("(Ljava/lang/String;Ljava/lang/instrument/Instrumentation;)V")) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block4;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_unsafeClassReplace(ClassNode classNode) {
        boolean bChanged;
        block9: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean usingPutIntVolatile = false;
                    boolean usingGetIntVolatile = false;
                    boolean usingAllocateInstance = false;
                    boolean usingAddressSize = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        Long l;
                        if (insn instanceof MethodInsnNode) {
                            MethodInsnNode methodInsn = (MethodInsnNode)insn;
                            if (methodInsn.name.equals("putIntVolatile") || methodInsn.name.equals("putLongVolatile")) {
                                usingPutIntVolatile = true;
                            }
                            if (methodInsn.name.equals("getIntVolatile") || methodInsn.name.equals("getLongVolatile")) {
                                usingGetIntVolatile = true;
                            }
                            if (methodInsn.name.equals("allocateInstance")) {
                                usingAllocateInstance = true;
                            }
                            if (!methodInsn.name.equals("addressSize")) continue;
                            usingAddressSize = true;
                            continue;
                        }
                        if (!(insn instanceof LdcInsnNode)) continue;
                        LdcInsnNode ldc = (LdcInsnNode)insn;
                        Object object = ldc.cst;
                        if (!(object instanceof Long) || (l = (Long)object) != 8L) continue;
                        usingAddressSize = true;
                    }
                    if (!usingPutIntVolatile || !usingAllocateInstance && !usingGetIntVolatile || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block9;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_dllLoad(ClassNode classNode) {
        boolean bChanged;
        block21: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode mInsn = (MethodInsnNode)insn;
                        boolean isDllLoad = false;
                        boolean returnsInterface = false;
                        if (mInsn.getOpcode() == 184 && mInsn.owner.equals("java/lang/System") && (mInsn.name.equals("load") || mInsn.name.equals("loadLibrary"))) {
                            isDllLoad = true;
                        }
                        if (mInsn.getOpcode() == 182 && mInsn.owner.equals("java/lang/Runtime") && (mInsn.name.equals("load") || mInsn.name.equals("loadLibrary"))) {
                            isDllLoad = true;
                        }
                        if (mInsn.getOpcode() == 184 && mInsn.owner.equals("com/sun/jna/Native") && (mInsn.name.equals("load") || mInsn.name.equals("loadLibrary") || mInsn.name.equals("register"))) {
                            if (classNode.name.equals("net/madness/MadnessEntities$User32") && method.name.equals("<clinit>")) continue;
                            isDllLoad = true;
                            if (Type.getReturnType((String)mInsn.desc).getSort() == 10) {
                                returnsInterface = true;
                            }
                        }
                        if (!isDllLoad) continue;
                        InsnList insnList = new InsnList();
                        Type[] args = Type.getArgumentTypes((String)mInsn.desc);
                        for (int i = args.length - 1; i >= 0; --i) {
                            int sort = args[i].getSort();
                            if (sort == 7 || sort == 8) {
                                insnList.add((AbstractInsnNode)new InsnNode(88));
                                continue;
                            }
                            insnList.add((AbstractInsnNode)new InsnNode(87));
                        }
                        if (mInsn.getOpcode() != 184) {
                            insnList.add((AbstractInsnNode)new InsnNode(87));
                        }
                        if (returnsInterface && mInsn.owner.equals("com/sun/jna/Native")) {
                            TypeInsnNode typeInsnNode;
                            AbstractInsnNode next;
                            String ifaceInternalName = null;
                            boolean nextHasCheckcast = false;
                            for (next = insn.getNext(); next != null && (next.getType() == 8 || next.getType() == 15 || next.getType() == 14); next = next.getNext()) {
                            }
                            if (next instanceof TypeInsnNode && (typeInsnNode = (TypeInsnNode)next).getOpcode() == 192) {
                                ifaceInternalName = typeInsnNode.desc;
                                nextHasCheckcast = true;
                            }
                            if (ifaceInternalName == null) {
                                for (AbstractInsnNode prev = insn.getPrevious(); prev != null; prev = prev.getPrevious()) {
                                    Type type;
                                    if (!(prev instanceof LdcInsnNode)) continue;
                                    LdcInsnNode ldcInsnNode = (LdcInsnNode)prev;
                                    Object object = ldcInsnNode.cst;
                                    if (!(object instanceof Type) || (type = (Type)object).getSort() != 10 && type.getSort() != 9) continue;
                                    ifaceInternalName = type.getInternalName();
                                    break;
                                }
                            }
                            if (ifaceInternalName != null) {
                                insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)("L" + ifaceInternalName + ";"))));
                                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "kakiku/pig2mod/xform/MyXformer2", "getInterfaceStub", "(Ljava/lang/Class;)Ljava/lang/Object;", false));
                                if (!nextHasCheckcast) {
                                    insnList.add((AbstractInsnNode)new TypeInsnNode(192, ifaceInternalName));
                                }
                            } else {
                                insnList.add((AbstractInsnNode)new InsnNode(1));
                            }
                        } else {
                            this.insnListAdd0null(mInsn.desc, insnList);
                        }
                        method.instructions.insertBefore(insn, insnList);
                        method.instructions.remove(insn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block21;
                bChanged = false;
            }
        }
        return bChanged;
    }

    public static Object getInterfaceStub(Class<?> iface) {
        if (iface == null) {
            return null;
        }
        if (!iface.isInterface()) {
            return null;
        }
        try {
            return Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Class<?> ret = method.getReturnType();
                    if (ret == Void.TYPE) {
                        return null;
                    }
                    if (ret == Boolean.TYPE) {
                        return false;
                    }
                    if (ret == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (ret == Short.TYPE) {
                        return (short)0;
                    }
                    if (ret == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (ret == Integer.TYPE) {
                        return 0;
                    }
                    if (ret == Long.TYPE) {
                        return 0L;
                    }
                    if (ret == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (ret == Double.TYPE) {
                        return 0.0;
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean tranNodes_dllString(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        String string;
                        String lowerString;
                        if (!(insn instanceof LdcInsnNode)) continue;
                        LdcInsnNode ldc = (LdcInsnNode)insn;
                        Object object = ldc.cst;
                        if (!(object instanceof String) || !(lowerString = (string = (String)object).toLowerCase(Locale.ROOT)).endsWith(".dll")) continue;
                        String newString = string.replaceAll("(?i)\\.dll", ".d11");
                        ldc.cst = newString;
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_dllCall(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean canMakeEmpty = this.canMakeMethodEmpty(method);
                    boolean callingOSAPI = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        MethodInsnNode mInsn;
                        if (!(insn instanceof MethodInsnNode) || (mInsn = (MethodInsnNode)insn).getOpcode() != 185 && mInsn.getOpcode() != 182 || !mInsn.owner.startsWith("com/sun/jna/platform/")) continue;
                        callingOSAPI = true;
                        if (canMakeEmpty) break;
                    }
                    if (!callingOSAPI || !this.canMakeMethodEmpty(method)) continue;
                    this.makeMethodEmpty(classNode, method);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_nativeMethod(ClassNode classNode) {
        boolean bChanged;
        block13: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    if ((method.access & 0x100) == 0) continue;
                    method.access &= 0xFFFFFEFF;
                    method.instructions.clear();
                    method.tryCatchBlocks.clear();
                    method.localVariables = null;
                    InsnList insnList = new InsnList();
                    Type returnType = Type.getReturnType((String)method.desc);
                    switch (returnType.getSort()) {
                        case 0: {
                            insnList.add((AbstractInsnNode)new InsnNode(177));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            insnList.add((AbstractInsnNode)new InsnNode(3));
                            insnList.add((AbstractInsnNode)new InsnNode(172));
                            break;
                        }
                        case 7: {
                            insnList.add((AbstractInsnNode)new InsnNode(9));
                            insnList.add((AbstractInsnNode)new InsnNode(173));
                            break;
                        }
                        case 6: {
                            insnList.add((AbstractInsnNode)new InsnNode(11));
                            insnList.add((AbstractInsnNode)new InsnNode(174));
                            break;
                        }
                        case 8: {
                            insnList.add((AbstractInsnNode)new InsnNode(14));
                            insnList.add((AbstractInsnNode)new InsnNode(175));
                            break;
                        }
                        case 9: {
                            insnList.add((AbstractInsnNode)new InsnNode(1));
                            insnList.add((AbstractInsnNode)new InsnNode(176));
                            break;
                        }
                        case 10: {
                            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)("L" + returnType.getInternalName() + ";"))));
                            insnList.add((AbstractInsnNode)new MethodInsnNode(184, "kakiku/pig2mod/xform/MyXformer2", "getInterfaceStub", "(Ljava/lang/Class;)Ljava/lang/Object;", false));
                            insnList.add((AbstractInsnNode)new InsnNode(176));
                        }
                    }
                    method.instructions.insert(insnList);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block13;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_ifWin(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        AbstractInsnNode abstractInsnNode;
                        MethodInsnNode mInsn;
                        if (!(insn instanceof MethodInsnNode) || (mInsn = (MethodInsnNode)insn).getOpcode() != 184 || !"java/lang/System".equals(mInsn.owner) || !"getProperty".equals(mInsn.name) || !"(Ljava/lang/String;)Ljava/lang/String;".equals(mInsn.desc) && !"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;".equals(mInsn.desc) || !((abstractInsnNode = mInsn.getPrevious()) instanceof LdcInsnNode)) continue;
                        LdcInsnNode ldc = (LdcInsnNode)abstractInsnNode;
                        if (!"os.name".equals(ldc.cst)) continue;
                        boolean twoArgs = "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;".equals(mInsn.desc);
                        InsnList insnList = new InsnList();
                        if (twoArgs) {
                            insnList.add((AbstractInsnNode)new InsnNode(87));
                        }
                        insnList.add((AbstractInsnNode)new InsnNode(87));
                        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)""));
                        method.instructions.insert((AbstractInsnNode)mInsn, insnList);
                        method.instructions.remove((AbstractInsnNode)mInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_methodHandle(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        boolean hasArgThread;
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if ((!methodInsn.owner.equals("java/lang/invoke/MethodHandle") || !methodInsn.name.equals("invoke")) && (!methodInsn.owner.equals("java/lang/invoke/VarHandle") || !methodInsn.name.equals("set")) || !(hasArgThread = methodInsn.desc.contains("Ljava/lang/Thread;"))) continue;
                        this.makeMethodCallEmpty(method, methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_badLoop(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions) {
                        JumpInsnNode jump;
                        AbstractInsnNode next;
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (!methodInsn.owner.equals("net/minecraft/client/Minecraft") || !methodInsn.name.equals("m_91396_") || !methodInsn.desc.equals("()Z") || !((next = methodInsn.getNext()) instanceof JumpInsnNode) || (jump = (JumpInsnNode)next).getOpcode() != 153 && jump.getOpcode() != 154 || !this.hasBackJumpTo(methodInsn, jump)) continue;
                        AbstractInsnNode prev = methodInsn.getPrevious();
                        if (prev != null && (prev.getOpcode() == 25 || prev.getOpcode() == 178 || prev.getOpcode() == 184)) {
                            method.instructions.remove(prev);
                        }
                        InsnList insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new InsnNode(3));
                        method.instructions.insert((AbstractInsnNode)methodInsn, insnList);
                        method.instructions.remove((AbstractInsnNode)methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean hasBackJumpTo(MethodInsnNode condCall, JumpInsnNode condJump) {
        LabelNode startLabel = null;
        for (AbstractInsnNode cur = condCall.getPrevious(); cur != null; cur = cur.getPrevious()) {
            if (!(cur instanceof LabelNode)) continue;
            startLabel = (LabelNode)cur;
            break;
        }
        if (startLabel == null) {
            return false;
        }
        for (AbstractInsnNode scan = condCall.getNext(); scan != null && scan != condJump.label; scan = scan.getNext()) {
            JumpInsnNode j;
            if (!(scan instanceof JumpInsnNode) || (j = (JumpInsnNode)scan).getOpcode() != 167 || j.label != startLabel) continue;
            return true;
        }
        return false;
    }

    private boolean tranNodes_osCommand(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                block2: for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (!(methodInsn.owner.equals("java/lang/Runtime") && methodInsn.name.equals("exec") || methodInsn.owner.equals("java/lang/ProcessBuilder") && methodInsn.name.equals("start") || methodInsn.owner.equals("java/awt/Desktop") && (methodInsn.name.equals("open") || methodInsn.name.equals("browse")) || methodInsn.owner.endsWith("/ProcessImpl")) && !methodInsn.owner.endsWith("/Win32Process")) continue;
                        if (this.canMakeMethodEmpty(method)) {
                            this.makeMethodEmpty(classNode, method);
                            bChanged = true;
                            continue block2;
                        }
                        this.makeMethodCallEmpty(method, methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_vmAttach(ClassNode classNode) {
        boolean bChanged;
        block6: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                block2: for (MethodNode method : classNode.methods) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (!methodInsn.owner.equals("com/sun/tools/attach/VirtualMachine") || !methodInsn.name.equals("attach")) continue;
                        if (this.canMakeMethodEmpty(method)) {
                            this.makeMethodEmpty(classNode, method);
                            bChanged = true;
                            continue block2;
                        }
                        this.makeMethodCallEmpty(method, methodInsn);
                        bChanged = true;
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block6;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_invalidKakure(ClassNode classNode) {
        boolean bChanged;
        block11: {
            bChanged = false;
            try {
                if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
                    return false;
                }
                for (MethodNode method : classNode.methods) {
                    boolean usingClassLoader_defineClass0 = false;
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (!(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode mInsn = (MethodInsnNode)insn;
                        if (insn.getOpcode() != 182 || !mInsn.name.equals("invoke") || !mInsn.owner.equals("java/lang/invoke/MethodHandle") || !mInsn.desc.startsWith("(Ljava/lang/ClassLoader;Ljava/lang/Class;Ljava/lang/String;[BIILjava/security/ProtectionDomain;ZI") || !mInsn.desc.endsWith(")Ljava/lang/Object;")) continue;
                        usingClassLoader_defineClass0 = true;
                        break;
                    }
                    if (!usingClassLoader_defineClass0) continue;
                    int indexBytesBytes = -1;
                    int indexStringName = -1;
                    int indexBooleanInitialize = -1;
                    int indexClassLoaderLoader = -1;
                    int indexProtectedDomain = -1;
                    Type[] argTypes = Type.getArgumentTypes((String)method.desc);
                    for (int i = 0; i < argTypes.length; ++i) {
                        String cn = argTypes[i].getClassName();
                        if ("java.lang.String".equals(cn)) {
                            indexStringName = i;
                            continue;
                        }
                        if (argTypes[i].getSort() == 1) {
                            indexBooleanInitialize = i;
                            continue;
                        }
                        if ("java.lang.ClassLoader".equals(cn)) {
                            indexClassLoaderLoader = i;
                            continue;
                        }
                        if ("java.security.ProtectionDomain".equals(cn)) {
                            indexProtectedDomain = i;
                            continue;
                        }
                        if (argTypes[i].getSort() != 9 || argTypes[i].getElementType().getSort() != 3) continue;
                        indexBytesBytes = i;
                    }
                    if (indexBytesBytes == -1 || indexStringName == -1 || indexBooleanInitialize == -1 || indexClassLoaderLoader == -1 || indexProtectedDomain == -1) continue;
                    if ((method.access & 8) == 0) {
                        ++indexBytesBytes;
                        ++indexStringName;
                        ++indexBooleanInitialize;
                        ++indexClassLoaderLoader;
                        ++indexProtectedDomain;
                    }
                    InsnList insnList = new InsnList();
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, indexBytesBytes));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, indexStringName));
                    insnList.add((AbstractInsnNode)new VarInsnNode(21, indexBooleanInitialize));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, indexClassLoaderLoader));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, indexProtectedDomain));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, "kakiku/pig2mod/xform/MyXformer2", "myDefineKakureClass", "([BLjava/lang/String;ZLjava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;", false));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/invoke/MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/invoke/MethodHandles", "privateLookupIn", "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandles$Lookup;)Ljava/lang/invoke/MethodHandles$Lookup;", false));
                    insnList.add((AbstractInsnNode)new InsnNode(176));
                    method.instructions.insert(insnList);
                    bChanged = true;
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block11;
                bChanged = false;
            }
        }
        return bChanged;
    }

    public static Class<?> myDefineKakureClass(byte[] bytes, String name, boolean initialize, ClassLoader loader, ProtectionDomain pd) {
        try {
            Field fieldJdkUnsafe = Unsafe.class.getDeclaredField("theInternalUnsafe");
            fieldJdkUnsafe.setAccessible(true);
            Object jdkUnsafe = fieldJdkUnsafe.get(null);
            Method defineClass = jdkUnsafe.getClass().getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            Class cls = (Class)defineClass.invoke(jdkUnsafe, name, bytes, 0, bytes.length, loader, pd);
            return cls;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean tranNodes_fixVanilla(ClassNode classNode) {
        boolean bChanged;
        block5: {
            bChanged = false;
            try {
                if (classNode.name.equals("io/netty/util/internal/PlatformDependent0")) {
                    for (MethodNode method : classNode.methods) {
                        if (!method.name.equals("<clinit>")) continue;
                        for (AbstractInsnNode insn : method.instructions.toArray()) {
                            if (!(insn instanceof MethodInsnNode)) continue;
                            MethodInsnNode mInsn = (MethodInsnNode)insn;
                            if (!mInsn.owner.equals("io/netty/util/internal/logging/InternalLogger") || !mInsn.name.equals("debug") || !mInsn.desc.equals("(Ljava/lang/String;Ljava/lang/Throwable;)V")) continue;
                            method.instructions.insertBefore((AbstractInsnNode)mInsn, (AbstractInsnNode)new InsnNode(87));
                            mInsn.desc = "(Ljava/lang/String;)V";
                            bChanged = true;
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!bChanged) break block5;
                bChanged = false;
            }
        }
        return bChanged;
    }

    private boolean tranNodes_tempXXXX(ClassNode classNode) {
        if (!MyLib2.isThisNameOtherBadMOD(classNode.name.replace('/', '.'))) {
            return false;
        }
        boolean bChanged = false;
        return bChanged;
    }

    public static Instrumentation myCreateInstrumentationImpl() {
        return MyKeisou.gInstance;
    }

    public static void doNotResetThisClass(String className) {
        if (MyLib2.isCalledFromOtherModWithin1()) {
            return;
        }
        gDoNotResetThisClass.add(className);
    }

    public boolean canMakeMethodEmpty(MethodNode method) {
        return (method.access & 0x500) == 0 && !method.name.equals("<init>") && !method.name.equals("<clinit>");
    }

    public void makeMethodEmpty(ClassNode classNode, MethodNode method) {
        boolean shouldInsertSuperCall = this.shouldInsertSuperCall(classNode, method);
        method.instructions.clear();
        method.tryCatchBlocks.clear();
        method.localVariables = null;
        InsnList insnList = new InsnList();
        Type returnType = Type.getReturnType((String)method.desc);
        if (shouldInsertSuperCall) {
            this.insnListAddSuperCall(classNode, method, insnList);
        } else {
            this.insnListAdd0null(method.desc, insnList);
        }
        insnList.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
        method.instructions.insert(insnList);
    }

    private boolean shouldInsertSuperCall(ClassNode classNode, MethodNode method) {
        if (!MyLib2.isThisNameMinecraftVanilla(classNode.superName.replace('/', '.'))) {
            return false;
        }
        for (AbstractInsnNode insn : method.instructions) {
            MethodInsnNode mInsn;
            if (!(insn instanceof MethodInsnNode) || (mInsn = (MethodInsnNode)insn).getOpcode() != 183 || !mInsn.owner.equals(classNode.superName) || !mInsn.name.equals(method.name) || !mInsn.desc.equals(method.desc)) continue;
            return true;
        }
        return false;
    }

    private void insnListAddSuperCall(ClassNode classNode, MethodNode method, InsnList insnList) {
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int index = 1;
        for (Type arg : Type.getArgumentTypes((String)method.desc)) {
            insnList.add((AbstractInsnNode)new VarInsnNode(arg.getOpcode(21), index));
            index += arg.getSize();
        }
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, classNode.superName, method.name, method.desc, false));
    }

    private void insnListAdd0null(String desc, InsnList insnList) {
        Type returnType = Type.getReturnType((String)desc);
        switch (returnType.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                insnList.add((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 7: {
                insnList.add((AbstractInsnNode)new InsnNode(9));
                break;
            }
            case 6: {
                insnList.add((AbstractInsnNode)new InsnNode(11));
                break;
            }
            case 8: {
                insnList.add((AbstractInsnNode)new InsnNode(14));
                break;
            }
            case 9: 
            case 10: {
                insnList.add((AbstractInsnNode)new InsnNode(1));
            }
        }
    }

    public void makeMethodCallEmpty(MethodNode method, MethodInsnNode methodInsn) {
        if (methodInsn.name.equals("<init>") || methodInsn.name.equals("<clinit>")) {
            return;
        }
        InsnList insnList = new InsnList();
        Type[] args = Type.getArgumentTypes((String)methodInsn.desc);
        for (int i = args.length - 1; i >= 0; --i) {
            int sort = args[i].getSort();
            if (sort == 7 || sort == 8) {
                insnList.add((AbstractInsnNode)new InsnNode(88));
                continue;
            }
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        if (methodInsn.getOpcode() != 184) {
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        this.insnListAdd0null(methodInsn.desc, insnList);
        method.instructions.insertBefore((AbstractInsnNode)methodInsn, insnList);
        method.instructions.remove((AbstractInsnNode)methodInsn);
    }

    private void insertDebugLog(ClassNode classNode, MethodNode method) {
    }
}

