/*
 * Decompiled with CFR 0.152.
 */
package energon.srpdeepseadanger.entity.monster.deterrent.nexus;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.EntityBiomass;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import energon.srpdeepseadanger.client.particle.DSDEnumParticle;
import energon.srpdeepseadanger.client.particle.DSDParticles;
import energon.srpdeepseadanger.util.DSDUtilities;
import energon.srpextra.entity.IEData;
import energon.srpextra.entity.ISRPExtraEntity;
import energon.srpextra.entity.IWaterParasite;
import energon.srpextra.entity.deterrent.INexus;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVeruBase
extends EntityPStationaryArchitect
implements IWaterParasite,
ISRPExtraEntity,
INexus,
IEData {
    public int waterR = 0;
    private static final DataParameter<Boolean> AGGRESSIVE = EntityDataManager.func_187226_a(EntityVeruBase.class, (DataSerializer)DataSerializers.field_187198_h);
    public float animationOpen = 0.0f;
    public int summonCD = 5;
    public boolean ignore = true;
    public int up = 0;

    public EntityVeruBase(World worldIn) {
        super(worldIn);
        this.getData().initEntity_PRE((EntityParasiteBase)this);
    }

    public int getParasiteIDRegister() {
        return this.getData().parasiteId;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.canChangeVariant) {
                EntityParasiteBase pre = this.getPreVersion();
                if (pre != null) {
                    ParasiteEventEntity.spawnNext((EntityParasiteBase)this, (EntityParasiteBase)pre, (boolean)true, (boolean)false);
                }
            } else {
                super.func_70645_a(source);
                if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    this.spawnDeathLoot();
                }
            }
        }
    }

    @Nullable
    public EntityParasiteBase getPreVersion() {
        return this.getData().getPreVersion((Entity)this);
    }

    @Nullable
    public EntityParasiteBase getNextVersion() {
        return this.getData().getNextVersion((Entity)this);
    }

    public float getBombDamage() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public int water() {
        return this.waterR;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGGRESSIVE, (Object)false);
    }

    public void setAGGRESSIVE(boolean v) {
        this.field_70180_af.func_187227_b(AGGRESSIVE, (Object)v);
    }

    public boolean getAGGRESSIVE() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRESSIVE);
    }

    public abstract void checkGrow();

    public abstract float getGrowChance();

    public float getWaterUpAnimationProgress() {
        return (float)this.waterR * 0.01f;
    }

    public float getUP() {
        return (float)this.up * 0.02f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 111) {
            this.up = 50;
            return;
        }
        super.func_70103_a(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnVeruParticle() {
        if (this.field_70146_Z.nextFloat() < this.animationOpen - 0.2f) {
            DSDParticles.spawnParticle(this.field_70170_p, DSDEnumParticle.VERU, this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * (0.3f + this.animationOpen * 0.5f)), this.field_70163_u + 1.0 + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.3f), this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * (0.3f + this.animationOpen * 0.5f)));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.up != 0) {
                this.up = Math.max(this.up - 1, 0);
            }
            if (this.getAGGRESSIVE()) {
                if (this.animationOpen != 1.0f) {
                    this.animationOpen = Math.min(this.animationOpen + 0.015f, 1.0f);
                }
                this.spawnVeruParticle();
            } else if (this.animationOpen != 0.0f) {
                this.animationOpen = Math.max(this.animationOpen - 0.02f, 0.0f);
            }
            if (this.func_70090_H()) {
                if (this.waterR != 100) {
                    this.waterR = Math.min(this.waterR + 3, 100);
                }
            } else if (this.waterR != 0) {
                this.waterR = Math.max(this.waterR - 1, 0);
            }
        } else if (this.func_70089_S()) {
            if (this.func_70090_H()) {
                if (this.waterR < 100) {
                    this.waterR = 100;
                }
                if (this.field_70173_aa % 20 == 15) {
                    this.checkGrow();
                }
                if (this.getAGGRESSIVE()) {
                    if (this.animationOpen != 1.5f) {
                        this.animationOpen = Math.min(this.animationOpen + 0.015f, 1.5f);
                    } else if (this.summonCD == 0) {
                        this.util();
                    }
                } else if (this.animationOpen != 0.0f) {
                    this.animationOpen = Math.max(this.animationOpen - 0.02f, 0.0f);
                }
            } else {
                --this.waterR;
                if (this.waterR == -30) {
                    this.waterR = 0;
                    this.func_70097_a(DamageSource.field_76369_e, 3.0f);
                    this.cutRes("drown", 5);
                }
            }
        }
    }

    public abstract void util();

    public void cutRes(String damage, int v) {
        for (int i = 0; i < this.getResistanceS().size(); ++i) {
            if (!((String)this.getResistanceS().get(i)).equals(damage)) continue;
            this.getResistanceI().set(i, Math.max((Integer)this.getResistanceI().get(i) - v, 1));
        }
    }

    public abstract String[] getMinions();

    public boolean skillSummon() {
        boolean flag = false;
        this.checkID();
        int freeCell = this.IDable();
        int limitPoint = this.getTotalParasites() - this.getActualParasites();
        for (int tryLimit = 0; tryLimit < this.totalP; ++tryLimit) {
            for (String element : this.getMinions()) {
                if (freeCell > 0) {
                    int pointC;
                    String[] parts = element.split(";");
                    if (parts.length != 3 || limitPoint < (pointC = Integer.parseInt(parts[2])) || !(this.field_70146_Z.nextFloat() < Float.parseFloat(parts[1]))) continue;
                    --freeCell;
                    limitPoint -= pointC;
                    EntityBiomass biomass = new EntityBiomass(this.field_70170_p, (EntityParasiteBase)this, (float)this.stage, this.func_70638_az(), true);
                    biomass.func_70012_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    double dx = this.field_70165_t + (double)this.field_70170_p.field_73012_v.nextFloat();
                    double dy = this.field_70163_u + (double)this.func_70047_e() + (double)this.field_70170_p.field_73012_v.nextFloat();
                    double dz = this.field_70161_v + (double)this.field_70170_p.field_73012_v.nextFloat();
                    double vx = dx - this.field_70165_t;
                    double vy = dy - this.field_70163_u;
                    double vz = dz - this.field_70161_v;
                    double distance = MathHelper.func_76133_a((double)(vx * vx + vy * vy + vz * vz));
                    vx /= distance;
                    vy /= distance;
                    vz /= distance;
                    double velocityFactor = 0.5 / (distance / 4.0 + 0.1);
                    velocityFactor *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat()) + 1.7;
                    double multiplier = 4.0;
                    if (this.stage == 3) {
                        multiplier = 5.0;
                    }
                    biomass.setMotion(vx *= velocityFactor * multiplier, vy *= velocityFactor * 1.5, vz *= velocityFactor * multiplier, 0.6, 1.0);
                    biomass.setSkin(Math.max(this.stage - 1, 1));
                    biomass.setFuse(80);
                    biomass.setParasite(parts[0], pointC);
                    this.field_70170_p.func_72838_d((Entity)biomass);
                    flag = true;
                    continue;
                }
                return flag;
            }
        }
        return flag;
    }

    public boolean buried() {
        return false;
    }

    protected void retreat(boolean dead) {
    }

    public double getRSChance(byte in) {
        if (this.ignore) {
            return 0.05;
        }
        return DSDUtilities.getRSChance(in);
    }

    public void func_191986_a(float x, float y, float z) {
        super.func_191986_a(x * 0.01f, y < 0.0f ? y : y * 0.1f, z * 0.01f);
    }

    public void func_70624_b(@Nullable EntityLivingBase p_setAttackTarget_1_) {
        if (this.func_70090_H() && !(p_setAttackTarget_1_ instanceof EntityParasiteBase)) {
            super.func_70624_b(p_setAttackTarget_1_);
        } else {
            super.func_70624_b(null);
        }
    }

    @Nullable
    public EntityLivingBase func_70638_az() {
        return this.func_70090_H() ? super.func_70638_az() : null;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SRPSounds.MOBSILENCE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        return SRPSounds.MOBSILENCE;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.MOBSILENCE;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185913_b();
    }

    protected void func_70665_d(DamageSource source, float v) {
        super.func_70665_d(source, this.animationOpen == 0.0f ? v : v * 2.5f);
    }

    protected void spawnGore() {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnMobsInside();
        }
    }

    public void spawnDeathLoot() {
        this.getData().spawnDeathLoot((EntityLivingBase)this);
    }

    public void spawnMobsInside() {
        this.getData().spawnMobInside((EntityLivingBase)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.getData().addBaseAttributes((EntityLivingBase)this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.getData().initEntity_AI((EntityParasiteBase)this);
    }
}

