/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;
import vernando.blueprints.Main;
import vernando.blueprints.MathUtils;
import vernando.blueprints.TransformUtils;
import vernando.blueprints.Util;

public class Blueprint {
    private class_1043 texture;
    public class_2960 textureId;
    private String texturePath;
    private String id;
    private float scaleX;
    private float scaleY;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float alpha;
    private float aspectRatio;
    public int order;
    private String configFile;
    private boolean visibility;
    private Util.GifAnimation gifAnimation;
    private boolean isAnimated;
    private int currentFrame;
    private long lastFrameTime;
    private List<class_1043> frameTextures;
    private List<class_2960> frameTextureIds;

    public Blueprint(String filename) {
        this.texturePath = filename;
        this.configFile = this.texturePath + ".json";
        this.id = Long.toString(System.currentTimeMillis());
        this.LoadConfig();
        this.frameTextures = new ArrayList<class_1043>();
        this.frameTextureIds = new ArrayList<class_2960>();
        this.currentFrame = 0;
        this.lastFrameTime = System.currentTimeMillis();
        if (Util.IsGifFile(this.texturePath)) {
            this.loadGifTextures();
        } else {
            this.loadStaticTexture();
        }
        this.SaveConfig();
    }

    private void loadStaticTexture() {
        this.textureId = class_2960.method_60655((String)"blueprints", (String)this.id);
        this.texture = Util.RegisterTexture(this.texturePath, this.textureId);
        if (this.texture != null) {
            this.aspectRatio = (float)this.texture.method_4525().method_4307() / (float)this.texture.method_4525().method_4323();
        }
        this.isAnimated = false;
    }

    private void loadGifTextures() {
        this.gifAnimation = Util.LoadGif(this.texturePath);
        this.isAnimated = this.gifAnimation.isAnimated;
        if (this.gifAnimation.frames.isEmpty()) {
            Main.LOGGER.error("No frames loaded from GIF: " + this.texturePath);
            return;
        }
        class_310 client = class_310.method_1551();
        int[] index = new int[]{0};
        this.gifAnimation.frames.forEach(frame -> {
            class_2960 frameId = class_2960.method_60655((String)"blueprints", (String)(this.id + "_frame_" + index[0]));
            class_1043 frameTexture = new class_1043(() -> this.texturePath + " frame " + index[0], frame.image);
            client.method_1531().method_4616(frameId, (class_1044)frameTexture);
            this.frameTextures.add(frameTexture);
            this.frameTextureIds.add(frameId);
            index[0] = index[0] + 1;
        });
        if (!this.frameTextures.isEmpty()) {
            this.texture = this.frameTextures.get(0);
            this.textureId = this.frameTextureIds.get(0);
            this.aspectRatio = (float)this.texture.method_4525().method_4307() / (float)this.texture.method_4525().method_4323();
        }
        Main.LOGGER.info("Loaded animated GIF with " + this.gifAnimation.frames.size() + " frames: " + this.texturePath);
    }

    private void updateAnimation() {
        if (!this.isAnimated || this.gifAnimation == null || this.gifAnimation.frames.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Util.GifFrame currentGifFrame = this.gifAnimation.frames.get(this.currentFrame);
        if (currentTime - this.lastFrameTime >= (long)currentGifFrame.delayMs) {
            this.currentFrame = (this.currentFrame + 1) % this.gifAnimation.frames.size();
            this.lastFrameTime = currentTime;
            if (this.currentFrame < this.frameTextures.size() && this.currentFrame < this.frameTextureIds.size()) {
                this.texture = this.frameTextures.get(this.currentFrame);
                this.textureId = this.frameTextureIds.get(this.currentFrame);
            }
        }
    }

    private void LoadConfig() {
        class_310 client = class_310.method_1551();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.positionX = (float)client.field_1724.method_23317();
        this.positionY = (float)client.field_1724.method_23318();
        this.positionZ = (float)client.field_1724.method_23321();
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
        this.rotationZ = 0.0f;
        this.order = -1;
        this.alpha = 1.0f;
        this.visibility = true;
        try {
            File file = new File(this.configFile);
            if (file.exists()) {
                Main.LOGGER.info("Loading config: " + this.configFile);
                Gson gson = new Gson();
                JsonReader reader = new JsonReader((Reader)new FileReader(this.configFile));
                JsonObject obj = (JsonObject)gson.fromJson(reader, JsonObject.class);
                if (obj != null && obj.has("scaleX")) {
                    this.scaleX = obj.get("scaleX").getAsFloat();
                }
                if (obj != null && obj.has("scaleY")) {
                    this.scaleY = obj.get("scaleY").getAsFloat();
                }
                if (obj != null && obj.has("positionX")) {
                    this.positionX = obj.get("positionX").getAsFloat();
                }
                if (obj != null && obj.has("positionY")) {
                    this.positionY = obj.get("positionY").getAsFloat();
                }
                if (obj != null && obj.has("positionZ")) {
                    this.positionZ = obj.get("positionZ").getAsFloat();
                }
                if (obj != null && obj.has("rotationX")) {
                    this.rotationX = obj.get("rotationX").getAsFloat();
                }
                if (obj != null && obj.has("rotationY")) {
                    this.rotationY = obj.get("rotationY").getAsFloat();
                }
                if (obj != null && obj.has("rotationZ")) {
                    this.rotationZ = obj.get("rotationZ").getAsFloat();
                }
                if (obj != null && obj.has("alpha")) {
                    this.alpha = obj.get("alpha").getAsFloat();
                }
                if (obj != null && obj.has("visibility")) {
                    this.visibility = obj.get("visibility").getAsBoolean();
                }
            } else {
                Main.LOGGER.info("Config file not found: " + this.configFile);
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to load config: " + this.configFile);
            Main.LOGGER.error(e.getMessage());
        }
    }

    public void SaveConfig() {
        try {
            Main.LOGGER.info("Saving config: " + this.configFile);
            JsonObject obj = new JsonObject();
            obj.addProperty("scaleX", (Number)Float.valueOf(this.scaleX));
            obj.addProperty("scaleY", (Number)Float.valueOf(this.scaleY));
            obj.addProperty("positionX", (Number)Float.valueOf(this.positionX));
            obj.addProperty("positionY", (Number)Float.valueOf(this.positionY));
            obj.addProperty("positionZ", (Number)Float.valueOf(this.positionZ));
            obj.addProperty("rotationX", (Number)Float.valueOf(this.rotationX));
            obj.addProperty("rotationY", (Number)Float.valueOf(this.rotationY));
            obj.addProperty("rotationZ", (Number)Float.valueOf(this.rotationZ));
            obj.addProperty("alpha", (Number)Float.valueOf(this.alpha));
            obj.addProperty("visibility", Boolean.valueOf(this.visibility));
            String json = obj.toString();
            Files.write(Paths.get(this.configFile, new String[0]), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to save config: " + this.configFile);
            Main.LOGGER.error(e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_4587 matrices, class_4184 camera, Boolean renderThroughBlocks, Boolean renderBothSides) {
        if (this.texture == null || !this.visibility) {
            return;
        }
        class_1921 renderLayer = class_1921.method_23588((class_2960)this.textureId);
        this.updateAnimation();
        class_243 targetPosition = new class_243((double)this.positionX, (double)this.positionY, (double)this.positionZ);
        class_243 transformedPosition = targetPosition.method_1020(camera.method_19326());
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22903();
        matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrixStack.method_22904(transformedPosition.field_1352, transformedPosition.field_1351, transformedPosition.field_1350);
        matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(this.rotationX));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(this.rotationY));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(this.rotationZ));
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        boolean wasBlendEnabled = GL11.glIsEnabled((int)3042);
        boolean wasDepthTestEnabled = GL11.glIsEnabled((int)2929);
        boolean wasCullFaceEnabled = GL11.glIsEnabled((int)2884);
        int[] currentBlendSrc = new int[1];
        int[] currentBlendDst = new int[1];
        GL11.glGetIntegerv((int)3041, (int[])currentBlendSrc);
        GL11.glGetIntegerv((int)3040, (int[])currentBlendDst);
        int[] currentDepthFunc = new int[1];
        GL11.glGetIntegerv((int)2932, (int[])currentDepthFunc);
        try {
            if (!wasBlendEnabled) {
                GL11.glEnable((int)3042);
            }
            GL11.glBlendFunc((int)770, (int)771);
            if (renderThroughBlocks.booleanValue()) {
                if (wasDepthTestEnabled) {
                    GL11.glDisable((int)2929);
                }
            } else if (!wasDepthTestEnabled) {
                GL11.glEnable((int)2929);
            }
            if (renderBothSides.booleanValue()) {
                if (wasCullFaceEnabled) {
                    GL11.glDisable((int)2884);
                }
            } else if (!wasCullFaceEnabled) {
                GL11.glEnable((int)2884);
            }
            class_4597.class_4598 bufferBuilder = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = bufferBuilder.method_73477(renderLayer);
            int lightmapUV = 0xF000F0;
            int overlayUV = 0;
            float normalX = 0.0f;
            float normalY = 0.0f;
            float normalZ = 1.0f;
            vertexConsumer.method_22918(positionMatrix, -this.scaleX, -this.scaleY / this.aspectRatio, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_22913(0.0f, 1.0f).method_22922(overlayUV).method_60803(lightmapUV).method_22914(normalX, normalY, normalZ);
            vertexConsumer.method_22918(positionMatrix, this.scaleX, -this.scaleY / this.aspectRatio, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_22913(1.0f, 1.0f).method_22922(overlayUV).method_60803(lightmapUV).method_22914(normalX, normalY, normalZ);
            vertexConsumer.method_22918(positionMatrix, this.scaleX, this.scaleY / this.aspectRatio, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_22913(1.0f, 0.0f).method_22922(overlayUV).method_60803(lightmapUV).method_22914(normalX, normalY, normalZ);
            vertexConsumer.method_22918(positionMatrix, -this.scaleX, this.scaleY / this.aspectRatio, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_22913(0.0f, 0.0f).method_22922(overlayUV).method_60803(lightmapUV).method_22914(normalX, normalY, normalZ);
            bufferBuilder.method_37104();
        }
        finally {
            matrixStack.method_22909();
            if (wasCullFaceEnabled && !GL11.glIsEnabled((int)2884)) {
                GL11.glEnable((int)2884);
            } else if (!wasCullFaceEnabled && GL11.glIsEnabled((int)2884)) {
                GL11.glDisable((int)2884);
            }
            if (wasDepthTestEnabled && !GL11.glIsEnabled((int)2929)) {
                GL11.glEnable((int)2929);
            } else if (!wasDepthTestEnabled && GL11.glIsEnabled((int)2929)) {
                GL11.glDisable((int)2929);
            }
            GL11.glDepthFunc((int)currentDepthFunc[0]);
            if (wasBlendEnabled && !GL11.glIsEnabled((int)3042)) {
                GL11.glEnable((int)3042);
            } else if (!wasBlendEnabled && GL11.glIsEnabled((int)3042)) {
                GL11.glDisable((int)3042);
            }
            GL11.glBlendFunc((int)currentBlendSrc[0], (int)currentBlendDst[0]);
        }
    }

    public void renderThumbnail(class_332 drawContext, int x, int y, int width, int height, boolean includeFrame) {
        if (this.texture == null) {
            Main.LOGGER.error("\"" + this.texturePath + "\" is not a valid image file.");
            return;
        }
        if (includeFrame) {
            drawContext.method_25290(class_10799.field_56883, class_2960.method_60655((String)"blueprints", (String)"item_frame.png"), x, y, 0.0f, 0.0f, width, height, width, height);
        }
        x = (int)((float)x + (0.14285715f * (float)width + 1.0f));
        y = (int)((float)y + (0.16666667f * (float)height + 1.0f));
        width = (int)((float)width * 0.71428573f);
        height = (int)((float)height * 0.6666667f);
        drawContext.method_25290(class_10799.field_56883, this.textureId, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public void NudgeRotation(class_2350.class_2351 axis, float amount, boolean multiply, boolean finetune) {
        TransformUtils.Rotation current = new TransformUtils.Rotation(this.rotationX, this.rotationY, this.rotationZ);
        TransformUtils.Rotation newRotation = TransformUtils.nudgeRotation3D(current, axis, amount, multiply, finetune);
        this.rotationX = newRotation.x;
        this.rotationY = newRotation.y;
        this.rotationZ = newRotation.z;
    }

    public void NudgePosition(Util.Direction direction, float amount, boolean multiply, boolean finetune) {
        TransformUtils.Position current = new TransformUtils.Position(this.positionX, this.positionY, this.positionZ);
        TransformUtils.Position newPosition = TransformUtils.nudgePosition3D(current, direction, amount, multiply, finetune);
        this.positionX = newPosition.x;
        this.positionY = newPosition.y;
        this.positionZ = newPosition.z;
    }

    public void NudgeAlpha(float amount, boolean multiply, boolean finetune) {
        this.alpha = TransformUtils.nudgeAlpha(this.alpha, amount, multiply, finetune);
    }

    public void SetPosition(float x, float y, float z) {
        this.positionX = x;
        this.positionY = y;
        this.positionZ = z;
    }

    public void NudgeScale(class_2350.class_2351 axis, float amount, boolean multiply, boolean finetune) {
        TransformUtils.Scale current = new TransformUtils.Scale(this.scaleX, this.scaleY);
        TransformUtils.Scale newScale = TransformUtils.nudgeScale2D(current, axis, amount, multiply, finetune);
        this.scaleX = newScale.x;
        this.scaleY = newScale.y;
    }

    public String getName() {
        return MathUtils.getFilenameFromPath(this.texturePath);
    }

    public void ToggleVisibility() {
        this.visibility = !this.visibility;
    }

    public boolean isVisible() {
        return this.visibility;
    }

    public void ResetRotation() {
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
        this.rotationZ = 0.0f;
    }

    public void ResetScale() {
        this.scaleX = 1.0f;
        this.scaleY = this.scaleX / this.aspectRatio;
    }

    public void setVisible(boolean b) {
        this.visibility = b;
    }

    public String getFilename() {
        return this.texturePath;
    }

    public Float getPosX() {
        return Float.valueOf(this.positionX);
    }

    public Float getPosY() {
        return Float.valueOf(this.positionY);
    }

    public Float getPosZ() {
        return Float.valueOf(this.positionZ);
    }

    public Float getRotationX() {
        return Float.valueOf(this.rotationX);
    }

    public Float getRotationY() {
        return Float.valueOf(this.rotationY);
    }

    public Float getRotationZ() {
        return Float.valueOf(this.rotationZ);
    }

    public Float getScaleX() {
        return Float.valueOf(this.scaleX);
    }

    public Float getScaleY() {
        return Float.valueOf(this.scaleY);
    }

    public Float getAlpha() {
        return Float.valueOf(this.alpha);
    }

    public String getVisibility() {
        return Boolean.toString(this.visibility);
    }

    public void setVisibility(boolean b) {
        this.visibility = b;
    }

    public void setPosX(float f) {
        this.positionX = f;
    }

    public void setPosY(float f) {
        this.positionY = f;
    }

    public void setPosZ(float f) {
        this.positionZ = f;
    }

    public void setRotationX(float f) {
        this.rotationX = f;
    }

    public void setRotationY(float f) {
        this.rotationY = f;
    }

    public void setRotationZ(float f) {
        this.rotationZ = f;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public void setVisibility(String string) {
        this.visibility = Boolean.parseBoolean(string);
    }

    public double getDistanceFromCamera(class_4184 camera) {
        class_243 cameraPos = camera.method_19326();
        class_243 blueprintPos = new class_243((double)this.positionX, (double)this.positionY, (double)this.positionZ);
        return cameraPos.method_1022(blueprintPos);
    }

    public class_1043 getTexture() {
        return this.texture;
    }

    public int getTextureWidth() {
        return this.texture != null ? this.texture.method_4525().method_4307() : 0;
    }

    public int getTextureHeight() {
        return this.texture != null ? this.texture.method_4525().method_4323() : 0;
    }
}

