/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;
import vernando.blueprints.Blueprint;

@Environment(value=EnvType.CLIENT)
public class BlueprintCalibrationScreen
extends class_437 {
    private Blueprint blueprint;
    private class_437 parent;
    private Float point1X = null;
    private Float point1Y = null;
    private Float point2X = null;
    private Float point2Y = null;
    private Integer draggingPoint = null;
    private boolean wasMousePressed = false;
    private boolean wasMiddleMousePressed = false;
    private int lastPanMouseX = 0;
    private int lastPanMouseY = 0;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private class_342 distanceField;
    private static final int POINT_RADIUS = 8;
    private static final int CROSSHAIR_SIZE = 4;
    private static final float MIN_ZOOM = 0.1f;
    private static final float MAX_ZOOM = 10.0f;
    private static final float ZOOM_SPEED = 0.1f;

    protected BlueprintCalibrationScreen(Blueprint blueprint, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)("Calibrate: " + blueprint.getName())));
        this.blueprint = blueprint;
        this.parent = parent;
    }

    protected void method_25426() {
        int buttonWidth = 80;
        int buttonHeight = 20;
        int padding = 5;
        int fieldWidth = Math.min(120, this.field_22789 / 4);
        int fieldX = this.field_22789 / 2 - fieldWidth / 2;
        this.distanceField = new class_342(this.field_22793, fieldX, this.field_22790 - 35, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Distance in blocks"));
        this.distanceField.method_47404((class_2561)class_2561.method_43470((String)"Enter blocks"));
        this.distanceField.method_1880(10);
        this.distanceField.method_1852("1.0");
        this.method_37063((class_364)this.distanceField);
        int totalButtonWidth = buttonWidth * 3 + padding * 2;
        int availableWidth = this.field_22789 - (fieldWidth + 20);
        if (this.field_22789 > 600) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
                this.point1X = null;
                this.point1Y = null;
                this.point2X = null;
                this.point2Y = null;
                this.draggingPoint = null;
                this.zoom = 1.0f;
                this.panX = 0.0f;
                this.panY = 0.0f;
            }).method_46434(padding, this.field_22790 - 35, buttonWidth, buttonHeight).method_46431());
            int cancelX = fieldX + fieldWidth + 10;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.method_25419()).method_46434(cancelX, this.field_22790 - 35, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply"), b -> this.applyCalibration()).method_46434(this.field_22789 - buttonWidth - padding, this.field_22790 - 35, buttonWidth, buttonHeight).method_46431());
        } else {
            int smallButtonWidth = (this.field_22789 - padding * 4) / 3;
            int row1Y = this.field_22790 - 60;
            int row2Y = this.field_22790 - 35;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
                this.point1X = null;
                this.point1Y = null;
                this.point2X = null;
                this.point2Y = null;
                this.draggingPoint = null;
                this.zoom = 1.0f;
                this.panX = 0.0f;
                this.panY = 0.0f;
            }).method_46434(padding, row1Y, smallButtonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.method_25419()).method_46434(padding + smallButtonWidth + padding, row1Y, smallButtonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply"), b -> this.applyCalibration()).method_46434(padding + 2 * (smallButtonWidth + padding), row1Y, smallButtonWidth, buttonHeight).method_46431());
            this.distanceField.method_48229(fieldX, row2Y);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.handleMouseInput(mouseX, mouseY);
        int imageDisplayWidth = this.field_22789;
        int imageDisplayHeight = this.field_22790 - 60;
        int textureWidth = this.blueprint.getTextureWidth();
        int textureHeight = this.blueprint.getTextureHeight();
        if (textureWidth == 0 || textureHeight == 0) {
            textureWidth = 100;
            textureHeight = 100;
        }
        float scale = Math.min((float)imageDisplayWidth / (float)textureWidth, (float)imageDisplayHeight / (float)textureHeight) * this.zoom;
        int scaledWidth = (int)((float)textureWidth * scale);
        int scaledHeight = (int)((float)textureHeight * scale);
        int imageX = (this.field_22789 - scaledWidth) / 2 + (int)this.panX;
        int imageY = (imageDisplayHeight - scaledHeight) / 2 + (int)this.panY;
        if (this.blueprint.textureId != null) {
            context.method_25290(class_10799.field_56883, this.blueprint.textureId, imageX, imageY, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
        }
        Integer screenPoint1X = null;
        Integer screenPoint1Y = null;
        Integer screenPoint2X = null;
        Integer screenPoint2Y = null;
        if (this.point1X != null && this.point1Y != null) {
            screenPoint1X = imageX + (int)(this.point1X.floatValue() * (float)scaledWidth);
            screenPoint1Y = imageY + (int)(this.point1Y.floatValue() * (float)scaledHeight);
            this.drawCalibrationPoint(context, screenPoint1X, screenPoint1Y, 1);
        }
        if (this.point2X != null && this.point2Y != null) {
            screenPoint2X = imageX + (int)(this.point2X.floatValue() * (float)scaledWidth);
            screenPoint2Y = imageY + (int)(this.point2Y.floatValue() * (float)scaledHeight);
            this.drawCalibrationPoint(context, screenPoint2X, screenPoint2Y, 2);
        }
        if (screenPoint1X != null && screenPoint1Y != null && screenPoint2X != null && screenPoint2Y != null) {
            this.drawCalibrationLine(context, screenPoint1X, screenPoint1Y, screenPoint2X, screenPoint2Y);
            double pixelDistance = Math.sqrt(Math.pow(screenPoint2X - screenPoint1X, 2.0) + Math.pow(screenPoint2Y - screenPoint1Y, 2.0));
            String distanceText = String.format("Distance: %.1f pixels", pixelDistance);
            context.method_25303(this.field_22793, distanceText, 10, 30, 0xFFFFFF);
        }
        int instructionY = 10;
        context.method_25303(this.field_22793, "Instructions:", 10, instructionY, -256);
        context.method_25303(this.field_22793, "1. Scroll to zoom, middle-click and drag to pan", 10, instructionY += 12, -5592406);
        context.method_25303(this.field_22793, "2. Click two points on the image with a known distance", 10, instructionY += 10, -5592406);
        context.method_25303(this.field_22793, "3. Enter the distance in blocks and click Apply", 10, instructionY += 10, -5592406);
        String stepInstructions = this.point1X == null ? "Click to place first point" : (this.point2X == null ? "Click to place second point" : "Drag points to adjust, or enter distance and click Apply");
        context.method_25303(this.field_22793, stepInstructions, 10, this.field_22790 - 55, -1);
        if (this.field_22789 > 400) {
            String distanceLabel = "Distance (blocks):";
            int labelX = this.distanceField.method_46426() - this.field_22793.method_1727(distanceLabel) - 5;
            int labelY = this.distanceField.method_46427() + 4;
            if (labelX > 10) {
                context.method_25303(this.field_22793, distanceLabel, labelX, labelY, 0xFFFFFF);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void handleMouseInput(int mouseX, int mouseY) {
        float relY;
        float relX;
        class_310 client = class_310.method_1551();
        long windowHandle = client.method_22683().method_4490();
        boolean isMousePressed = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        boolean isMiddleMousePressed = GLFW.glfwGetMouseButton((long)windowHandle, (int)2) == 1;
        int imageDisplayWidth = this.field_22789;
        int imageDisplayHeight = this.field_22790 - 60;
        int textureWidth = this.blueprint.getTextureWidth();
        int textureHeight = this.blueprint.getTextureHeight();
        if (textureWidth == 0 || textureHeight == 0) {
            textureWidth = 100;
            textureHeight = 100;
        }
        float scale = Math.min((float)imageDisplayWidth / (float)textureWidth, (float)imageDisplayHeight / (float)textureHeight) * this.zoom;
        int scaledWidth = (int)((float)textureWidth * scale);
        int scaledHeight = (int)((float)textureHeight * scale);
        int imageX = (this.field_22789 - scaledWidth) / 2 + (int)this.panX;
        int imageY = (imageDisplayHeight - scaledHeight) / 2 + (int)this.panY;
        if (isMiddleMousePressed) {
            if (this.wasMiddleMousePressed) {
                int deltaX = mouseX - this.lastPanMouseX;
                int deltaY = mouseY - this.lastPanMouseY;
                this.panX += (float)deltaX;
                this.panY += (float)deltaY;
            }
            this.lastPanMouseX = mouseX;
            this.lastPanMouseY = mouseY;
        }
        Integer screenPoint1X = null;
        Integer screenPoint1Y = null;
        Integer screenPoint2X = null;
        Integer screenPoint2Y = null;
        if (this.point1X != null && this.point1Y != null) {
            screenPoint1X = imageX + (int)(this.point1X.floatValue() * (float)scaledWidth);
            screenPoint1Y = imageY + (int)(this.point1Y.floatValue() * (float)scaledHeight);
        }
        if (this.point2X != null && this.point2Y != null) {
            screenPoint2X = imageX + (int)(this.point2X.floatValue() * (float)scaledWidth);
            screenPoint2Y = imageY + (int)(this.point2Y.floatValue() * (float)scaledHeight);
        }
        if (isMousePressed && !this.wasMousePressed && mouseY < this.field_22790 - 60) {
            if (screenPoint1X != null && screenPoint1Y != null && this.isNearPoint(mouseX, mouseY, screenPoint1X, screenPoint1Y)) {
                this.draggingPoint = 1;
            } else if (screenPoint2X != null && screenPoint2Y != null && this.isNearPoint(mouseX, mouseY, screenPoint2X, screenPoint2Y)) {
                this.draggingPoint = 2;
            } else if (mouseX >= imageX && mouseX <= imageX + scaledWidth && mouseY >= imageY && mouseY <= imageY + scaledHeight) {
                relX = (float)(mouseX - imageX) / (float)scaledWidth;
                relY = (float)(mouseY - imageY) / (float)scaledHeight;
                if (this.point1X == null) {
                    this.point1X = Float.valueOf(relX);
                    this.point1Y = Float.valueOf(relY);
                } else if (this.point2X == null) {
                    this.point2X = Float.valueOf(relX);
                    this.point2Y = Float.valueOf(relY);
                }
            }
        }
        if (isMousePressed && this.draggingPoint != null && mouseY < this.field_22790 - 60 && mouseX >= imageX && mouseX <= imageX + scaledWidth && mouseY >= imageY && mouseY <= imageY + scaledHeight) {
            relX = (float)(mouseX - imageX) / (float)scaledWidth;
            relY = (float)(mouseY - imageY) / (float)scaledHeight;
            if (this.draggingPoint == 1) {
                this.point1X = Float.valueOf(relX);
                this.point1Y = Float.valueOf(relY);
            } else if (this.draggingPoint == 2) {
                this.point2X = Float.valueOf(relX);
                this.point2Y = Float.valueOf(relY);
            }
        }
        if (!isMousePressed && this.wasMousePressed) {
            this.draggingPoint = null;
        }
        this.wasMousePressed = isMousePressed;
        this.wasMiddleMousePressed = isMiddleMousePressed;
    }

    private void drawCalibrationPoint(class_332 context, int x, int y, int pointNumber) {
        this.drawCircleOutline(context, x, y, 8, 2, -16777216);
        this.drawCircleOutline(context, x, y, 7, 1, -1);
        int gapSize = 3;
        context.method_25294(x - 8 - 4, y - 1, x - gapSize, y, -16777216);
        context.method_25294(x - 8 - 4, y, x - gapSize, y + 1, -1);
        context.method_25294(x + gapSize, y - 1, x + 8 + 4, y, -16777216);
        context.method_25294(x + gapSize, y, x + 8 + 4, y + 1, -1);
        context.method_25294(x - 1, y - 8 - 4, x, y - gapSize, -16777216);
        context.method_25294(x, y - 8 - 4, x + 1, y - gapSize, -1);
        context.method_25294(x - 1, y + gapSize, x, y + 8 + 4, -16777216);
        context.method_25294(x, y + gapSize, x + 1, y + 8 + 4, -1);
        String label = String.valueOf(pointNumber);
        int labelWidth = this.field_22793.method_1727(label);
        Objects.requireNonNull(this.field_22793);
        int labelY = y - 8 - 4 - 9 - 2;
        context.method_25303(this.field_22793, label, x - labelWidth / 2, labelY, 0xFFFFFF);
    }

    private void drawCircleOutline(class_332 context, int cx, int cy, int radius, int thickness, int color) {
        int t;
        for (int dx = -radius; dx <= radius; ++dx) {
            int dy = (int)Math.sqrt(radius * radius - dx * dx);
            for (t = 0; t < thickness; ++t) {
                context.method_25294(cx + dx, cy - dy - t, cx + dx + 1, cy - dy - t + 1, color);
            }
            for (t = 0; t < thickness; ++t) {
                context.method_25294(cx + dx, cy + dy + t, cx + dx + 1, cy + dy + t + 1, color);
            }
        }
        for (int dy = -radius; dy <= radius; ++dy) {
            int dx = (int)Math.sqrt(radius * radius - dy * dy);
            for (t = 0; t < thickness; ++t) {
                context.method_25294(cx - dx - t, cy + dy, cx - dx - t + 1, cy + dy + 1, color);
            }
            for (t = 0; t < thickness; ++t) {
                context.method_25294(cx + dx + t, cy + dy, cx + dx + t + 1, cy + dy + 1, color);
            }
        }
    }

    private void drawCalibrationLine(class_332 context, int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length > 0.0) {
            int endY;
            int newDy;
            double angle = Math.atan2(dy, dx);
            int lineMargin = 10;
            int startX = x1 + (int)(Math.cos(angle) * (double)lineMargin);
            int startY = y1 + (int)(Math.sin(angle) * (double)lineMargin);
            int endX = x2 - (int)(Math.cos(angle) * (double)lineMargin);
            int newDx = endX - startX;
            double newLength = Math.sqrt(newDx * newDx + (newDy = (endY = y2 - (int)(Math.sin(angle) * (double)lineMargin)) - startY) * newDy);
            if (newLength > 0.0) {
                int py;
                int px;
                int i;
                int segments = Math.max(10, (int)newLength);
                for (i = 0; i <= segments; ++i) {
                    px = startX + newDx * i / segments;
                    py = startY + newDy * i / segments;
                    context.method_25294(px - 2, py - 2, px + 2, py + 2, -16777216);
                }
                for (i = 0; i <= segments; ++i) {
                    px = startX + newDx * i / segments;
                    py = startY + newDy * i / segments;
                    context.method_25294(px - 1, py - 1, px + 1, py + 1, -1);
                }
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseY < (double)(this.field_22790 - 60)) {
            float oldZoom = this.zoom;
            this.zoom += (float)verticalAmount * 0.1f;
            this.zoom = class_3532.method_15363((float)this.zoom, (float)0.1f, (float)10.0f);
            float zoomFactor = this.zoom / oldZoom;
            float mouseXRelative = (float)mouseX - (float)(this.field_22789 / 2) - this.panX;
            float mouseYRelative = (float)mouseY - (float)((this.field_22790 - 60) / 2) - this.panY;
            this.panX = (float)mouseX - (float)(this.field_22789 / 2) - mouseXRelative * zoomFactor;
            this.panY = (float)mouseY - (float)((this.field_22790 - 60) / 2) - mouseYRelative * zoomFactor;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private boolean isNearPoint(int x, int y, int px, int py) {
        int dx = x - px;
        int dy = y - py;
        return dx * dx + dy * dy <= 169;
    }

    private void applyCalibration() {
        if (this.point1X == null || this.point1Y == null || this.point2X == null || this.point2Y == null) {
            return;
        }
        String distanceText = this.distanceField.method_1882();
        if (distanceText == null || distanceText.trim().isEmpty()) {
            return;
        }
        try {
            float blockDistance = Float.parseFloat(distanceText.trim());
            if (blockDistance <= 0.0f) {
                return;
            }
            int textureWidth = this.blueprint.getTextureWidth();
            int textureHeight = this.blueprint.getTextureHeight();
            if (textureWidth == 0 || textureHeight == 0) {
                return;
            }
            double relativeDistance = Math.sqrt(Math.pow(this.point2X.floatValue() - this.point1X.floatValue(), 2.0) + Math.pow(this.point2Y.floatValue() - this.point1Y.floatValue(), 2.0));
            if (relativeDistance == 0.0) {
                return;
            }
            double dx = (this.point2X.floatValue() - this.point1X.floatValue()) * (float)textureWidth;
            double dy = (this.point2Y.floatValue() - this.point1Y.floatValue()) * (float)textureHeight;
            double texturePixelDistance = Math.sqrt(dx * dx + dy * dy);
            float blocksPerTexturePixel = (float)((double)blockDistance / texturePixelDistance);
            float newScaleX = blocksPerTexturePixel * (float)textureWidth / 2.0f;
            float newScaleY = blocksPerTexturePixel * (float)textureHeight / 2.0f;
            this.blueprint.setScaleX(newScaleX);
            this.blueprint.setScaleY(newScaleY);
            this.blueprint.SaveConfig();
            this.method_25419();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

