/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import vernando.blueprints.Main;
import vernando.blueprints.Util;

public class Settings {
    private static boolean renderThroughBlocks = false;
    private static int imagesPerRow = 5;

    public static void LoadSettings() {
        String configPath = Util.GetConfigPath();
        try {
            File file = new File(configPath + "/blueprints.json");
            if (file.exists()) {
                Gson gson = new Gson();
                FileReader reader = new FileReader(file);
                JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (obj != null && obj.has("renderThroughBlocks")) {
                    renderThroughBlocks = obj.get("renderThroughBlocks").getAsBoolean();
                }
                if (obj != null && obj.has("imagesPerRow")) {
                    imagesPerRow = obj.get("imagesPerRow").getAsInt();
                }
            } else {
                renderThroughBlocks = false;
                Settings.SaveSettings();
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to load config");
            Main.LOGGER.error(e.getMessage());
            return;
        }
    }

    public static void SaveSettings() {
        String configPath = Util.GetConfigPath();
        JsonObject obj = new JsonObject();
        obj.addProperty("renderThroughBlocks", Boolean.valueOf(renderThroughBlocks));
        obj.addProperty("imagesPerRow", (Number)imagesPerRow);
        String json = obj.toString();
        try {
            Files.write(Paths.get(configPath + "/blueprints.json", new String[0]), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to save config");
            Main.LOGGER.error(e.getMessage());
            return;
        }
    }

    public static boolean getRenderThroughBlocks() {
        return renderThroughBlocks;
    }

    public static void setRenderThroughBlocks(boolean b) {
        renderThroughBlocks = b;
        Settings.SaveSettings();
    }

    public static void setImagesPerRow(int x) {
        imagesPerRow = x;
        Settings.SaveSettings();
    }

    public static int getImagesPerRow() {
        return imagesPerRow;
    }
}

