/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ValidationUtils {
    private static final Set<String> SUPPORTED_IMAGE_EXTENSIONS = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "tiff", "tif", "webp", "cr2", "nef", "arw", "dng", "orf", "rw2", "pef", "srw", "raf", "3fr", "fff", "dcr", "kdc", "srf", "mrw", "raw", "psd", "psb", "ai", "eps", "svg", "svgz", "ico", "cur", "pcx", "ppm", "pbm", "pgm", "pnm", "xbm", "xpm", "emf", "wmf", "dib", "icns", "pict", "pct", "dcm", "dicom", "fits", "fts", "apng", "mng", "hdr", "exr", "pfm", "rgbe", "jp2", "jpx", "j2k", "j2c", "jpc", "iff", "lbm", "cut", "dds", "ftx", "g3", "hdf", "img", "jbig", "jng", "koala", "msp", "p7", "ras", "sun", "sgi", "targa", "tga", "wbmp", "xif"));
    private static final Set<String> ADDITIONAL_VARIANTS = new HashSet<String>(Arrays.asList("jpe", "jfif"));

    public static boolean isImageFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            return false;
        }
        String extension = ValidationUtils.getFileExtension(filename);
        if (extension == null || extension.isEmpty()) {
            return false;
        }
        return SUPPORTED_IMAGE_EXTENSIONS.contains(extension) || ADDITIONAL_VARIANTS.contains(extension);
    }

    public static boolean isImageFile(String filename, Set<String> dynamicFormats) {
        if (ValidationUtils.isImageFile(filename)) {
            return true;
        }
        if (dynamicFormats != null && !dynamicFormats.isEmpty()) {
            String extension = ValidationUtils.getFileExtension(filename);
            return extension != null && dynamicFormats.contains(extension);
        }
        return false;
    }

    public static String getFileExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String lowerFilename = filename.toLowerCase();
        int lastDotIndex = lowerFilename.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == lowerFilename.length() - 1) {
            return null;
        }
        return lowerFilename.substring(lastDotIndex + 1);
    }

    public static Set<String> getSupportedExtensions() {
        HashSet<String> allExtensions = new HashSet<String>(SUPPORTED_IMAGE_EXTENSIONS);
        allExtensions.addAll(ADDITIONAL_VARIANTS);
        return Collections.unmodifiableSet(allExtensions);
    }

    public static boolean isSupportedExtension(String extension) {
        if (extension == null || extension.isEmpty()) {
            return false;
        }
        String lowerExtension = extension.toLowerCase();
        return SUPPORTED_IMAGE_EXTENSIONS.contains(lowerExtension) || ADDITIONAL_VARIANTS.contains(lowerExtension);
    }

    public static boolean isValidFloat(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidInteger(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

