/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;
import vernando.blueprints.Blueprint;
import vernando.blueprints.BlueprintConfigScreen;
import vernando.blueprints.BlueprintsHud;
import vernando.blueprints.BlueprintsManager;
import vernando.blueprints.Main;
import vernando.blueprints.Settings;
import vernando.blueprints.Util;

@Environment(value=EnvType.CLIENT)
public class BlueprintsConfigScreen
extends class_437 {
    private ArrayList<Blueprint> blueprints;
    private Main main;
    private int imagesPerRow = 5;
    private int imageWidth = 100;
    private int imageHeight = 100;
    private int pageOffset = 0;
    private int rowsPerPage = 3;

    protected BlueprintsConfigScreen(Main main, ArrayList<Blueprint> blueprints) {
        super((class_2561)class_2561.method_43470((String)"Blueprints Config"));
        this.blueprints = blueprints;
        this.main = main;
    }

    protected void method_25426() {
        this.imagesPerRow = Settings.getImagesPerRow();
        if (this.imagesPerRow < 5 || this.imagesPerRow > 20) {
            this.imagesPerRow = 5;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reload"), b -> {
            b.method_25355((class_2561)class_2561.method_43470((String)"..."));
            this.blueprints = BlueprintsManager.getInstance().ScanFileSystemForImages();
            this.field_22787.method_1507((class_437)new BlueprintsConfigScreen(this.main, this.blueprints));
        }).method_46434(10, 10, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(Settings.getRenderThroughBlocks() ? "Mode: Render all" : "Mode: Render visible")), b -> {
            Settings.setRenderThroughBlocks(!Settings.getRenderThroughBlocks());
            b.method_25355((class_2561)(Settings.getRenderThroughBlocks() ? class_2561.method_43470((String)"Mode: Render all") : class_2561.method_43470((String)"Mode: Render visible")));
            this.field_22787.method_1507((class_437)new BlueprintsConfigScreen(this.main, this.blueprints));
        }).method_46434(80, 10, 140, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Folder"), b -> Util.OpenFolder(Util.GetPerWorldDimensionConfigPath())).method_46434(this.field_22789 - 200, 10, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.field_22787.method_1507(null)).method_46434(this.field_22789 - 100, 10, 50, 20).method_46431());
        this.imageHeight = this.imageWidth = (this.field_22789 - 20) / this.imagesPerRow;
        this.rowsPerPage = (this.field_22790 - 50) / this.imageHeight;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
            this.pageOffset = Math.max(0, this.pageOffset - 1);
            this.field_22787.method_1507((class_437)new BlueprintsConfigScreen(this.main, this.blueprints));
        }).method_46434(this.field_22789 - 135, this.field_22790 - 25, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
            this.pageOffset = Math.min((this.blueprints.size() - 1) / this.imagesPerRow / this.rowsPerPage, this.pageOffset + 1);
            this.field_22787.method_1507((class_437)new BlueprintsConfigScreen(this.main, this.blueprints));
        }).method_46434(this.field_22789 - 35, this.field_22790 - 25, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Images per row: " + this.imagesPerRow)), b -> {
            this.imagesPerRow = this.imagesPerRow % 20 + 5;
            this.imageHeight = this.imageWidth = (this.field_22789 - 20) / this.imagesPerRow;
            this.rowsPerPage = (this.field_22790 - 50) / this.imageHeight;
            this.pageOffset = 0;
            b.method_25355((class_2561)class_2561.method_43470((String)("Images per row: " + this.imagesPerRow)));
            Settings.setImagesPerRow(this.imagesPerRow);
            this.field_22787.method_1507((class_437)new BlueprintsConfigScreen(this.main, this.blueprints));
        }).method_46434(this.field_22789 - 250, this.field_22790 - 25, 110, 20).method_46431());
        this.addBlueprintButtons();
    }

    private void addBlueprintButtons() {
        for (Blueprint blueprint : this.blueprints) {
            int index = this.blueprints.indexOf(blueprint);
            if (!this.isImageInView(index)) continue;
            int[] pos = this.getImagePostion(index);
            int x = pos[0];
            int y = pos[1];
            int buttonWidth = this.imageWidth - 3;
            int buttonHeight = this.imageHeight - 3;
            int buttonX = x;
            int buttonY = y;
            class_4185 blueprintButton = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> {
                boolean ctrl;
                BlueprintsHud.getInstance().setSelectedBlueprint(blueprint);
                class_310 client = class_310.method_1551();
                boolean bl = ctrl = GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)341) == 1 || GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)345) == 1;
                if (ctrl) {
                    blueprint.setVisible(!blueprint.isVisible());
                } else {
                    client.method_1507((class_437)new BlueprintConfigScreen(blueprint, this));
                }
            }).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)blueprintButton);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        try {
            this.blueprints.forEach(blueprint -> {
                int index = this.blueprints.indexOf(blueprint);
                if (!this.isImageInView(index)) {
                    return;
                }
                int[] pos = this.getImagePostion(index);
                int x = pos[0];
                int y = pos[1];
                if (mouseX >= x && mouseX <= x + this.imageWidth && mouseY >= y && mouseY <= y + this.imageHeight) {
                    context.method_25294(x, y, x + this.imageWidth, y + this.imageHeight, -2130706433);
                    x += 2;
                    y += 2;
                }
                blueprint.renderThumbnail(context, x, y, this.imageWidth - 4, this.imageHeight - 4, true);
                if (!blueprint.isVisible()) {
                    context.method_25294(x, y, x + this.imageWidth - 4, y + this.imageHeight - 4, Integer.MIN_VALUE);
                }
            });
            context.method_25303(this.field_22793, "Path: " + Util.GetPerWorldDimensionConfigPath(), 10, 35, 0xFFFFFF);
            context.method_25290(class_10799.field_56883, class_2960.method_60655((String)"blueprints", (String)"icon.png"), this.field_22789 - 45, 10, 0.0f, 0.0f, 30, 30, 30, 30);
            if (this.rowsPerPage > 0 && this.imagesPerRow > 0) {
                context.method_25303(this.field_22793, "Page " + (this.pageOffset + 1) + " of " + ((this.blueprints.size() - 1) / this.imagesPerRow / this.rowsPerPage + 1), this.field_22789 - 110, this.field_22790 - 20, 0xFFFFFF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.LOGGER.error(e.getMessage());
        }
    }

    private boolean isImageInView(int index) {
        return (index -= this.pageOffset * this.imagesPerRow * this.rowsPerPage) >= 0 && index < this.imagesPerRow * this.rowsPerPage;
    }

    private int[] getImagePostion(int index) {
        int x = 10 + (index -= this.pageOffset * this.imagesPerRow * this.rowsPerPage) % this.imagesPerRow * this.imageWidth;
        int y = 50 + index / this.imagesPerRow * this.imageHeight;
        return new int[]{x, y};
    }
}

