/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_7919;

public class NumberFieldWidget
extends class_342 {
    private float value;
    private float standardDelta;
    private Consumer<Float> changedListener;
    private Float maxValue;
    private Float minValue;
    private int precision = 1;

    public NumberFieldWidget(class_327 textRenderer, int x, int y, int width, int height, float value, Consumer<Float> changedListener, String tooltip, float standardDelta) {
        super(textRenderer, x, y, width, height, (class_2561)class_2561.method_43470((String)String.valueOf(value)));
        this.value = value;
        this.standardDelta = standardDelta;
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)tooltip)));
        this.method_1852(String.valueOf(value));
        this.method_1870(false);
        this.changedListener = changedListener;
        this.method_1863(s -> {
            try {
                float newValue;
                this.value = newValue = Float.parseFloat(s);
                changedListener.accept(Float.valueOf(this.value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public float getValue() {
        return this.value;
    }

    public NumberFieldWidget setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public NumberFieldWidget setMinValue(Float minValue) {
        this.minValue = minValue;
        return this;
    }

    public NumberFieldWidget setStandardDelta(float standardDelta) {
        this.standardDelta = standardDelta;
        return this;
    }

    public NumberFieldWidget setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public NumberFieldWidget setValue(float value) {
        value = (float)Math.round((double)value * Math.pow(10.0, this.precision)) / (float)Math.pow(10.0, this.precision);
        if (this.maxValue != null && value > this.maxValue.floatValue()) {
            value = this.maxValue.floatValue();
        }
        if (this.minValue != null && value < this.minValue.floatValue()) {
            value = this.minValue.floatValue();
        }
        this.value = value;
        this.method_1852(String.valueOf(value));
        this.method_1870(false);
        this.changedListener.accept(Float.valueOf(this.value));
        return this;
    }

    public NumberFieldWidget increment(boolean shift, boolean ctrl) {
        float x = this.standardDelta;
        if (shift && ctrl) {
            x *= 100.0f;
        } else {
            if (shift) {
                x *= 10.0f;
            }
            if (ctrl) {
                x = (float)((double)x * 0.1);
            }
        }
        this.setValue(this.value + x);
        return this;
    }

    public NumberFieldWidget decrement(boolean shift, boolean ctrl) {
        float x = this.standardDelta;
        if (shift && ctrl) {
            x *= 100.0f;
        } else {
            if (shift) {
                x *= 10.0f;
            }
            if (ctrl) {
                x = (float)((double)x * 0.1);
            }
        }
        this.setValue(this.value - x);
        return this;
    }
}

