/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import vernando.blueprints.Blueprint;
import vernando.blueprints.Main;
import vernando.blueprints.Util;

public class BlueprintsManager {
    public static BlueprintsManager instance;
    public ArrayList<Blueprint> blueprints;
    private static final Set<String> SUPPORTED_IMAGE_EXTENSIONS;
    private static Set<String> dynamicallySupportedFormats;

    public static BlueprintsManager getInstance() {
        if (instance == null) {
            instance = new BlueprintsManager();
        }
        return instance;
    }

    private static Set<String> getDynamicallySupportedFormats() {
        if (dynamicallySupportedFormats == null) {
            String[] readerFormats;
            dynamicallySupportedFormats = new HashSet<String>();
            for (String format : readerFormats = ImageIO.getReaderFormatNames()) {
                dynamicallySupportedFormats.add(format.toLowerCase());
            }
            Main.LOGGER.info("Dynamically detected image formats: " + String.join((CharSequence)", ", dynamicallySupportedFormats));
        }
        return dynamicallySupportedFormats;
    }

    public static boolean isImageFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            return false;
        }
        String lowerFilename = filename.toLowerCase();
        int lastDotIndex = lowerFilename.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == lowerFilename.length() - 1) {
            return false;
        }
        String extension = lowerFilename.substring(lastDotIndex + 1);
        if (SUPPORTED_IMAGE_EXTENSIONS.contains(extension)) {
            return true;
        }
        Set<String> dynamicFormats = BlueprintsManager.getDynamicallySupportedFormats();
        if (dynamicFormats.contains(extension)) {
            return true;
        }
        switch (extension) {
            case "jpe": 
            case "jfif": {
                return true;
            }
            case "tiff": {
                return true;
            }
            case "svg": {
                return true;
            }
        }
        return false;
    }

    public ArrayList<Blueprint> ScanFileSystemForImages() {
        String fullPath = Util.GetPerWorldDimensionConfigPath();
        Main.LOGGER.info("Scanning for images in " + fullPath);
        this.blueprints = new ArrayList();
        File folder = new File(fullPath);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            Main.LOGGER.warn("Could not list files in directory: " + fullPath);
            return this.blueprints;
        }
        int supportedFiles = 0;
        int totalFiles = 0;
        for (File file : listOfFiles) {
            if (!file.isFile()) continue;
            ++totalFiles;
            String filename = file.getName();
            if (!BlueprintsManager.isImageFile(filename)) continue;
            try {
                Blueprint blueprint = new Blueprint(fullPath + "/" + filename);
                this.blueprints.add(blueprint);
                ++supportedFiles;
                Main.LOGGER.debug("Added image file: " + filename);
            }
            catch (Exception e) {
                Main.LOGGER.error("Failed to load image file: " + filename + " - " + e.getMessage());
            }
        }
        Main.LOGGER.info("Loaded " + supportedFiles + " image files out of " + totalFiles + " total files in " + fullPath);
        return this.blueprints;
    }

    static {
        SUPPORTED_IMAGE_EXTENSIONS = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "tiff", "tif", "webp", "cr2", "nef", "arw", "dng", "orf", "rw2", "pef", "srw", "raf", "3fr", "fff", "dcr", "kdc", "srf", "mrw", "raw", "psd", "psb", "ai", "eps", "svg", "svgz", "ico", "cur", "pcx", "ppm", "pbm", "pgm", "pnm", "xbm", "xpm", "emf", "wmf", "dib", "icns", "pict", "pct", "dcm", "dicom", "fits", "fts", "apng", "mng", "hdr", "exr", "pfm", "rgbe", "jp2", "jpx", "j2k", "j2c", "jpc", "iff", "lbm", "cut", "dds", "ftx", "g3", "hdf", "img", "jbig", "jng", "koala", "msp", "p7", "ras", "sun", "sgi", "targa", "tga", "wbmp", "xif"));
        dynamicallySupportedFormats = null;
    }
}

