/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vernando.blueprints.Main;

public class Util {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blueprints");

    public static String GetPerWorldDimensionConfigPath() {
        String worldString = Util.getWorldOrServerName();
        String dimension = Util.getDimensionName();
        String path = "config/blueprints/" + (worldString = worldString.replace(":", "_").trim()) + "/" + dimension;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return path;
    }

    public static String GetConfigPath() {
        String path = "config/blueprints";
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return path;
    }

    private static float fixYaw(float yaw) {
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    public static Direction PlayerFacingDirection(Boolean usePitch) {
        class_310 client = class_310.method_1551();
        if (usePitch.booleanValue()) {
            float pitch = client.method_1560().method_36455();
            if (pitch >= 45.0f) {
                return Direction.UP;
            }
            if (pitch <= -45.0f) {
                return Direction.DOWN;
            }
        }
        float yaw = client.method_1560().method_36454();
        if ((yaw = Util.fixYaw(yaw)) > -45.0f && yaw < 45.0f) {
            return Direction.SOUTH;
        }
        if (yaw > 45.0f && yaw < 135.0f) {
            return Direction.WEST;
        }
        if (yaw > 135.0f || yaw < -135.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public static String getWorldOrServerName() {
        try {
            class_310 client = class_310.method_1551();
            if (client.method_1542()) {
                if (client.method_1576() == null) {
                    return "singleplayer";
                }
                if (client.method_1576().method_27728() == null) {
                    return "singleplayer";
                }
                return client.method_1576().method_27728().method_150();
            }
            return client.method_1558().field_3761;
        }
        catch (Exception e) {
            return "default";
        }
    }

    public static String getDimensionName() {
        try {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) {
                return "null";
            }
            if (client.field_1687.method_40134() == null) {
                return "null";
            }
            return client.field_1687.method_40134().toString().toString().split(":")[2].split("]")[0];
        }
        catch (Exception e) {
            return "default";
        }
    }

    private static class_1011 LoadAsPng(String texturePath) {
        try {
            String format = ImageIO.getReaderFormatNames()[0];
            if (!format.equals("png")) {
                Main.LOGGER.info("Converting image to png: " + texturePath);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)ImageIO.read(new File(texturePath)), "png", baos);
                return class_1011.method_4309((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            return class_1011.method_4309((InputStream)new FileInputStream(texturePath));
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to load image: " + texturePath);
            Main.LOGGER.error(e.getMessage());
            return null;
        }
    }

    public static class_1043 RegisterTexture(String texturePath, class_2960 textureId) {
        class_310 client = class_310.method_1551();
        try {
            Main.LOGGER.info("Loading image: " + texturePath + " as " + textureId.toString());
            ImageInputStream iis = ImageIO.createImageInputStream(new File(texturePath));
            if (iis == null) {
                Main.LOGGER.error("Failed to load image: " + texturePath);
                return null;
            }
            class_1011 image = Util.LoadAsPng(texturePath);
            if (image == null) {
                Main.LOGGER.error("Failed to load image: " + texturePath);
                return null;
            }
            class_1043 texture = new class_1043(() -> texturePath, image);
            Main.LOGGER.info("Registering texture: " + String.valueOf(textureId));
            client.method_1531().method_4616(textureId, (class_1044)texture);
            return texture;
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to load image: " + texturePath);
            Main.LOGGER.error(e.getMessage());
            return null;
        }
    }

    public static void OpenFolder(String folder) {
        class_310 client = class_310.method_1551();
        String basePath = client.field_1697.getAbsolutePath();
        Path path = Path.of(basePath, folder);
        String folderPath = path.toString();
        Main.LOGGER.info("opening folder: " + folderPath);
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                ProcessBuilder pb = new ProcessBuilder("explorer.exe", folderPath);
                pb.start();
            } else if (os.contains("nix") || os.contains("nux")) {
                ProcessBuilder pb = new ProcessBuilder("xdg-open", folderPath);
                pb.start();
            } else if (os.contains("mac")) {
                ProcessBuilder pb = new ProcessBuilder("open", folderPath);
                pb.start();
            } else {
                Main.LOGGER.error("Unknown OS: " + os);
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to open folder: " + folderPath + " on " + os);
            Main.LOGGER.error(e.getMessage());
        }
    }

    public static boolean IsGifFile(String texturePath) {
        return texturePath.toLowerCase().endsWith(".gif");
    }

    public static GifAnimation LoadGif(String texturePath) {
        GifAnimation animation = new GifAnimation();
        try {
            BufferedImage firstFrame;
            int canvasHeight;
            int canvasWidth;
            File file = new File(texturePath);
            ImageInputStream iis = ImageIO.createImageInputStream(file);
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(iis, false);
            int numFrames = reader.getNumImages(true);
            animation.isAnimated = numFrames > 1;
            Main.LOGGER.info("Loading GIF with " + numFrames + " frames: " + texturePath);
            int backgroundColor = 0;
            try {
                IIOMetadata streamMetadata = reader.getStreamMetadata();
                if (streamMetadata != null) {
                    String metaFormatName = streamMetadata.getNativeMetadataFormatName();
                    IIOMetadataNode root = (IIOMetadataNode)streamMetadata.getAsTree(metaFormatName);
                    IIOMetadataNode screenDescriptor = Util.getNode(root, "LogicalScreenDescriptor");
                    if (screenDescriptor != null) {
                        String widthAttr = screenDescriptor.getAttribute("logicalScreenWidth");
                        String heightAttr = screenDescriptor.getAttribute("logicalScreenHeight");
                        canvasWidth = Integer.parseInt(widthAttr);
                        canvasHeight = Integer.parseInt(heightAttr);
                        String bgColorIndex = screenDescriptor.getAttribute("backgroundColorIndex");
                        if (bgColorIndex == null || !bgColorIndex.isEmpty()) {
                            // empty if block
                        }
                        Main.LOGGER.debug("GIF logical screen size: " + canvasWidth + "x" + canvasHeight);
                    } else {
                        BufferedImage firstFrame2 = reader.read(0);
                        canvasWidth = firstFrame2.getWidth();
                        canvasHeight = firstFrame2.getHeight();
                        Main.LOGGER.warn("Could not read GIF logical screen size, using first frame: " + canvasWidth + "x" + canvasHeight);
                    }
                } else {
                    firstFrame = reader.read(0);
                    canvasWidth = firstFrame.getWidth();
                    canvasHeight = firstFrame.getHeight();
                    Main.LOGGER.warn("No stream metadata available, using first frame size: " + canvasWidth + "x" + canvasHeight);
                }
            }
            catch (Exception e) {
                firstFrame = reader.read(0);
                canvasWidth = firstFrame.getWidth();
                canvasHeight = firstFrame.getHeight();
                Main.LOGGER.warn("Failed to read GIF logical screen size, using first frame: " + canvasWidth + "x" + canvasHeight + " - " + e.getMessage());
            }
            BufferedImage canvas = new BufferedImage(canvasWidth, canvasHeight, 2);
            Graphics2D canvasGraphics = canvas.createGraphics();
            canvasGraphics.setComposite(AlphaComposite.Src);
            canvasGraphics.setColor(new Color(backgroundColor, true));
            canvasGraphics.fillRect(0, 0, canvasWidth, canvasHeight);
            String currentDisposalMethod = "none";
            int currentFrameX = 0;
            int currentFrameY = 0;
            int currentFrameWidth = 0;
            int currentFrameHeight = 0;
            for (int i = 0; i < numFrames; ++i) {
                BufferedImage frameImage = reader.read(i);
                if (i > 0) {
                    switch (currentDisposalMethod) {
                        case "restoreToBackgroundColor": 
                        case "2": {
                            canvasGraphics.setComposite(AlphaComposite.Src);
                            canvasGraphics.setColor(new Color(backgroundColor, true));
                            canvasGraphics.fillRect(currentFrameX, currentFrameY, currentFrameWidth, currentFrameHeight);
                            break;
                        }
                        case "restoreToPrevious": 
                        case "3": {
                            Main.LOGGER.debug("Frame " + (i - 1) + ": restoreToPrevious disposal not fully implemented, treating as none");
                            break;
                        }
                    }
                }
                IIOMetadata metadata = reader.getImageMetadata(i);
                String disposalMethod = "none";
                int frameX = 0;
                int frameY = 0;
                int delayMs = 100;
                try {
                    IIOMetadataNode imageDescriptorNode;
                    String metaFormatName = metadata.getNativeMetadataFormatName();
                    IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
                    IIOMetadataNode graphicsControlExtensionNode = Util.getNode(root, "GraphicControlExtension");
                    if (graphicsControlExtensionNode != null) {
                        String disposal;
                        String delayTime = graphicsControlExtensionNode.getAttribute("delayTime");
                        if (delayTime != null && !delayTime.isEmpty() && (delayMs = Integer.parseInt(delayTime) * 10) < 20) {
                            delayMs = 100;
                        }
                        if ((disposal = graphicsControlExtensionNode.getAttribute("disposalMethod")) != null && !disposal.isEmpty()) {
                            disposalMethod = disposal;
                        }
                    }
                    if ((imageDescriptorNode = Util.getNode(root, "ImageDescriptor")) != null) {
                        String leftPos = imageDescriptorNode.getAttribute("imageLeft");
                        String topPos = imageDescriptorNode.getAttribute("imageTop");
                        if (leftPos != null && !leftPos.isEmpty()) {
                            frameX = Integer.parseInt(leftPos);
                        }
                        if (topPos != null && !topPos.isEmpty()) {
                            frameY = Integer.parseInt(topPos);
                        }
                    }
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Failed to read frame metadata for frame " + i + ", using defaults: " + e.getMessage());
                }
                canvasGraphics.setComposite(AlphaComposite.SrcOver);
                canvasGraphics.drawImage((Image)frameImage, frameX, frameY, null);
                BufferedImage compositeFrame = new BufferedImage(canvasWidth, canvasHeight, 2);
                Graphics2D frameGraphics = compositeFrame.createGraphics();
                frameGraphics.setComposite(AlphaComposite.Src);
                frameGraphics.drawImage((Image)canvas, 0, 0, null);
                frameGraphics.dispose();
                class_1011 nativeImage = Util.convertBufferedImageToNativeImage(compositeFrame);
                animation.frames.add(new GifFrame(nativeImage, delayMs));
                currentDisposalMethod = disposalMethod;
                currentFrameX = frameX;
                currentFrameY = frameY;
                currentFrameWidth = frameImage.getWidth();
                currentFrameHeight = frameImage.getHeight();
                Main.LOGGER.debug("Frame " + i + ": disposal=" + disposalMethod + ", delay=" + delayMs + "ms, pos=(" + frameX + "," + frameY + "), size=(" + frameImage.getWidth() + "x" + frameImage.getHeight() + "), canvas=(" + canvasWidth + "x" + canvasHeight + ")");
            }
            canvasGraphics.dispose();
            reader.dispose();
            iis.close();
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to load GIF: " + texturePath);
            Main.LOGGER.error(e.getMessage());
            e.printStackTrace();
            try {
                class_1011 staticImage = Util.LoadAsPng(texturePath);
                if (staticImage != null) {
                    animation.frames.add(new GifFrame(staticImage, 1000));
                }
            }
            catch (Exception fallbackEx) {
                Main.LOGGER.error("Fallback loading also failed: " + fallbackEx.getMessage());
            }
        }
        return animation;
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    private static class_1011 convertBufferedImageToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = bufferedImage.getRGB(x, y);
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST,
        UP,
        DOWN;

    }

    public static class GifAnimation {
        public List<GifFrame> frames = new ArrayList<GifFrame>();
        public boolean isAnimated = false;
    }

    public static class GifFrame {
        public class_1011 image;
        public int delayMs;

        public GifFrame(class_1011 image, int delayMs) {
            this.image = image;
            this.delayMs = delayMs;
        }
    }
}

