/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

public class MathUtils {
    public static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) > 180.0f) {
            yaw -= 360.0f;
        } else if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public static float calculateNudgeAmount(float baseAmount, boolean multiply, boolean finetune, NudgeContext context) {
        if (finetune && multiply) {
            switch (context.ordinal()) {
                case 0: {
                    return baseAmount * 180.0f;
                }
                case 1: 
                case 2: 
                case 3: {
                    return baseAmount * 100.0f;
                }
            }
            return baseAmount;
        }
        if (finetune) {
            return baseAmount / 10.0f;
        }
        if (multiply) {
            switch (context.ordinal()) {
                case 0: {
                    return baseAmount * 90.0f;
                }
                case 1: 
                case 2: 
                case 3: {
                    return baseAmount * 10.0f;
                }
            }
            return baseAmount;
        }
        return baseAmount;
    }

    public static float clampAlpha(float value) {
        if (value > 1.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            return 0.0f;
        }
        return value;
    }

    public static float clamp(float value, Float min, Float max) {
        if (max != null && value > max.floatValue()) {
            return max.floatValue();
        }
        if (min != null && value < min.floatValue()) {
            return min.floatValue();
        }
        return value;
    }

    public static float roundToPrecision(float value, int precision) {
        if (precision < 0) {
            precision = 0;
        }
        float multiplier = (float)Math.pow(10.0, precision);
        return (float)Math.round(value * multiplier) / multiplier;
    }

    public static float calculateFieldDelta(float standardDelta, boolean shift, boolean ctrl) {
        float delta = standardDelta;
        if (shift && ctrl) {
            delta *= 100.0f;
        } else {
            if (shift) {
                delta *= 10.0f;
            }
            if (ctrl) {
                delta = (float)((double)delta * 0.1);
            }
        }
        return delta;
    }

    public static String getFilenameFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        String[] parts = path.split("[/\\\\]");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    public static enum NudgeContext {
        ROTATION,
        POSITION,
        SCALE,
        ALPHA;

    }
}

