/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_7919;
import vernando.blueprints.MathUtils;

public class NumberFieldWidget
extends class_342 {
    private float value;
    private float standardDelta;
    private Consumer<Float> changedListener;
    private Float maxValue;
    private Float minValue;
    private int precision = 1;

    public NumberFieldWidget(class_327 textRenderer, int x, int y, int width, int height, float value, Consumer<Float> changedListener, String tooltip, float standardDelta) {
        super(textRenderer, x, y, width, height, (class_2561)class_2561.method_43470((String)String.valueOf(value)));
        this.value = value;
        this.standardDelta = standardDelta;
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)tooltip)));
        this.method_1852(String.valueOf(value));
        this.method_1870(false);
        this.changedListener = changedListener;
        this.method_1863(s -> {
            try {
                float newValue;
                this.value = newValue = Float.parseFloat(s);
                changedListener.accept(Float.valueOf(this.value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public float getValue() {
        return this.value;
    }

    public NumberFieldWidget setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public NumberFieldWidget setMinValue(Float minValue) {
        this.minValue = minValue;
        return this;
    }

    public NumberFieldWidget setStandardDelta(float standardDelta) {
        this.standardDelta = standardDelta;
        return this;
    }

    public NumberFieldWidget setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public NumberFieldWidget setValue(float value) {
        value = MathUtils.roundToPrecision(value, this.precision);
        this.value = value = MathUtils.clamp(value, this.minValue, this.maxValue);
        this.method_1852(String.valueOf(value));
        this.method_1870(false);
        this.changedListener.accept(Float.valueOf(this.value));
        return this;
    }

    public NumberFieldWidget increment(boolean shift, boolean ctrl) {
        float delta = MathUtils.calculateFieldDelta(this.standardDelta, shift, ctrl);
        this.setValue(this.value + delta);
        return this;
    }

    public NumberFieldWidget decrement(boolean shift, boolean ctrl) {
        float delta = MathUtils.calculateFieldDelta(this.standardDelta, shift, ctrl);
        this.setValue(this.value - delta);
        return this;
    }
}

