/*
 * Decompiled with CFR 0.152.
 */
package vernando.blueprints;

import net.minecraft.class_2350;
import vernando.blueprints.MathUtils;
import vernando.blueprints.Util;

public class TransformUtils {
    public static float nudgeRotation(float currentRotation, float amount, boolean multiply, boolean finetune) {
        float adjustedAmount = MathUtils.calculateNudgeAmount(amount, multiply, finetune, MathUtils.NudgeContext.ROTATION);
        float newRotation = currentRotation + adjustedAmount;
        return MathUtils.normalizeAngle(newRotation);
    }

    public static float nudgePosition(float currentPosition, Util.Direction direction, float amount, boolean multiply, boolean finetune) {
        if (direction == null) {
            return currentPosition;
        }
        float adjustedAmount = MathUtils.calculateNudgeAmount(amount, multiply, finetune, MathUtils.NudgeContext.POSITION);
        switch (direction) {
            case UP: 
            case EAST: 
            case SOUTH: {
                return currentPosition + adjustedAmount;
            }
            case DOWN: 
            case WEST: 
            case NORTH: {
                return currentPosition - adjustedAmount;
            }
        }
        return currentPosition;
    }

    public static Position nudgePosition3D(Position current, Util.Direction direction, float amount, boolean multiply, boolean finetune) {
        if (current == null || direction == null) {
            return current;
        }
        float adjustedAmount = MathUtils.calculateNudgeAmount(amount, multiply, finetune, MathUtils.NudgeContext.POSITION);
        float newX = current.x;
        float newY = current.y;
        float newZ = current.z;
        switch (direction) {
            case UP: {
                newY += adjustedAmount;
                break;
            }
            case DOWN: {
                newY -= adjustedAmount;
                break;
            }
            case EAST: {
                newX += adjustedAmount;
                break;
            }
            case WEST: {
                newX -= adjustedAmount;
                break;
            }
            case NORTH: {
                newZ -= adjustedAmount;
                break;
            }
            case SOUTH: {
                newZ += adjustedAmount;
            }
        }
        return new Position(newX, newY, newZ);
    }

    public static float nudgeAlpha(float currentAlpha, float amount, boolean multiply, boolean finetune) {
        float adjustedAmount = MathUtils.calculateNudgeAmount(amount, multiply, finetune, MathUtils.NudgeContext.ALPHA);
        float newAlpha = currentAlpha + adjustedAmount;
        return MathUtils.clampAlpha(newAlpha);
    }

    public static float nudgeScale(float currentScale, float amount, boolean multiply, boolean finetune) {
        float adjustedAmount = MathUtils.calculateNudgeAmount(amount, multiply, finetune, MathUtils.NudgeContext.SCALE);
        return currentScale + adjustedAmount;
    }

    public static Rotation nudgeRotation3D(Rotation current, class_2350.class_2351 axis, float amount, boolean multiply, boolean finetune) {
        if (current == null || axis == null) {
            return current;
        }
        float newX = current.x;
        float newY = current.y;
        float newZ = current.z;
        switch (axis) {
            case field_11048: {
                newX = TransformUtils.nudgeRotation(current.x, amount, multiply, finetune);
                break;
            }
            case field_11052: {
                newY = TransformUtils.nudgeRotation(current.y, amount, multiply, finetune);
                break;
            }
            case field_11051: {
                newZ = TransformUtils.nudgeRotation(current.z, amount, multiply, finetune);
            }
        }
        return new Rotation(newX, newY, newZ);
    }

    public static Scale nudgeScale2D(Scale current, class_2350.class_2351 axis, float amount, boolean multiply, boolean finetune) {
        if (current == null || axis == null) {
            return current;
        }
        float newX = current.x;
        float newY = current.y;
        switch (axis) {
            case field_11048: {
                newX = TransformUtils.nudgeScale(current.x, amount, multiply, finetune);
                break;
            }
            case field_11052: {
                newY = TransformUtils.nudgeScale(current.y, amount, multiply, finetune);
                break;
            }
        }
        return new Scale(newX, newY);
    }

    public static class Position {
        public final float x;
        public final float y;
        public final float z;

        public Position(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class Rotation {
        public final float x;
        public final float y;
        public final float z;

        public Rotation(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class Scale {
        public final float x;
        public final float y;

        public Scale(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

