/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.client;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.auroraslanterns.AurorasLanterns;
import dev.lambdaurora.auroraslanterns.AurorasLanternsRegistry;
import dev.lambdaurora.auroraslanterns.LanternRegistry;
import dev.lambdaurora.auroraslanterns.block.WallLanternBlock;
import dev.lambdaurora.auroraslanterns.client.particle.AmethystGlintParticle;
import dev.lambdaurora.auroraslanterns.client.renderer.WallLanternBlockEntityRenderer;
import dev.lambdaurora.auroraslanterns.resource.AurorasLanternsRuntimeDatagen;
import dev.lambdaurora.auroraslanterns.resource.InMemoryPackResources;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.entrypoint.client.ClientModInitializer;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.minecraft.class_11515;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_3264;
import net.minecraft.class_5616;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class AurorasLanternsClient
implements ClientModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onInitializeClient(ModContainer mod) {
        ParticleFactoryRegistry.getInstance().register((class_2396)AurorasLanternsRegistry.AMETHYST_GLINT_PARTICLE_TYPE, AmethystGlintParticle.Provider::new);
        BlockRenderLayerMap.putBlocks((class_11515)class_11515.field_60925, (class_2248[])new class_2248[]{AurorasLanternsRegistry.AMETHYST_LANTERN_BLOCK, AurorasLanternsRegistry.REDSTONE_LANTERN_BLOCK});
        LanternRegistry.forEachAndFuture((id, wallLanternBlock) -> BlockRenderLayerMap.putBlocks((class_11515)class_11515.field_60925, (class_2248[])new class_2248[]{wallLanternBlock}));
        class_5616.method_32144(AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE, WallLanternBlockEntityRenderer::new);
        AurorasLanternsRuntimeDatagen.CLIENT_DATAGEN.register(registrar -> {
            InMemoryPackResources.Named pack = new InMemoryPackResources.Named(AurorasLanterns.id("generated").toString());
            registrar.accept(pack);
            try (InputStream stream = AurorasLanternsClient.class.getResourceAsStream("/assets/%s/blockstates/wall_lantern.json".formatted("auroraslanterns"));){
                if (stream != null) {
                    byte[] blockStateTemplate = stream.readAllBytes();
                    LanternRegistry.forEach((id, block) -> {
                        pack.putResource(class_3264.field_14188, id.method_45134(path -> "blockstates/" + path + ".json"), blockStateTemplate);
                        pack.putText(class_3264.field_14188, id.method_45134(path -> "bettergrass/states/" + path + ".json"), "{\"type\":\"layer\",\"data\":\"" + String.valueOf(WallLanternBlock.BETTERGRASS_DATA) + "\"}");
                    });
                } else {
                    LOGGER.error("Failed to load wall lantern blockstate JSON template: could not find file.");
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load wall lantern blockstate JSON template:", (Throwable)e);
            }
        });
    }
}

