/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.item;

import dev.lambdaurora.auroraslanterns.AurorasLanterns;
import dev.lambdaurora.auroraslanterns.AurorasLanternsRegistry;
import dev.lambdaurora.auroraslanterns.item.ItemTreeGroupNode;
import dev.lambdaurora.auroraslanterns.item.ItemTreeItemNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3749;
import net.minecraft.class_5321;
import net.minecraft.class_7706;

public class ItemTree
extends ItemTreeGroupNode {
    private static final class_2960 PHASE = AurorasLanterns.id("phase");
    private static final class_2960 ROOT = AurorasLanterns.id("root");

    public ItemTree() {
        super(ROOT);
    }

    public static ItemTree fromStacks(List<class_1799> displayStacks, List<class_1799> searchStacks) {
        ItemTree tree = new ItemTree();
        ArrayList<ItemTreeItemNode> nodes = new ArrayList<ItemTreeItemNode>();
        for (class_1799 stack : displayStacks) {
            nodes.add(new ItemTreeItemNode(stack, class_1761.class_7705.field_40192));
        }
        for (int i = 0; i < searchStacks.size(); ++i) {
            class_1799 current = searchStacks.get(i);
            class_1799 previous = i == 0 ? null : searchStacks.get(i - 1);
            int foundIndex = -1;
            for (int j = 0; j < nodes.size(); ++j) {
                ItemTreeItemNode node = (ItemTreeItemNode)nodes.get(j);
                if (class_1799.method_31577((class_1799)node.stack(), (class_1799)current)) {
                    node.setVisibility(class_1761.class_7705.field_40191);
                    foundIndex = -1;
                    break;
                }
                if (previous == null || !class_1799.method_31577((class_1799)node.stack(), (class_1799)previous)) continue;
                foundIndex = j + 1;
            }
            if (foundIndex == -1) continue;
            nodes.add(foundIndex, new ItemTreeItemNode(current, class_1761.class_7705.field_40193));
        }
        tree.nodes.addAll(nodes);
        return tree;
    }

    public static void init() {
        ItemTree.register((class_5321<class_1761>)class_7706.field_40197, ItemTree::modifyFunctionalBlocks);
        ItemTree.register((class_5321<class_1761>)class_7706.field_40198, ItemTree::modifyRedstoneBlocks);
    }

    private static void register(class_5321<class_1761> tab, Consumer<ItemTree> modifier) {
        Event event = ItemGroupEvents.modifyEntriesEvent(tab);
        event.addPhaseOrdering(Event.DEFAULT_PHASE, PHASE);
        event.register(PHASE, (Object)ItemTree.modifyItems(modifier));
    }

    private static ItemGroupEvents.ModifyEntries modifyItems(Consumer<ItemTree> modifier) {
        return entries -> {
            ItemTree tree = ItemTree.fromStacks(entries.getDisplayStacks(), entries.getSearchTabStacks());
            modifier.accept(tree);
            entries.getDisplayStacks().clear();
            entries.getSearchTabStacks().clear();
            tree.build(entries.getDisplayStacks(), entries.getEnabledFeatures(), class_1761.class_7705.field_40192);
            tree.build(entries.getSearchTabStacks(), entries.getEnabledFeatures(), class_1761.class_7705.field_40193);
        };
    }

    private static void modifyFunctionalBlocks(ItemTree tree) {
        ItemTreeGroupNode lanterns = tree.collectItemsAsGroup(class_2960.method_60656((String)"lantern"), stack -> {
            class_1747 blockItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof class_1747 && (blockItem = (class_1747)patt0$temp).method_7711() instanceof class_3749;
        });
        lanterns.add((class_1935)AurorasLanternsRegistry.AMETHYST_LANTERN_ITEM);
        lanterns.add((class_1935)AurorasLanternsRegistry.REDSTONE_LANTERN_ITEM);
    }

    private static void modifyRedstoneBlocks(ItemTree tree) {
        tree.addAfter((class_1935)class_1802.field_8530, (class_1935)AurorasLanternsRegistry.REDSTONE_LANTERN_ITEM);
    }
}

