/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.resource;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.auroraslanterns.resource.MutablePackResources;
import dev.yumi.commons.TriState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

public abstract class InMemoryPackResources
implements MutablePackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DUMP = TriState.fromProperty((String)"auroraslanterns.pack.dump_from_in_memory").toBooleanOrElse(FabricLoader.getInstance().isDevelopmentEnvironment());
    private final Map<class_2960, Supplier<byte[]>> assets = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<String, Supplier<byte[]>> root = new ConcurrentHashMap<String, Supplier<byte[]>>();

    @Nullable
    public class_7367<InputStream> method_14410(String ... path) {
        String actualPath = String.join((CharSequence)"/", path);
        return this.openResource(this.root, actualPath);
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        return this.openResource(this.getResourceMap(type), id);
    }

    @Nullable
    protected <T> class_7367<InputStream> openResource(Map<T, Supplier<byte[]>> map, @NotNull T key) {
        Supplier<byte[]> supplier = map.get(key);
        if (supplier == null) {
            return null;
        }
        byte[] bytes = supplier.get();
        if (bytes == null) {
            return null;
        }
        return () -> new ByteArrayInputStream(bytes);
    }

    public void method_14408(class_3264 type, String namespace, String startingPath, class_3262.class_7664 consumer) {
        this.getResourceMap(type).entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace) && ((class_2960)entry.getKey()).method_12832().startsWith(startingPath)).forEach(entry -> {
            byte[] bytes = (byte[])((Supplier)entry.getValue()).get();
            if (bytes != null) {
                consumer.accept((Object)((class_2960)entry.getKey()), () -> new ByteArrayInputStream(bytes));
            }
        });
    }

    public @Unmodifiable @NotNull Set<String> method_14406(class_3264 type) {
        return this.getResourceMap(type).keySet().stream().map(class_2960::method_12836).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public <T> T method_14407(class_7677<T> metadataSectionType) throws IOException {
        if (!this.root.containsKey("pack.mcmeta")) {
            JsonObject json = new JsonObject();
            JsonObject packJson = new JsonObject();
            packJson.addProperty("description", "A virtual resource pack.");
            packJson.addProperty("pack_format", (Number)5);
            json.add("pack", (JsonElement)packJson);
            if (!json.has(metadataSectionType.comp_3436())) {
                return null;
            }
            try {
                return (T)class_3255.method_14392(metadataSectionType, (InputStream)new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8)), (class_9224)this.method_56926());
            }
            catch (Exception e) {
                LOGGER.error("Couldn't load {} metadata from pack \"{}\":", new Object[]{metadataSectionType.comp_3436(), this.method_14409(), e});
                return null;
            }
        }
        class_7367<InputStream> resource = this.method_14410("pack.mcmeta");
        if (resource == null) {
            return null;
        }
        try (InputStream stream = (InputStream)resource.get();){
            Object object = class_3255.method_14392(metadataSectionType, (InputStream)stream, (class_9224)this.method_56926());
            return (T)object;
        }
    }

    public void close() {
        if (DUMP) {
            this.dumpAll();
        }
    }

    @Override
    public void putResource(@NotNull String fileName, byte @NotNull [] resource) {
        this.root.put(fileName, () -> resource);
    }

    @Override
    public void putResource(@NotNull class_3264 type, @NotNull class_2960 id, byte @NotNull [] resource) {
        this.getResourceMap(type).put(id, () -> resource);
    }

    @Override
    public void putResource(@NotNull String fileName, @NotNull Supplier<byte[]> resource) {
        this.root.put(fileName, (Supplier<byte[]>)Suppliers.memoize(resource::get));
    }

    @Override
    public void putResource(@NotNull class_3264 type, @NotNull class_2960 id, @NotNull @NotNull Supplier<byte @NotNull []> resource) {
        this.getResourceMap(type).put(id, (Supplier<byte[]>)Suppliers.memoize(resource::get));
    }

    @Override
    public void clearResources(class_3264 type) {
        this.getResourceMap(type).clear();
    }

    @Override
    public void clearResources() {
        this.root.clear();
        this.clearResources(class_3264.field_14188);
        this.clearResources(class_3264.field_14190);
    }

    public void dumpTo(@NotNull Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            this.root.forEach((p, resource) -> this.dumpResource(path, (String)p, (byte[])resource.get()));
            this.assets.forEach((p, resource) -> this.dumpResource(path, InMemoryPackResources.getResourcePath(class_3264.field_14188, p), (byte[])resource.get()));
            this.data.forEach((p, resource) -> this.dumpResource(path, InMemoryPackResources.getResourcePath(class_3264.field_14190, p), (byte[])resource.get()));
        }
        catch (IOException e) {
            LOGGER.error("Failed to write resource pack dump from pack {} to {}.", new Object[]{this.method_14409(), path, e});
        }
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    static String getResourcePath(@NotNull class_3264 type, @NotNull class_2960 id) {
        return type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832();
    }

    protected void dumpAll() {
        this.dumpTo(Path.of("debug", "packs", this.method_14409()));
    }

    protected void dumpResource(Path parentPath, String resourcePath, byte[] resource) {
        try {
            Path p = parentPath.resolve(resourcePath);
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.write(p, resource, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write resource pack dump from pack {}.", (Object)this.method_14409(), (Object)e);
        }
    }

    private Map<class_2960, Supplier<byte[]>> getResourceMap(class_3264 type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_3264.field_14188 -> this.assets;
            case class_3264.field_14190 -> this.data;
        };
    }

    public static class Named
    extends InMemoryPackResources {
        private final String name;

        public Named(String name) {
            this.name = name;
        }

        @NotNull
        public class_9224 method_56926() {
            return new class_9224(this.name, (class_2561)class_2561.method_43473(), class_5352.field_25348, Optional.empty());
        }

        @NotNull
        public String method_14409() {
            return this.name;
        }
    }
}

