/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns;

import com.google.common.collect.BiMap;
import dev.lambdaurora.auroraslanterns.AurorasLanterns;
import dev.lambdaurora.auroraslanterns.AurorasLanternsRegistry;
import dev.lambdaurora.auroraslanterns.accessor.BlockEntityTypeAccessor;
import dev.lambdaurora.auroraslanterns.block.OxidizableWallLanternBlock;
import dev.lambdaurora.auroraslanterns.block.WallLanternBlock;
import dev.yumi.commons.event.Event;
import dev.yumi.mc.core.api.YumiEvents;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3749;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class LanternRegistry {
    private static final Map<class_2960, WallLanternBlock<?>> WALL_LANTERNS = new Object2ObjectOpenHashMap();
    private static final Map<class_3749, WallLanternBlock<?>> WALL_LANTERN_BLOCK_MAP = new Reference2ObjectOpenHashMap();
    public static final Event<class_2960, OnLanternRegistration> REGISTRATION_EVENT = YumiEvents.EVENTS.create(OnLanternRegistration.class);

    private LanternRegistry() {
        throw new UnsupportedOperationException("LanternRegistry only contains static definitions.");
    }

    public static Stream<class_2960> streamIds() {
        return WALL_LANTERNS.keySet().stream();
    }

    public static void forEach(BiConsumer<class_2960, WallLanternBlock<?>> consumer) {
        WALL_LANTERNS.forEach(consumer);
    }

    public static void forEachAndFuture(OnLanternRegistration listener) {
        WALL_LANTERNS.forEach(listener::onRegisterWallLantern);
        REGISTRATION_EVENT.register((Object)listener);
    }

    public static <L extends class_3749> WallLanternBlock<L> registerWallLantern(class_2378<class_2248> registry, L block, class_2960 lanternId) {
        WallLanternBlock wallLanternBlock;
        class_2960 wallLanternId = LanternRegistry.getWallLanternId(lanternId);
        if (WALL_LANTERNS.containsKey(wallLanternId)) {
            return WALL_LANTERNS.get(wallLanternId);
        }
        if (block == class_2246.field_16541 || block == class_2246.field_22110) {
            wallLanternBlock = (WallLanternBlock)((Object)registry.method_63535(wallLanternId));
        } else {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)wallLanternId);
            class_4970.class_2251 properties = WallLanternBlock.properties(block).method_63500(key);
            if (block instanceof WallLanternBlock.Provider) {
                WallLanternBlock.Provider provider = (WallLanternBlock.Provider)block;
                wallLanternBlock = provider.getWallLanternFactory().create(block, properties);
            } else {
                wallLanternBlock = block instanceof class_5955 ? new OxidizableWallLanternBlock<L>(block, properties) : new WallLanternBlock<L>(block, properties);
            }
            class_2378.method_39197(registry, (class_5321)key, wallLanternBlock);
            ((BlockEntityTypeAccessor)AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE).auroraslanterns$addSupportedBlock((class_2248)wallLanternBlock);
        }
        WALL_LANTERNS.put(wallLanternId, wallLanternBlock);
        WALL_LANTERN_BLOCK_MAP.put(block, wallLanternBlock);
        ((OnLanternRegistration)REGISTRATION_EVENT.invoker()).onRegisterWallLantern(wallLanternId, wallLanternBlock);
        return wallLanternBlock;
    }

    public static <L extends class_3749> WallLanternBlock<L> registerWallLantern(L block) {
        return LanternRegistry.registerWallLantern((class_2378<class_2248>)class_7923.field_41175, block, class_7923.field_41175.method_10221(block));
    }

    public static void tryRegisterWallLantern(class_2378<class_2248> registry, class_2248 block, class_2960 id) {
        if (block instanceof class_3749) {
            LanternRegistry.registerWallLantern(registry, (class_3749)block, id);
        }
    }

    private static class_2960 getWallLanternId(class_2960 lanternId) {
        String namespace = lanternId.method_12836();
        String path = lanternId.method_12832();
        Object wallLanternPath = "wall_lantern";
        if (!namespace.equals("minecraft") && !namespace.equals("auroraslanterns")) {
            wallLanternPath = (String)wallLanternPath + "/" + namespace + "/" + path.replace("_lantern_block", "").replace("_lantern", "");
        } else if (!path.equals("lantern")) {
            wallLanternPath = (String)wallLanternPath + "/" + path.replace("_lantern", "");
        }
        return AurorasLanterns.id((String)wallLanternPath);
    }

    @Nullable
    public static WallLanternBlock<?> fromItem(class_1792 item) {
        class_1747 blockItem;
        class_2248 class_22482;
        if (item instanceof class_1747 && (class_22482 = (blockItem = (class_1747)item).method_7711()) instanceof class_3749) {
            class_3749 lanternBlock = (class_3749)class_22482;
            return WALL_LANTERN_BLOCK_MAP.get(lanternBlock);
        }
        return null;
    }

    public static void rebuildCaches() {
        LanternRegistry.forEach((id, block) -> {
            class_2248 nextWaxable;
            if (block instanceof OxidizableWallLanternBlock) {
                OxidizableWallLanternBlock oxidizable = (OxidizableWallLanternBlock)((Object)block);
                Object lantern = oxidizable.getLanternBlock();
                class_2248 next = (class_2248)((BiMap)class_5955.field_29564.get()).get(lantern);
                if (next instanceof class_3749) {
                    class_3749 nextLantern = (class_3749)next;
                    WallLanternBlock<?> nextWallLantern = WALL_LANTERN_BLOCK_MAP.get(nextLantern);
                    OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)block, nextWallLantern);
                }
            }
            if ((nextWaxable = (class_2248)((BiMap)class_5953.field_29560.get()).get(block.getLanternBlock())) instanceof class_3749) {
                class_3749 waxedLantern = (class_3749)nextWaxable;
                WallLanternBlock<?> waxedWallLantern = WALL_LANTERN_BLOCK_MAP.get(waxedLantern);
                OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)block, waxedWallLantern);
            }
        });
    }

    static {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> LanternRegistry.rebuildCaches());
    }

    @FunctionalInterface
    public static interface OnLanternRegistration {
        public void onRegisterWallLantern(class_2960 var1, WallLanternBlock<?> var2);
    }
}

