/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.auroraslanterns.AurorasLanterns;
import dev.lambdaurora.auroraslanterns.AurorasLanternsRegistry;
import dev.lambdaurora.auroraslanterns.ExtensionType;
import dev.lambdaurora.auroraslanterns.accessor.BlockItemAccessor;
import dev.lambdaurora.auroraslanterns.block.behavior.AnimateTickBehavior;
import dev.lambdaurora.auroraslanterns.block.entity.SwayingBlockEntity;
import dev.lambdaurora.auroraslanterns.block.entity.WallLanternBlockEntity;
import dev.lambdaurora.auroraslanterns.mixin.BlockAccessor;
import dev.lambdaurora.auroraslanterns.util.CustomStateBuilder;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3749;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallLanternBlock<L extends class_3749>
extends class_2237
implements class_3737 {
    public static final MapCodec<? extends WallLanternBlock<?>> CODEC = WallLanternBlock.makeCodec(class_3749.class, WallLanternBlock::new);
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2754<ExtensionType> EXTENSION = class_2754.method_11850((String)"extension", ExtensionType.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_265 LANTERN_HANG_SHAPE = WallLanternBlock.method_9541((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);
    private static final double LANTERN_HANG_SHAPE_MIN_Y = LANTERN_HANG_SHAPE.method_1091(class_2350.class_2351.field_11052);
    public static final Map<class_2350, Map<ExtensionType, class_265>> ATTACHMENT_SHAPES;
    private static final ThreadLocal<class_3749> ASSOCIATED_LANTERN_INIT;
    private static final class_265 HOLDER_SHAPE;
    public static final class_2960 BETTERGRASS_DATA;
    protected final L lanternBlock;
    private final AnimateTickBehavior<L> animateTickBehavior;

    static <L extends class_3749, W extends WallLanternBlock<? extends L>> MapCodec<W> makeCodec(@NotNull Class<L> lanternClass, @NotNull Factory<L, W> instantiator) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("lantern").flatXmap(block -> lanternClass.isInstance(block) ? DataResult.success((Object)((class_3749)lanternClass.cast(block))) : DataResult.error(() -> "Lantern must be of type LanternBlock"), DataResult::success).forGetter(lantern -> lantern.lanternBlock), (App)WallLanternBlock.method_54096()).apply((Applicative)instance, instantiator::create));
    }

    public WallLanternBlock(L lantern, class_4970.class_2251 properties) {
        super(WallLanternBlock.setupContext(lantern, properties));
        this.lanternBlock = lantern;
        this.method_9590((class_2680)((class_2680)this.method_34725(lantern.method_9564()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657(EXTENSION, (Comparable)((Object)ExtensionType.NONE)));
        class_1792 item = class_1792.method_7867(lantern);
        if (item instanceof BlockItemAccessor) {
            BlockItemAccessor blockItem = (BlockItemAccessor)item;
            blockItem.auroraslanterns$setWallBlock((class_2248)this);
        }
        this.animateTickBehavior = AnimateTickBehavior.lanternBehavior(this.lanternBlock);
    }

    @NotNull
    protected MapCodec<? extends WallLanternBlock<?>> method_53969() {
        return CODEC;
    }

    @NotNull
    public L getLanternBlock() {
        return this.lanternBlock;
    }

    public class_2680 getLanternState(class_2680 state) {
        return this.getLanternBlock().method_34725(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        class_3749 lantern = ASSOCIATED_LANTERN_INIT.get();
        ASSOCIATED_LANTERN_INIT.remove();
        CustomStateBuilder<class_2248, class_2680> customBuilder = new CustomStateBuilder<class_2248, class_2680>(builder);
        customBuilder.exclude("hanging", "facing");
        ((BlockAccessor)lantern).auroraslanterns$createStateDefinition(customBuilder);
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{EXTENSION});
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654(FACING);
        ExtensionType extension = (ExtensionType)((Object)state.method_11654(EXTENSION));
        class_265 lanternShape = this.getLanternState(state).method_26218(world, pos);
        double lanternShapeMaxY = lanternShape.method_1105(class_2350.class_2351.field_11052);
        double lanternShapeMinY = lanternShape.method_1091(class_2350.class_2351.field_11052);
        double yOffset = 0.125;
        if (lanternShapeMaxY < LANTERN_HANG_SHAPE_MIN_Y) {
            double size = lanternShapeMaxY - lanternShapeMinY;
            yOffset = LANTERN_HANG_SHAPE_MIN_Y - size;
        }
        return class_259.method_1084((class_265)lanternShape.method_1096((double)(-facing.method_10148() * extension.getOffset()) / 16.0, yOffset, (double)(-facing.method_10165() * extension.getOffset()) / 16.0), (class_265)ATTACHMENT_SHAPES.get(facing).get((Object)extension));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        class_2338 attachPos = pos.method_10093(direction.method_10153());
        class_2680 attachState = world.method_8320(attachPos);
        return !class_259.method_1074((class_265)attachState.method_26222((class_1922)world, attachPos).method_20538(direction), (class_265)HOLDER_SHAPE, (class_247)class_247.field_16893) || ExtensionType.getExtensionValue(attachState, attachPos, world) != ExtensionType.NONE;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = this.method_9564();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_3610 fluidState = world.method_8316(pos);
        class_2350[] directions = context.method_7718();
        state = (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        for (class_2350 direction : directions) {
            class_2350 opposite;
            if (!direction.method_10166().method_10179() || !(state = (class_2680)state.method_11657(FACING, (Comparable)(opposite = direction.method_10153()))).method_26184((class_4538)world, pos)) continue;
            class_2338 attachPos = pos.method_10093(direction);
            return (class_2680)state.method_11657(EXTENSION, (Comparable)((Object)ExtensionType.getExtensionValue(world.method_8320(attachPos), attachPos, (class_4538)world)));
        }
        return null;
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        this.lanternBlock.method_9615(state, world, pos, oldState, notify);
    }

    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        this.lanternBlock.method_66388(state, world, pos, moved);
        super.method_66388(state, world, pos, moved);
    }

    @NotNull
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickScheduler, class_2338 pos, class_2350 direction, class_2338 posFrom, class_2680 newState, class_5819 randomSource) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickScheduler.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        if (direction.method_10153() == state.method_11654(FACING)) {
            if (!state.method_26184(world, pos)) {
                return class_2246.field_10124.method_9564();
            }
            ExtensionType extensionType = ExtensionType.getExtensionValue(newState, posFrom, world);
            if (extensionType != state.method_11654(EXTENSION)) {
                return (class_2680)state.method_11657(EXTENSION, (Comparable)((Object)extensionType));
            }
        }
        return state;
    }

    @NotNull
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return this.getLanternState(state).method_65171(world, pos, includeData);
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_1657 player;
        class_1297 entity = projectile.method_24921();
        this.swing(world, state, hit, entity instanceof class_1657 ? (player = (class_1657)entity) : null, true);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        return this.swing(world, state, hit, player, true) ? class_1269.field_5812 : class_1269.field_5811;
    }

    public boolean swing(class_1937 world, class_2680 state, class_3965 hitResult, @Nullable class_1657 player, boolean hitResultIndependent) {
        boolean canSwing;
        class_2350 direction = hitResult.method_17780();
        class_2338 blockPos = hitResult.method_17777();
        boolean bl = canSwing = !hitResultIndependent || this.isPointOnLantern(state, direction, (double)hitResult.method_17777().method_10264() - (double)blockPos.method_10264());
        if (canSwing) {
            this.swing((class_1297)player, world, blockPos, direction, false);
            return true;
        }
        return false;
    }

    private boolean isPointOnLantern(class_2680 state, class_2350 side, double y) {
        if (side.method_10166() != class_2350.class_2351.field_11052 && y <= (double)0.8124f) {
            class_2350 direction = (class_2350)state.method_11654(FACING);
            return direction.method_10166() != side.method_10166();
        }
        return false;
    }

    public void swing(@Nullable class_1297 entity, class_1937 world, class_2338 pos, class_2350 direction, boolean collision) {
        WallLanternBlockEntity blockEntity = (WallLanternBlockEntity)AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE.method_24182((class_1922)world, pos);
        if (!world.method_8608() && blockEntity != null) {
            if (!blockEntity.isColliding()) {
                world.method_8396(null, pos, AurorasLanternsRegistry.LANTERN_SWING_SOUND_EVENT, class_3419.field_15245, 2.0f, 1.0f);
                world.method_33596(entity, (class_6880)class_5712.field_28733, pos);
            }
            if (!collision) {
                blockEntity.activate(direction);
            } else {
                blockEntity.activate(direction, entity);
            }
        }
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 insideBlockEffectApplier, boolean b) {
        class_238 entityBox;
        if (world.method_8608()) {
            return;
        }
        if (entity instanceof class_1676) {
            return;
        }
        WallLanternBlockEntity blockEntity = (WallLanternBlockEntity)AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE.method_24182((class_1922)world, pos);
        if (blockEntity == null) {
            return;
        }
        class_2350.class_2351 swingAxis = ((class_2350)state.method_11654(FACING)).method_10170().method_10166();
        class_238 lanternBox = blockEntity.getCollisionBox();
        if (lanternBox.method_994(entityBox = entity.method_5829())) {
            class_2350 swingDirection = class_2350.field_11043;
            if (swingAxis == class_2350.class_2351.field_11048) {
                swingDirection = (double)((float)pos.method_10263() + 0.5f) > entity.method_23317() ? class_2350.field_11039 : class_2350.field_11034;
            } else if (swingAxis == class_2350.class_2351.field_11051 && (double)((float)pos.method_10260() + 0.5f) < entity.method_23321()) {
                swingDirection = class_2350.field_11035;
            }
            this.swing(entity, world, pos, swingDirection, true);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                AurorasLanternsRegistry.WALL_LANTERN_BONK_TRIGGER.trigger(player, state);
            }
        }
    }

    @NotNull
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE.method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return WallLanternBlock.method_31618(type, AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE, (class_5558)(world.method_8608() ? SwayingBlockEntity::clientTick : SwayingBlockEntity::serverTick));
    }

    @NotNull
    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    protected boolean method_9506(class_2680 state) {
        return this.getLanternState(state).method_26219();
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        WallLanternBlockEntity lantern = (WallLanternBlockEntity)AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE.method_24182((class_1922)world, pos);
        if (lantern != null) {
            if (lantern.isColliding()) {
                return 15;
            }
            if (lantern.isSwinging()) {
                int max = lantern.getMaxSwingTicks();
                float progress = (float)(max - lantern.getSwingTicks()) / (float)max;
                return (int)(progress * 14.0f);
            }
        }
        return 0;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        this.animateTickBehavior.animateTick(this.getLanternBlock(), this.getLanternState(state), world, pos, random);
    }

    public boolean method_9542(class_2680 state) {
        return this.lanternBlock.method_9542(state);
    }

    public void method_9514(class_2680 state, class_3218 serverLevel, class_2338 pos, class_5819 randomSource) {
        this.lanternBlock.method_9514(state, serverLevel, pos, randomSource);
        super.method_9514(state, serverLevel, pos, randomSource);
    }

    private static class_4970.class_2251 setupContext(class_3749 lanternBlock, class_4970.class_2251 properties) {
        ASSOCIATED_LANTERN_INIT.set(lanternBlock);
        return properties;
    }

    public static class_4970.class_2251 properties(class_2248 lanternBlock) {
        return class_4970.class_2251.method_9630((class_4970)lanternBlock).method_50012(class_3619.field_15971).method_63501(lanternBlock.method_63499()).method_63502(lanternBlock.method_26162());
    }

    private static class_265 getLanternHangShape(class_2350 direction, ExtensionType extensionType) {
        if (extensionType.getOffset() == 0) {
            return LANTERN_HANG_SHAPE;
        }
        float offset = (float)extensionType.getOffset() / 16.0f;
        return switch (direction) {
            case class_2350.field_11043 -> LANTERN_HANG_SHAPE.method_1096(0.0, 0.0, (double)offset);
            case class_2350.field_11035 -> LANTERN_HANG_SHAPE.method_1096(0.0, 0.0, (double)(-offset));
            case class_2350.field_11039 -> LANTERN_HANG_SHAPE.method_1096((double)offset, 0.0, 0.0);
            case class_2350.field_11034 -> LANTERN_HANG_SHAPE.method_1096((double)(-offset), 0.0, 0.0);
            default -> LANTERN_HANG_SHAPE;
        };
    }

    private static class_265 getWallAttachmentShape(class_2350 direction, ExtensionType extensionType) {
        double attachmentMaxY = 16.0;
        double attachmentMinY = 10.0 + (double)(extensionType != ExtensionType.NONE ? -3 : 0);
        double minSide = 6.0;
        double maxSide = 10.0;
        double offset = extensionType == ExtensionType.NONE ? 0.0 : (double)(extensionType.getOffset() + 2);
        return switch (direction) {
            case class_2350.field_11043 -> WallLanternBlock.method_9541((double)6.0, (double)attachmentMinY, (double)(15.0 + offset), (double)10.0, (double)16.0, (double)(16.0 + offset));
            case class_2350.field_11035 -> WallLanternBlock.method_9541((double)6.0, (double)attachmentMinY, (double)(-offset), (double)10.0, (double)16.0, (double)(1.0 - offset));
            case class_2350.field_11039 -> WallLanternBlock.method_9541((double)(15.0 + offset), (double)attachmentMinY, (double)6.0, (double)(16.0 + offset), (double)16.0, (double)10.0);
            case class_2350.field_11034 -> WallLanternBlock.method_9541((double)(-offset), (double)attachmentMinY, (double)6.0, (double)(1.0 - offset), (double)16.0, (double)10.0);
            default -> class_259.method_1073();
        };
    }

    private static class_265 getPoleShape(class_2350 direction, ExtensionType extensionType) {
        double minY = 13.0;
        double maxY = 15.0;
        double minSide = 7.0;
        double maxSide = 9.0;
        double offset = extensionType == ExtensionType.NONE ? 0.0 : (double)(extensionType.getOffset() - 2);
        double length = offset + (extensionType == ExtensionType.NONE ? 8.0 : 12.0);
        return switch (direction) {
            case class_2350.field_11043 -> WallLanternBlock.method_9541((double)7.0, (double)13.0, (double)(7.0 + offset), (double)9.0, (double)15.0, (double)(7.0 + length));
            case class_2350.field_11035 -> WallLanternBlock.method_9541((double)7.0, (double)13.0, (double)(9.0 - length), (double)9.0, (double)15.0, (double)(9.0 - offset));
            case class_2350.field_11039 -> WallLanternBlock.method_9541((double)(7.0 + offset), (double)13.0, (double)7.0, (double)(7.0 + length), (double)15.0, (double)9.0);
            case class_2350.field_11034 -> WallLanternBlock.method_9541((double)(9.0 - length), (double)13.0, (double)7.0, (double)(9.0 - offset), (double)15.0, (double)9.0);
            default -> class_259.method_1073();
        };
    }

    static {
        ASSOCIATED_LANTERN_INIT = new ThreadLocal();
        HOLDER_SHAPE = WallLanternBlock.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        BETTERGRASS_DATA = AurorasLanterns.id("bettergrass/data/wall_lantern");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_2350 direction : class_2350.values()) {
            if (!direction.method_10166().method_10179()) continue;
            ImmutableMap.Builder directionBuilder = ImmutableMap.builder();
            for (ExtensionType extensionType : ExtensionType.VALUES) {
                directionBuilder.put((Object)extensionType, (Object)class_259.method_17786((class_265)WallLanternBlock.getLanternHangShape(direction, extensionType), (class_265[])new class_265[]{WallLanternBlock.getPoleShape(direction, extensionType), WallLanternBlock.getWallAttachmentShape(direction, extensionType)}));
            }
            builder.put((Object)direction, (Object)directionBuilder.build());
        }
        ATTACHMENT_SHAPES = Maps.newEnumMap((Map)builder.build());
    }

    public static interface Factory<L extends class_3749, W extends WallLanternBlock<? extends L>> {
        public W create(L var1, class_4970.class_2251 var2);
    }

    public static interface Provider<L extends class_3749, W extends WallLanternBlock<? extends L>> {
        public Factory<L, W> getWallLanternFactory();
    }
}

