/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.block.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_8235;

public final class RedstoneLanternBehavior {
    public static final class_2746 LIT = class_2741.field_12548;
    private final Map<class_1922, List<BurnoutEntry>> burnoutMap = new WeakHashMap<class_1922, List<BurnoutEntry>>();
    private final Function<class_2680, class_2350> attachmentDirection;

    public RedstoneLanternBehavior(Function<class_2680, class_2350> attachmentDirection) {
        this.attachmentDirection = attachmentDirection;
    }

    public static boolean isLit(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT);
    }

    public void neighborChanged(class_2680 state, class_1937 world, class_2338 pos) {
        if (RedstoneLanternBehavior.isLit(state) == this.shouldUnpower((class_8235)world, pos, state) && !world.method_8397().method_8677(pos, (Object)state.method_26204())) {
            world.method_64310(pos, state.method_26204(), 2);
        }
    }

    public int getWeakRedstonePower(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (this.attachmentDirection.apply(state) == class_2350.field_11036 && direction == class_2350.field_11033) {
            return 0;
        }
        return (Boolean)state.method_11654((class_2769)LIT) != false && this.attachmentDirection.apply(state) != direction ? 15 : 0;
    }

    public int getStrongRedstonePower(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return direction == class_2350.field_11036 ? state.method_26195(world, pos, direction) : 0;
    }

    private boolean shouldUnpower(class_8235 world, class_2338 pos, class_2680 state) {
        class_2350 direction = this.attachmentDirection.apply(state).method_10153();
        return world.method_49807(pos.method_10093(direction), direction);
    }

    public void scheduledTick(class_2680 state, class_3218 world, class_2338 pos) {
        boolean shouldUnpower = this.shouldUnpower((class_8235)world, pos, state);
        List<BurnoutEntry> list = this.burnoutMap.get(world);
        while (list != null && !list.isEmpty() && world.method_8510() - list.getFirst().time > 60L) {
            list.removeFirst();
        }
        if (RedstoneLanternBehavior.isLit(state)) {
            if (shouldUnpower) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (this.isBurnedOut((class_1937)world, pos, true)) {
                    world.method_20290(1502, pos, 0);
                    world.method_64310(pos, world.method_8320(pos).method_26204(), 160);
                }
            }
        } else if (!shouldUnpower && !this.isBurnedOut((class_1937)world, pos, false)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private boolean isBurnedOut(class_1937 world, class_2338 pos, boolean addNew) {
        List list = this.burnoutMap.computeIfAbsent((class_1922)world, w -> new ArrayList());
        if (addNew) {
            list.add(new BurnoutEntry(pos.method_10062(), world.method_8510()));
        }
        int i = 0;
        for (BurnoutEntry burnoutEntry : list) {
            if (!burnoutEntry.pos().equals((Object)pos) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    public record BurnoutEntry(class_2338 pos, long time) {
    }
}

