/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.block.entity;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class SwayingBlockEntity
extends class_2586 {
    protected boolean naturalSway = false;
    private int swingTicks;
    private boolean swinging;
    private class_2350 swingBaseDirection;
    private boolean colliding = false;
    private final Set<class_1297> collisions = new ObjectOpenHashSet();

    public SwayingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean canNaturallySway() {
        return this.naturalSway;
    }

    public abstract class_238 getCollisionBox();

    public int getSwingTicks() {
        return this.swingTicks;
    }

    public float getAdjustedSwingTicks() {
        boolean fluid = !this.method_11010().method_26227().method_15769();
        float ticks = this.getSwingTicks();
        if (this.isColliding() && ticks > 4.0f) {
            ticks = 4.0f;
        }
        if (fluid) {
            ticks /= 2.0f;
        }
        return ticks;
    }

    public abstract int getMaxSwingTicks();

    public boolean isSwinging() {
        return this.swinging;
    }

    public class_2350 getSwingBaseDirection() {
        return this.swingBaseDirection;
    }

    public boolean isColliding() {
        return this.colliding;
    }

    public void activate(class_2350 direction) {
        class_2338 blockPos = this.method_11016();
        this.swingBaseDirection = direction;
        if (this.swinging) {
            this.swingTicks = this.isColliding() ? 4 : 0;
        } else {
            this.swinging = true;
        }
        this.method_10997().method_8427(blockPos, this.method_11010().method_26204(), 1, direction.method_10146());
    }

    public void activate(class_2350 direction, class_1297 entity) {
        this.collisions.add(entity);
        this.colliding = true;
        class_2338 pos = this.method_11016();
        class_1937 world = this.method_10997();
        world.method_8427(pos, this.method_11010().method_26204(), 2, 1);
        world.method_8455(pos, this.method_11010().method_26204());
        this.activate(direction);
    }

    public void activate(class_1297 entity) {
        class_2338 pos = this.method_11016();
        double selfX = (double)pos.method_10263() + 0.5;
        double selfZ = (double)pos.method_10260() + 0.5;
        double diffX = selfX - entity.method_23317();
        double diffZ = selfZ - entity.method_23321();
        class_2350 direction = Math.abs(diffX) > Math.abs(diffZ) ? (diffX > 0.0 ? class_2350.field_11039 : class_2350.field_11034) : (diffZ > 0.0 ? class_2350.field_11043 : class_2350.field_11035);
        this.activate(direction, entity);
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.swingBaseDirection = class_2350.method_10143((int)data);
            if (!this.swinging || !this.isColliding()) {
                this.swingTicks = 0;
            }
            this.swinging = true;
            return true;
        }
        if (type == 2) {
            this.colliding = data != 0;
            return true;
        }
        return super.method_11004(type, data);
    }

    private void tick() {
        ++this.swingTicks;
        if (this.swingTicks >= 4 && this.isColliding()) {
            this.swingTicks = 4;
        }
        if (this.swingTicks >= this.getMaxSwingTicks()) {
            this.swinging = false;
            this.swingTicks = 0;
        }
    }

    protected void tickClient(class_1937 world) {
        this.naturalSway = world.method_8314(class_1944.field_9284, this.field_11867) >= 12;
        this.tick();
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, SwayingBlockEntity swayingBlockEntity) {
        swayingBlockEntity.tickClient(world);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SwayingBlockEntity swayingBlockEntity) {
        boolean canTick = true;
        if (!swayingBlockEntity.collisions.isEmpty()) {
            Iterator<class_1297> it = swayingBlockEntity.collisions.iterator();
            while (it.hasNext()) {
                class_1297 entry = it.next();
                if (entry.method_31481()) {
                    it.remove();
                    continue;
                }
                if (swayingBlockEntity.getCollisionBox().method_994(entry.method_5829())) {
                    canTick = false;
                    continue;
                }
                it.remove();
            }
        }
        if (swayingBlockEntity.collisions.isEmpty() && swayingBlockEntity.isColliding()) {
            swayingBlockEntity.colliding = false;
            world.method_8427(pos, state.method_26204(), 2, 0);
            world.method_8455(pos, state.method_26204());
        }
        if (canTick) {
            int oldSwingTicks = swayingBlockEntity.swingTicks;
            swayingBlockEntity.tick();
            if (oldSwingTicks != swayingBlockEntity.swingTicks) {
                world.method_8455(pos, state.method_26204());
            }
        }
    }
}

