/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.block.entity;

import dev.lambdaurora.auroraslanterns.AurorasLanternsRegistry;
import dev.lambdaurora.auroraslanterns.block.WallLanternBlock;
import dev.lambdaurora.auroraslanterns.block.entity.SwayingBlockEntity;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;

public class WallLanternBlockEntity
extends SwayingBlockEntity {
    private class_238 lanternCollisionBoxX;
    private class_238 lanternCollisionBoxZ;
    public float prevAngle;
    public float angle;

    public WallLanternBlockEntity(class_2338 pos, class_2680 state) {
        super(AurorasLanternsRegistry.WALL_LANTERN_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        this.updateCollisionBoxes();
    }

    public class_2680 getLanternState() {
        class_2680 cachedState = this.method_11010();
        return ((WallLanternBlock)cachedState.method_26204()).getLanternState(cachedState);
    }

    @Override
    public class_238 getCollisionBox() {
        class_2350.class_2351 swingAxis = ((class_2350)this.method_11010().method_11654(WallLanternBlock.FACING)).method_10170().method_10166();
        return swingAxis == class_2350.class_2351.field_11048 ? this.lanternCollisionBoxX : this.lanternCollisionBoxZ;
    }

    @Override
    public int getMaxSwingTicks() {
        return this.method_11010().method_26227().method_15769() ? 60 : 100;
    }

    private void updateCollisionBoxes() {
        class_1937 world = this.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = this.method_11016();
        class_2680 lanternState = this.getLanternState();
        class_238 box = lanternState.method_26172((class_1922)world, pos, class_3726.method_16194()).method_1096(0.0, 0.125, 0.0).method_1107();
        this.lanternCollisionBoxX = box.method_1009(0.1, 0.0, 0.0).method_996(pos);
        this.lanternCollisionBoxZ = box.method_1009(0.0, 0.0, 0.1).method_996(pos);
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.updateCollisionBoxes();
    }

    @Override
    protected void tickClient(class_1937 world) {
        super.tickClient(world);
        this.prevAngle = this.angle;
        this.angle = this.computeAngle();
    }

    public float computeAngle() {
        if (this.isSwinging() || this.isColliding()) {
            float ticks = this.getAdjustedSwingTicks();
            float shiftedTicks = ticks - 100.0f;
            return shiftedTicks * shiftedTicks / 5000.0f * class_3532.method_15374((float)(ticks / (float)Math.PI)) / (4.0f + ticks / 3.0f);
        }
        return this.getNaturalSwayingAngle();
    }

    public float getNaturalSwayingAngle() {
        if (!this.canNaturallySway()) {
            return 0.0f;
        }
        class_2338 pos = this.method_11016();
        long time = 0L;
        class_1937 world = this.method_10997();
        if (world != null) {
            time = world.method_8510();
        }
        int period = 125;
        float n = (float)Math.floorMod((long)pos.method_10263() * 7L + (long)pos.method_10264() * 9L + (long)pos.method_10260() * 13L + time, (long)period) / (float)period;
        return (float)((double)(0.01f * class_3532.method_15362((float)((float)(Math.PI * 2 * (double)n)))) * Math.PI);
    }
}

