/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.client.renderer;

import dev.lambdaurora.auroraslanterns.ExtensionType;
import dev.lambdaurora.auroraslanterns.block.WallLanternBlock;
import dev.lambdaurora.auroraslanterns.block.entity.WallLanternBlockEntity;
import dev.lambdaurora.auroraslanterns.client.renderer.WallLanternBlockEntityRenderState;
import dev.lambdaurora.auroraslanterns.client.utils.LBGHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class WallLanternBlockEntityRenderer
implements class_827<WallLanternBlockEntity, WallLanternBlockEntityRenderState> {
    public WallLanternBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public int method_33893() {
        return 128;
    }

    @NotNull
    public WallLanternBlockEntityRenderState createRenderState() {
        return new WallLanternBlockEntityRenderState();
    }

    public void extractRenderState(WallLanternBlockEntity lantern, WallLanternBlockEntityRenderState state, float tickDelta, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        float angle;
        super.method_74331((class_2586)lantern, (class_11954)state, tickDelta, cameraPos, crumblingOverlay);
        float pitch = 0.0f;
        float roll = 0.0f;
        lantern.prevAngle = angle = class_3532.method_16439((float)tickDelta, (float)lantern.prevAngle, (float)lantern.angle);
        if ((lantern.isSwinging() || lantern.isColliding()) && lantern.getSwingBaseDirection() != null) {
            switch (lantern.getSwingBaseDirection()) {
                case field_11043: {
                    pitch = -angle;
                    break;
                }
                case field_11035: {
                    pitch = angle;
                    break;
                }
                case field_11034: {
                    roll = -angle;
                    break;
                }
                case field_11039: {
                    roll = angle;
                }
            }
        } else if (((class_2350)lantern.method_11010().method_11654(WallLanternBlock.FACING)).method_10166() == class_2350.class_2351.field_11051) {
            roll = angle;
        } else {
            pitch = angle;
        }
        state.lanternState = lantern.getLanternState();
        state.pitch = pitch;
        state.roll = roll;
        class_265 lanternShape = lantern.getLanternState().method_26218((class_1922)lantern.method_10997(), lantern.method_11016());
        double lanternShapeMaxY = lanternShape.method_1105(class_2350.class_2351.field_11052);
        double lanternShapeMinY = lanternShape.method_1091(class_2350.class_2351.field_11052);
        state.size = lanternShapeMaxY - lanternShapeMinY;
    }

    public void submit(WallLanternBlockEntityRenderState lantern, class_4587 matrices, class_11659 collector, class_12075 cameraRenderState) {
        class_2338 pos = lantern.field_62673;
        float pitch = lantern.pitch;
        float roll = lantern.roll;
        class_2680 lanternState = lantern.lanternState;
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.75f, 0.5f);
        if (roll != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(roll));
        }
        if (pitch != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(pitch));
        }
        class_2350 facing = (class_2350)lantern.field_62674.method_11654(WallLanternBlock.FACING);
        int lanternRotation = switch (facing) {
            case class_2350.field_11043 -> 90;
            case class_2350.field_11034 -> 180;
            case class_2350.field_11035 -> 270;
            default -> 0;
        };
        int extension = ((ExtensionType)((Object)lantern.field_62674.method_11654(WallLanternBlock.EXTENSION))).getOffset();
        matrices.method_46416((float)(-facing.method_10148() * extension) / 16.0f, 0.0f, (float)(-facing.method_10165() * extension) / 16.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees((float)lanternRotation));
        matrices.method_22904(-0.5, -0.0625 - lantern.size, -0.5);
        LBGHooks.pushDisableBetterLayer();
        collector.method_73481(matrices, lanternState, lantern.field_62676, class_4608.field_21444, 0);
        LBGHooks.popDisableBetterLayer();
        matrices.method_22909();
    }
}

