/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.auroraslanterns.item;

import dev.lambdaurora.auroraslanterns.item.ItemTreeItemNode;
import dev.lambdaurora.auroraslanterns.item.ItemTreeNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7699;
import org.jetbrains.annotations.Nullable;

public class ItemTreeGroupNode
implements ItemTreeNode {
    private final class_2960 id;
    protected final List<ItemTreeNode> nodes = new ArrayList<ItemTreeNode>();
    private final Map<class_2960, ItemTreeGroupNode> groupNodes = new Object2ObjectOpenHashMap();
    private final class_1761.class_7705 visibility = class_1761.class_7705.field_40191;

    public ItemTreeGroupNode(class_2960 id) {
        this.id = id;
    }

    public void add(class_1799 stack, class_1761.class_7705 visibility) {
        this.nodes.add(new ItemTreeItemNode(stack, visibility));
    }

    public void add(class_1799 stack) {
        this.add(stack, class_1761.class_7705.field_40191);
    }

    public void add(int index, class_1799 stack, class_1761.class_7705 visibility) {
        this.nodes.add(index, new ItemTreeItemNode(stack, visibility));
    }

    public void add(int index, class_1799 stack) {
        this.add(index, stack, class_1761.class_7705.field_40191);
    }

    public void add(class_1935 item) {
        this.add(new class_1799(item));
    }

    public void add(class_1935 item, class_1761.class_7705 visibility) {
        this.add(new class_1799(item), visibility);
    }

    public void add(ItemTreeGroupNode groupNode) {
        this.nodes.add(groupNode);
        this.groupNodes.put(groupNode.id, groupNode);
        this.groupNodes.putAll(groupNode.groupNodes);
    }

    public void add(int index, ItemTreeGroupNode groupNode) {
        this.nodes.add(index, groupNode);
        this.groupNodes.put(groupNode.id, groupNode);
        this.groupNodes.putAll(groupNode.groupNodes);
    }

    private int addRelative(class_1799 toFind, ItemTreeNode node, int offset) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            ItemTreeItemNode item;
            ItemTreeNode itemTreeNode = this.nodes.get(i);
            if (!(itemTreeNode instanceof ItemTreeItemNode) || !class_1799.method_31577((class_1799)(item = (ItemTreeItemNode)itemTreeNode).stack(), (class_1799)toFind)) continue;
            this.nodes.add(i + offset, node);
            return i + offset;
        }
        return -1;
    }

    public int addAfter(class_1799 toFind, ItemTreeNode node) {
        return this.addRelative(toFind, node, 1);
    }

    public int addAfter(class_1799 toFind, class_1799 toAdd, class_1761.class_7705 visibility) {
        return this.addAfter(toFind, new ItemTreeItemNode(toAdd, visibility));
    }

    public int addAfter(class_1799 toFind, class_1799 toAdd) {
        return this.addAfter(toFind, toAdd, class_1761.class_7705.field_40191);
    }

    public void addAfter(class_1799 toFind, class_1935 toAdd) {
        this.addAfter(toFind, new class_1799(toAdd));
    }

    public void addAfter(class_1935 toFind, class_1935 toAdd) {
        this.addAfter(new class_1799(toFind), toAdd);
    }

    @Nullable
    public ItemTreeGroupNode collectItemsAsGroup(class_2960 id, Predicate<class_1799> collector) {
        int start = -1;
        int end = -1;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ItemTreeNode itemTreeNode = this.nodes.get(i);
            if (!(itemTreeNode instanceof ItemTreeItemNode)) continue;
            ItemTreeItemNode item = (ItemTreeItemNode)itemTreeNode;
            if (collector.test(item.stack())) {
                if (start != -1) continue;
                start = i;
                continue;
            }
            if (start == -1) continue;
            end = i - 1;
            break;
        }
        if (start == -1 || end == -1) {
            return null;
        }
        if (end < start) {
            return null;
        }
        return this.replaceNodesWithGroup(id, start, end);
    }

    private ItemTreeGroupNode replaceNodesWithGroup(class_2960 id, int start, int end) {
        ItemTreeGroupNode group = new ItemTreeGroupNode(id);
        group.nodes.addAll(this.nodes.subList(start, end + 1));
        group.detectGroups();
        this.nodes.removeAll(group.nodes);
        this.add(start, group);
        return group;
    }

    @Override
    public class_1761.class_7705 getVisibility() {
        return this.visibility;
    }

    @Override
    public void build(Collection<class_1799> stacks, class_7699 enabledFeatures, class_1761.class_7705 visibility) {
        if (this.visibility == class_1761.class_7705.field_40191 || this.visibility == visibility) {
            for (ItemTreeNode node : this.nodes) {
                node.build(stacks, enabledFeatures, visibility);
            }
        }
    }

    private void detectGroups() {
        for (ItemTreeNode node : this.nodes) {
            if (!(node instanceof ItemTreeGroupNode)) continue;
            ItemTreeGroupNode groupNode = (ItemTreeGroupNode)node;
            this.groupNodes.putIfAbsent(groupNode.id, groupNode);
        }
    }
}

