/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeAttributeModifier
extends AbilityTypeAdapter {
    private final String attributeId;
    private final class_6880<class_1320> attribute;
    private final double amountFactor;
    private final class_1322.class_1323 operation;
    private final Map<Integer, class_1322> attributeModifiers;

    public AbilityTypeAttributeModifier(IAbilityCondition condition, String name, class_1814 rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, String attributeId, double amountFactor, class_1322.class_1323 operation) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.attributeId = attributeId;
        Optional attributeOptional = class_7923.field_41190.method_55841(class_2960.method_60654((String)attributeId));
        if (attributeOptional.isEmpty()) {
            EverlastingAbilitiesInstance.MOD.log(Level.INFO, "No attribute was found with id: " + attributeId + ". Marking as disabled.");
            this.setCondition(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityConditionFalse());
            this.attribute = null;
        } else {
            this.attribute = (class_6880)attributeOptional.get();
        }
        this.amountFactor = amountFactor;
        this.operation = operation;
        this.attributeModifiers = Maps.newHashMap();
        for (int i = 1; i <= maxLevel; ++i) {
            this.attributeModifiers.put(i, new class_1322(class_2960.method_60654((String)("everlastingabilities:modifier_" + name + "_" + i)), this.amountFactor * (double)i, this.operation));
        }
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public double getAmountFactor() {
        return this.amountFactor;
    }

    public class_1322.class_1323 getOperation() {
        return this.operation;
    }

    @Override
    public MapCodec<? extends IAbilityType> codec() {
        return Objects.requireNonNull((MapCodec)RegistryEntries.ABILITYSERIALIZER_ATTRIBUTE_MODIFIER.comp_349());
    }

    @Override
    public void onTick(class_1657 player, int level) {
        class_1322 modifier;
        super.onTick(player, level);
        class_1324 attribute = player.method_5996(this.attribute);
        if (attribute != null && !attribute.method_6196((modifier = this.attributeModifiers.get(level)).comp_2447())) {
            attribute.method_26835(modifier);
        }
    }

    @Override
    public void onChangedLevel(class_1657 player, int oldLevel, int newLevel) {
        class_1324 attribute = player.method_5996(this.attribute);
        if (attribute != null) {
            if (oldLevel > 0) {
                attribute.method_6202(this.attributeModifiers.get(oldLevel));
            }
            if (newLevel > 0) {
                attribute.method_26835(this.attributeModifiers.get(newLevel));
            }
        }
    }
}

