/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeEffect
extends AbilityTypeAdapter {
    private final Target target;
    private final boolean targetsFriendlyMobs;
    private final double radiusFactor;
    private final String effectId;
    private final class_6880<class_1291> potion;
    private final int tickModulus;
    private final double amplifierFactor;
    private final boolean levelBasedDuration;
    private final double durationFactor;

    public AbilityTypeEffect(IAbilityCondition condition, String name, class_1814 rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, Target target, boolean targetsFriendlyMobs, double radiusFactor, String effectId, int tickModulus, double amplifierFactor, boolean levelBasedDuration, double durationFactor) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.target = target;
        this.targetsFriendlyMobs = targetsFriendlyMobs;
        this.radiusFactor = radiusFactor;
        this.effectId = effectId;
        Optional potionOptional = class_7923.field_41174.method_55841(class_2960.method_60654((String)effectId));
        if (potionOptional.isEmpty()) {
            EverlastingAbilitiesInstance.MOD.log(Level.INFO, "No potion effect was found with id: " + effectId + ". Marking as disabled.");
            this.setCondition(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityConditionFalse());
            this.potion = null;
        } else {
            this.potion = (class_6880)potionOptional.get();
        }
        this.tickModulus = tickModulus;
        this.amplifierFactor = amplifierFactor;
        this.levelBasedDuration = levelBasedDuration;
        this.durationFactor = durationFactor;
    }

    public Target getTarget() {
        return this.target;
    }

    public boolean isTargetsFriendlyMobs() {
        return this.targetsFriendlyMobs;
    }

    public double getRadiusFactor() {
        return this.radiusFactor;
    }

    public String getEffectId() {
        return this.effectId;
    }

    public int getTickModulus() {
        return this.tickModulus;
    }

    public double getAmplifierFactor() {
        return this.amplifierFactor;
    }

    public boolean isLevelBasedDuration() {
        return this.levelBasedDuration;
    }

    public double getDurationFactor() {
        return this.durationFactor;
    }

    @Override
    public MapCodec<? extends IAbilityType> codec() {
        return Objects.requireNonNull((MapCodec)RegistryEntries.ABILITYSERIALIZER_EFFECT.comp_349());
    }

    protected int getDuration(int tickModulus, int level) {
        if (this.isLevelBasedDuration()) {
            int maxLevel = this.getMaxLevel() == -1 ? 5 : this.getMaxLevel();
            return (int)((double)((float)IModHelpers.get().getMinecraftHelpers().getSecondInTicks() * ((float)level / (float)maxLevel * 20.0f)) * this.getDurationFactor());
        }
        return (int)((double)tickModulus * this.getDurationFactor());
    }

    protected int getTickModulus(int level) {
        return this.getTickModulus();
    }

    protected int getAmplifier(int level) {
        return (int)((double)(level - 1) * this.getAmplifierFactor());
    }

    @Override
    public void onTick(class_1657 player, int level) {
        class_1937 world = player.method_37908();
        if (this.potion != null && !world.field_9236 && world.method_8510() % (long)this.getTickModulus(level) == 0L) {
            switch (this.getTarget().ordinal()) {
                case 0: {
                    player.method_6092(new class_1293(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    break;
                }
                case 1: {
                    double radius = (double)level * this.getRadiusFactor();
                    List mobs = world.method_8390(class_1309.class, player.method_5829().method_1009(radius, radius, radius), class_1301.field_6155);
                    for (class_1309 mob : mobs) {
                        if (mob == player || !this.targetsFriendlyMobs && AbilityTypeEffect.isFriendlyMob(mob, player)) continue;
                        mob.method_6092(new class_1293(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFriendlyMob(class_1309 mob, class_1657 player) {
        class_2960 resourceLocation = mob instanceof class_1657 ? class_2960.method_60654((String)"player") : class_7923.field_41177.method_10221((Object)mob.method_5864());
        String mobName = resourceLocation == null ? "null" : resourceLocation.toString();
        if (player.method_5722((class_1297)mob)) return true;
        if (mob instanceof class_1321) {
            if (((class_1321)mob).method_35057() == player) return true;
        }
        if (!GeneralConfig.friendlyMobs.stream().anyMatch(mobName::matches)) return false;
        return true;
    }

    public static enum Target {
        SELF,
        RADIUS;

    }
}

