/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IInitializableMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class CompoundTagMutableAbilityStore
implements IMutableAbilityStore,
IInitializableMutableAbilityStore {
    private static final String NBT_STORE = "everlastingabilities:abilityStoreStack";
    private final Supplier<class_2487> tagSupplier;
    private final class_5455 registryAccess;

    public CompoundTagMutableAbilityStore(Supplier<class_2487> tagSupplier, class_5455 registryAccess) {
        this.tagSupplier = tagSupplier;
        this.registryAccess = registryAccess;
    }

    protected class_2378<IAbilityType> getRegistry() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(this.registryAccess);
    }

    @Override
    public boolean isInitialized() {
        class_2487 root = this.tagSupplier.get();
        return root.method_10545(NBT_STORE);
    }

    protected IMutableAbilityStore getInnerStore() {
        DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
        class_2487 root = this.tagSupplier.get();
        if (!root.method_10545(NBT_STORE)) {
            root.method_10566(NBT_STORE, (class_2520)new class_2499());
        }
        class_2520 nbt = root.method_10580(NBT_STORE);
        EverlastingAbilitiesInstance.MOD.getAbilityHelpers().deserialize(this.getRegistry(), store, nbt);
        return store;
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        class_2487 root = this.tagSupplier.get();
        class_2520 nbt = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().serialize(this.getRegistry(), store);
        root.method_10566(NBT_STORE, nbt);
        return store;
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<class_6880<IAbilityType>, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(class_6880<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<class_6880<IAbilityType>> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<class_6880<IAbilityType>, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(class_6880<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

