/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.attachment;

import java.util.Collection;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_6880;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultAbilityStore;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IInitializableMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.attachment.Attachments;

public class AttachableMutableAbilityStore
implements IMutableAbilityStore,
IInitializableMutableAbilityStore {
    private final AttachmentTarget target;
    private final Runnable onModified;

    public AttachableMutableAbilityStore(AttachmentTarget target, Runnable onModified) {
        this.target = target;
        this.onModified = onModified;
    }

    public AttachableMutableAbilityStore(AttachmentTarget target) {
        this(target, () -> {});
    }

    protected IMutableAbilityStore getInnerStore() {
        return new DefaultMutableAbilityStore((IAbilityStore)this.target.getAttachedOrGet(Attachments.ABILITY_STORE, DefaultAbilityStore::new));
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        this.target.setAttached(Attachments.ABILITY_STORE, (Object)new DefaultAbilityStore(store));
        this.onModified.run();
        return store;
    }

    @Override
    public boolean isInitialized() {
        return this.target.hasAttached(Attachments.ABILITY_STORE);
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<class_6880<IAbilityType>, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(class_6880<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<class_6880<IAbilityType>> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<class_6880<IAbilityType>, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(class_6880<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

