/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_4722;
import net.minecraft.class_490;
import net.minecraft.class_5251;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtendedCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtendedCommon;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;
import org.cyclops.everlastingabilities.network.packet.MoveAbilityPacket;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ContainerScreenAbilityContainer
extends ContainerScreenExtendedCommon<ContainerAbilityContainer> {
    private static final class_2960 RES_ITEM_GLINT = class_918.field_43087;
    protected static final int ABILITY_LIST_SIZE = 6;
    protected static final int ABILITY_BOX_HEIGHT = 18;
    protected static final int ABILITY_BOX_WIDTH = 63;
    private final class_1657 player;
    protected int startIndexPlayer = 0;
    protected int startIndexItem = 0;
    protected int absoluteSelectedIndexPlayer = -1;
    protected int absoluteSelectedIndexItem = -1;
    protected ButtonArrow buttonUp1;
    protected ButtonArrow buttonDown1;
    protected ButtonArrow buttonUp2;
    protected ButtonArrow buttonDown2;
    protected ButtonArrow buttonLeft;
    protected ButtonArrow buttonRight;
    private final IModHelpers modHelpers;

    public ContainerScreenAbilityContainer(ContainerAbilityContainer container, class_1661 inventory, class_2561 title) {
        super((ContainerExtendedCommon)container, inventory, title);
        this.player = inventory.field_7546;
        this.modHelpers = IModHelpers.get();
    }

    protected class_2960 constructGuiTexture() {
        return class_2960.method_60655((String)"everlastingabilities", (String)"textures/gui/ability_totem.png");
    }

    public void method_25426() {
        super.method_25426();
        this.buttonUp1 = new ButtonArrow(this.field_2776 + 73, this.field_2800 + 83, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexPlayer > 0) {
                --this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.NORTH);
        this.method_37063((class_364)this.buttonUp1);
        this.buttonDown1 = new ButtonArrow(this.field_2776 + 73, this.field_2800 + 174, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.method_37063((class_364)this.buttonDown1);
        this.buttonUp2 = new ButtonArrow(this.field_2776 + 88, this.field_2800 + 83, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexItem > 0) {
                --this.startIndexItem;
            }
        }, ButtonArrow.Direction.NORTH);
        this.method_37063((class_364)this.buttonUp2);
        this.buttonDown2 = new ButtonArrow(this.field_2776 + 88, this.field_2800 + 174, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.method_37063((class_364)this.buttonDown2);
        class_2378<IAbilityType> registry = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(this.player.method_37908().method_30349());
        this.buttonLeft = new ButtonArrow(this.field_2776 + 76, this.field_2800 + 130, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.left"), button -> {
            if (this.canMoveToPlayer()) {
                EverlastingAbilitiesInstance.MOD.getPacketHandlerCommon().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedItemAbilitySingle(), MoveAbilityPacket.Movement.TO_PLAYER));
                this.moveToPlayer();
            }
        }, ButtonArrow.Direction.WEST);
        this.method_37063((class_364)this.buttonLeft);
        this.buttonRight = new ButtonArrow(this.field_2776 + 90, this.field_2800 + 130, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.right"), button -> {
            if (this.canMoveFromPlayer()) {
                EverlastingAbilitiesInstance.MOD.getPacketHandlerCommon().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedPlayerAbilitySingle(), MoveAbilityPacket.Movement.FROM_PLAYER));
                this.moveFromPlayer();
            }
        }, ButtonArrow.Direction.EAST);
        this.method_37063((class_364)this.buttonRight);
    }

    protected int getBaseYSize() {
        return 219;
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.method_17577()).getItemStack(this.player) == null) {
            return;
        }
        guiGraphics.method_25303(this.field_22793, this.player.method_5476().getString(), 8, 6, -1);
        guiGraphics.method_35720(this.field_22793, ((ContainerAbilityContainer)this.method_17577()).getItemStack(this.player).method_7964().method_30937(), 102, 6, -1);
        this.drawAbilitiesTooltip(guiGraphics, 8, 83, this.getPlayerAbilities(), this.startIndexPlayer, mouseX, mouseY);
        this.drawAbilitiesTooltip(guiGraphics, 105, 83, this.getItemAbilities(), this.startIndexItem, mouseX, mouseY);
    }

    protected List<Ability> getPlayerAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.method_17577()).getPlayerAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected List<Ability> getItemAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.method_17577()).getItemAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected IMutableAbilityStore getPlayerAbilityStore() {
        return ((ContainerAbilityContainer)this.method_17577()).getPlayerAbilityStore().orElse(null);
    }

    protected IMutableAbilityStore getItemAbilityStore() {
        return ((ContainerAbilityContainer)this.method_17577()).getItemAbilityStore().orElse(null);
    }

    protected int getPlayerAbilitiesCount() {
        return this.getPlayerAbilities().size();
    }

    protected int getItemAbilitiesCount() {
        return this.getItemAbilities().size();
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.method_17577()).getItemStack(this.player) == null) {
            return;
        }
        if (this.buttonUp1 != null) {
            this.buttonUp1.field_22763 = this.startIndexPlayer > 0;
            this.buttonDown1.field_22763 = this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount());
            this.buttonUp2.field_22763 = this.startIndexItem > 0;
            this.buttonDown2.field_22763 = this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount());
            this.buttonLeft.field_22763 = this.canMoveToPlayer();
            this.buttonRight.field_22763 = this.canMoveFromPlayer();
            this.buttonRight.field_22763 = this.canMoveFromPlayerByItem();
        }
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        int i = this.field_2776;
        int j = this.field_2800;
        this.drawFancyBackground(guiGraphics, i + 8, j + 17, 66, 61, this.getPlayerAbilityStore());
        class_490.method_2486((class_332)guiGraphics, (int)(i + 26 - 8), (int)(j + 8 + 3), (int)(i + 75 - 8), (int)(j + 78 + 3), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)this.field_22787.field_1724);
        this.drawXp(guiGraphics, i + 67, j + 70);
        IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.field_22793, "" + this.player.field_7495, i + 62, j + 73, 0, 0.5f, IModHelpers.get().getBaseHelpers().RGBToInt(40, 215, 40), false, class_327.class_6415.field_33993);
        this.drawFancyBackground(guiGraphics, i + 102, j + 17, 66, 61, this.getItemAbilityStore());
        ContainerScreenAbilityContainer.drawItemOnScreen(guiGraphics, i + 134, j + 46, 50, (float)(i + 134) - (float)mouseX, (float)(j + 46 - 30) - (float)mouseY, ((ContainerAbilityContainer)this.method_17577()).getItemStack((class_1657)this.field_22787.field_1724));
        this.drawAbilities(guiGraphics, this.field_2776 + 8, this.field_2800 + 83, this.getPlayerAbilities(), this.startIndexPlayer, Integer.MAX_VALUE, this.absoluteSelectedIndexPlayer, mouseX, mouseY, this.canMoveFromPlayerByItem());
        this.drawAbilities(guiGraphics, this.field_2776 + 105, this.field_2800 + 83, this.getItemAbilities(), this.startIndexItem, this.player.field_7495, this.absoluteSelectedIndexItem, mouseX, mouseY, true);
    }

    public void drawFancyBackground(class_332 guiGraphics, int x, int y, int width, int height, IAbilityStore abilityStore) {
        class_1921 rendertype = class_4722.method_29382();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexconsumer = class_918.method_23181((class_4597)bufferSource, (class_1921)rendertype, (boolean)true, (boolean)true);
        int r = 140;
        int g = 140;
        int b = 140;
        if (abilityStore != null) {
            if (abilityStore.getAbilityTypes().isEmpty()) {
                return;
            }
            Triple<Integer, Integer, Integer> color = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAverageRarityColor(abilityStore);
            r = (Integer)color.getLeft();
            g = (Integer)color.getMiddle();
            b = (Integer)color.getRight();
        }
        float f = (float)(class_156.method_658() % 9000L) / 9000.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_DST_COLOR);
        this.drawTexturedModalRectColor(guiGraphics, vertexconsumer, x, y, (int)(0.0f + f * 256.0f), 0, width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        this.drawTexturedModalRectColor(guiGraphics, vertexconsumer, x, y, (int)(0.0f + f * 150.0f), (int)(0.0f + f * 256.0f), width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    protected void drawXp(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_25302(this.texture, x, y, 0, 219, 5, 5);
    }

    private void drawAbilities(class_332 guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int playerXp, int currentSelectedIndex, int mouseX, int mouseY, boolean canEdit) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            Ability ability = abilities.get(i + startIndex);
            if (canEdit) {
                boolean showActive;
                boolean active = currentSelectedIndex == i + startIndex;
                boolean bl = showActive = active || this.isPointInRegion(new Rectangle(x - this.field_2776, boxY - this.field_2800, 63, 18), new Point(mouseX, mouseY));
                if (showActive) {
                    this.drawFancyBackground(guiGraphics, x, boxY - 1, 63, 18, null);
                }
            }
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.field_22793, class_2561.method_43471((String)ability.getAbilityType().getTranslationKey()).method_10862(class_2583.field_24360.method_10977(ability.getAbilityType().getRarity().method_58413())).getString(), x + 27, boxY + 7, 0, 1.0f, 50, ability.getAbilityType().getRarity().method_58413().method_532().intValue(), false, class_327.class_6415.field_33993);
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.field_22793, "" + ability.getLevel(), x + 58, boxY + 5, 0, 0.8f, -1, false, class_327.class_6415.field_33993);
            int requiredXp = ability.getAbilityType().getXpPerLevelScaled();
            if (playerXp < requiredXp) {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.drawXp(guiGraphics, x + 57, boxY + 10);
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.field_22793, "" + requiredXp, x + 53, boxY + 13, 0, 0.5f, this.modHelpers.getBaseHelpers().RGBToInt(40, 215, 40), false, class_327.class_6415.field_33993);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawAbilitiesTooltip(class_332 guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int mouseX, int mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point(mouseX, mouseY))) continue;
            Ability ability = abilities.get(i + startIndex);
            LinkedList lines = Lists.newLinkedList();
            lines.add(class_2561.method_43471((String)ability.getAbilityType().getTranslationKey()).method_10862(class_2583.field_24360.method_10977(ability.getAbilityType().getRarity().method_58413())));
            lines.add(class_2561.method_43469((String)"general.everlastingabilities.level", (Object[])new Object[]{ability.getLevel(), ability.getAbilityType().getMaxLevel() == -1 ? "Inf" : Integer.valueOf(ability.getAbilityType().getMaxLevel())}));
            lines.add(class_2561.method_43471((String)ability.getAbilityType().getUnlocalizedDescription()).method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1061})));
            lines.add(class_2561.method_43469((String)"general.everlastingabilities.xp", (Object[])new Object[]{ability.getAbilityType().getXpPerLevelScaled(), EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getLevelForExperience(ability.getAbilityType().getXpPerLevelScaled())}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1077))));
            if (!EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getPredicateAbilityEnabled().test(ability.getAbilityTypeHolder())) {
                lines.add(class_2561.method_43471((String)"general.everlastingabilities.disabled").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1079)).method_10982(Boolean.valueOf(true))));
            }
            this.modHelpers.getGuiHelpers().drawTooltip((class_465)this, guiGraphics.method_51448(), (List)lines, mouseX - this.field_2776, mouseY - this.field_2800);
        }
    }

    public void drawTexturedModalRectColor(class_332 guiGraphics, class_4588 vertexbuffer, int x, int y, int textureX, int textureY, int width, int height, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        guiGraphics.method_25302(RES_ITEM_GLINT, x, y, textureX, textureY, width, height);
    }

    public static void drawItemOnScreen(class_332 guiGraphics, int posX, int posY, int scale, float mouseX, float mouseY, class_1799 itemStack) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        class_4587 posestack = guiGraphics.method_51448();
        posestack.method_22903();
        posestack.method_22904((double)posX, (double)posY, 1050.0);
        posestack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 posestack1 = posestack;
        posestack1.method_22904(0.0, 0.0, 1000.0);
        posestack1.method_22905((float)scale, (float)scale, (float)scale);
        Quaternionf rotation = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf cameraOrientationY = class_7833.field_40716.rotationDegrees(-f * 40.0f);
        Quaternionf cameraOrientationX = class_7833.field_40714.rotationDegrees(f1 * 20.0f);
        rotation.mul((Quaternionfc)cameraOrientationY);
        rotation.mul((Quaternionfc)cameraOrientationX);
        posestack1.method_22907(rotation);
        class_4597.class_4598 renderTypeBuffer = class_310.method_1551().method_22940().method_23000();
        class_308.method_24211();
        class_310.method_1551().method_1480().method_23178(itemStack, class_811.field_4319, 0xF000F0, class_4608.field_21444, posestack1, (class_4597)renderTypeBuffer, null, 0);
        class_308.method_24210();
        renderTypeBuffer.method_22993();
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        int newSelectedPlayer = this.canMoveFromPlayerByItem() ? this.clickAbilities(8, 83, this.getPlayerAbilities(), this.startIndexPlayer, this.absoluteSelectedIndexPlayer, mouseX, mouseY) : -2;
        int newSelectedItem = this.clickAbilities(105, 83, this.getItemAbilities(), this.startIndexItem, this.absoluteSelectedIndexItem, mouseX, mouseY);
        if (newSelectedPlayer >= -1) {
            this.absoluteSelectedIndexPlayer = newSelectedPlayer;
        }
        if (newSelectedItem >= -1) {
            this.absoluteSelectedIndexItem = newSelectedItem;
        }
        if (newSelectedPlayer < 0 && newSelectedItem < 0) {
            super.method_25402(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double mouseZ, double scrollAmount) {
        if (this.method_2378(8, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexPlayer > 0) {
                    --this.startIndexPlayer;
                }
            } else if (scrollAmount < 0.0 && this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
            return true;
        }
        if (this.method_2378(105, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexItem > 0) {
                    --this.startIndexItem;
                }
            } else if (scrollAmount < 0.0 && this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
            return true;
        }
        return false;
    }

    private int clickAbilities(int x, int y, List<Ability> abilities, int startIndex, int currentSelectedIndex, double mouseX, double mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point((int)mouseX, (int)mouseY))) continue;
            int absoluteIndex = startIndex + i;
            if (currentSelectedIndex == absoluteIndex) {
                return -1;
            }
            return absoluteIndex;
        }
        return -2;
    }

    public Ability getSelectedPlayerAbilitySingle() {
        Ability ability = this.getSelectedPlayerAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityTypeHolder(), 1);
        }
        return ability;
    }

    public Ability getSelectedItemAbilitySingle() {
        Ability ability = this.getSelectedItemAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityTypeHolder(), 1);
        }
        return ability;
    }

    public Ability getSelectedPlayerAbility() {
        List<Ability> abilities = this.getPlayerAbilities();
        if (this.absoluteSelectedIndexPlayer >= 0 && this.absoluteSelectedIndexPlayer < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexPlayer);
        }
        return Ability.EMPTY;
    }

    public Ability getSelectedItemAbility() {
        List<Ability> abilities = this.getItemAbilities();
        if (this.absoluteSelectedIndexItem >= 0 && this.absoluteSelectedIndexItem < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexItem);
        }
        return Ability.EMPTY;
    }

    public boolean canMoveFromPlayer(Ability ability, class_1657 player, IMutableAbilityStore target) {
        return !ability.isEmpty() && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsert(ability, target);
    }

    public boolean canMoveToPlayer(Ability ability, class_1657 player) {
        return !ability.isEmpty() && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsertToPlayer(ability, player);
    }

    public boolean canMoveFromPlayerByItem() {
        return ((ItemGuiAbilityContainer)((ContainerAbilityContainer)this.method_17577()).getItem()).canMoveFromPlayer();
    }

    public boolean canMoveFromPlayer() {
        if (!this.canMoveFromPlayerByItem()) {
            return false;
        }
        Ability playerAbility = this.getSelectedPlayerAbilitySingle();
        return this.canMoveFromPlayer(playerAbility, this.player, this.getItemAbilityStore());
    }

    public boolean canMoveToPlayer() {
        Ability itemAbility = this.getSelectedItemAbilitySingle();
        return this.canMoveToPlayer(itemAbility, this.player);
    }

    public void moveFromPlayer() {
        ((ContainerAbilityContainer)this.method_17577()).moveFromPlayer(this.getSelectedPlayerAbilitySingle());
    }

    public void moveToPlayer() {
        ((ContainerAbilityContainer)this.method_17577()).moveToPlayer(this.getSelectedItemAbilitySingle());
    }
}

